// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNvmeCollectionPerformanceMetricsGetParams creates a new NvmeCollectionPerformanceMetricsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNvmeCollectionPerformanceMetricsGetParams() *NvmeCollectionPerformanceMetricsGetParams {
	return &NvmeCollectionPerformanceMetricsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNvmeCollectionPerformanceMetricsGetParamsWithTimeout creates a new NvmeCollectionPerformanceMetricsGetParams object
// with the ability to set a timeout on a request.
func NewNvmeCollectionPerformanceMetricsGetParamsWithTimeout(timeout time.Duration) *NvmeCollectionPerformanceMetricsGetParams {
	return &NvmeCollectionPerformanceMetricsGetParams{
		timeout: timeout,
	}
}

// NewNvmeCollectionPerformanceMetricsGetParamsWithContext creates a new NvmeCollectionPerformanceMetricsGetParams object
// with the ability to set a context for a request.
func NewNvmeCollectionPerformanceMetricsGetParamsWithContext(ctx context.Context) *NvmeCollectionPerformanceMetricsGetParams {
	return &NvmeCollectionPerformanceMetricsGetParams{
		Context: ctx,
	}
}

// NewNvmeCollectionPerformanceMetricsGetParamsWithHTTPClient creates a new NvmeCollectionPerformanceMetricsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNvmeCollectionPerformanceMetricsGetParamsWithHTTPClient(client *http.Client) *NvmeCollectionPerformanceMetricsGetParams {
	return &NvmeCollectionPerformanceMetricsGetParams{
		HTTPClient: client,
	}
}

/*
NvmeCollectionPerformanceMetricsGetParams contains all the parameters to send to the API endpoint

	for the nvme collection performance metrics get operation.

	Typically these are written to a http.Request.
*/
type NvmeCollectionPerformanceMetricsGetParams struct {

	/* Duration.

	   Filter by duration
	*/
	Duration *string

	/* FcDuration.

	   Filter by fc.duration
	*/
	FcDuration *string

	/* FcIopsOther.

	   Filter by fc.iops.other
	*/
	FcIopsOther *int64

	/* FcIopsRead.

	   Filter by fc.iops.read
	*/
	FcIopsRead *int64

	/* FcIopsTotal.

	   Filter by fc.iops.total
	*/
	FcIopsTotal *int64

	/* FcIopsWrite.

	   Filter by fc.iops.write
	*/
	FcIopsWrite *int64

	/* FcLatencyOther.

	   Filter by fc.latency.other
	*/
	FcLatencyOther *int64

	/* FcLatencyRead.

	   Filter by fc.latency.read
	*/
	FcLatencyRead *int64

	/* FcLatencyTotal.

	   Filter by fc.latency.total
	*/
	FcLatencyTotal *int64

	/* FcLatencyWrite.

	   Filter by fc.latency.write
	*/
	FcLatencyWrite *int64

	/* FcStatus.

	   Filter by fc.status
	*/
	FcStatus *string

	/* FcThroughputRead.

	   Filter by fc.throughput.read
	*/
	FcThroughputRead *int64

	/* FcThroughputTotal.

	   Filter by fc.throughput.total
	*/
	FcThroughputTotal *int64

	/* FcThroughputWrite.

	   Filter by fc.throughput.write
	*/
	FcThroughputWrite *int64

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Interval.

	     The time range for the data. Examples can be 1h, 1d, 1m, 1w, 1y.
	The period for each time range is as follows:
	* 1h: Metrics over the most recent hour sampled over 15 seconds.
	* 1d: Metrics over the most recent day sampled over 5 minutes.
	* 1w: Metrics over the most recent week sampled over 30 minutes.
	* 1m: Metrics over the most recent month sampled over 2 hours.
	* 1y: Metrics over the most recent year sampled over a day.


	     Default: "1h"
	*/
	Interval *string

	/* IopsOther.

	   Filter by iops.other
	*/
	IopsOther *int64

	/* IopsRead.

	   Filter by iops.read
	*/
	IopsRead *int64

	/* IopsTotal.

	   Filter by iops.total
	*/
	IopsTotal *int64

	/* IopsWrite.

	   Filter by iops.write
	*/
	IopsWrite *int64

	/* LatencyOther.

	   Filter by latency.other
	*/
	LatencyOther *int64

	/* LatencyRead.

	   Filter by latency.read
	*/
	LatencyRead *int64

	/* LatencyTotal.

	   Filter by latency.total
	*/
	LatencyTotal *int64

	/* LatencyWrite.

	   Filter by latency.write
	*/
	LatencyWrite *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Status.

	   Filter by status
	*/
	Status *string

	/* SvmUUID.

	   Unique identifier of the SVM.
	*/
	SvmUUID string

	/* TCPDuration.

	   Filter by tcp.duration
	*/
	TCPDuration *string

	/* TCPIopsOther.

	   Filter by tcp.iops.other
	*/
	TCPIopsOther *int64

	/* TCPIopsRead.

	   Filter by tcp.iops.read
	*/
	TCPIopsRead *int64

	/* TCPIopsTotal.

	   Filter by tcp.iops.total
	*/
	TCPIopsTotal *int64

	/* TCPIopsWrite.

	   Filter by tcp.iops.write
	*/
	TCPIopsWrite *int64

	/* TCPLatencyOther.

	   Filter by tcp.latency.other
	*/
	TCPLatencyOther *int64

	/* TCPLatencyRead.

	   Filter by tcp.latency.read
	*/
	TCPLatencyRead *int64

	/* TCPLatencyTotal.

	   Filter by tcp.latency.total
	*/
	TCPLatencyTotal *int64

	/* TCPLatencyWrite.

	   Filter by tcp.latency.write
	*/
	TCPLatencyWrite *int64

	/* TCPStatus.

	   Filter by tcp.status
	*/
	TCPStatus *string

	/* TCPThroughputRead.

	   Filter by tcp.throughput.read
	*/
	TCPThroughputRead *int64

	/* TCPThroughputTotal.

	   Filter by tcp.throughput.total
	*/
	TCPThroughputTotal *int64

	/* TCPThroughputWrite.

	   Filter by tcp.throughput.write
	*/
	TCPThroughputWrite *int64

	/* ThroughputRead.

	   Filter by throughput.read
	*/
	ThroughputRead *int64

	/* ThroughputTotal.

	   Filter by throughput.total
	*/
	ThroughputTotal *int64

	/* ThroughputWrite.

	   Filter by throughput.write
	*/
	ThroughputWrite *int64

	/* Timestamp.

	   Filter by timestamp
	*/
	Timestamp *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nvme collection performance metrics get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeCollectionPerformanceMetricsGetParams) WithDefaults() *NvmeCollectionPerformanceMetricsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nvme collection performance metrics get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeCollectionPerformanceMetricsGetParams) SetDefaults() {
	var (
		intervalDefault = string("1h")

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NvmeCollectionPerformanceMetricsGetParams{
		Interval:      &intervalDefault,
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTimeout(timeout time.Duration) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithContext(ctx context.Context) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithHTTPClient(client *http.Client) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDuration adds the duration to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithDuration(duration *string) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetDuration(duration)
	return o
}

// SetDuration adds the duration to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetDuration(duration *string) {
	o.Duration = duration
}

// WithFcDuration adds the fcDuration to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcDuration(fcDuration *string) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcDuration(fcDuration)
	return o
}

// SetFcDuration adds the fcDuration to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcDuration(fcDuration *string) {
	o.FcDuration = fcDuration
}

// WithFcIopsOther adds the fcIopsOther to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcIopsOther(fcIopsOther *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcIopsOther(fcIopsOther)
	return o
}

// SetFcIopsOther adds the fcIopsOther to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcIopsOther(fcIopsOther *int64) {
	o.FcIopsOther = fcIopsOther
}

// WithFcIopsRead adds the fcIopsRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcIopsRead(fcIopsRead *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcIopsRead(fcIopsRead)
	return o
}

// SetFcIopsRead adds the fcIopsRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcIopsRead(fcIopsRead *int64) {
	o.FcIopsRead = fcIopsRead
}

// WithFcIopsTotal adds the fcIopsTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcIopsTotal(fcIopsTotal *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcIopsTotal(fcIopsTotal)
	return o
}

// SetFcIopsTotal adds the fcIopsTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcIopsTotal(fcIopsTotal *int64) {
	o.FcIopsTotal = fcIopsTotal
}

// WithFcIopsWrite adds the fcIopsWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcIopsWrite(fcIopsWrite *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcIopsWrite(fcIopsWrite)
	return o
}

// SetFcIopsWrite adds the fcIopsWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcIopsWrite(fcIopsWrite *int64) {
	o.FcIopsWrite = fcIopsWrite
}

// WithFcLatencyOther adds the fcLatencyOther to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcLatencyOther(fcLatencyOther *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcLatencyOther(fcLatencyOther)
	return o
}

// SetFcLatencyOther adds the fcLatencyOther to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcLatencyOther(fcLatencyOther *int64) {
	o.FcLatencyOther = fcLatencyOther
}

// WithFcLatencyRead adds the fcLatencyRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcLatencyRead(fcLatencyRead *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcLatencyRead(fcLatencyRead)
	return o
}

// SetFcLatencyRead adds the fcLatencyRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcLatencyRead(fcLatencyRead *int64) {
	o.FcLatencyRead = fcLatencyRead
}

// WithFcLatencyTotal adds the fcLatencyTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcLatencyTotal(fcLatencyTotal *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcLatencyTotal(fcLatencyTotal)
	return o
}

// SetFcLatencyTotal adds the fcLatencyTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcLatencyTotal(fcLatencyTotal *int64) {
	o.FcLatencyTotal = fcLatencyTotal
}

// WithFcLatencyWrite adds the fcLatencyWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcLatencyWrite(fcLatencyWrite *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcLatencyWrite(fcLatencyWrite)
	return o
}

// SetFcLatencyWrite adds the fcLatencyWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcLatencyWrite(fcLatencyWrite *int64) {
	o.FcLatencyWrite = fcLatencyWrite
}

// WithFcStatus adds the fcStatus to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcStatus(fcStatus *string) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcStatus(fcStatus)
	return o
}

// SetFcStatus adds the fcStatus to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcStatus(fcStatus *string) {
	o.FcStatus = fcStatus
}

// WithFcThroughputRead adds the fcThroughputRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcThroughputRead(fcThroughputRead *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcThroughputRead(fcThroughputRead)
	return o
}

// SetFcThroughputRead adds the fcThroughputRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcThroughputRead(fcThroughputRead *int64) {
	o.FcThroughputRead = fcThroughputRead
}

// WithFcThroughputTotal adds the fcThroughputTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcThroughputTotal(fcThroughputTotal *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcThroughputTotal(fcThroughputTotal)
	return o
}

// SetFcThroughputTotal adds the fcThroughputTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcThroughputTotal(fcThroughputTotal *int64) {
	o.FcThroughputTotal = fcThroughputTotal
}

// WithFcThroughputWrite adds the fcThroughputWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFcThroughputWrite(fcThroughputWrite *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFcThroughputWrite(fcThroughputWrite)
	return o
}

// SetFcThroughputWrite adds the fcThroughputWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFcThroughputWrite(fcThroughputWrite *int64) {
	o.FcThroughputWrite = fcThroughputWrite
}

// WithFields adds the fields to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithFields(fields []string) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInterval adds the interval to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithInterval(interval *string) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetInterval(interval)
	return o
}

// SetInterval adds the interval to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetInterval(interval *string) {
	o.Interval = interval
}

// WithIopsOther adds the iopsOther to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithIopsOther(iopsOther *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetIopsOther(iopsOther)
	return o
}

// SetIopsOther adds the iopsOther to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetIopsOther(iopsOther *int64) {
	o.IopsOther = iopsOther
}

// WithIopsRead adds the iopsRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithIopsRead(iopsRead *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetIopsRead(iopsRead)
	return o
}

// SetIopsRead adds the iopsRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetIopsRead(iopsRead *int64) {
	o.IopsRead = iopsRead
}

// WithIopsTotal adds the iopsTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithIopsTotal(iopsTotal *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetIopsTotal(iopsTotal)
	return o
}

// SetIopsTotal adds the iopsTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetIopsTotal(iopsTotal *int64) {
	o.IopsTotal = iopsTotal
}

// WithIopsWrite adds the iopsWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithIopsWrite(iopsWrite *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetIopsWrite(iopsWrite)
	return o
}

// SetIopsWrite adds the iopsWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetIopsWrite(iopsWrite *int64) {
	o.IopsWrite = iopsWrite
}

// WithLatencyOther adds the latencyOther to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithLatencyOther(latencyOther *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetLatencyOther(latencyOther)
	return o
}

// SetLatencyOther adds the latencyOther to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetLatencyOther(latencyOther *int64) {
	o.LatencyOther = latencyOther
}

// WithLatencyRead adds the latencyRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithLatencyRead(latencyRead *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetLatencyRead(latencyRead)
	return o
}

// SetLatencyRead adds the latencyRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetLatencyRead(latencyRead *int64) {
	o.LatencyRead = latencyRead
}

// WithLatencyTotal adds the latencyTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithLatencyTotal(latencyTotal *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetLatencyTotal(latencyTotal)
	return o
}

// SetLatencyTotal adds the latencyTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetLatencyTotal(latencyTotal *int64) {
	o.LatencyTotal = latencyTotal
}

// WithLatencyWrite adds the latencyWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithLatencyWrite(latencyWrite *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetLatencyWrite(latencyWrite)
	return o
}

// SetLatencyWrite adds the latencyWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetLatencyWrite(latencyWrite *int64) {
	o.LatencyWrite = latencyWrite
}

// WithMaxRecords adds the maxRecords to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithMaxRecords(maxRecords *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithOrderBy(orderBy []string) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithReturnRecords(returnRecords *bool) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithReturnTimeout(returnTimeout *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStatus adds the status to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithStatus(status *string) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetStatus(status *string) {
	o.Status = status
}

// WithSvmUUID adds the svmUUID to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithSvmUUID(svmUUID string) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithTCPDuration adds the tCPDuration to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPDuration(tCPDuration *string) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPDuration(tCPDuration)
	return o
}

// SetTCPDuration adds the tcpDuration to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPDuration(tCPDuration *string) {
	o.TCPDuration = tCPDuration
}

// WithTCPIopsOther adds the tCPIopsOther to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPIopsOther(tCPIopsOther *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPIopsOther(tCPIopsOther)
	return o
}

// SetTCPIopsOther adds the tcpIopsOther to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPIopsOther(tCPIopsOther *int64) {
	o.TCPIopsOther = tCPIopsOther
}

// WithTCPIopsRead adds the tCPIopsRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPIopsRead(tCPIopsRead *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPIopsRead(tCPIopsRead)
	return o
}

// SetTCPIopsRead adds the tcpIopsRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPIopsRead(tCPIopsRead *int64) {
	o.TCPIopsRead = tCPIopsRead
}

// WithTCPIopsTotal adds the tCPIopsTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPIopsTotal(tCPIopsTotal *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPIopsTotal(tCPIopsTotal)
	return o
}

// SetTCPIopsTotal adds the tcpIopsTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPIopsTotal(tCPIopsTotal *int64) {
	o.TCPIopsTotal = tCPIopsTotal
}

// WithTCPIopsWrite adds the tCPIopsWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPIopsWrite(tCPIopsWrite *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPIopsWrite(tCPIopsWrite)
	return o
}

// SetTCPIopsWrite adds the tcpIopsWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPIopsWrite(tCPIopsWrite *int64) {
	o.TCPIopsWrite = tCPIopsWrite
}

// WithTCPLatencyOther adds the tCPLatencyOther to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPLatencyOther(tCPLatencyOther *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPLatencyOther(tCPLatencyOther)
	return o
}

// SetTCPLatencyOther adds the tcpLatencyOther to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPLatencyOther(tCPLatencyOther *int64) {
	o.TCPLatencyOther = tCPLatencyOther
}

// WithTCPLatencyRead adds the tCPLatencyRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPLatencyRead(tCPLatencyRead *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPLatencyRead(tCPLatencyRead)
	return o
}

// SetTCPLatencyRead adds the tcpLatencyRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPLatencyRead(tCPLatencyRead *int64) {
	o.TCPLatencyRead = tCPLatencyRead
}

// WithTCPLatencyTotal adds the tCPLatencyTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPLatencyTotal(tCPLatencyTotal *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPLatencyTotal(tCPLatencyTotal)
	return o
}

// SetTCPLatencyTotal adds the tcpLatencyTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPLatencyTotal(tCPLatencyTotal *int64) {
	o.TCPLatencyTotal = tCPLatencyTotal
}

// WithTCPLatencyWrite adds the tCPLatencyWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPLatencyWrite(tCPLatencyWrite *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPLatencyWrite(tCPLatencyWrite)
	return o
}

// SetTCPLatencyWrite adds the tcpLatencyWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPLatencyWrite(tCPLatencyWrite *int64) {
	o.TCPLatencyWrite = tCPLatencyWrite
}

// WithTCPStatus adds the tCPStatus to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPStatus(tCPStatus *string) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPStatus(tCPStatus)
	return o
}

// SetTCPStatus adds the tcpStatus to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPStatus(tCPStatus *string) {
	o.TCPStatus = tCPStatus
}

// WithTCPThroughputRead adds the tCPThroughputRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPThroughputRead(tCPThroughputRead *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPThroughputRead(tCPThroughputRead)
	return o
}

// SetTCPThroughputRead adds the tcpThroughputRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPThroughputRead(tCPThroughputRead *int64) {
	o.TCPThroughputRead = tCPThroughputRead
}

// WithTCPThroughputTotal adds the tCPThroughputTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPThroughputTotal(tCPThroughputTotal *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPThroughputTotal(tCPThroughputTotal)
	return o
}

// SetTCPThroughputTotal adds the tcpThroughputTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPThroughputTotal(tCPThroughputTotal *int64) {
	o.TCPThroughputTotal = tCPThroughputTotal
}

// WithTCPThroughputWrite adds the tCPThroughputWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTCPThroughputWrite(tCPThroughputWrite *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTCPThroughputWrite(tCPThroughputWrite)
	return o
}

// SetTCPThroughputWrite adds the tcpThroughputWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTCPThroughputWrite(tCPThroughputWrite *int64) {
	o.TCPThroughputWrite = tCPThroughputWrite
}

// WithThroughputRead adds the throughputRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithThroughputRead(throughputRead *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetThroughputRead(throughputRead)
	return o
}

// SetThroughputRead adds the throughputRead to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetThroughputRead(throughputRead *int64) {
	o.ThroughputRead = throughputRead
}

// WithThroughputTotal adds the throughputTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithThroughputTotal(throughputTotal *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetThroughputTotal(throughputTotal)
	return o
}

// SetThroughputTotal adds the throughputTotal to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetThroughputTotal(throughputTotal *int64) {
	o.ThroughputTotal = throughputTotal
}

// WithThroughputWrite adds the throughputWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithThroughputWrite(throughputWrite *int64) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetThroughputWrite(throughputWrite)
	return o
}

// SetThroughputWrite adds the throughputWrite to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetThroughputWrite(throughputWrite *int64) {
	o.ThroughputWrite = throughputWrite
}

// WithTimestamp adds the timestamp to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) WithTimestamp(timestamp *string) *NvmeCollectionPerformanceMetricsGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the nvme collection performance metrics get params
func (o *NvmeCollectionPerformanceMetricsGetParams) SetTimestamp(timestamp *string) {
	o.Timestamp = timestamp
}

// WriteToRequest writes these params to a swagger request
func (o *NvmeCollectionPerformanceMetricsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Duration != nil {

		// query param duration
		var qrDuration string

		if o.Duration != nil {
			qrDuration = *o.Duration
		}
		qDuration := qrDuration
		if qDuration != "" {

			if err := r.SetQueryParam("duration", qDuration); err != nil {
				return err
			}
		}
	}

	if o.FcDuration != nil {

		// query param fc.duration
		var qrFcDuration string

		if o.FcDuration != nil {
			qrFcDuration = *o.FcDuration
		}
		qFcDuration := qrFcDuration
		if qFcDuration != "" {

			if err := r.SetQueryParam("fc.duration", qFcDuration); err != nil {
				return err
			}
		}
	}

	if o.FcIopsOther != nil {

		// query param fc.iops.other
		var qrFcIopsOther int64

		if o.FcIopsOther != nil {
			qrFcIopsOther = *o.FcIopsOther
		}
		qFcIopsOther := swag.FormatInt64(qrFcIopsOther)
		if qFcIopsOther != "" {

			if err := r.SetQueryParam("fc.iops.other", qFcIopsOther); err != nil {
				return err
			}
		}
	}

	if o.FcIopsRead != nil {

		// query param fc.iops.read
		var qrFcIopsRead int64

		if o.FcIopsRead != nil {
			qrFcIopsRead = *o.FcIopsRead
		}
		qFcIopsRead := swag.FormatInt64(qrFcIopsRead)
		if qFcIopsRead != "" {

			if err := r.SetQueryParam("fc.iops.read", qFcIopsRead); err != nil {
				return err
			}
		}
	}

	if o.FcIopsTotal != nil {

		// query param fc.iops.total
		var qrFcIopsTotal int64

		if o.FcIopsTotal != nil {
			qrFcIopsTotal = *o.FcIopsTotal
		}
		qFcIopsTotal := swag.FormatInt64(qrFcIopsTotal)
		if qFcIopsTotal != "" {

			if err := r.SetQueryParam("fc.iops.total", qFcIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.FcIopsWrite != nil {

		// query param fc.iops.write
		var qrFcIopsWrite int64

		if o.FcIopsWrite != nil {
			qrFcIopsWrite = *o.FcIopsWrite
		}
		qFcIopsWrite := swag.FormatInt64(qrFcIopsWrite)
		if qFcIopsWrite != "" {

			if err := r.SetQueryParam("fc.iops.write", qFcIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.FcLatencyOther != nil {

		// query param fc.latency.other
		var qrFcLatencyOther int64

		if o.FcLatencyOther != nil {
			qrFcLatencyOther = *o.FcLatencyOther
		}
		qFcLatencyOther := swag.FormatInt64(qrFcLatencyOther)
		if qFcLatencyOther != "" {

			if err := r.SetQueryParam("fc.latency.other", qFcLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.FcLatencyRead != nil {

		// query param fc.latency.read
		var qrFcLatencyRead int64

		if o.FcLatencyRead != nil {
			qrFcLatencyRead = *o.FcLatencyRead
		}
		qFcLatencyRead := swag.FormatInt64(qrFcLatencyRead)
		if qFcLatencyRead != "" {

			if err := r.SetQueryParam("fc.latency.read", qFcLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.FcLatencyTotal != nil {

		// query param fc.latency.total
		var qrFcLatencyTotal int64

		if o.FcLatencyTotal != nil {
			qrFcLatencyTotal = *o.FcLatencyTotal
		}
		qFcLatencyTotal := swag.FormatInt64(qrFcLatencyTotal)
		if qFcLatencyTotal != "" {

			if err := r.SetQueryParam("fc.latency.total", qFcLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.FcLatencyWrite != nil {

		// query param fc.latency.write
		var qrFcLatencyWrite int64

		if o.FcLatencyWrite != nil {
			qrFcLatencyWrite = *o.FcLatencyWrite
		}
		qFcLatencyWrite := swag.FormatInt64(qrFcLatencyWrite)
		if qFcLatencyWrite != "" {

			if err := r.SetQueryParam("fc.latency.write", qFcLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.FcStatus != nil {

		// query param fc.status
		var qrFcStatus string

		if o.FcStatus != nil {
			qrFcStatus = *o.FcStatus
		}
		qFcStatus := qrFcStatus
		if qFcStatus != "" {

			if err := r.SetQueryParam("fc.status", qFcStatus); err != nil {
				return err
			}
		}
	}

	if o.FcThroughputRead != nil {

		// query param fc.throughput.read
		var qrFcThroughputRead int64

		if o.FcThroughputRead != nil {
			qrFcThroughputRead = *o.FcThroughputRead
		}
		qFcThroughputRead := swag.FormatInt64(qrFcThroughputRead)
		if qFcThroughputRead != "" {

			if err := r.SetQueryParam("fc.throughput.read", qFcThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.FcThroughputTotal != nil {

		// query param fc.throughput.total
		var qrFcThroughputTotal int64

		if o.FcThroughputTotal != nil {
			qrFcThroughputTotal = *o.FcThroughputTotal
		}
		qFcThroughputTotal := swag.FormatInt64(qrFcThroughputTotal)
		if qFcThroughputTotal != "" {

			if err := r.SetQueryParam("fc.throughput.total", qFcThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.FcThroughputWrite != nil {

		// query param fc.throughput.write
		var qrFcThroughputWrite int64

		if o.FcThroughputWrite != nil {
			qrFcThroughputWrite = *o.FcThroughputWrite
		}
		qFcThroughputWrite := swag.FormatInt64(qrFcThroughputWrite)
		if qFcThroughputWrite != "" {

			if err := r.SetQueryParam("fc.throughput.write", qFcThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Interval != nil {

		// query param interval
		var qrInterval string

		if o.Interval != nil {
			qrInterval = *o.Interval
		}
		qInterval := qrInterval
		if qInterval != "" {

			if err := r.SetQueryParam("interval", qInterval); err != nil {
				return err
			}
		}
	}

	if o.IopsOther != nil {

		// query param iops.other
		var qrIopsOther int64

		if o.IopsOther != nil {
			qrIopsOther = *o.IopsOther
		}
		qIopsOther := swag.FormatInt64(qrIopsOther)
		if qIopsOther != "" {

			if err := r.SetQueryParam("iops.other", qIopsOther); err != nil {
				return err
			}
		}
	}

	if o.IopsRead != nil {

		// query param iops.read
		var qrIopsRead int64

		if o.IopsRead != nil {
			qrIopsRead = *o.IopsRead
		}
		qIopsRead := swag.FormatInt64(qrIopsRead)
		if qIopsRead != "" {

			if err := r.SetQueryParam("iops.read", qIopsRead); err != nil {
				return err
			}
		}
	}

	if o.IopsTotal != nil {

		// query param iops.total
		var qrIopsTotal int64

		if o.IopsTotal != nil {
			qrIopsTotal = *o.IopsTotal
		}
		qIopsTotal := swag.FormatInt64(qrIopsTotal)
		if qIopsTotal != "" {

			if err := r.SetQueryParam("iops.total", qIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.IopsWrite != nil {

		// query param iops.write
		var qrIopsWrite int64

		if o.IopsWrite != nil {
			qrIopsWrite = *o.IopsWrite
		}
		qIopsWrite := swag.FormatInt64(qrIopsWrite)
		if qIopsWrite != "" {

			if err := r.SetQueryParam("iops.write", qIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.LatencyOther != nil {

		// query param latency.other
		var qrLatencyOther int64

		if o.LatencyOther != nil {
			qrLatencyOther = *o.LatencyOther
		}
		qLatencyOther := swag.FormatInt64(qrLatencyOther)
		if qLatencyOther != "" {

			if err := r.SetQueryParam("latency.other", qLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.LatencyRead != nil {

		// query param latency.read
		var qrLatencyRead int64

		if o.LatencyRead != nil {
			qrLatencyRead = *o.LatencyRead
		}
		qLatencyRead := swag.FormatInt64(qrLatencyRead)
		if qLatencyRead != "" {

			if err := r.SetQueryParam("latency.read", qLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.LatencyTotal != nil {

		// query param latency.total
		var qrLatencyTotal int64

		if o.LatencyTotal != nil {
			qrLatencyTotal = *o.LatencyTotal
		}
		qLatencyTotal := swag.FormatInt64(qrLatencyTotal)
		if qLatencyTotal != "" {

			if err := r.SetQueryParam("latency.total", qLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.LatencyWrite != nil {

		// query param latency.write
		var qrLatencyWrite int64

		if o.LatencyWrite != nil {
			qrLatencyWrite = *o.LatencyWrite
		}
		qLatencyWrite := swag.FormatInt64(qrLatencyWrite)
		if qLatencyWrite != "" {

			if err := r.SetQueryParam("latency.write", qLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.TCPDuration != nil {

		// query param tcp.duration
		var qrTCPDuration string

		if o.TCPDuration != nil {
			qrTCPDuration = *o.TCPDuration
		}
		qTCPDuration := qrTCPDuration
		if qTCPDuration != "" {

			if err := r.SetQueryParam("tcp.duration", qTCPDuration); err != nil {
				return err
			}
		}
	}

	if o.TCPIopsOther != nil {

		// query param tcp.iops.other
		var qrTCPIopsOther int64

		if o.TCPIopsOther != nil {
			qrTCPIopsOther = *o.TCPIopsOther
		}
		qTCPIopsOther := swag.FormatInt64(qrTCPIopsOther)
		if qTCPIopsOther != "" {

			if err := r.SetQueryParam("tcp.iops.other", qTCPIopsOther); err != nil {
				return err
			}
		}
	}

	if o.TCPIopsRead != nil {

		// query param tcp.iops.read
		var qrTCPIopsRead int64

		if o.TCPIopsRead != nil {
			qrTCPIopsRead = *o.TCPIopsRead
		}
		qTCPIopsRead := swag.FormatInt64(qrTCPIopsRead)
		if qTCPIopsRead != "" {

			if err := r.SetQueryParam("tcp.iops.read", qTCPIopsRead); err != nil {
				return err
			}
		}
	}

	if o.TCPIopsTotal != nil {

		// query param tcp.iops.total
		var qrTCPIopsTotal int64

		if o.TCPIopsTotal != nil {
			qrTCPIopsTotal = *o.TCPIopsTotal
		}
		qTCPIopsTotal := swag.FormatInt64(qrTCPIopsTotal)
		if qTCPIopsTotal != "" {

			if err := r.SetQueryParam("tcp.iops.total", qTCPIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.TCPIopsWrite != nil {

		// query param tcp.iops.write
		var qrTCPIopsWrite int64

		if o.TCPIopsWrite != nil {
			qrTCPIopsWrite = *o.TCPIopsWrite
		}
		qTCPIopsWrite := swag.FormatInt64(qrTCPIopsWrite)
		if qTCPIopsWrite != "" {

			if err := r.SetQueryParam("tcp.iops.write", qTCPIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.TCPLatencyOther != nil {

		// query param tcp.latency.other
		var qrTCPLatencyOther int64

		if o.TCPLatencyOther != nil {
			qrTCPLatencyOther = *o.TCPLatencyOther
		}
		qTCPLatencyOther := swag.FormatInt64(qrTCPLatencyOther)
		if qTCPLatencyOther != "" {

			if err := r.SetQueryParam("tcp.latency.other", qTCPLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.TCPLatencyRead != nil {

		// query param tcp.latency.read
		var qrTCPLatencyRead int64

		if o.TCPLatencyRead != nil {
			qrTCPLatencyRead = *o.TCPLatencyRead
		}
		qTCPLatencyRead := swag.FormatInt64(qrTCPLatencyRead)
		if qTCPLatencyRead != "" {

			if err := r.SetQueryParam("tcp.latency.read", qTCPLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.TCPLatencyTotal != nil {

		// query param tcp.latency.total
		var qrTCPLatencyTotal int64

		if o.TCPLatencyTotal != nil {
			qrTCPLatencyTotal = *o.TCPLatencyTotal
		}
		qTCPLatencyTotal := swag.FormatInt64(qrTCPLatencyTotal)
		if qTCPLatencyTotal != "" {

			if err := r.SetQueryParam("tcp.latency.total", qTCPLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.TCPLatencyWrite != nil {

		// query param tcp.latency.write
		var qrTCPLatencyWrite int64

		if o.TCPLatencyWrite != nil {
			qrTCPLatencyWrite = *o.TCPLatencyWrite
		}
		qTCPLatencyWrite := swag.FormatInt64(qrTCPLatencyWrite)
		if qTCPLatencyWrite != "" {

			if err := r.SetQueryParam("tcp.latency.write", qTCPLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.TCPStatus != nil {

		// query param tcp.status
		var qrTCPStatus string

		if o.TCPStatus != nil {
			qrTCPStatus = *o.TCPStatus
		}
		qTCPStatus := qrTCPStatus
		if qTCPStatus != "" {

			if err := r.SetQueryParam("tcp.status", qTCPStatus); err != nil {
				return err
			}
		}
	}

	if o.TCPThroughputRead != nil {

		// query param tcp.throughput.read
		var qrTCPThroughputRead int64

		if o.TCPThroughputRead != nil {
			qrTCPThroughputRead = *o.TCPThroughputRead
		}
		qTCPThroughputRead := swag.FormatInt64(qrTCPThroughputRead)
		if qTCPThroughputRead != "" {

			if err := r.SetQueryParam("tcp.throughput.read", qTCPThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.TCPThroughputTotal != nil {

		// query param tcp.throughput.total
		var qrTCPThroughputTotal int64

		if o.TCPThroughputTotal != nil {
			qrTCPThroughputTotal = *o.TCPThroughputTotal
		}
		qTCPThroughputTotal := swag.FormatInt64(qrTCPThroughputTotal)
		if qTCPThroughputTotal != "" {

			if err := r.SetQueryParam("tcp.throughput.total", qTCPThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.TCPThroughputWrite != nil {

		// query param tcp.throughput.write
		var qrTCPThroughputWrite int64

		if o.TCPThroughputWrite != nil {
			qrTCPThroughputWrite = *o.TCPThroughputWrite
		}
		qTCPThroughputWrite := swag.FormatInt64(qrTCPThroughputWrite)
		if qTCPThroughputWrite != "" {

			if err := r.SetQueryParam("tcp.throughput.write", qTCPThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.ThroughputRead != nil {

		// query param throughput.read
		var qrThroughputRead int64

		if o.ThroughputRead != nil {
			qrThroughputRead = *o.ThroughputRead
		}
		qThroughputRead := swag.FormatInt64(qrThroughputRead)
		if qThroughputRead != "" {

			if err := r.SetQueryParam("throughput.read", qThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.ThroughputTotal != nil {

		// query param throughput.total
		var qrThroughputTotal int64

		if o.ThroughputTotal != nil {
			qrThroughputTotal = *o.ThroughputTotal
		}
		qThroughputTotal := swag.FormatInt64(qrThroughputTotal)
		if qThroughputTotal != "" {

			if err := r.SetQueryParam("throughput.total", qThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.ThroughputWrite != nil {

		// query param throughput.write
		var qrThroughputWrite int64

		if o.ThroughputWrite != nil {
			qrThroughputWrite = *o.ThroughputWrite
		}
		qThroughputWrite := swag.FormatInt64(qrThroughputWrite)
		if qThroughputWrite != "" {

			if err := r.SetQueryParam("throughput.write", qThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.Timestamp != nil {

		// query param timestamp
		var qrTimestamp string

		if o.Timestamp != nil {
			qrTimestamp = *o.Timestamp
		}
		qTimestamp := qrTimestamp
		if qTimestamp != "" {

			if err := r.SetQueryParam("timestamp", qTimestamp); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNvmeCollectionPerformanceMetricsGet binds the parameter fields
func (o *NvmeCollectionPerformanceMetricsGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNvmeCollectionPerformanceMetricsGet binds the parameter order_by
func (o *NvmeCollectionPerformanceMetricsGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
