// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNvmeInterfaceCollectionGetParams creates a new NvmeInterfaceCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNvmeInterfaceCollectionGetParams() *NvmeInterfaceCollectionGetParams {
	return &NvmeInterfaceCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNvmeInterfaceCollectionGetParamsWithTimeout creates a new NvmeInterfaceCollectionGetParams object
// with the ability to set a timeout on a request.
func NewNvmeInterfaceCollectionGetParamsWithTimeout(timeout time.Duration) *NvmeInterfaceCollectionGetParams {
	return &NvmeInterfaceCollectionGetParams{
		timeout: timeout,
	}
}

// NewNvmeInterfaceCollectionGetParamsWithContext creates a new NvmeInterfaceCollectionGetParams object
// with the ability to set a context for a request.
func NewNvmeInterfaceCollectionGetParamsWithContext(ctx context.Context) *NvmeInterfaceCollectionGetParams {
	return &NvmeInterfaceCollectionGetParams{
		Context: ctx,
	}
}

// NewNvmeInterfaceCollectionGetParamsWithHTTPClient creates a new NvmeInterfaceCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNvmeInterfaceCollectionGetParamsWithHTTPClient(client *http.Client) *NvmeInterfaceCollectionGetParams {
	return &NvmeInterfaceCollectionGetParams{
		HTTPClient: client,
	}
}

/*
NvmeInterfaceCollectionGetParams contains all the parameters to send to the API endpoint

	for the nvme interface collection get operation.

	Typically these are written to a http.Request.
*/
type NvmeInterfaceCollectionGetParams struct {

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* FcInterfacePortName.

	   Filter by fc_interface.port.name
	*/
	FcInterfacePortName *string

	/* FcInterfacePortNodeName.

	   Filter by fc_interface.port.node.name
	*/
	FcInterfacePortNodeName *string

	/* FcInterfacePortUUID.

	   Filter by fc_interface.port.uuid
	*/
	FcInterfacePortUUID *string

	/* FcInterfaceWwnn.

	   Filter by fc_interface.wwnn
	*/
	FcInterfaceWwnn *string

	/* FcInterfaceWwpn.

	   Filter by fc_interface.wwpn
	*/
	FcInterfaceWwpn *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* InterfaceType.

	   Filter by interface_type
	*/
	InterfaceType *string

	/* IPInterfaceIPAddress.

	   Filter by ip_interface.ip.address
	*/
	IPInterfaceIPAddress *string

	/* IPInterfaceLocationPortName.

	   Filter by ip_interface.location.port.name
	*/
	IPInterfaceLocationPortName *string

	/* IPInterfaceLocationPortNodeName.

	   Filter by ip_interface.location.port.node.name
	*/
	IPInterfaceLocationPortNodeName *string

	/* IPInterfaceLocationPortUUID.

	   Filter by ip_interface.location.port.uuid
	*/
	IPInterfaceLocationPortUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TransportAddress.

	   Filter by transport_address
	*/
	TransportAddress *string

	/* TransportProtocols.

	   Filter by transport_protocols
	*/
	TransportProtocols *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nvme interface collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeInterfaceCollectionGetParams) WithDefaults() *NvmeInterfaceCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nvme interface collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeInterfaceCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NvmeInterfaceCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithTimeout(timeout time.Duration) *NvmeInterfaceCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithContext(ctx context.Context) *NvmeInterfaceCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithHTTPClient(client *http.Client) *NvmeInterfaceCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEnabled adds the enabled to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithEnabled(enabled *bool) *NvmeInterfaceCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFcInterfacePortName adds the fcInterfacePortName to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithFcInterfacePortName(fcInterfacePortName *string) *NvmeInterfaceCollectionGetParams {
	o.SetFcInterfacePortName(fcInterfacePortName)
	return o
}

// SetFcInterfacePortName adds the fcInterfacePortName to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetFcInterfacePortName(fcInterfacePortName *string) {
	o.FcInterfacePortName = fcInterfacePortName
}

// WithFcInterfacePortNodeName adds the fcInterfacePortNodeName to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithFcInterfacePortNodeName(fcInterfacePortNodeName *string) *NvmeInterfaceCollectionGetParams {
	o.SetFcInterfacePortNodeName(fcInterfacePortNodeName)
	return o
}

// SetFcInterfacePortNodeName adds the fcInterfacePortNodeName to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetFcInterfacePortNodeName(fcInterfacePortNodeName *string) {
	o.FcInterfacePortNodeName = fcInterfacePortNodeName
}

// WithFcInterfacePortUUID adds the fcInterfacePortUUID to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithFcInterfacePortUUID(fcInterfacePortUUID *string) *NvmeInterfaceCollectionGetParams {
	o.SetFcInterfacePortUUID(fcInterfacePortUUID)
	return o
}

// SetFcInterfacePortUUID adds the fcInterfacePortUuid to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetFcInterfacePortUUID(fcInterfacePortUUID *string) {
	o.FcInterfacePortUUID = fcInterfacePortUUID
}

// WithFcInterfaceWwnn adds the fcInterfaceWwnn to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithFcInterfaceWwnn(fcInterfaceWwnn *string) *NvmeInterfaceCollectionGetParams {
	o.SetFcInterfaceWwnn(fcInterfaceWwnn)
	return o
}

// SetFcInterfaceWwnn adds the fcInterfaceWwnn to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetFcInterfaceWwnn(fcInterfaceWwnn *string) {
	o.FcInterfaceWwnn = fcInterfaceWwnn
}

// WithFcInterfaceWwpn adds the fcInterfaceWwpn to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithFcInterfaceWwpn(fcInterfaceWwpn *string) *NvmeInterfaceCollectionGetParams {
	o.SetFcInterfaceWwpn(fcInterfaceWwpn)
	return o
}

// SetFcInterfaceWwpn adds the fcInterfaceWwpn to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetFcInterfaceWwpn(fcInterfaceWwpn *string) {
	o.FcInterfaceWwpn = fcInterfaceWwpn
}

// WithFields adds the fields to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithFields(fields []string) *NvmeInterfaceCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInterfaceType adds the interfaceType to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithInterfaceType(interfaceType *string) *NvmeInterfaceCollectionGetParams {
	o.SetInterfaceType(interfaceType)
	return o
}

// SetInterfaceType adds the interfaceType to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetInterfaceType(interfaceType *string) {
	o.InterfaceType = interfaceType
}

// WithIPInterfaceIPAddress adds the iPInterfaceIPAddress to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithIPInterfaceIPAddress(iPInterfaceIPAddress *string) *NvmeInterfaceCollectionGetParams {
	o.SetIPInterfaceIPAddress(iPInterfaceIPAddress)
	return o
}

// SetIPInterfaceIPAddress adds the ipInterfaceIpAddress to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetIPInterfaceIPAddress(iPInterfaceIPAddress *string) {
	o.IPInterfaceIPAddress = iPInterfaceIPAddress
}

// WithIPInterfaceLocationPortName adds the iPInterfaceLocationPortName to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithIPInterfaceLocationPortName(iPInterfaceLocationPortName *string) *NvmeInterfaceCollectionGetParams {
	o.SetIPInterfaceLocationPortName(iPInterfaceLocationPortName)
	return o
}

// SetIPInterfaceLocationPortName adds the ipInterfaceLocationPortName to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetIPInterfaceLocationPortName(iPInterfaceLocationPortName *string) {
	o.IPInterfaceLocationPortName = iPInterfaceLocationPortName
}

// WithIPInterfaceLocationPortNodeName adds the iPInterfaceLocationPortNodeName to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithIPInterfaceLocationPortNodeName(iPInterfaceLocationPortNodeName *string) *NvmeInterfaceCollectionGetParams {
	o.SetIPInterfaceLocationPortNodeName(iPInterfaceLocationPortNodeName)
	return o
}

// SetIPInterfaceLocationPortNodeName adds the ipInterfaceLocationPortNodeName to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetIPInterfaceLocationPortNodeName(iPInterfaceLocationPortNodeName *string) {
	o.IPInterfaceLocationPortNodeName = iPInterfaceLocationPortNodeName
}

// WithIPInterfaceLocationPortUUID adds the iPInterfaceLocationPortUUID to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithIPInterfaceLocationPortUUID(iPInterfaceLocationPortUUID *string) *NvmeInterfaceCollectionGetParams {
	o.SetIPInterfaceLocationPortUUID(iPInterfaceLocationPortUUID)
	return o
}

// SetIPInterfaceLocationPortUUID adds the ipInterfaceLocationPortUuid to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetIPInterfaceLocationPortUUID(iPInterfaceLocationPortUUID *string) {
	o.IPInterfaceLocationPortUUID = iPInterfaceLocationPortUUID
}

// WithMaxRecords adds the maxRecords to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithMaxRecords(maxRecords *int64) *NvmeInterfaceCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithName(name *string) *NvmeInterfaceCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithNodeName adds the nodeName to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithNodeName(nodeName *string) *NvmeInterfaceCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithNodeUUID(nodeUUID *string) *NvmeInterfaceCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithOrderBy(orderBy []string) *NvmeInterfaceCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithReturnRecords(returnRecords *bool) *NvmeInterfaceCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *NvmeInterfaceCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithSvmName(svmName *string) *NvmeInterfaceCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithSvmUUID(svmUUID *string) *NvmeInterfaceCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTransportAddress adds the transportAddress to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithTransportAddress(transportAddress *string) *NvmeInterfaceCollectionGetParams {
	o.SetTransportAddress(transportAddress)
	return o
}

// SetTransportAddress adds the transportAddress to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetTransportAddress(transportAddress *string) {
	o.TransportAddress = transportAddress
}

// WithTransportProtocols adds the transportProtocols to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithTransportProtocols(transportProtocols *string) *NvmeInterfaceCollectionGetParams {
	o.SetTransportProtocols(transportProtocols)
	return o
}

// SetTransportProtocols adds the transportProtocols to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetTransportProtocols(transportProtocols *string) {
	o.TransportProtocols = transportProtocols
}

// WithUUID adds the uuid to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) WithUUID(uuid *string) *NvmeInterfaceCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the nvme interface collection get params
func (o *NvmeInterfaceCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *NvmeInterfaceCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.FcInterfacePortName != nil {

		// query param fc_interface.port.name
		var qrFcInterfacePortName string

		if o.FcInterfacePortName != nil {
			qrFcInterfacePortName = *o.FcInterfacePortName
		}
		qFcInterfacePortName := qrFcInterfacePortName
		if qFcInterfacePortName != "" {

			if err := r.SetQueryParam("fc_interface.port.name", qFcInterfacePortName); err != nil {
				return err
			}
		}
	}

	if o.FcInterfacePortNodeName != nil {

		// query param fc_interface.port.node.name
		var qrFcInterfacePortNodeName string

		if o.FcInterfacePortNodeName != nil {
			qrFcInterfacePortNodeName = *o.FcInterfacePortNodeName
		}
		qFcInterfacePortNodeName := qrFcInterfacePortNodeName
		if qFcInterfacePortNodeName != "" {

			if err := r.SetQueryParam("fc_interface.port.node.name", qFcInterfacePortNodeName); err != nil {
				return err
			}
		}
	}

	if o.FcInterfacePortUUID != nil {

		// query param fc_interface.port.uuid
		var qrFcInterfacePortUUID string

		if o.FcInterfacePortUUID != nil {
			qrFcInterfacePortUUID = *o.FcInterfacePortUUID
		}
		qFcInterfacePortUUID := qrFcInterfacePortUUID
		if qFcInterfacePortUUID != "" {

			if err := r.SetQueryParam("fc_interface.port.uuid", qFcInterfacePortUUID); err != nil {
				return err
			}
		}
	}

	if o.FcInterfaceWwnn != nil {

		// query param fc_interface.wwnn
		var qrFcInterfaceWwnn string

		if o.FcInterfaceWwnn != nil {
			qrFcInterfaceWwnn = *o.FcInterfaceWwnn
		}
		qFcInterfaceWwnn := qrFcInterfaceWwnn
		if qFcInterfaceWwnn != "" {

			if err := r.SetQueryParam("fc_interface.wwnn", qFcInterfaceWwnn); err != nil {
				return err
			}
		}
	}

	if o.FcInterfaceWwpn != nil {

		// query param fc_interface.wwpn
		var qrFcInterfaceWwpn string

		if o.FcInterfaceWwpn != nil {
			qrFcInterfaceWwpn = *o.FcInterfaceWwpn
		}
		qFcInterfaceWwpn := qrFcInterfaceWwpn
		if qFcInterfaceWwpn != "" {

			if err := r.SetQueryParam("fc_interface.wwpn", qFcInterfaceWwpn); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.InterfaceType != nil {

		// query param interface_type
		var qrInterfaceType string

		if o.InterfaceType != nil {
			qrInterfaceType = *o.InterfaceType
		}
		qInterfaceType := qrInterfaceType
		if qInterfaceType != "" {

			if err := r.SetQueryParam("interface_type", qInterfaceType); err != nil {
				return err
			}
		}
	}

	if o.IPInterfaceIPAddress != nil {

		// query param ip_interface.ip.address
		var qrIPInterfaceIPAddress string

		if o.IPInterfaceIPAddress != nil {
			qrIPInterfaceIPAddress = *o.IPInterfaceIPAddress
		}
		qIPInterfaceIPAddress := qrIPInterfaceIPAddress
		if qIPInterfaceIPAddress != "" {

			if err := r.SetQueryParam("ip_interface.ip.address", qIPInterfaceIPAddress); err != nil {
				return err
			}
		}
	}

	if o.IPInterfaceLocationPortName != nil {

		// query param ip_interface.location.port.name
		var qrIPInterfaceLocationPortName string

		if o.IPInterfaceLocationPortName != nil {
			qrIPInterfaceLocationPortName = *o.IPInterfaceLocationPortName
		}
		qIPInterfaceLocationPortName := qrIPInterfaceLocationPortName
		if qIPInterfaceLocationPortName != "" {

			if err := r.SetQueryParam("ip_interface.location.port.name", qIPInterfaceLocationPortName); err != nil {
				return err
			}
		}
	}

	if o.IPInterfaceLocationPortNodeName != nil {

		// query param ip_interface.location.port.node.name
		var qrIPInterfaceLocationPortNodeName string

		if o.IPInterfaceLocationPortNodeName != nil {
			qrIPInterfaceLocationPortNodeName = *o.IPInterfaceLocationPortNodeName
		}
		qIPInterfaceLocationPortNodeName := qrIPInterfaceLocationPortNodeName
		if qIPInterfaceLocationPortNodeName != "" {

			if err := r.SetQueryParam("ip_interface.location.port.node.name", qIPInterfaceLocationPortNodeName); err != nil {
				return err
			}
		}
	}

	if o.IPInterfaceLocationPortUUID != nil {

		// query param ip_interface.location.port.uuid
		var qrIPInterfaceLocationPortUUID string

		if o.IPInterfaceLocationPortUUID != nil {
			qrIPInterfaceLocationPortUUID = *o.IPInterfaceLocationPortUUID
		}
		qIPInterfaceLocationPortUUID := qrIPInterfaceLocationPortUUID
		if qIPInterfaceLocationPortUUID != "" {

			if err := r.SetQueryParam("ip_interface.location.port.uuid", qIPInterfaceLocationPortUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TransportAddress != nil {

		// query param transport_address
		var qrTransportAddress string

		if o.TransportAddress != nil {
			qrTransportAddress = *o.TransportAddress
		}
		qTransportAddress := qrTransportAddress
		if qTransportAddress != "" {

			if err := r.SetQueryParam("transport_address", qTransportAddress); err != nil {
				return err
			}
		}
	}

	if o.TransportProtocols != nil {

		// query param transport_protocols
		var qrTransportProtocols string

		if o.TransportProtocols != nil {
			qrTransportProtocols = *o.TransportProtocols
		}
		qTransportProtocols := qrTransportProtocols
		if qTransportProtocols != "" {

			if err := r.SetQueryParam("transport_protocols", qTransportProtocols); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNvmeInterfaceCollectionGet binds the parameter fields
func (o *NvmeInterfaceCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNvmeInterfaceCollectionGet binds the parameter order_by
func (o *NvmeInterfaceCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
