// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NvmeNamespaceModifyCollectionReader is a Reader for the NvmeNamespaceModifyCollection structure.
type NvmeNamespaceModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NvmeNamespaceModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNvmeNamespaceModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewNvmeNamespaceModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNvmeNamespaceModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNvmeNamespaceModifyCollectionOK creates a NvmeNamespaceModifyCollectionOK with default headers values
func NewNvmeNamespaceModifyCollectionOK() *NvmeNamespaceModifyCollectionOK {
	return &NvmeNamespaceModifyCollectionOK{}
}

/*
NvmeNamespaceModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NvmeNamespaceModifyCollectionOK struct {
}

// IsSuccess returns true when this nvme namespace modify collection o k response has a 2xx status code
func (o *NvmeNamespaceModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme namespace modify collection o k response has a 3xx status code
func (o *NvmeNamespaceModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme namespace modify collection o k response has a 4xx status code
func (o *NvmeNamespaceModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme namespace modify collection o k response has a 5xx status code
func (o *NvmeNamespaceModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme namespace modify collection o k response a status code equal to that given
func (o *NvmeNamespaceModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nvme namespace modify collection o k response
func (o *NvmeNamespaceModifyCollectionOK) Code() int {
	return 200
}

func (o *NvmeNamespaceModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/namespaces][%d] nvmeNamespaceModifyCollectionOK", 200)
}

func (o *NvmeNamespaceModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /storage/namespaces][%d] nvmeNamespaceModifyCollectionOK", 200)
}

func (o *NvmeNamespaceModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNvmeNamespaceModifyCollectionAccepted creates a NvmeNamespaceModifyCollectionAccepted with default headers values
func NewNvmeNamespaceModifyCollectionAccepted() *NvmeNamespaceModifyCollectionAccepted {
	return &NvmeNamespaceModifyCollectionAccepted{}
}

/*
NvmeNamespaceModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type NvmeNamespaceModifyCollectionAccepted struct {
	Payload *models.NvmeNamespaceJobLinkResponse
}

// IsSuccess returns true when this nvme namespace modify collection accepted response has a 2xx status code
func (o *NvmeNamespaceModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme namespace modify collection accepted response has a 3xx status code
func (o *NvmeNamespaceModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme namespace modify collection accepted response has a 4xx status code
func (o *NvmeNamespaceModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme namespace modify collection accepted response has a 5xx status code
func (o *NvmeNamespaceModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme namespace modify collection accepted response a status code equal to that given
func (o *NvmeNamespaceModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the nvme namespace modify collection accepted response
func (o *NvmeNamespaceModifyCollectionAccepted) Code() int {
	return 202
}

func (o *NvmeNamespaceModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/namespaces][%d] nvmeNamespaceModifyCollectionAccepted %s", 202, payload)
}

func (o *NvmeNamespaceModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/namespaces][%d] nvmeNamespaceModifyCollectionAccepted %s", 202, payload)
}

func (o *NvmeNamespaceModifyCollectionAccepted) GetPayload() *models.NvmeNamespaceJobLinkResponse {
	return o.Payload
}

func (o *NvmeNamespaceModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NvmeNamespaceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNvmeNamespaceModifyCollectionDefault creates a NvmeNamespaceModifyCollectionDefault with default headers values
func NewNvmeNamespaceModifyCollectionDefault(code int) *NvmeNamespaceModifyCollectionDefault {
	return &NvmeNamespaceModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	NvmeNamespaceModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374127 | The specified namespace name is invalid. |
| 5376461 | The specified namespace name is invalid. |
| 5376462 | The specified namespace name is too long. |
| 5376463 | The snapshot portion of the specified namespace name is too long. |
| 5376466 | An attempt was made to rename an NVMe namespace to a snapshot name. |
| 5376467 | An attempt was made to rename a primary NVMe namespace to a secondary name. |
| 5376468 | An attempt was made to rename an NVMe namespace to a reserved name. |
| 13565952 | The namespace clone request failed. |
| 72089724 | The specified namespace size is too large. |
| 72089730 | The specified namespace cannot be updated as it resides in a snapshot. |
| 72090005 | The specified `clone.source.uuid` and `clone.source.name` do not refer to the same LUN. |
| 72090006 | The specified namespace was not found. This can apply to `clone.source` or the target namespace. The `target` property of the error object identifies the property. |
| 72090007 | The specified namespace was not found. This can apply to `clone.source` or the target namespace. The `target` property of the error object identifies the property. |
| 72090010 | An error occurred after successfully overwriting data for the namespace as a clone. Some properties were not modified. |
| 72090011 | An error occurred after successfully modifying some of the properties of the namespace. Some properties were not modified. |
| 72090016 | The namespace's aggregate is offline. The aggregate must be online to modify or remove the namespace. |
| 72090017 | The namespace's volume is offline. The volume must be online to modify or remove the namespace. |
| 72090038 | An attempt was made to reduce the size of the specified namespace. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NvmeNamespaceModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nvme namespace modify collection default response has a 2xx status code
func (o *NvmeNamespaceModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nvme namespace modify collection default response has a 3xx status code
func (o *NvmeNamespaceModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nvme namespace modify collection default response has a 4xx status code
func (o *NvmeNamespaceModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nvme namespace modify collection default response has a 5xx status code
func (o *NvmeNamespaceModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nvme namespace modify collection default response a status code equal to that given
func (o *NvmeNamespaceModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nvme namespace modify collection default response
func (o *NvmeNamespaceModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NvmeNamespaceModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/namespaces][%d] nvme_namespace_modify_collection default %s", o._statusCode, payload)
}

func (o *NvmeNamespaceModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/namespaces][%d] nvme_namespace_modify_collection default %s", o._statusCode, payload)
}

func (o *NvmeNamespaceModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NvmeNamespaceModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NvmeNamespaceModifyCollectionBody nvme namespace modify collection body
swagger:model NvmeNamespaceModifyCollectionBody
*/
type NvmeNamespaceModifyCollectionBody struct {

	// links
	Links *models.NvmeNamespaceInlineLinks `json:"_links,omitempty"`

	// <personalities supports=unified>This property marks the NVMe namespace for auto deletion when the volume containing the namespace runs out of space. This is most commonly set on namespace clones.<br/>
	// When set to _true_, the NVMe namespace becomes eligible for automatic deletion when the volume runs out of space. Auto deletion only occurs when the volume containing the namespace is also configured for auto deletion and free space in the volume decreases below a particular threshold.<br/>
	// This property is optional in POST and PATCH. The default value for a new NVMe namespace is _false_.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
	// <personalities supports=asar2>This property is not supported. It cannot be set in POST or PATCH and will not be returned by GET.</personalities>
	//
	AutoDelete *bool `json:"auto_delete,omitempty"`

	// clone
	Clone *models.NvmeNamespaceInlineClone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// consistency group
	ConsistencyGroup *models.NvmeNamespaceInlineConsistencyGroup `json:"consistency_group,omitempty"`

	// convert
	Convert *models.NvmeNamespaceInlineConvert `json:"convert,omitempty"`

	// The time the NVMe namespace was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the NVMe namespace. Certain error conditions cause the namespace to become disabled. If the namespace is disabled, check the `status.state` property to determine what error disabled the namespace. An NVMe namespace is enabled automatically when it is created.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// encryption
	Encryption *models.StorageUnitEncryption `json:"encryption,omitempty"`

	// location
	Location *models.NvmeNamespaceInlineLocation `json:"location,omitempty"`

	// metric
	Metric *models.NvmeNamespaceInlineMetric `json:"metric,omitempty"`

	// The name of the NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Renaming an NVMe namespace is not supported. Valid in POST.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
	// Renaming an NVMe namespace is supported. Valid in POST and PATCH.</personalities>
	//
	// Example: /vol/volume1/qtree1/namespace1
	Name *string `json:"name,omitempty"`

	// nvme namespace response inline records
	NvmeNamespaceResponseInlineRecords []*models.NvmeNamespace `json:"records,omitempty"`

	// The operating system type of the NVMe namespace.<br/>
	// Required in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *models.NvmeNamespaceInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos policy
	QosPolicy *models.NvmeNamespaceInlineQosPolicy `json:"qos_policy,omitempty"`

	// space
	Space *models.NvmeNamespaceInlineSpace `json:"space,omitempty"`

	// statistics
	Statistics *models.NvmeNamespaceInlineStatistics `json:"statistics,omitempty"`

	// status
	Status *models.NvmeNamespaceInlineStatus `json:"status,omitempty"`

	// subsystem map
	SubsystemMap *models.NvmeNamespaceInlineSubsystemMap `json:"subsystem_map,omitempty"`

	// svm
	Svm *models.NvmeNamespaceInlineSvm `json:"svm,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace modify collection body
func (o *NvmeNamespaceModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConvert(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNvmeNamespaceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(o.Clone) { // not required
		return nil
	}

	if o.Clone != nil {
		if err := o.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyGroup) { // not required
		return nil
	}

	if o.ConsistencyGroup != nil {
		if err := o.ConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateConvert(formats strfmt.Registry) error {
	if swag.IsZero(o.Convert) { // not required
		return nil
	}

	if o.Convert != nil {
		if err := o.Convert.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "convert")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(o.Encryption) { // not required
		return nil
	}

	if o.Encryption != nil {
		if err := o.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateNvmeNamespaceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NvmeNamespaceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NvmeNamespaceResponseInlineRecords); i++ {
		if swag.IsZero(o.NvmeNamespaceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NvmeNamespaceResponseInlineRecords[i] != nil {
			if err := o.NvmeNamespaceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nvmeNamespaceModifyCollectionBodyTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceModifyCollectionBodyTypeOsTypePropEnum = append(nvmeNamespaceModifyCollectionBodyTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NvmeNamespaceModifyCollectionBody
	// NvmeNamespaceModifyCollectionBody
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// NvmeNamespaceModifyCollectionBodyOsTypeAix captures enum value "aix"
	NvmeNamespaceModifyCollectionBodyOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// NvmeNamespaceModifyCollectionBody
	// NvmeNamespaceModifyCollectionBody
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// NvmeNamespaceModifyCollectionBodyOsTypeLinux captures enum value "linux"
	NvmeNamespaceModifyCollectionBodyOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// NvmeNamespaceModifyCollectionBody
	// NvmeNamespaceModifyCollectionBody
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// NvmeNamespaceModifyCollectionBodyOsTypeVmware captures enum value "vmware"
	NvmeNamespaceModifyCollectionBodyOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// NvmeNamespaceModifyCollectionBody
	// NvmeNamespaceModifyCollectionBody
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// NvmeNamespaceModifyCollectionBodyOsTypeWindows captures enum value "windows"
	NvmeNamespaceModifyCollectionBodyOsTypeWindows string = "windows"
)

// prop value enum
func (o *NvmeNamespaceModifyCollectionBody) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceModifyCollectionBodyTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("info"+"."+"os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(o.ProvisioningOptions) { // not required
		return nil
	}

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.QosPolicy) { // not required
		return nil
	}

	if o.QosPolicy != nil {
		if err := o.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(o.SubsystemMap) { // not required
		return nil
	}

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace modify collection body based on the context it is used
func (o *NvmeNamespaceModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConvert(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNvmeNamespaceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if o.Clone != nil {
		if err := o.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.ConsistencyGroup != nil {
		if err := o.ConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateConvert(ctx context.Context, formats strfmt.Registry) error {

	if o.Convert != nil {
		if err := o.Convert.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "convert")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if o.Encryption != nil {
		if err := o.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {
		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateNvmeNamespaceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NvmeNamespaceResponseInlineRecords); i++ {

		if o.NvmeNamespaceResponseInlineRecords[i] != nil {
			if err := o.NvmeNamespaceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if o.ProvisioningOptions != nil {
		if err := o.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.QosPolicy != nil {
		if err := o.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsExcludeAggregatesItems0 nvme namespace modify collection params body provisioning options exclude aggregates items0
swagger:model NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsExcludeAggregatesItems0
*/
type NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsExcludeAggregatesItems0 struct {

	// The aggregate name.
	//
	// Example: aggr1
	Name *string `json:"name,omitempty"`
}

// Validate validates this nvme namespace modify collection params body provisioning options exclude aggregates items0
func (o *NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsExcludeAggregatesItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nvme namespace modify collection params body provisioning options exclude aggregates items0 based on context it is used
func (o *NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsExcludeAggregatesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsExcludeAggregatesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsExcludeAggregatesItems0) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsExcludeAggregatesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsTieringObjectStoresItems0 nvme namespace modify collection params body provisioning options tiering object stores items0
swagger:model NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsTieringObjectStoresItems0
*/
type NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsTieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this nvme namespace modify collection params body provisioning options tiering object stores items0
func (o *NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsTieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nvme namespace modify collection params body provisioning options tiering object stores items0 based on context it is used
func (o *NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsTieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsTieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsTieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsTieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0 The NVMe host provisioned to access NVMe namespaces mapped to a subsystem.
//
swagger:model NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0
*/
type NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0 struct {

	// dh hmac chap
	DhHmacChap *models.ConsistencyGroupNvmeHostDhHmacChap `json:"dh_hmac_chap,omitempty"`

	// The NVMe qualified name (NQN) used to identify the NVMe storage target.
	//
	// Example: nqn.1992-01.example.com:string
	Nqn *string `json:"nqn,omitempty"`

	// The host priority setting allocates appropriate NVMe I/O queues (count and depth) for the host to submit I/O commands. Absence of this property in GET implies io_queue count and I/O queue depth are being used.
	//
	// Enum: ["regular","high"]
	Priority *string `json:"priority,omitempty"`

	// proximity
	Proximity *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0Proximity `json:"proximity,omitempty"`

	// tls
	TLS *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS `json:"tls,omitempty"`
}

// Validate validates this nvme namespace modify collection params body subsystem map subsystem hosts items0
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDhHmacChap(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePriority(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTLS(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0) validateDhHmacChap(formats strfmt.Registry) error {
	if swag.IsZero(o.DhHmacChap) { // not required
		return nil
	}

	if o.DhHmacChap != nil {
		if err := o.DhHmacChap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

var nvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TypePriorityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["regular","high"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TypePriorityPropEnum = append(nvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TypePriorityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0
	// NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0
	// priority
	// Priority
	// regular
	// END DEBUGGING
	// NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0PriorityRegular captures enum value "regular"
	NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0PriorityRegular string = "regular"

	// BEGIN DEBUGGING
	// NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0
	// NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0
	// priority
	// Priority
	// high
	// END DEBUGGING
	// NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0PriorityHigh captures enum value "high"
	NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0PriorityHigh string = "high"
)

// prop value enum
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0) validatePriorityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TypePriorityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0) validatePriority(formats strfmt.Registry) error {
	if swag.IsZero(o.Priority) { // not required
		return nil
	}

	// value enum
	if err := o.validatePriorityEnum("priority", "body", *o.Priority); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(o.Proximity) { // not required
		return nil
	}

	if o.Proximity != nil {
		if err := o.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0) validateTLS(formats strfmt.Registry) error {
	if swag.IsZero(o.TLS) { // not required
		return nil
	}

	if o.TLS != nil {
		if err := o.TLS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace modify collection params body subsystem map subsystem hosts items0 based on the context it is used
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDhHmacChap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTLS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0) contextValidateDhHmacChap(ctx context.Context, formats strfmt.Registry) error {

	if o.DhHmacChap != nil {
		if err := o.DhHmacChap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if o.Proximity != nil {
		if err := o.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0) contextValidateTLS(ctx context.Context, formats strfmt.Registry) error {

	if o.TLS != nil {
		if err := o.TLS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0Proximity Properties that define the SVMs to which the host is proximal. This information is used to properly report active optimized and active non-optimized network paths using an NVMe controller. If no configuration has been specified for the host, the sub-object is not present in GET requests.<br/>
// These properties apply to all instances of the host in the NVMe subsystem in the SVM and its peers.
//
swagger:model NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0Proximity
*/
type NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0Proximity struct {

	// A boolean that indicates if the host is proximal to the SVM for which it is configured.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the host is proximal.
	//
	PeerSvms []*NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0 `json:"peer_svms"`
}

// Validate validates this nvme namespace modify collection params body subsystem map subsystem hosts items0 proximity
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0Proximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0Proximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(o.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(o.PeerSvms); i++ {
		if swag.IsZero(o.PeerSvms[i]) { // not required
			continue
		}

		if o.PeerSvms[i] != nil {
			if err := o.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this nvme namespace modify collection params body subsystem map subsystem hosts items0 proximity based on the context it is used
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0Proximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0Proximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.PeerSvms); i++ {

		if o.PeerSvms[i] != nil {
			if err := o.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0Proximity) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0Proximity) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0Proximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0 A reference to an SVM peer relationship.
swagger:model NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0
*/
type NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0 struct {

	// links
	Links *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace modify collection params body subsystem map subsystem hosts items0 proximity peer svms items0
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace modify collection params body subsystem map subsystem hosts items0 proximity peer svms items0 based on the context it is used
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links nvme namespace modify collection params body subsystem map subsystem hosts items0 proximity peer svms items0 links
swagger:model NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links
*/
type NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace modify collection params body subsystem map subsystem hosts items0 proximity peer svms items0 links
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace modify collection params body subsystem map subsystem hosts items0 proximity peer svms items0 links based on the context it is used
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS A container for the configuration for NVMe/TCP-TLS transport session for the host.
//
swagger:model NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS
*/
type NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS struct {

	// A user supplied pre-shared key (PSK) value in PSK Interchange Format. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree. This property is only allowed when `key_type` is `configured`. If `configured_psk` is supplied and `key_type` is unset, `key_type` defaults to `configured`.</br>
	// This property is write-only. The `key_type` property can be used to identify if a configured PSK has been set for the host, but the PSK value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: NVMeTLSkey-1:01:VRLbtnN9AQb2WXW3c9+wEf/DRLz0QuLdbYvEhwtdWwNf9LrZ:
	ConfiguredPsk *string `json:"configured_psk,omitempty"`

	// The method by which the TLS pre-shared key (PSK) is configured for the host. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree.</br>
	// Possible values:
	// - `none` - TLS is not configured for the host connection. No value is allowed for property `configured_psk`.
	// - `configured` - A user supplied PSK is configured for the NVMe/TCP-TLS transport connection between the host and the NVMe subsystem. A valid value for property `configured_psk` is required.
	// </br>
	// This property defaults to `none` unless a value is supplied for `configured_psk` in which case it defaults to `configured`.
	//
	// Example: configured
	// Enum: ["none","configured"]
	KeyType *string `json:"key_type,omitempty"`
}

// Validate validates this nvme namespace modify collection params body subsystem map subsystem hosts items0 TLS
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateKeyType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TlsTypeKeyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","configured"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TlsTypeKeyTypePropEnum = append(nvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TlsTypeKeyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS
	// NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS
	// key_type
	// KeyType
	// none
	// END DEBUGGING
	// NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLSKeyTypeNone captures enum value "none"
	NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLSKeyTypeNone string = "none"

	// BEGIN DEBUGGING
	// NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS
	// NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS
	// key_type
	// KeyType
	// configured
	// END DEBUGGING
	// NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLSKeyTypeConfigured captures enum value "configured"
	NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLSKeyTypeConfigured string = "configured"
)

// prop value enum
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS) validateKeyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TlsTypeKeyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS) validateKeyType(formats strfmt.Registry) error {
	if swag.IsZero(o.KeyType) { // not required
		return nil
	}

	// value enum
	if err := o.validateKeyTypeEnum("tls"+"."+"key_type", "body", *o.KeyType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nvme namespace modify collection params body subsystem map subsystem hosts items0 TLS based on context it is used
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0TLS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineLinks nvme namespace inline links
swagger:model nvme_namespace_inline__links
*/
type NvmeNamespaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline links
func (o *NvmeNamespaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline links based on the context it is used
func (o *NvmeNamespaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineClone <personalities supports=unified>This sub-object is used in POST to create a new NVMe namespace as a clone of an existing namespace, or PATCH to overwrite an existing namespace as a clone of another. Setting a property in this sub-object indicates that a namespace clone is desired.<br/>
// When used in a PATCH, the patched NVMe namespace's data is over-written as a clone of the source and the following properties are preserved from the patched namespace unless otherwise specified as part of the PATCH: `auto_delete` (unless specified in the request), `subsystem_map`, `status.state`, and `uuid`.</personalities>
// <personalities supports=asar2>This endpoint does not support clones. No properties in this sub-object can be set for POST or PATCH and none will be returned by GET.<br/>
// Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning NVMe namespaces.</personalities>
//
swagger:model nvme_namespace_inline_clone
*/
type NvmeNamespaceInlineClone struct {

	// source
	Source *models.NvmeNamespaceInlineCloneInlineSource `json:"source,omitempty"`
}

// Validate validates this nvme namespace inline clone
func (o *NvmeNamespaceInlineClone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineClone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(o.Source) { // not required
		return nil
	}

	if o.Source != nil {
		if err := o.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline clone based on the context it is used
func (o *NvmeNamespaceInlineClone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineClone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if o.Source != nil {
		if err := o.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineClone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineClone) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineClone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineCloneInlineSource The source NVMe namespace for a namespace clone operation. This can be specified using property `clone.source.uuid` or `clone.source.name`. If both properties are supplied, they must refer to the same namespace.<br/>
// Valid in POST to create a new NVMe namespace as a clone of the source.<br/>
// Valid in PATCH to overwrite an existing NVMe namespace's data as a clone of another.
//
swagger:model nvme_namespace_inline_clone_inline_source
*/
type NvmeNamespaceInlineCloneInlineSource struct {

	// The name of the clone source NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning NVMe namespaces.</personalities>
	//
	// Example: /vol/volume1/namespace1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the clone source NVMe namespace.
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning NVMe namespaces.</personalities>
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline clone inline source
func (o *NvmeNamespaceInlineCloneInlineSource) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nvme namespace inline clone inline source based on context it is used
func (o *NvmeNamespaceInlineCloneInlineSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineCloneInlineSource) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineCloneInlineSource) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineCloneInlineSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineConsistencyGroup The namespace's consistency group. This property is populated for namespaces that are members of a consistency group. If the namespace is a member of a child consistency group, the parent consistency group is reported.
// <personalities supports=unified>A namespace's consistency group is the consistency group of its containing volume.</personalities>
// <personalities supports=asar2>A namespace is optionally associated directly with a consistency group.</personalities>
//
swagger:model nvme_namespace_inline_consistency_group
*/
type NvmeNamespaceInlineConsistencyGroup struct {

	// links
	Links *models.NvmeNamespaceInlineConsistencyGroupInlineLinks `json:"_links,omitempty"`

	// The name of the consistency group.
	//
	// Example: cg1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	//
	// Example: 4abc2317-4332-9d37-93a0-20bd29c22df0
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline consistency group
func (o *NvmeNamespaceInlineConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline consistency group based on the context it is used
func (o *NvmeNamespaceInlineConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineConsistencyGroup) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"consistency_group"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineConsistencyGroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"consistency_group"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineConsistencyGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineConsistencyGroupInlineLinks nvme namespace inline consistency group inline links
swagger:model nvme_namespace_inline_consistency_group_inline__links
*/
type NvmeNamespaceInlineConsistencyGroupInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline consistency group inline links
func (o *NvmeNamespaceInlineConsistencyGroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineConsistencyGroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline consistency group inline links based on the context it is used
func (o *NvmeNamespaceInlineConsistencyGroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineConsistencyGroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineConsistencyGroupInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineConsistencyGroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineConsistencyGroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineConvert This sub-object is used in POST to convert a valid in-place LUN to an NVMe namespace. Setting a property in this sub-object indicates that a conversion from the specified LUN to NVMe namespace is desired.<br/>
//
swagger:model nvme_namespace_inline_convert
*/
type NvmeNamespaceInlineConvert struct {

	// lun
	Lun *models.NvmeNamespaceInlineConvertInlineLun `json:"lun,omitempty"`
}

// Validate validates this nvme namespace inline convert
func (o *NvmeNamespaceInlineConvert) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLun(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineConvert) validateLun(formats strfmt.Registry) error {
	if swag.IsZero(o.Lun) { // not required
		return nil
	}

	if o.Lun != nil {
		if err := o.Lun.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "convert" + "." + "lun")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline convert based on the context it is used
func (o *NvmeNamespaceInlineConvert) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLun(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineConvert) contextValidateLun(ctx context.Context, formats strfmt.Registry) error {

	if o.Lun != nil {
		if err := o.Lun.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "convert" + "." + "lun")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineConvert) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineConvert) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineConvert
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineConvertInlineLun The source LUN for convert operation. This can be specified using property `convert.lun.uuid` or `convert.lun.name`. If both properties are supplied, they must refer to the same LUN.<br/>
// Valid in POST. A convert request from LUN to NVMe namespace cannot be combined with setting any other namespace properties. All other properties of the converted NVMe namespace come from the source LUN.<br/>
//
swagger:model nvme_namespace_inline_convert_inline_lun
*/
type NvmeNamespaceInlineConvertInlineLun struct {

	// The name of the source LUN. Valid in POST.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the source LUN. Valid in POST.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline convert inline lun
func (o *NvmeNamespaceInlineConvertInlineLun) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nvme namespace inline convert inline lun based on context it is used
func (o *NvmeNamespaceInlineConvertInlineLun) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineConvertInlineLun) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineConvertInlineLun) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineConvertInlineLun
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineLocation The location of the NVMe namespace within the ONTAP cluster.
// <personalities supports=unified>NVMe namespaces do not support rename, or movement between volumes. Valid in POST.</personalities>
// <personalities supports=asar2>The NVMe namespace name can be changed by PATCHing the `name` property. The `location` properties are read-only.</personalities>
//
swagger:model nvme_namespace_inline_location
*/
type NvmeNamespaceInlineLocation struct {

	// <personalities supports=unified>The base name component of the NVMe namespace. Valid in POST.<br/>
	// If properties `name` and `location.namespace` are specified in the same request, they must refer to the base name.<br/>
	// NVMe namespaces do not support rename.</personalities>
	// <personalities supports=asar2>The namespace property is read-only and cannot be set in POST or PATCH. Use the `name` property for POST and PATCH.</personalities>
	//
	// Example: namespace1
	Namespace *string `json:"namespace,omitempty"`

	// node
	Node *models.NvmeNamespaceInlineLocationInlineNode `json:"node,omitempty"`

	// qtree
	Qtree *models.NvmeNamespaceInlineLocationInlineQtree `json:"qtree,omitempty"`

	// storage availability zone
	StorageAvailabilityZone *models.NvmeNamespaceInlineLocationInlineStorageAvailabilityZone `json:"storage_availability_zone,omitempty"`

	// volume
	Volume *models.NvmeNamespaceInlineLocationInlineVolume `json:"volume,omitempty"`
}

// Validate validates this nvme namespace inline location
func (o *NvmeNamespaceInlineLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQtree(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageAvailabilityZone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocation) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineLocation) validateQtree(formats strfmt.Registry) error {
	if swag.IsZero(o.Qtree) { // not required
		return nil
	}

	if o.Qtree != nil {
		if err := o.Qtree.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "qtree")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineLocation) validateStorageAvailabilityZone(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageAvailabilityZone) { // not required
		return nil
	}

	if o.StorageAvailabilityZone != nil {
		if err := o.StorageAvailabilityZone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineLocation) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.Volume) { // not required
		return nil
	}

	if o.Volume != nil {
		if err := o.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location based on the context it is used
func (o *NvmeNamespaceInlineLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQtree(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageAvailabilityZone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocation) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineLocation) contextValidateQtree(ctx context.Context, formats strfmt.Registry) error {

	if o.Qtree != nil {
		if err := o.Qtree.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "qtree")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineLocation) contextValidateStorageAvailabilityZone(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageAvailabilityZone != nil {
		if err := o.StorageAvailabilityZone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineLocation) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.Volume != nil {
		if err := o.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocation) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineLocationInlineNode The cluster node that hosts the NVMe namespace.
//
swagger:model nvme_namespace_inline_location_inline_node
*/
type NvmeNamespaceInlineLocationInlineNode struct {

	// links
	Links *models.NvmeNamespaceInlineLocationInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline location inline node
func (o *NvmeNamespaceInlineLocationInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline node based on the context it is used
func (o *NvmeNamespaceInlineLocationInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineNode) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineLocationInlineNodeInlineLinks nvme namespace inline location inline node inline links
swagger:model nvme_namespace_inline_location_inline_node_inline__links
*/
type NvmeNamespaceInlineLocationInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline location inline node inline links
func (o *NvmeNamespaceInlineLocationInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline node inline links based on the context it is used
func (o *NvmeNamespaceInlineLocationInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineLocationInlineQtree <personalities supports=unified>The qtree in which the NVMe namespace is optionally located. Valid in POST.<br/>
// If properties `name` and `location.qtree.name` and/or `location.qtree.uuid` are specified in the same request, they must refer to the same qtree.<br/>
// NVMe namespaces do not support rename.</personalities>
// <personalities supports=asar2>Qtrees are not supported. The properties of the qtree sub-object cannot be set in POST or PATCH.</personalities>
//
swagger:model nvme_namespace_inline_location_inline_qtree
*/
type NvmeNamespaceInlineLocationInlineQtree struct {

	// links
	Links *models.NvmeNamespaceInlineLocationInlineQtreeInlineLinks `json:"_links,omitempty"`

	// The identifier for the qtree, unique within the qtree's volume.
	//
	// Example: 1
	// Maximum: 4994
	// Minimum: 0
	ID *int64 `json:"id,omitempty"`

	// The name of the qtree.
	// Example: qt1
	Name *string `json:"name,omitempty"`
}

// Validate validates this nvme namespace inline location inline qtree
func (o *NvmeNamespaceInlineLocationInlineQtree) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineQtree) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "qtree" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineLocationInlineQtree) validateID(formats strfmt.Registry) error {
	if swag.IsZero(o.ID) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"location"+"."+"qtree"+"."+"id", "body", *o.ID, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"location"+"."+"qtree"+"."+"id", "body", *o.ID, 4994, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline qtree based on the context it is used
func (o *NvmeNamespaceInlineLocationInlineQtree) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineQtree) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "qtree" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineQtree) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineQtree) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineQtree
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineLocationInlineQtreeInlineLinks nvme namespace inline location inline qtree inline links
swagger:model nvme_namespace_inline_location_inline_qtree_inline__links
*/
type NvmeNamespaceInlineLocationInlineQtreeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline location inline qtree inline links
func (o *NvmeNamespaceInlineLocationInlineQtreeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineQtreeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "qtree" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline qtree inline links based on the context it is used
func (o *NvmeNamespaceInlineLocationInlineQtreeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineQtreeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "qtree" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineQtreeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineQtreeInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineQtreeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineLocationInlineStorageAvailabilityZone The storage availability zone that contains the NVMe namespace.
//
swagger:model nvme_namespace_inline_location_inline_storage_availability_zone
*/
type NvmeNamespaceInlineLocationInlineStorageAvailabilityZone struct {

	// links
	Links *models.NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks `json:"_links,omitempty"`

	// The name of the storage availability zone.
	// Example: storage_availability_zone_1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the storage availability zone.
	// Example: 9b3ff559-3333-11ef-b420-005056ae6060
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline location inline storage availability zone
func (o *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline storage availability zone based on the context it is used
func (o *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineStorageAvailabilityZone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks nvme namespace inline location inline storage availability zone inline links
swagger:model nvme_namespace_inline_location_inline_storage_availability_zone_inline__links
*/
type NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline location inline storage availability zone inline links
func (o *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline storage availability zone inline links based on the context it is used
func (o *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineLocationInlineVolume <personalities supports=unified>The volume in which the NVMe namespace is located. Valid in POST.<br/>
// If properties `name` and `location.volume.name` and/or `location.volume.uuid` are specified in the same request, they must refer to the same volume.<br/>
// NVMe namespaces do not support movement between volumes.</personalities>
// <personalities supports=asar2>The volume sub-object is read-only and its properties cannot be set in POST or PATCH. Use the `name` property for POST.</personalities>
//
swagger:model nvme_namespace_inline_location_inline_volume
*/
type NvmeNamespaceInlineLocationInlineVolume struct {

	// links
	Links *models.NvmeNamespaceInlineLocationInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline location inline volume
func (o *NvmeNamespaceInlineLocationInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline volume based on the context it is used
func (o *NvmeNamespaceInlineLocationInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineVolume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineVolume) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineLocationInlineVolumeInlineLinks nvme namespace inline location inline volume inline links
swagger:model nvme_namespace_inline_location_inline_volume_inline__links
*/
type NvmeNamespaceInlineLocationInlineVolumeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline location inline volume inline links
func (o *NvmeNamespaceInlineLocationInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline volume inline links based on the context it is used
func (o *NvmeNamespaceInlineLocationInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineLocationInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineLocationInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineMetric Performance numbers, such as IOPS latency and throughput
swagger:model nvme_namespace_inline_metric
*/
type NvmeNamespaceInlineMetric struct {

	// links
	Links *models.NvmeNamespaceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *models.NvmeNamespaceInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.NvmeNamespaceInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.NvmeNamespaceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme namespace inline metric
func (o *NvmeNamespaceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nvmeNamespaceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineMetricTypeDurationPropEnum = append(nvmeNamespaceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NvmeNamespaceInlineMetricDurationPT15S captures enum value "PT15S"
	NvmeNamespaceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NvmeNamespaceInlineMetricDurationPT4M captures enum value "PT4M"
	NvmeNamespaceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NvmeNamespaceInlineMetricDurationPT30M captures enum value "PT30M"
	NvmeNamespaceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NvmeNamespaceInlineMetricDurationPT2H captures enum value "PT2H"
	NvmeNamespaceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NvmeNamespaceInlineMetricDurationP1D captures enum value "P1D"
	NvmeNamespaceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NvmeNamespaceInlineMetricDurationPT5M captures enum value "PT5M"
	NvmeNamespaceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *NvmeNamespaceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nvmeNamespaceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineMetricTypeStatusPropEnum = append(nvmeNamespaceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusOk captures enum value "ok"
	NvmeNamespaceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusError captures enum value "error"
	NvmeNamespaceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	NvmeNamespaceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeNamespaceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	NvmeNamespaceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	NvmeNamespaceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusNotFound captures enum value "not_found"
	NvmeNamespaceInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	NvmeNamespaceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeNamespaceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeNamespaceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeNamespaceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *NvmeNamespaceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme namespace inline metric based on the context it is used
func (o *NvmeNamespaceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineMetric) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineMetricInlineLinks nvme namespace inline metric inline links
swagger:model nvme_namespace_inline_metric_inline__links
*/
type NvmeNamespaceInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline metric inline links
func (o *NvmeNamespaceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline metric inline links based on the context it is used
func (o *NvmeNamespaceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineMetricInlineIops The rate of I/O operations observed at the storage object.
swagger:model nvme_namespace_inline_metric_inline_iops
*/
type NvmeNamespaceInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme namespace inline metric inline iops
func (o *NvmeNamespaceInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline metric inline iops based on the context it is used
func (o *NvmeNamespaceInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model nvme_namespace_inline_metric_inline_latency
*/
type NvmeNamespaceInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme namespace inline metric inline latency
func (o *NvmeNamespaceInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline metric inline latency based on the context it is used
func (o *NvmeNamespaceInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model nvme_namespace_inline_metric_inline_throughput
*/
type NvmeNamespaceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme namespace inline metric inline throughput
func (o *NvmeNamespaceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline metric inline throughput based on the context it is used
func (o *NvmeNamespaceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineProvisioningOptions Options that are applied to the operation.
swagger:model nvme_namespace_inline_provisioning_options
*/
type NvmeNamespaceInlineProvisioningOptions struct {

	// If the volume specified in the request does not exist, automatically provision one of appropriate size. If the volume does exist, resize it to accommodate the new namespace.<br/>
	// This property is only supported on Unified ONTAP.<br/>
	// The following behavior is different from a traditional POST request:
	// * The operation is asynchronous.
	// * The `qos_policy` property is supported and is applied to the provisioned volume. A default QoS policy is applied to the volume if one is not provided.
	// * The `provisioning_options.count` property is supported, provisioning _count_ namespaces on the volume using the specified properties.
	// * The `subsystem_map` property is supported. If the specified subsystem does not exist, it is created. The namespace is mapped to this subsystem. If a subsystem is provisioned in this way, it is deleted after it is no longer mapped to any namespaces.
	// * The `clone` and `convert` properties are not supported.
	// * When performing `records` based operations, specifying this property in the query applies to the entire operation. Specifying it for an individual record within the request applies to only that record.
	// * Many other `provisioning_options` properties are supported to control the placement of the namespace and the properties of the volume containing the namespace.
	//
	Auto *bool `json:"auto,omitempty"`

	// The number of namespaces to provision with these properties. Only POST requests based on `space.size` are supported. When provided, the name is considered a prefix, and a suffix of the form __&lt;N&gt;_ is generated where N is the next available numeric index, starting with 1.
	// Maximum: 80
	// Minimum: 1
	Count *int64 `json:"count,omitempty"`

	// A list of aggregates to exclude when determining the placement of the volume. <br/>
	//
	// Max Items: 100
	// Min Items: 0
	ExcludeAggregates []*NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsExcludeAggregatesItems0 `json:"exclude_aggregates,omitempty"`

	// qos policy
	QosPolicy *models.NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy `json:"qos_policy,omitempty"`

	// The snapshot policy for the volume provisioned to host the namespace. This property is only supported when the request provisions a new volume.
	//
	SnapshotPolicy *models.SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// storage service
	StorageService *models.NvmeNamespaceInlineProvisioningOptionsInlineStorageService `json:"storage_service,omitempty"`

	// tiering
	Tiering *models.NvmeNamespaceInlineProvisioningOptionsInlineTiering `json:"tiering,omitempty"`

	// Specifies whether mirrored aggregates are selected when provisioning the volume to host the namespace. Only mirrored aggregates are used if this parameter is set to _true_ and only unmirrored aggregates are used if this parameter is set to _false_. The default value is _true_ for a MetroCluster configuration and is _false_ for a non-MetroCluster configuration.
	UseMirroredAggregates *bool `json:"use_mirrored_aggregates,omitempty"`
}

// Validate validates this nvme namespace inline provisioning options
func (o *NvmeNamespaceInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCount(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExcludeAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptions) validateCount(formats strfmt.Registry) error {
	if swag.IsZero(o.Count) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"provisioning_options"+"."+"count", "body", *o.Count, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"provisioning_options"+"."+"count", "body", *o.Count, 80, false); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptions) validateExcludeAggregates(formats strfmt.Registry) error {
	if swag.IsZero(o.ExcludeAggregates) { // not required
		return nil
	}

	iExcludeAggregatesSize := int64(len(o.ExcludeAggregates))

	if err := validate.MinItems("info"+"."+"provisioning_options"+"."+"exclude_aggregates", "body", iExcludeAggregatesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("info"+"."+"provisioning_options"+"."+"exclude_aggregates", "body", iExcludeAggregatesSize, 100); err != nil {
		return err
	}

	for i := 0; i < len(o.ExcludeAggregates); i++ {
		if swag.IsZero(o.ExcludeAggregates[i]) { // not required
			continue
		}

		if o.ExcludeAggregates[i] != nil {
			if err := o.ExcludeAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "provisioning_options" + "." + "exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptions) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.QosPolicy) { // not required
		return nil
	}

	if o.QosPolicy != nil {
		if err := o.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptions) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageService) { // not required
		return nil
	}

	if o.StorageService != nil {
		if err := o.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptions) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(o.Tiering) { // not required
		return nil
	}

	if o.Tiering != nil {
		if err := o.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options" + "." + "tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline provisioning options based on the context it is used
func (o *NvmeNamespaceInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateExcludeAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptions) contextValidateExcludeAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ExcludeAggregates); i++ {

		if o.ExcludeAggregates[i] != nil {
			if err := o.ExcludeAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "provisioning_options" + "." + "exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptions) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.QosPolicy != nil {
		if err := o.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptions) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageService != nil {
		if err := o.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptions) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if o.Tiering != nil {
		if err := o.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options" + "." + "tiering")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy The QoS policy for the volume provisioned to host the namespace. This property is only supported when the request provisions a new volume. If no `qos_policy` is provided, a policy is be set based on the `storage_service.name`, which defaults to the most performant service available.
//
swagger:model nvme_namespace_inline_provisioning_options_inline_qos_policy
*/
type NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline provisioning options inline qos policy
func (o *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline provisioning options inline qos policy based on the context it is used
func (o *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "provisioning_options" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineProvisioningOptionsInlineStorageService Determines the placement of the namespace based on the value specified. Valid in POST.
//
swagger:model nvme_namespace_inline_provisioning_options_inline_storage_service
*/
type NvmeNamespaceInlineProvisioningOptionsInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this nvme namespace inline provisioning options inline storage service
func (o *NvmeNamespaceInlineProvisioningOptionsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeNamespaceInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum = append(nvmeNamespaceInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_storage_service
	// NvmeNamespaceInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineStorageServiceNameExtreme captures enum value "extreme"
	NvmeNamespaceInlineProvisioningOptionsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_storage_service
	// NvmeNamespaceInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineStorageServiceNamePerformance captures enum value "performance"
	NvmeNamespaceInlineProvisioningOptionsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_storage_service
	// NvmeNamespaceInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineStorageServiceNameValue captures enum value "value"
	NvmeNamespaceInlineProvisioningOptionsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (o *NvmeNamespaceInlineProvisioningOptionsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptionsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("info"+"."+"provisioning_options"+"."+"storage_service"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nvme namespace inline provisioning options inline storage service based on context it is used
func (o *NvmeNamespaceInlineProvisioningOptionsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineProvisioningOptionsInlineStorageService) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineProvisioningOptionsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineProvisioningOptionsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineProvisioningOptionsInlineTiering The tiering placement and policy definitions for the volume provisioned to host the namespace. This property is only supported when the request provisions a new volume.
//
swagger:model nvme_namespace_inline_provisioning_options_inline_tiering
*/
type NvmeNamespaceInlineProvisioningOptionsInlineTiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*NvmeNamespaceModifyCollectionParamsBodyProvisioningOptionsTieringObjectStoresItems0 `json:"object_stores,omitempty"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this nvme namespace inline provisioning options inline tiering
func (o *NvmeNamespaceInlineProvisioningOptionsInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeNamespaceInlineProvisioningOptionsInlineTieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineProvisioningOptionsInlineTieringTypeControlPropEnum = append(nvmeNamespaceInlineProvisioningOptionsInlineTieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringControlAllowed captures enum value "allowed"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringControlBestEffort captures enum value "best_effort"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringControlDisallowed captures enum value "disallowed"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// control
	// Control
	// required
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringControlRequired captures enum value "required"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringControlRequired string = "required"
)

// prop value enum
func (o *NvmeNamespaceInlineProvisioningOptionsInlineTiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineProvisioningOptionsInlineTieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptionsInlineTiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(o.Control) { // not required
		return nil
	}

	// value enum
	if err := o.validateControlEnum("info"+"."+"provisioning_options"+"."+"tiering"+"."+"control", "body", *o.Control); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptionsInlineTiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(o.ObjectStores))

	if err := validate.MinItems("info"+"."+"provisioning_options"+"."+"tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("info"+"."+"provisioning_options"+"."+"tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(o.ObjectStores); i++ {
		if swag.IsZero(o.ObjectStores[i]) { // not required
			continue
		}

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "provisioning_options" + "." + "tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nvmeNamespaceInlineProvisioningOptionsInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineProvisioningOptionsInlineTieringTypePolicyPropEnum = append(nvmeNamespaceInlineProvisioningOptionsInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyAll captures enum value "all"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyAuto captures enum value "auto"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyBackup captures enum value "backup"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyNone captures enum value "none"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (o *NvmeNamespaceInlineProvisioningOptionsInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineProvisioningOptionsInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptionsInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyEnum("info"+"."+"provisioning_options"+"."+"tiering"+"."+"policy", "body", *o.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme namespace inline provisioning options inline tiering based on the context it is used
func (o *NvmeNamespaceInlineProvisioningOptionsInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineProvisioningOptionsInlineTiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ObjectStores); i++ {

		if o.ObjectStores[i] != nil {
			if err := o.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "provisioning_options" + "." + "tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineProvisioningOptionsInlineTiering) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineProvisioningOptionsInlineTiering) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineProvisioningOptionsInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineQosPolicy The QoS policy for the NVMe namespace. Both traditional and adaptive QoS policies are supported. If both property `qos_policy.uuid` and `qos_policy.name` are specified in the same request, they must refer to the same QoS policy. To remove the QoS policy from an NVMe namespace, leaving it with no QoS policy, set property `qos_policy.name` to an empty string ("") in a PATCH request. An NVMe namespace is optionally associated directly with a QoS policy. To remove the QoS policy, set it to `null` in a PATCH request. Valid in POST and PATCH.
//
swagger:model nvme_namespace_inline_qos_policy
*/
type NvmeNamespaceInlineQosPolicy struct {

	// links
	Links *models.NvmeNamespaceInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// The name of the QoS policy. To remove the QoS policy from an NVMe namespace, leaving it with no QoS policy, set this property to an empty string ("") in a PATCH request. Valid in POST and PATCH.
	//
	// Example: qos1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the QoS policy. Valid in POST and PATCH.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline qos policy
func (o *NvmeNamespaceInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline qos policy based on the context it is used
func (o *NvmeNamespaceInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineQosPolicyInlineLinks nvme namespace inline qos policy inline links
swagger:model nvme_namespace_inline_qos_policy_inline__links
*/
type NvmeNamespaceInlineQosPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline qos policy inline links
func (o *NvmeNamespaceInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline qos policy inline links based on the context it is used
func (o *NvmeNamespaceInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineSpace The storage space related properties of the NVMe namespace.
//
swagger:model nvme_namespace_inline_space
*/
type NvmeNamespaceInlineSpace struct {

	// The size of blocks in the namespace in bytes. The default for namespaces with an `os_type` of _vmware_ is _512_. All other namespaces default to _4096_.<br/>
	// Valid in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//  Valid in POST.
	//
	// Enum: [512,4096]
	BlockSize *int64 `json:"block_size,omitempty"`

	// The storage efficiency ratio of the namespace without snapshots. (Logical Used / Used)
	// <personalities supports=unified>This property is not available on the namespace object in the REST API and is not reported for GET requests. See the containing volume object for this information.</personalities>
	// <personalities supports=asar2>Available for GET.</personalities>
	//
	// Example: 2.5
	// Read Only: true
	EfficiencyRatio *float64 `json:"efficiency_ratio,omitempty"`

	// guarantee
	Guarantee *models.NvmeNamespaceInlineSpaceInlineGuarantee `json:"guarantee,omitempty"`

	// The number of bytes consumed on the disk by the namespace, excluding snapshots.
	// <personalities supports=unified>This property is not available on the namespace object in the REST API and is not reported for GET requests. See the containing volume object for this information.</personalities>
	// <personalities supports=asar2>Available for GET.</personalities>
	//
	// Example: 1073741824
	// Read Only: true
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// The number of bytes consumed on the disk by the namespace's snapshots.
	// This property has been replaced by `space.snapshot.used`.
	// <personalities supports=unified>This property is not available on the namespace object in the REST API and is not reported for GET requests. See the containing volume object for this information.</personalities>
	// <personalities supports=asar2>Available for GET.</personalities>
	//
	// Example: 1073741824
	// Read Only: true
	PhysicalUsedBySnapshots *int64 `json:"physical_used_by_snapshots,omitempty"`

	// The total provisioned size of the NVMe namespace. Valid in POST and PATCH. The NVMe namespace size can be increased but not be made smaller using the REST interface.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes in bytes. The maximum size is variable with respect to large NVMe namespace support in ONTAP. If large namespaces are supported, the maximum size is 128 TB (140737488355328 bytes) and if not supported, the maximum size is just under 16 TB (17557557870592 bytes). The minimum size supported is always 4096 bytes.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the NVMe namespace.<br/>
	// This value is the total space consumed in the volume by the NVMe namespace, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways NVMe filesystems and applications utilize blocks within a namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the namespace blocks are utilized outside of ONTAP, this property should not be used and an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this nvme namespace inline space
func (o *NvmeNamespaceInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeNamespaceInlineSpaceTypeBlockSizePropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[512,4096]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineSpaceTypeBlockSizePropEnum = append(nvmeNamespaceInlineSpaceTypeBlockSizePropEnum, v)
	}
}

// prop value enum
func (o *NvmeNamespaceInlineSpace) validateBlockSizeEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineSpaceTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceInlineSpace) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(o.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateBlockSizeEnum("info"+"."+"space"+"."+"block_size", "body", *o.BlockSize); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineSpace) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineSpace) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline space based on the context it is used
func (o *NvmeNamespaceInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateEfficiencyRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePhysicalUsedBySnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSpace) contextValidateEfficiencyRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency_ratio", "body", o.EfficiencyRatio); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineSpace) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineSpace) contextValidatePhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"physical_used", "body", o.PhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineSpace) contextValidatePhysicalUsedBySnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"physical_used_by_snapshots", "body", o.PhysicalUsedBySnapshots); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineSpace) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineSpaceInlineGuarantee Properties that request and report the space guarantee for the NVMe namespace.
//
swagger:model nvme_namespace_inline_space_inline_guarantee
*/
type NvmeNamespaceInlineSpaceInlineGuarantee struct {

	// The requested space reservation policy for the NVMe namespace. If _true_, a space reservation is requested for the namespace; if _false_, the namespace is thin provisioned. Guaranteeing a space reservation request for a namespace requires that the volume in which the namespace resides also be space reserved and that the fractional reserve for the volume be 100%.<br/>
	// The space reservation policy for an NVMe namespace is determined by ONTAP.
	//
	// Read Only: true
	Requested *bool `json:"requested,omitempty"`

	// Reports if the NVMe namespace is space guaranteed.<br/>
	// This property is _true_ if a space guarantee is requested and the containing volume and aggregate support the request. This property is _false_ if a space guarantee is not requested or if a space guarantee is requested and either the containing volume and aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this nvme namespace inline space inline guarantee
func (o *NvmeNamespaceInlineSpaceInlineGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline space inline guarantee based on the context it is used
func (o *NvmeNamespaceInlineSpaceInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRequested(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSpaceInlineGuarantee) contextValidateRequested(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"guarantee"+"."+"requested", "body", o.Requested); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineSpaceInlineGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"guarantee"+"."+"reserved", "body", o.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineSpaceInlineGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineSpaceInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSpaceInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineStatistics These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
swagger:model nvme_namespace_inline_statistics
*/
type NvmeNamespaceInlineStatistics struct {

	// iops raw
	IopsRaw *models.NvmeNamespaceInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.NvmeNamespaceInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.NvmeNamespaceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme namespace inline statistics
func (o *NvmeNamespaceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nvmeNamespaceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineStatisticsTypeStatusPropEnum = append(nvmeNamespaceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusOk captures enum value "ok"
	NvmeNamespaceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusError captures enum value "error"
	NvmeNamespaceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	NvmeNamespaceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeNamespaceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	NvmeNamespaceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	NvmeNamespaceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusNotFound captures enum value "not_found"
	NvmeNamespaceInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	NvmeNamespaceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeNamespaceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeNamespaceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeNamespaceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *NvmeNamespaceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme namespace inline statistics based on the context it is used
func (o *NvmeNamespaceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model nvme_namespace_inline_statistics_inline_iops_raw
*/
type NvmeNamespaceInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme namespace inline statistics inline iops raw
func (o *NvmeNamespaceInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline statistics inline iops raw based on the context it is used
func (o *NvmeNamespaceInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model nvme_namespace_inline_statistics_inline_latency_raw
*/
type NvmeNamespaceInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme namespace inline statistics inline latency raw
func (o *NvmeNamespaceInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline statistics inline latency raw based on the context it is used
func (o *NvmeNamespaceInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model nvme_namespace_inline_statistics_inline_throughput_raw
*/
type NvmeNamespaceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme namespace inline statistics inline throughput raw
func (o *NvmeNamespaceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline statistics inline throughput raw based on the context it is used
func (o *NvmeNamespaceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineStatus Status information about the NVMe namespace.
//
swagger:model nvme_namespace_inline_status
*/
type NvmeNamespaceInlineStatus struct {

	// The state of the volume and aggregate that contain the NVMe namespace. Namespaces are only available when their containers are available.
	//
	// Read Only: true
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the NVMe namespace is mapped to an NVMe subsystem.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the NVMe namespace allows only read access.
	//
	// Read Only: true
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the NVMe namespace. Normal states for a namespace are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Read Only: true
	// Enum: ["nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this nvme namespace inline status
func (o *NvmeNamespaceInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeNamespaceInlineStatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineStatusTypeContainerStatePropEnum = append(nvmeNamespaceInlineStatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// NvmeNamespaceInlineStatusContainerStateOnline captures enum value "online"
	NvmeNamespaceInlineStatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// NvmeNamespaceInlineStatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	NvmeNamespaceInlineStatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// NvmeNamespaceInlineStatusContainerStateVolumeOffline captures enum value "volume_offline"
	NvmeNamespaceInlineStatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (o *NvmeNamespaceInlineStatus) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineStatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceInlineStatus) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(o.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := o.validateContainerStateEnum("info"+"."+"status"+"."+"container_state", "body", *o.ContainerState); err != nil {
		return err
	}

	return nil
}

var nvmeNamespaceInlineStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineStatusTypeStatePropEnum = append(nvmeNamespaceInlineStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// state
	// State
	// nvfail
	// END DEBUGGING
	// NvmeNamespaceInlineStatusStateNvfail captures enum value "nvfail"
	NvmeNamespaceInlineStatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// state
	// State
	// offline
	// END DEBUGGING
	// NvmeNamespaceInlineStatusStateOffline captures enum value "offline"
	NvmeNamespaceInlineStatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// state
	// State
	// online
	// END DEBUGGING
	// NvmeNamespaceInlineStatusStateOnline captures enum value "online"
	NvmeNamespaceInlineStatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// state
	// State
	// space_error
	// END DEBUGGING
	// NvmeNamespaceInlineStatusStateSpaceError captures enum value "space_error"
	NvmeNamespaceInlineStatusStateSpaceError string = "space_error"
)

// prop value enum
func (o *NvmeNamespaceInlineStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceInlineStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"status"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme namespace inline status based on the context it is used
func (o *NvmeNamespaceInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateContainerState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMapped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReadOnly(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineStatus) contextValidateContainerState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"container_state", "body", o.ContainerState); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineStatus) contextValidateMapped(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"mapped", "body", o.Mapped); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineStatus) contextValidateReadOnly(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"read_only", "body", o.ReadOnly); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineStatus) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineStatus) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineStatus) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineSubsystemMap The NVMe subsystem with which the NVMe namespace is associated. A namespace can be mapped to zero (0) or one (1) subsystems.<br/>
// There is an added computational cost to retrieving property values for `subsystem_map`. They are not populated for a GET request unless explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
// <personalities supports=unified>These properties are supported for GET and POST. During POST, it requires the `provisioning_options.auto` property to be set to true.
// See the `provisioning_options.auto` property for full details.</personalities>
// <personalities supports=asar2>These properties are supported for GET and POST. During POST, a new or existing subsystem can be referenced. When referencing an existing subsystem, only the `name` and `uuid` properties are supported.</personalities>
//
swagger:model nvme_namespace_inline_subsystem_map
*/
type NvmeNamespaceInlineSubsystemMap struct {

	// links
	Links *models.NvmeNamespaceInlineSubsystemMapInlineLinks `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPID is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// subsystem
	Subsystem *models.NvmeNamespaceInlineSubsystemMapInlineSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this nvme namespace inline subsystem map
func (o *NvmeNamespaceInlineSubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineSubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(o.Subsystem) { // not required
		return nil
	}

	if o.Subsystem != nil {
		if err := o.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline subsystem map based on the context it is used
func (o *NvmeNamespaceInlineSubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineSubsystemMap) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"subsystem_map"+"."+"anagrpid", "body", o.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineSubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"subsystem_map"+"."+"nsid", "body", o.Nsid); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineSubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if o.Subsystem != nil {
		if err := o.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineSubsystemMap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineSubsystemMap) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineSubsystemMapInlineLinks nvme namespace inline subsystem map inline links
swagger:model nvme_namespace_inline_subsystem_map_inline__links
*/
type NvmeNamespaceInlineSubsystemMapInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline subsystem map inline links
func (o *NvmeNamespaceInlineSubsystemMapInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSubsystemMapInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem_map" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline subsystem map inline links based on the context it is used
func (o *NvmeNamespaceInlineSubsystemMapInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSubsystemMapInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem_map" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineSubsystemMapInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineSubsystemMapInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSubsystemMapInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineSubsystemMapInlineSubsystem The NVMe subsystem to which the NVMe namespace is mapped.
//
swagger:model nvme_namespace_inline_subsystem_map_inline_subsystem
*/
type NvmeNamespaceInlineSubsystemMapInlineSubsystem struct {

	// links
	Links *models.NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks `json:"_links,omitempty"`

	// A configurable comment for the NVMe subsystem. Optional in POST.
	//
	// Max Length: 255
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The NVMe hosts configured for access to the NVMe subsystem.
	// Optional in POST.
	//
	Hosts []*NvmeNamespaceModifyCollectionParamsBodySubsystemMapSubsystemHostsItems0 `json:"hosts,omitempty"`

	// The name of the NVMe subsystem. Once created, an NVMe subsystem cannot be renamed. Optional in POST.
	//
	// Example: subsystem1
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the NVMe subsystem's hosts. Optional in POST.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline subsystem map inline subsystem
func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHosts(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem_map" + "." + "subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"subsystem_map"+"."+"subsystem"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"subsystem_map"+"."+"subsystem"+"."+"comment", "body", *o.Comment, 255); err != nil {
		return err
	}

	return nil
}

func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystem) validateHosts(formats strfmt.Registry) error {
	if swag.IsZero(o.Hosts) { // not required
		return nil
	}

	for i := 0; i < len(o.Hosts); i++ {
		if swag.IsZero(o.Hosts[i]) { // not required
			continue
		}

		if o.Hosts[i] != nil {
			if err := o.Hosts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "subsystem_map" + "." + "subsystem" + "." + "hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"subsystem_map"+"."+"subsystem"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"subsystem_map"+"."+"subsystem"+"."+"name", "body", *o.Name, 64); err != nil {
		return err
	}

	return nil
}

var nvmeNamespaceInlineSubsystemMapInlineSubsystemTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineSubsystemMapInlineSubsystemTypeOsTypePropEnum = append(nvmeNamespaceInlineSubsystemMapInlineSubsystemTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_subsystem_map_inline_subsystem
	// NvmeNamespaceInlineSubsystemMapInlineSubsystem
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeAix captures enum value "aix"
	NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_subsystem_map_inline_subsystem
	// NvmeNamespaceInlineSubsystemMapInlineSubsystem
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeLinux captures enum value "linux"
	NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_subsystem_map_inline_subsystem
	// NvmeNamespaceInlineSubsystemMapInlineSubsystem
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeVmware captures enum value "vmware"
	NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_subsystem_map_inline_subsystem
	// NvmeNamespaceInlineSubsystemMapInlineSubsystem
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeWindows captures enum value "windows"
	NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeWindows string = "windows"
)

// prop value enum
func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystem) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineSubsystemMapInlineSubsystemTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystem) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("info"+"."+"subsystem_map"+"."+"subsystem"+"."+"os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme namespace inline subsystem map inline subsystem based on the context it is used
func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHosts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem_map" + "." + "subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystem) contextValidateHosts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Hosts); i++ {

		if o.Hosts[i] != nil {
			if err := o.Hosts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "subsystem_map" + "." + "subsystem" + "." + "hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystem) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSubsystemMapInlineSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks nvme namespace inline subsystem map inline subsystem inline links
swagger:model nvme_namespace_inline_subsystem_map_inline_subsystem_inline__links
*/
type NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline subsystem map inline subsystem inline links
func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem_map" + "." + "subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline subsystem map inline subsystem inline links based on the context it is used
func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem_map" + "." + "subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model nvme_namespace_inline_svm
*/
type NvmeNamespaceInlineSvm struct {

	// links
	Links *models.NvmeNamespaceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline svm
func (o *NvmeNamespaceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline svm based on the context it is used
func (o *NvmeNamespaceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineSvm) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeNamespaceInlineSvmInlineLinks nvme namespace inline svm inline links
swagger:model nvme_namespace_inline_svm_inline__links
*/
type NvmeNamespaceInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline svm inline links
func (o *NvmeNamespaceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline svm inline links based on the context it is used
func (o *NvmeNamespaceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeNamespaceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeNamespaceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeNamespaceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
