// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewNvmeNamespaceModifyParams creates a new NvmeNamespaceModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNvmeNamespaceModifyParams() *NvmeNamespaceModifyParams {
	return &NvmeNamespaceModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNvmeNamespaceModifyParamsWithTimeout creates a new NvmeNamespaceModifyParams object
// with the ability to set a timeout on a request.
func NewNvmeNamespaceModifyParamsWithTimeout(timeout time.Duration) *NvmeNamespaceModifyParams {
	return &NvmeNamespaceModifyParams{
		timeout: timeout,
	}
}

// NewNvmeNamespaceModifyParamsWithContext creates a new NvmeNamespaceModifyParams object
// with the ability to set a context for a request.
func NewNvmeNamespaceModifyParamsWithContext(ctx context.Context) *NvmeNamespaceModifyParams {
	return &NvmeNamespaceModifyParams{
		Context: ctx,
	}
}

// NewNvmeNamespaceModifyParamsWithHTTPClient creates a new NvmeNamespaceModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewNvmeNamespaceModifyParamsWithHTTPClient(client *http.Client) *NvmeNamespaceModifyParams {
	return &NvmeNamespaceModifyParams{
		HTTPClient: client,
	}
}

/*
NvmeNamespaceModifyParams contains all the parameters to send to the API endpoint

	for the nvme namespace modify operation.

	Typically these are written to a http.Request.
*/
type NvmeNamespaceModifyParams struct {

	/* Info.

	   The new property values for the NVMe namespace.

	*/
	Info *models.NvmeNamespace

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   The unique identifier of the NVMe namespace to update.

	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nvme namespace modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeNamespaceModifyParams) WithDefaults() *NvmeNamespaceModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nvme namespace modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeNamespaceModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := NvmeNamespaceModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nvme namespace modify params
func (o *NvmeNamespaceModifyParams) WithTimeout(timeout time.Duration) *NvmeNamespaceModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nvme namespace modify params
func (o *NvmeNamespaceModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nvme namespace modify params
func (o *NvmeNamespaceModifyParams) WithContext(ctx context.Context) *NvmeNamespaceModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nvme namespace modify params
func (o *NvmeNamespaceModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nvme namespace modify params
func (o *NvmeNamespaceModifyParams) WithHTTPClient(client *http.Client) *NvmeNamespaceModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nvme namespace modify params
func (o *NvmeNamespaceModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the nvme namespace modify params
func (o *NvmeNamespaceModifyParams) WithInfo(info *models.NvmeNamespace) *NvmeNamespaceModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the nvme namespace modify params
func (o *NvmeNamespaceModifyParams) SetInfo(info *models.NvmeNamespace) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the nvme namespace modify params
func (o *NvmeNamespaceModifyParams) WithReturnTimeout(returnTimeout *int64) *NvmeNamespaceModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the nvme namespace modify params
func (o *NvmeNamespaceModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the nvme namespace modify params
func (o *NvmeNamespaceModifyParams) WithUUID(uuid string) *NvmeNamespaceModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the nvme namespace modify params
func (o *NvmeNamespaceModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *NvmeNamespaceModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
