// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewNvmeServiceCreateParams creates a new NvmeServiceCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNvmeServiceCreateParams() *NvmeServiceCreateParams {
	return &NvmeServiceCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNvmeServiceCreateParamsWithTimeout creates a new NvmeServiceCreateParams object
// with the ability to set a timeout on a request.
func NewNvmeServiceCreateParamsWithTimeout(timeout time.Duration) *NvmeServiceCreateParams {
	return &NvmeServiceCreateParams{
		timeout: timeout,
	}
}

// NewNvmeServiceCreateParamsWithContext creates a new NvmeServiceCreateParams object
// with the ability to set a context for a request.
func NewNvmeServiceCreateParamsWithContext(ctx context.Context) *NvmeServiceCreateParams {
	return &NvmeServiceCreateParams{
		Context: ctx,
	}
}

// NewNvmeServiceCreateParamsWithHTTPClient creates a new NvmeServiceCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewNvmeServiceCreateParamsWithHTTPClient(client *http.Client) *NvmeServiceCreateParams {
	return &NvmeServiceCreateParams{
		HTTPClient: client,
	}
}

/*
NvmeServiceCreateParams contains all the parameters to send to the API endpoint

	for the nvme service create operation.

	Typically these are written to a http.Request.
*/
type NvmeServiceCreateParams struct {

	/* Info.

	   The property values for the new NVMe service.

	*/
	Info *models.NvmeService

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nvme service create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeServiceCreateParams) WithDefaults() *NvmeServiceCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nvme service create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeServiceCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := NvmeServiceCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nvme service create params
func (o *NvmeServiceCreateParams) WithTimeout(timeout time.Duration) *NvmeServiceCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nvme service create params
func (o *NvmeServiceCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nvme service create params
func (o *NvmeServiceCreateParams) WithContext(ctx context.Context) *NvmeServiceCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nvme service create params
func (o *NvmeServiceCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nvme service create params
func (o *NvmeServiceCreateParams) WithHTTPClient(client *http.Client) *NvmeServiceCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nvme service create params
func (o *NvmeServiceCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the nvme service create params
func (o *NvmeServiceCreateParams) WithInfo(info *models.NvmeService) *NvmeServiceCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the nvme service create params
func (o *NvmeServiceCreateParams) SetInfo(info *models.NvmeService) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the nvme service create params
func (o *NvmeServiceCreateParams) WithReturnRecords(returnRecords *bool) *NvmeServiceCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the nvme service create params
func (o *NvmeServiceCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *NvmeServiceCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
