// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NvmeServiceDeleteCollectionReader is a Reader for the NvmeServiceDeleteCollection structure.
type NvmeServiceDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NvmeServiceDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNvmeServiceDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNvmeServiceDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNvmeServiceDeleteCollectionOK creates a NvmeServiceDeleteCollectionOK with default headers values
func NewNvmeServiceDeleteCollectionOK() *NvmeServiceDeleteCollectionOK {
	return &NvmeServiceDeleteCollectionOK{}
}

/*
NvmeServiceDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NvmeServiceDeleteCollectionOK struct {
}

// IsSuccess returns true when this nvme service delete collection o k response has a 2xx status code
func (o *NvmeServiceDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme service delete collection o k response has a 3xx status code
func (o *NvmeServiceDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme service delete collection o k response has a 4xx status code
func (o *NvmeServiceDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme service delete collection o k response has a 5xx status code
func (o *NvmeServiceDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme service delete collection o k response a status code equal to that given
func (o *NvmeServiceDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nvme service delete collection o k response
func (o *NvmeServiceDeleteCollectionOK) Code() int {
	return 200
}

func (o *NvmeServiceDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/nvme/services][%d] nvmeServiceDeleteCollectionOK", 200)
}

func (o *NvmeServiceDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/nvme/services][%d] nvmeServiceDeleteCollectionOK", 200)
}

func (o *NvmeServiceDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNvmeServiceDeleteCollectionDefault creates a NvmeServiceDeleteCollectionDefault with default headers values
func NewNvmeServiceDeleteCollectionDefault(code int) *NvmeServiceDeleteCollectionDefault {
	return &NvmeServiceDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	NvmeServiceDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621462 | The supplied SVM does not exist. |
| 5376452 | Service POST and DELETE are not supported on ASA r2. |
| 72089651 | The supplied SVM does not have an NVMe service. |
| 72089653 | There are subsystems associated with the NVMe service SVM. The subsystems must be removed before deleting the NVMe service. |
| 72089654 | There are NVMe-oF LIFs associated with the NVMe service SVM. The LIFs must be removed before deleting the NVMe service. |
| 72090028 | The NVMe service is enabled. The NVMe service must be disabled before it can be deleted. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NvmeServiceDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nvme service delete collection default response has a 2xx status code
func (o *NvmeServiceDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nvme service delete collection default response has a 3xx status code
func (o *NvmeServiceDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nvme service delete collection default response has a 4xx status code
func (o *NvmeServiceDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nvme service delete collection default response has a 5xx status code
func (o *NvmeServiceDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nvme service delete collection default response a status code equal to that given
func (o *NvmeServiceDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nvme service delete collection default response
func (o *NvmeServiceDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NvmeServiceDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nvme/services][%d] nvme_service_delete_collection default %s", o._statusCode, payload)
}

func (o *NvmeServiceDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nvme/services][%d] nvme_service_delete_collection default %s", o._statusCode, payload)
}

func (o *NvmeServiceDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NvmeServiceDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NvmeServiceDeleteCollectionBody nvme service delete collection body
swagger:model NvmeServiceDeleteCollectionBody
*/
type NvmeServiceDeleteCollectionBody struct {

	// nvme service response inline records
	NvmeServiceResponseInlineRecords []*models.NvmeService `json:"records,omitempty"`
}

// Validate validates this nvme service delete collection body
func (o *NvmeServiceDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNvmeServiceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceDeleteCollectionBody) validateNvmeServiceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NvmeServiceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NvmeServiceResponseInlineRecords); i++ {
		if swag.IsZero(o.NvmeServiceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NvmeServiceResponseInlineRecords[i] != nil {
			if err := o.NvmeServiceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this nvme service delete collection body based on the context it is used
func (o *NvmeServiceDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNvmeServiceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceDeleteCollectionBody) contextValidateNvmeServiceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NvmeServiceResponseInlineRecords); i++ {

		if o.NvmeServiceResponseInlineRecords[i] != nil {
			if err := o.NvmeServiceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res NvmeServiceDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
