// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNvmeServiceGetParams creates a new NvmeServiceGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNvmeServiceGetParams() *NvmeServiceGetParams {
	return &NvmeServiceGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNvmeServiceGetParamsWithTimeout creates a new NvmeServiceGetParams object
// with the ability to set a timeout on a request.
func NewNvmeServiceGetParamsWithTimeout(timeout time.Duration) *NvmeServiceGetParams {
	return &NvmeServiceGetParams{
		timeout: timeout,
	}
}

// NewNvmeServiceGetParamsWithContext creates a new NvmeServiceGetParams object
// with the ability to set a context for a request.
func NewNvmeServiceGetParamsWithContext(ctx context.Context) *NvmeServiceGetParams {
	return &NvmeServiceGetParams{
		Context: ctx,
	}
}

// NewNvmeServiceGetParamsWithHTTPClient creates a new NvmeServiceGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNvmeServiceGetParamsWithHTTPClient(client *http.Client) *NvmeServiceGetParams {
	return &NvmeServiceGetParams{
		HTTPClient: client,
	}
}

/*
NvmeServiceGetParams contains all the parameters to send to the API endpoint

	for the nvme service get operation.

	Typically these are written to a http.Request.
*/
type NvmeServiceGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* SvmUUID.

	   The unique identifier of the SVM whose NVMe service is to be retrieved.

	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nvme service get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeServiceGetParams) WithDefaults() *NvmeServiceGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nvme service get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeServiceGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the nvme service get params
func (o *NvmeServiceGetParams) WithTimeout(timeout time.Duration) *NvmeServiceGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nvme service get params
func (o *NvmeServiceGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nvme service get params
func (o *NvmeServiceGetParams) WithContext(ctx context.Context) *NvmeServiceGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nvme service get params
func (o *NvmeServiceGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nvme service get params
func (o *NvmeServiceGetParams) WithHTTPClient(client *http.Client) *NvmeServiceGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nvme service get params
func (o *NvmeServiceGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the nvme service get params
func (o *NvmeServiceGetParams) WithFields(fields []string) *NvmeServiceGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the nvme service get params
func (o *NvmeServiceGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithSvmUUID adds the svmUUID to the nvme service get params
func (o *NvmeServiceGetParams) WithSvmUUID(svmUUID string) *NvmeServiceGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the nvme service get params
func (o *NvmeServiceGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NvmeServiceGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNvmeServiceGet binds the parameter fields
func (o *NvmeServiceGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
