// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NvmeServiceGetReader is a Reader for the NvmeServiceGet structure.
type NvmeServiceGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NvmeServiceGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNvmeServiceGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNvmeServiceGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNvmeServiceGetOK creates a NvmeServiceGetOK with default headers values
func NewNvmeServiceGetOK() *NvmeServiceGetOK {
	return &NvmeServiceGetOK{}
}

/*
NvmeServiceGetOK describes a response with status code 200, with default header values.

OK
*/
type NvmeServiceGetOK struct {
	Payload *models.NvmeService
}

// IsSuccess returns true when this nvme service get o k response has a 2xx status code
func (o *NvmeServiceGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme service get o k response has a 3xx status code
func (o *NvmeServiceGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme service get o k response has a 4xx status code
func (o *NvmeServiceGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme service get o k response has a 5xx status code
func (o *NvmeServiceGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme service get o k response a status code equal to that given
func (o *NvmeServiceGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nvme service get o k response
func (o *NvmeServiceGetOK) Code() int {
	return 200
}

func (o *NvmeServiceGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nvme/services/{svm.uuid}][%d] nvmeServiceGetOK %s", 200, payload)
}

func (o *NvmeServiceGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nvme/services/{svm.uuid}][%d] nvmeServiceGetOK %s", 200, payload)
}

func (o *NvmeServiceGetOK) GetPayload() *models.NvmeService {
	return o.Payload
}

func (o *NvmeServiceGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NvmeService)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNvmeServiceGetDefault creates a NvmeServiceGetDefault with default headers values
func NewNvmeServiceGetDefault(code int) *NvmeServiceGetDefault {
	return &NvmeServiceGetDefault{
		_statusCode: code,
	}
}

/*
	NvmeServiceGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621462 | The supplied SVM does not exist. |
| 72089651 | The supplied SVM does not have an NVMe service. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NvmeServiceGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nvme service get default response has a 2xx status code
func (o *NvmeServiceGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nvme service get default response has a 3xx status code
func (o *NvmeServiceGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nvme service get default response has a 4xx status code
func (o *NvmeServiceGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nvme service get default response has a 5xx status code
func (o *NvmeServiceGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nvme service get default response a status code equal to that given
func (o *NvmeServiceGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nvme service get default response
func (o *NvmeServiceGetDefault) Code() int {
	return o._statusCode
}

func (o *NvmeServiceGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nvme/services/{svm.uuid}][%d] nvme_service_get default %s", o._statusCode, payload)
}

func (o *NvmeServiceGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nvme/services/{svm.uuid}][%d] nvme_service_get default %s", o._statusCode, payload)
}

func (o *NvmeServiceGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NvmeServiceGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
