// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NvmeServiceModifyCollectionReader is a Reader for the NvmeServiceModifyCollection structure.
type NvmeServiceModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NvmeServiceModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNvmeServiceModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNvmeServiceModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNvmeServiceModifyCollectionOK creates a NvmeServiceModifyCollectionOK with default headers values
func NewNvmeServiceModifyCollectionOK() *NvmeServiceModifyCollectionOK {
	return &NvmeServiceModifyCollectionOK{}
}

/*
NvmeServiceModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NvmeServiceModifyCollectionOK struct {
}

// IsSuccess returns true when this nvme service modify collection o k response has a 2xx status code
func (o *NvmeServiceModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme service modify collection o k response has a 3xx status code
func (o *NvmeServiceModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme service modify collection o k response has a 4xx status code
func (o *NvmeServiceModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme service modify collection o k response has a 5xx status code
func (o *NvmeServiceModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme service modify collection o k response a status code equal to that given
func (o *NvmeServiceModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nvme service modify collection o k response
func (o *NvmeServiceModifyCollectionOK) Code() int {
	return 200
}

func (o *NvmeServiceModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/nvme/services][%d] nvmeServiceModifyCollectionOK", 200)
}

func (o *NvmeServiceModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/nvme/services][%d] nvmeServiceModifyCollectionOK", 200)
}

func (o *NvmeServiceModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNvmeServiceModifyCollectionDefault creates a NvmeServiceModifyCollectionDefault with default headers values
func NewNvmeServiceModifyCollectionDefault(code int) *NvmeServiceModifyCollectionDefault {
	return &NvmeServiceModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	NvmeServiceModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1115127 | The cluster lacks a valid NVMe license. |
| 2621462 | The supplied SVM does not exist. |
| 5374893 | The SVM is stopped. The SVM must be running to create an NVMe service. |
| 72089651 | The supplied SVM does not have an NVMe service. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NvmeServiceModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nvme service modify collection default response has a 2xx status code
func (o *NvmeServiceModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nvme service modify collection default response has a 3xx status code
func (o *NvmeServiceModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nvme service modify collection default response has a 4xx status code
func (o *NvmeServiceModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nvme service modify collection default response has a 5xx status code
func (o *NvmeServiceModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nvme service modify collection default response a status code equal to that given
func (o *NvmeServiceModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nvme service modify collection default response
func (o *NvmeServiceModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NvmeServiceModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nvme/services][%d] nvme_service_modify_collection default %s", o._statusCode, payload)
}

func (o *NvmeServiceModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nvme/services][%d] nvme_service_modify_collection default %s", o._statusCode, payload)
}

func (o *NvmeServiceModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NvmeServiceModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NvmeServiceModifyCollectionBody nvme service modify collection body
swagger:model NvmeServiceModifyCollectionBody
*/
type NvmeServiceModifyCollectionBody struct {

	// links
	Links *models.NvmeServiceInlineLinks `json:"_links,omitempty"`

	// The administrative state of the NVMe service. The NVMe service can be disabled to block all NVMe connectivity to the SVM.<br/>
	// This is optional in POST and PATCH. The default setting is _true_ (enabled) in POST.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// metric
	Metric *models.NvmeServiceInlineMetric `json:"metric,omitempty"`

	// nvme service response inline records
	NvmeServiceResponseInlineRecords []*models.NvmeService `json:"records,omitempty"`

	// statistics
	Statistics *models.NvmeServiceInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *models.NvmeServiceInlineSvm `json:"svm,omitempty"`
}

// Validate validates this nvme service modify collection body
func (o *NvmeServiceModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNvmeServiceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceModifyCollectionBody) validateNvmeServiceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NvmeServiceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NvmeServiceResponseInlineRecords); i++ {
		if swag.IsZero(o.NvmeServiceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NvmeServiceResponseInlineRecords[i] != nil {
			if err := o.NvmeServiceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeServiceModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service modify collection body based on the context it is used
func (o *NvmeServiceModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNvmeServiceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceModifyCollectionBody) contextValidateNvmeServiceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NvmeServiceResponseInlineRecords); i++ {

		if o.NvmeServiceResponseInlineRecords[i] != nil {
			if err := o.NvmeServiceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeServiceModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res NvmeServiceModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineLinks nvme service inline links
swagger:model nvme_service_inline__links
*/
type NvmeServiceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme service inline links
func (o *NvmeServiceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service inline links based on the context it is used
func (o *NvmeServiceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetric Performance numbers, such as IOPS latency and throughput, for SVM protocols.
swagger:model nvme_service_inline_metric
*/
type NvmeServiceInlineMetric struct {

	// links
	Links *NvmeServiceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// fc
	Fc *NvmeServiceInlineMetricInlineFc `json:"fc,omitempty"`

	// iops
	Iops *NvmeServiceInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *NvmeServiceInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// tcp
	TCP *NvmeServiceInlineMetricInlineTCP `json:"tcp,omitempty"`

	// throughput
	Throughput *NvmeServiceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service inline metric
func (o *NvmeServiceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFc(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTCP(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineMetricTypeDurationPropEnum = append(nvmeServiceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NvmeServiceInlineMetricDurationPT15S captures enum value "PT15S"
	NvmeServiceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NvmeServiceInlineMetricDurationPT4M captures enum value "PT4M"
	NvmeServiceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NvmeServiceInlineMetricDurationPT30M captures enum value "PT30M"
	NvmeServiceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NvmeServiceInlineMetricDurationPT2H captures enum value "PT2H"
	NvmeServiceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NvmeServiceInlineMetricDurationP1D captures enum value "P1D"
	NvmeServiceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NvmeServiceInlineMetricDurationPT5M captures enum value "PT5M"
	NvmeServiceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *NvmeServiceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeServiceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineMetric) validateFc(formats strfmt.Registry) error {
	if swag.IsZero(o.Fc) { // not required
		return nil
	}

	if o.Fc != nil {
		if err := o.Fc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "fc")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineMetricTypeStatusPropEnum = append(nvmeServiceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusOk captures enum value "ok"
	NvmeServiceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusError captures enum value "error"
	NvmeServiceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusNotFound captures enum value "not_found"
	NvmeServiceInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *NvmeServiceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeServiceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineMetric) validateTCP(formats strfmt.Registry) error {
	if swag.IsZero(o.TCP) { // not required
		return nil
	}

	if o.TCP != nil {
		if err := o.TCP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "tcp")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service inline metric based on the context it is used
func (o *NvmeServiceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTCP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineMetric) contextValidateFc(ctx context.Context, formats strfmt.Registry) error {

	if o.Fc != nil {
		if err := o.Fc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "fc")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineMetric) contextValidateTCP(ctx context.Context, formats strfmt.Registry) error {

	if o.TCP != nil {
		if err := o.TCP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "tcp")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetric) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineLinks nvme service inline metric inline links
swagger:model nvme_service_inline_metric_inline__links
*/
type NvmeServiceInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme service inline metric inline links
func (o *NvmeServiceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service inline metric inline links based on the context it is used
func (o *NvmeServiceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineFc The NVMe/FC portion of the aggregated metrics.
swagger:model nvme_service_inline_metric_inline_fc
*/
type NvmeServiceInlineMetricInlineFc struct {

	// links
	Links *NvmeServiceInlineMetricInlineFcInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *NvmeServiceInlineMetricInlineFcInlineIops `json:"iops,omitempty"`

	// latency
	Latency *NvmeServiceInlineMetricInlineFcInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *NvmeServiceInlineMetricInlineFcInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service inline metric inline fc
func (o *NvmeServiceInlineMetricInlineFc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineMetricInlineFcTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineMetricInlineFcTypeDurationPropEnum = append(nvmeServiceInlineMetricInlineFcTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcDurationPT15S captures enum value "PT15S"
	NvmeServiceInlineMetricInlineFcDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcDurationPT4M captures enum value "PT4M"
	NvmeServiceInlineMetricInlineFcDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcDurationPT30M captures enum value "PT30M"
	NvmeServiceInlineMetricInlineFcDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcDurationPT2H captures enum value "PT2H"
	NvmeServiceInlineMetricInlineFcDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcDurationP1D captures enum value "P1D"
	NvmeServiceInlineMetricInlineFcDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcDurationPT5M captures enum value "PT5M"
	NvmeServiceInlineMetricInlineFcDurationPT5M string = "PT5M"
)

// prop value enum
func (o *NvmeServiceInlineMetricInlineFc) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineMetricInlineFcTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"fc"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "fc" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "fc" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineMetricInlineFcTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineMetricInlineFcTypeStatusPropEnum = append(nvmeServiceInlineMetricInlineFcTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusOk captures enum value "ok"
	NvmeServiceInlineMetricInlineFcStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusError captures enum value "error"
	NvmeServiceInlineMetricInlineFcStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceInlineMetricInlineFcStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceInlineMetricInlineFcStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceInlineMetricInlineFcStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceInlineMetricInlineFcStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusNotFound captures enum value "not_found"
	NvmeServiceInlineMetricInlineFcStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceInlineMetricInlineFcStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceInlineMetricInlineFcStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceInlineMetricInlineFcStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceInlineMetricInlineFcStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *NvmeServiceInlineMetricInlineFc) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineMetricInlineFcTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"fc"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "fc" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"fc"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service inline metric inline fc based on the context it is used
func (o *NvmeServiceInlineMetricInlineFc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"fc"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "fc" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "fc" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"fc"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "fc" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineFc) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"fc"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineFc) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineFc) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineFc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineFcInlineLinks nvme service inline metric inline fc inline links
swagger:model nvme_service_inline_metric_inline_fc_inline__links
*/
type NvmeServiceInlineMetricInlineFcInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme service inline metric inline fc inline links
func (o *NvmeServiceInlineMetricInlineFcInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineFcInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service inline metric inline fc inline links based on the context it is used
func (o *NvmeServiceInlineMetricInlineFcInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineFcInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineFcInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineFcInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineFcInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineFcInlineIops The rate of I/O operations observed at the storage object.
swagger:model nvme_service_inline_metric_inline_fc_inline_iops
*/
type NvmeServiceInlineMetricInlineFcInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline fc inline iops
func (o *NvmeServiceInlineMetricInlineFcInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline fc inline iops based on the context it is used
func (o *NvmeServiceInlineMetricInlineFcInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineFcInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineFcInlineIops) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineFcInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineFcInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model nvme_service_inline_metric_inline_fc_inline_latency
*/
type NvmeServiceInlineMetricInlineFcInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline fc inline latency
func (o *NvmeServiceInlineMetricInlineFcInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline fc inline latency based on the context it is used
func (o *NvmeServiceInlineMetricInlineFcInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineFcInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineFcInlineLatency) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineFcInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineFcInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model nvme_service_inline_metric_inline_fc_inline_throughput
*/
type NvmeServiceInlineMetricInlineFcInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline fc inline throughput
func (o *NvmeServiceInlineMetricInlineFcInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline fc inline throughput based on the context it is used
func (o *NvmeServiceInlineMetricInlineFcInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineFcInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineFcInlineThroughput) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineFcInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineIops The rate of I/O operations observed at the storage object.
swagger:model nvme_service_inline_metric_inline_iops
*/
type NvmeServiceInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline iops
func (o *NvmeServiceInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline iops based on the context it is used
func (o *NvmeServiceInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model nvme_service_inline_metric_inline_latency
*/
type NvmeServiceInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline latency
func (o *NvmeServiceInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline latency based on the context it is used
func (o *NvmeServiceInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineTCP The NVMe/TCP portion of the aggregated metrics.
swagger:model nvme_service_inline_metric_inline_tcp
*/
type NvmeServiceInlineMetricInlineTCP struct {

	// links
	Links *NvmeServiceInlineMetricInlineTCPInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *NvmeServiceInlineMetricInlineTCPInlineIops `json:"iops,omitempty"`

	// latency
	Latency *NvmeServiceInlineMetricInlineTCPInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *NvmeServiceInlineMetricInlineTCPInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service inline metric inline tcp
func (o *NvmeServiceInlineMetricInlineTCP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "tcp" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineMetricInlineTcpTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineMetricInlineTcpTypeDurationPropEnum = append(nvmeServiceInlineMetricInlineTcpTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPDurationPT15S captures enum value "PT15S"
	NvmeServiceInlineMetricInlineTCPDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPDurationPT4M captures enum value "PT4M"
	NvmeServiceInlineMetricInlineTCPDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPDurationPT30M captures enum value "PT30M"
	NvmeServiceInlineMetricInlineTCPDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPDurationPT2H captures enum value "PT2H"
	NvmeServiceInlineMetricInlineTCPDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPDurationP1D captures enum value "P1D"
	NvmeServiceInlineMetricInlineTCPDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPDurationPT5M captures enum value "PT5M"
	NvmeServiceInlineMetricInlineTCPDurationPT5M string = "PT5M"
)

// prop value enum
func (o *NvmeServiceInlineMetricInlineTCP) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineMetricInlineTcpTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"tcp"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "tcp" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "tcp" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineMetricInlineTcpTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineMetricInlineTcpTypeStatusPropEnum = append(nvmeServiceInlineMetricInlineTcpTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusOk captures enum value "ok"
	NvmeServiceInlineMetricInlineTCPStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusError captures enum value "error"
	NvmeServiceInlineMetricInlineTCPStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceInlineMetricInlineTCPStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceInlineMetricInlineTCPStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceInlineMetricInlineTCPStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceInlineMetricInlineTCPStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusNotFound captures enum value "not_found"
	NvmeServiceInlineMetricInlineTCPStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceInlineMetricInlineTCPStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceInlineMetricInlineTCPStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceInlineMetricInlineTCPStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceInlineMetricInlineTCPStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *NvmeServiceInlineMetricInlineTCP) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineMetricInlineTcpTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"tcp"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "tcp" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"tcp"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service inline metric inline tcp based on the context it is used
func (o *NvmeServiceInlineMetricInlineTCP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "tcp" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"tcp"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "tcp" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "tcp" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"tcp"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "tcp" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineMetricInlineTCP) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"tcp"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineTCP) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineTCP) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineTCP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineTCPInlineLinks nvme service inline metric inline tcp inline links
swagger:model nvme_service_inline_metric_inline_tcp_inline__links
*/
type NvmeServiceInlineMetricInlineTCPInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme service inline metric inline tcp inline links
func (o *NvmeServiceInlineMetricInlineTCPInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineTCPInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "tcp" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service inline metric inline tcp inline links based on the context it is used
func (o *NvmeServiceInlineMetricInlineTCPInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineMetricInlineTCPInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "tcp" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineTCPInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineTCPInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineTCPInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineTCPInlineIops The rate of I/O operations observed at the storage object.
swagger:model nvme_service_inline_metric_inline_tcp_inline_iops
*/
type NvmeServiceInlineMetricInlineTCPInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline tcp inline iops
func (o *NvmeServiceInlineMetricInlineTCPInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline tcp inline iops based on the context it is used
func (o *NvmeServiceInlineMetricInlineTCPInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineTCPInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineTCPInlineIops) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineTCPInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineTCPInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model nvme_service_inline_metric_inline_tcp_inline_latency
*/
type NvmeServiceInlineMetricInlineTCPInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline tcp inline latency
func (o *NvmeServiceInlineMetricInlineTCPInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline tcp inline latency based on the context it is used
func (o *NvmeServiceInlineMetricInlineTCPInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineTCPInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineTCPInlineLatency) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineTCPInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineTCPInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model nvme_service_inline_metric_inline_tcp_inline_throughput
*/
type NvmeServiceInlineMetricInlineTCPInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline tcp inline throughput
func (o *NvmeServiceInlineMetricInlineTCPInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline tcp inline throughput based on the context it is used
func (o *NvmeServiceInlineMetricInlineTCPInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineTCPInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineTCPInlineThroughput) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineTCPInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model nvme_service_inline_metric_inline_throughput
*/
type NvmeServiceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline throughput
func (o *NvmeServiceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline throughput based on the context it is used
func (o *NvmeServiceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineStatistics These are raw performance numbers, such as IOPS latency and throughput for SVM protocols. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
swagger:model nvme_service_inline_statistics
*/
type NvmeServiceInlineStatistics struct {

	// fc
	Fc *models.NvmeServiceInlineStatisticsInlineFc `json:"fc,omitempty"`

	// iops raw
	IopsRaw *models.NvmeServiceInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.NvmeServiceInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// tcp
	TCP *models.NvmeServiceInlineStatisticsInlineTCP `json:"tcp,omitempty"`

	// throughput raw
	ThroughputRaw *models.NvmeServiceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service inline statistics
func (o *NvmeServiceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFc(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTCP(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineStatistics) validateFc(formats strfmt.Registry) error {
	if swag.IsZero(o.Fc) { // not required
		return nil
	}

	if o.Fc != nil {
		if err := o.Fc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "fc")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineStatisticsTypeStatusPropEnum = append(nvmeServiceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusOk captures enum value "ok"
	NvmeServiceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusError captures enum value "error"
	NvmeServiceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusNotFound captures enum value "not_found"
	NvmeServiceInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *NvmeServiceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeServiceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineStatistics) validateTCP(formats strfmt.Registry) error {
	if swag.IsZero(o.TCP) { // not required
		return nil
	}

	if o.TCP != nil {
		if err := o.TCP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "tcp")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service inline statistics based on the context it is used
func (o *NvmeServiceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTCP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineStatistics) contextValidateFc(ctx context.Context, formats strfmt.Registry) error {

	if o.Fc != nil {
		if err := o.Fc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "fc")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineStatistics) contextValidateTCP(ctx context.Context, formats strfmt.Registry) error {

	if o.TCP != nil {
		if err := o.TCP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "tcp")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineStatisticsInlineFc The NVMe/FC portion of the aggregated statistics.
swagger:model nvme_service_inline_statistics_inline_fc
*/
type NvmeServiceInlineStatisticsInlineFc struct {

	// iops raw
	IopsRaw *models.NvmeServiceInlineStatisticsInlineFcInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service inline statistics inline fc
func (o *NvmeServiceInlineStatisticsInlineFc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineStatisticsInlineFc) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "fc" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineFc) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "fc" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineStatisticsInlineFcTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineStatisticsInlineFcTypeStatusPropEnum = append(nvmeServiceInlineStatisticsInlineFcTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusOk captures enum value "ok"
	NvmeServiceInlineStatisticsInlineFcStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusError captures enum value "error"
	NvmeServiceInlineStatisticsInlineFcStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceInlineStatisticsInlineFcStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceInlineStatisticsInlineFcStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceInlineStatisticsInlineFcStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceInlineStatisticsInlineFcStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusNotFound captures enum value "not_found"
	NvmeServiceInlineStatisticsInlineFcStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceInlineStatisticsInlineFcStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceInlineStatisticsInlineFcStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceInlineStatisticsInlineFcStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceInlineStatisticsInlineFcStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *NvmeServiceInlineStatisticsInlineFc) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineStatisticsInlineFcTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeServiceInlineStatisticsInlineFc) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"fc"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineFc) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "fc" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineFc) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"fc"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service inline statistics inline fc based on the context it is used
func (o *NvmeServiceInlineStatisticsInlineFc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineStatisticsInlineFc) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "fc" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineFc) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "fc" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineFc) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"fc"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineFc) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "fc" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineFc) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"fc"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineFc) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineFc) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineFc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineStatisticsInlineFcInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model nvme_service_inline_statistics_inline_fc_inline_iops_raw
*/
type NvmeServiceInlineStatisticsInlineFcInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline fc inline iops raw
func (o *NvmeServiceInlineStatisticsInlineFcInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline fc inline iops raw based on the context it is used
func (o *NvmeServiceInlineStatisticsInlineFcInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineFcInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineFcInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineFcInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model nvme_service_inline_statistics_inline_fc_inline_latency_raw
*/
type NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline fc inline latency raw
func (o *NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline fc inline latency raw based on the context it is used
func (o *NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model nvme_service_inline_statistics_inline_fc_inline_throughput_raw
*/
type NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline fc inline throughput raw
func (o *NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline fc inline throughput raw based on the context it is used
func (o *NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model nvme_service_inline_statistics_inline_iops_raw
*/
type NvmeServiceInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline iops raw
func (o *NvmeServiceInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline iops raw based on the context it is used
func (o *NvmeServiceInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model nvme_service_inline_statistics_inline_latency_raw
*/
type NvmeServiceInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline latency raw
func (o *NvmeServiceInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline latency raw based on the context it is used
func (o *NvmeServiceInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineStatisticsInlineTCP The NVMe/TCP portion of the aggregated statistics.
swagger:model nvme_service_inline_statistics_inline_tcp
*/
type NvmeServiceInlineStatisticsInlineTCP struct {

	// iops raw
	IopsRaw *models.NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service inline statistics inline tcp
func (o *NvmeServiceInlineStatisticsInlineTCP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineStatisticsInlineTCP) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "tcp" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineTCP) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "tcp" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineStatisticsInlineTcpTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineStatisticsInlineTcpTypeStatusPropEnum = append(nvmeServiceInlineStatisticsInlineTcpTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusOk captures enum value "ok"
	NvmeServiceInlineStatisticsInlineTCPStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusError captures enum value "error"
	NvmeServiceInlineStatisticsInlineTCPStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceInlineStatisticsInlineTCPStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceInlineStatisticsInlineTCPStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceInlineStatisticsInlineTCPStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceInlineStatisticsInlineTCPStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusNotFound captures enum value "not_found"
	NvmeServiceInlineStatisticsInlineTCPStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceInlineStatisticsInlineTCPStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceInlineStatisticsInlineTCPStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceInlineStatisticsInlineTCPStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceInlineStatisticsInlineTCPStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *NvmeServiceInlineStatisticsInlineTCP) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineStatisticsInlineTcpTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeServiceInlineStatisticsInlineTCP) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"tcp"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineTCP) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "tcp" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineTCP) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"tcp"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service inline statistics inline tcp based on the context it is used
func (o *NvmeServiceInlineStatisticsInlineTCP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineStatisticsInlineTCP) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "tcp" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineTCP) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "tcp" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineTCP) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"tcp"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineTCP) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "tcp" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeServiceInlineStatisticsInlineTCP) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"tcp"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineTCP) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineTCP) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineTCP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model nvme_service_inline_statistics_inline_tcp_inline_iops_raw
*/
type NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline tcp inline iops raw
func (o *NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline tcp inline iops raw based on the context it is used
func (o *NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model nvme_service_inline_statistics_inline_tcp_inline_latency_raw
*/
type NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline tcp inline latency raw
func (o *NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline tcp inline latency raw based on the context it is used
func (o *NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model nvme_service_inline_statistics_inline_tcp_inline_throughput_raw
*/
type NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline tcp inline throughput raw
func (o *NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline tcp inline throughput raw based on the context it is used
func (o *NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model nvme_service_inline_statistics_inline_throughput_raw
*/
type NvmeServiceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline throughput raw
func (o *NvmeServiceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline throughput raw based on the context it is used
func (o *NvmeServiceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model nvme_service_inline_svm
*/
type NvmeServiceInlineSvm struct {

	// links
	Links *models.NvmeServiceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme service inline svm
func (o *NvmeServiceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service inline svm based on the context it is used
func (o *NvmeServiceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineSvm) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeServiceInlineSvmInlineLinks nvme service inline svm inline links
swagger:model nvme_service_inline_svm_inline__links
*/
type NvmeServiceInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme service inline svm inline links
func (o *NvmeServiceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service inline svm inline links based on the context it is used
func (o *NvmeServiceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeServiceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeServiceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeServiceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
