// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNvmeSubsystemDeleteParams creates a new NvmeSubsystemDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNvmeSubsystemDeleteParams() *NvmeSubsystemDeleteParams {
	return &NvmeSubsystemDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNvmeSubsystemDeleteParamsWithTimeout creates a new NvmeSubsystemDeleteParams object
// with the ability to set a timeout on a request.
func NewNvmeSubsystemDeleteParamsWithTimeout(timeout time.Duration) *NvmeSubsystemDeleteParams {
	return &NvmeSubsystemDeleteParams{
		timeout: timeout,
	}
}

// NewNvmeSubsystemDeleteParamsWithContext creates a new NvmeSubsystemDeleteParams object
// with the ability to set a context for a request.
func NewNvmeSubsystemDeleteParamsWithContext(ctx context.Context) *NvmeSubsystemDeleteParams {
	return &NvmeSubsystemDeleteParams{
		Context: ctx,
	}
}

// NewNvmeSubsystemDeleteParamsWithHTTPClient creates a new NvmeSubsystemDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewNvmeSubsystemDeleteParamsWithHTTPClient(client *http.Client) *NvmeSubsystemDeleteParams {
	return &NvmeSubsystemDeleteParams{
		HTTPClient: client,
	}
}

/*
NvmeSubsystemDeleteParams contains all the parameters to send to the API endpoint

	for the nvme subsystem delete operation.

	Typically these are written to a http.Request.
*/
type NvmeSubsystemDeleteParams struct {

	/* AllowDeleteWhileMapped.

	   Allows for the deletion of a mapped NVMe subsystem.

	*/
	AllowDeleteWhileMapped *bool

	/* AllowDeleteWithHosts.

	   Allows for the deletion of an NVMe subsystem with NVMe hosts.

	*/
	AllowDeleteWithHosts *bool

	/* UUID.

	   The unique identifier of the NVMe subsystem.

	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nvme subsystem delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeSubsystemDeleteParams) WithDefaults() *NvmeSubsystemDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nvme subsystem delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeSubsystemDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the nvme subsystem delete params
func (o *NvmeSubsystemDeleteParams) WithTimeout(timeout time.Duration) *NvmeSubsystemDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nvme subsystem delete params
func (o *NvmeSubsystemDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nvme subsystem delete params
func (o *NvmeSubsystemDeleteParams) WithContext(ctx context.Context) *NvmeSubsystemDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nvme subsystem delete params
func (o *NvmeSubsystemDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nvme subsystem delete params
func (o *NvmeSubsystemDeleteParams) WithHTTPClient(client *http.Client) *NvmeSubsystemDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nvme subsystem delete params
func (o *NvmeSubsystemDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAllowDeleteWhileMapped adds the allowDeleteWhileMapped to the nvme subsystem delete params
func (o *NvmeSubsystemDeleteParams) WithAllowDeleteWhileMapped(allowDeleteWhileMapped *bool) *NvmeSubsystemDeleteParams {
	o.SetAllowDeleteWhileMapped(allowDeleteWhileMapped)
	return o
}

// SetAllowDeleteWhileMapped adds the allowDeleteWhileMapped to the nvme subsystem delete params
func (o *NvmeSubsystemDeleteParams) SetAllowDeleteWhileMapped(allowDeleteWhileMapped *bool) {
	o.AllowDeleteWhileMapped = allowDeleteWhileMapped
}

// WithAllowDeleteWithHosts adds the allowDeleteWithHosts to the nvme subsystem delete params
func (o *NvmeSubsystemDeleteParams) WithAllowDeleteWithHosts(allowDeleteWithHosts *bool) *NvmeSubsystemDeleteParams {
	o.SetAllowDeleteWithHosts(allowDeleteWithHosts)
	return o
}

// SetAllowDeleteWithHosts adds the allowDeleteWithHosts to the nvme subsystem delete params
func (o *NvmeSubsystemDeleteParams) SetAllowDeleteWithHosts(allowDeleteWithHosts *bool) {
	o.AllowDeleteWithHosts = allowDeleteWithHosts
}

// WithUUID adds the uuid to the nvme subsystem delete params
func (o *NvmeSubsystemDeleteParams) WithUUID(uuid string) *NvmeSubsystemDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the nvme subsystem delete params
func (o *NvmeSubsystemDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *NvmeSubsystemDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AllowDeleteWhileMapped != nil {

		// query param allow_delete_while_mapped
		var qrAllowDeleteWhileMapped bool

		if o.AllowDeleteWhileMapped != nil {
			qrAllowDeleteWhileMapped = *o.AllowDeleteWhileMapped
		}
		qAllowDeleteWhileMapped := swag.FormatBool(qrAllowDeleteWhileMapped)
		if qAllowDeleteWhileMapped != "" {

			if err := r.SetQueryParam("allow_delete_while_mapped", qAllowDeleteWhileMapped); err != nil {
				return err
			}
		}
	}

	if o.AllowDeleteWithHosts != nil {

		// query param allow_delete_with_hosts
		var qrAllowDeleteWithHosts bool

		if o.AllowDeleteWithHosts != nil {
			qrAllowDeleteWithHosts = *o.AllowDeleteWithHosts
		}
		qAllowDeleteWithHosts := swag.FormatBool(qrAllowDeleteWithHosts)
		if qAllowDeleteWithHosts != "" {

			if err := r.SetQueryParam("allow_delete_with_hosts", qAllowDeleteWithHosts); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
