// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NvmeSubsystemHostCreateReader is a Reader for the NvmeSubsystemHostCreate structure.
type NvmeSubsystemHostCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NvmeSubsystemHostCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewNvmeSubsystemHostCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNvmeSubsystemHostCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNvmeSubsystemHostCreateCreated creates a NvmeSubsystemHostCreateCreated with default headers values
func NewNvmeSubsystemHostCreateCreated() *NvmeSubsystemHostCreateCreated {
	return &NvmeSubsystemHostCreateCreated{}
}

/*
NvmeSubsystemHostCreateCreated describes a response with status code 201, with default header values.

Created
*/
type NvmeSubsystemHostCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.NvmeSubsystemHostResponse
}

// IsSuccess returns true when this nvme subsystem host create created response has a 2xx status code
func (o *NvmeSubsystemHostCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme subsystem host create created response has a 3xx status code
func (o *NvmeSubsystemHostCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme subsystem host create created response has a 4xx status code
func (o *NvmeSubsystemHostCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme subsystem host create created response has a 5xx status code
func (o *NvmeSubsystemHostCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme subsystem host create created response a status code equal to that given
func (o *NvmeSubsystemHostCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the nvme subsystem host create created response
func (o *NvmeSubsystemHostCreateCreated) Code() int {
	return 201
}

func (o *NvmeSubsystemHostCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/nvme/subsystems/{subsystem.uuid}/hosts][%d] nvmeSubsystemHostCreateCreated %s", 201, payload)
}

func (o *NvmeSubsystemHostCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/nvme/subsystems/{subsystem.uuid}/hosts][%d] nvmeSubsystemHostCreateCreated %s", 201, payload)
}

func (o *NvmeSubsystemHostCreateCreated) GetPayload() *models.NvmeSubsystemHostResponse {
	return o.Payload
}

func (o *NvmeSubsystemHostCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.NvmeSubsystemHostResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNvmeSubsystemHostCreateDefault creates a NvmeSubsystemHostCreateDefault with default headers values
func NewNvmeSubsystemHostCreateDefault(code int) *NvmeSubsystemHostCreateDefault {
	return &NvmeSubsystemHostCreateDefault{
		_statusCode: code,
	}
}

/*
	NvmeSubsystemHostCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262186 | The "records" array and other host properties are mutually exclusive. |
| 72089705 | The NVMe subsystem host already exists for the NVMe subsystem. |
| 72089716 | The DH-HMAC-CHAP secret property is invalid. DH-HMAC-CHAP secrets must be in the format "DHHC-1:0X:<Base 64 encoded key and CRC>:", where X represents 0, 1, or 3 indicating no hash function, SHA-256, and SHA-512 respectively. |
| 72089771 | The NQN is invalid. A non-empty qualifier is required after the prefix. An example of a valid NQN is _nqn.1992-01.com.example:string_. |
| 72089772 | The NQN is invalid. Add the prefix _'nqn'_. An example of a valid NQN is _nqn.1992-01.com.example:string_. |
| 72089773 | The NQN is invalid. The date field must be formatted _yyyy-mm_. An example of a valid NQN is _nqn.1992-01.com.example:string_. |
| 72090001 | The NVMe subsystem does not exist. |
| 72090003 | A host to be added to an NVMe subsystem is missing the "nqn" property. |
| 72090036 | An NVMe subsystem host NQN is duplicated in the input. |
| 72090041 | An element in the "records" array contains an invalid property. |
| 72090042 | The DH-HMAC-CHAP secret property is required when setting any other NVMe in-band authentication properties for a host. |
| 72090151 | NVMe/TCP-TLS is not supported for the effective version of the cluster. |
| 72090202 | A provided NVMe subsystem host TLS configured PSK is not valid. |
| 72090204 | A TLS configured PSK was not provided when adding an NVMe subsystem host with the configured key type. |
| 72090205 | An invalid combination for the TLS key type and configured PSK values was provided when adding an NVMe subsystem host. When key type is "none", no configured PSK is allowed. When key type is "configured", a configured PSK is required. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NvmeSubsystemHostCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nvme subsystem host create default response has a 2xx status code
func (o *NvmeSubsystemHostCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nvme subsystem host create default response has a 3xx status code
func (o *NvmeSubsystemHostCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nvme subsystem host create default response has a 4xx status code
func (o *NvmeSubsystemHostCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nvme subsystem host create default response has a 5xx status code
func (o *NvmeSubsystemHostCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nvme subsystem host create default response a status code equal to that given
func (o *NvmeSubsystemHostCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nvme subsystem host create default response
func (o *NvmeSubsystemHostCreateDefault) Code() int {
	return o._statusCode
}

func (o *NvmeSubsystemHostCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/nvme/subsystems/{subsystem.uuid}/hosts][%d] nvme_subsystem_host_create default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemHostCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/nvme/subsystems/{subsystem.uuid}/hosts][%d] nvme_subsystem_host_create default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemHostCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NvmeSubsystemHostCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
