// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNvmeSubsystemHostDeleteCollectionParams creates a new NvmeSubsystemHostDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNvmeSubsystemHostDeleteCollectionParams() *NvmeSubsystemHostDeleteCollectionParams {
	return &NvmeSubsystemHostDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNvmeSubsystemHostDeleteCollectionParamsWithTimeout creates a new NvmeSubsystemHostDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewNvmeSubsystemHostDeleteCollectionParamsWithTimeout(timeout time.Duration) *NvmeSubsystemHostDeleteCollectionParams {
	return &NvmeSubsystemHostDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewNvmeSubsystemHostDeleteCollectionParamsWithContext creates a new NvmeSubsystemHostDeleteCollectionParams object
// with the ability to set a context for a request.
func NewNvmeSubsystemHostDeleteCollectionParamsWithContext(ctx context.Context) *NvmeSubsystemHostDeleteCollectionParams {
	return &NvmeSubsystemHostDeleteCollectionParams{
		Context: ctx,
	}
}

// NewNvmeSubsystemHostDeleteCollectionParamsWithHTTPClient creates a new NvmeSubsystemHostDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewNvmeSubsystemHostDeleteCollectionParamsWithHTTPClient(client *http.Client) *NvmeSubsystemHostDeleteCollectionParams {
	return &NvmeSubsystemHostDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
NvmeSubsystemHostDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the nvme subsystem host delete collection operation.

	Typically these are written to a http.Request.
*/
type NvmeSubsystemHostDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info NvmeSubsystemHostDeleteCollectionBody

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SubsystemUUID.

	   The unique identifier of the NVMe subsystem.

	*/
	SubsystemUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nvme subsystem host delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeSubsystemHostDeleteCollectionParams) WithDefaults() *NvmeSubsystemHostDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nvme subsystem host delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeSubsystemHostDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := NvmeSubsystemHostDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) WithTimeout(timeout time.Duration) *NvmeSubsystemHostDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) WithContext(ctx context.Context) *NvmeSubsystemHostDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) WithHTTPClient(client *http.Client) *NvmeSubsystemHostDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *NvmeSubsystemHostDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) WithInfo(info NvmeSubsystemHostDeleteCollectionBody) *NvmeSubsystemHostDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) SetInfo(info NvmeSubsystemHostDeleteCollectionBody) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *NvmeSubsystemHostDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *NvmeSubsystemHostDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *NvmeSubsystemHostDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSubsystemUUID adds the subsystemUUID to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) WithSubsystemUUID(subsystemUUID string) *NvmeSubsystemHostDeleteCollectionParams {
	o.SetSubsystemUUID(subsystemUUID)
	return o
}

// SetSubsystemUUID adds the subsystemUuid to the nvme subsystem host delete collection params
func (o *NvmeSubsystemHostDeleteCollectionParams) SetSubsystemUUID(subsystemUUID string) {
	o.SubsystemUUID = subsystemUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NvmeSubsystemHostDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	// path param subsystem.uuid
	if err := r.SetPathParam("subsystem.uuid", o.SubsystemUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
