// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NvmeSubsystemHostDeleteCollectionReader is a Reader for the NvmeSubsystemHostDeleteCollection structure.
type NvmeSubsystemHostDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NvmeSubsystemHostDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNvmeSubsystemHostDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNvmeSubsystemHostDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNvmeSubsystemHostDeleteCollectionOK creates a NvmeSubsystemHostDeleteCollectionOK with default headers values
func NewNvmeSubsystemHostDeleteCollectionOK() *NvmeSubsystemHostDeleteCollectionOK {
	return &NvmeSubsystemHostDeleteCollectionOK{}
}

/*
NvmeSubsystemHostDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NvmeSubsystemHostDeleteCollectionOK struct {
}

// IsSuccess returns true when this nvme subsystem host delete collection o k response has a 2xx status code
func (o *NvmeSubsystemHostDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme subsystem host delete collection o k response has a 3xx status code
func (o *NvmeSubsystemHostDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme subsystem host delete collection o k response has a 4xx status code
func (o *NvmeSubsystemHostDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme subsystem host delete collection o k response has a 5xx status code
func (o *NvmeSubsystemHostDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme subsystem host delete collection o k response a status code equal to that given
func (o *NvmeSubsystemHostDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nvme subsystem host delete collection o k response
func (o *NvmeSubsystemHostDeleteCollectionOK) Code() int {
	return 200
}

func (o *NvmeSubsystemHostDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/nvme/subsystems/{subsystem.uuid}/hosts][%d] nvmeSubsystemHostDeleteCollectionOK", 200)
}

func (o *NvmeSubsystemHostDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/nvme/subsystems/{subsystem.uuid}/hosts][%d] nvmeSubsystemHostDeleteCollectionOK", 200)
}

func (o *NvmeSubsystemHostDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNvmeSubsystemHostDeleteCollectionDefault creates a NvmeSubsystemHostDeleteCollectionDefault with default headers values
func NewNvmeSubsystemHostDeleteCollectionDefault(code int) *NvmeSubsystemHostDeleteCollectionDefault {
	return &NvmeSubsystemHostDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	NvmeSubsystemHostDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 72089771 | The NQN is invalid. A non-empty qualifier is required after the prefix. An example of a valid NQN is _nqn.1992-01.com.example:string_. |
| 72089772 | The NQN is invalid. Add the prefix _'nqn'_. An example of a valid NQN is _nqn.1992-01.com.example:string_. |
| 72089773 | The NQN is invalid. The date field must be formatted _yyyy-mm_. An example of a valid NQN is _nqn.1992-01.com.example:string_. |
| 72090001 | The NVMe subsystem does not exist. |
| 72090004 | The NVMe subsystem host does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NvmeSubsystemHostDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nvme subsystem host delete collection default response has a 2xx status code
func (o *NvmeSubsystemHostDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nvme subsystem host delete collection default response has a 3xx status code
func (o *NvmeSubsystemHostDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nvme subsystem host delete collection default response has a 4xx status code
func (o *NvmeSubsystemHostDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nvme subsystem host delete collection default response has a 5xx status code
func (o *NvmeSubsystemHostDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nvme subsystem host delete collection default response a status code equal to that given
func (o *NvmeSubsystemHostDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nvme subsystem host delete collection default response
func (o *NvmeSubsystemHostDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NvmeSubsystemHostDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nvme/subsystems/{subsystem.uuid}/hosts][%d] nvme_subsystem_host_delete_collection default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemHostDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nvme/subsystems/{subsystem.uuid}/hosts][%d] nvme_subsystem_host_delete_collection default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemHostDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NvmeSubsystemHostDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NvmeSubsystemHostDeleteCollectionBody nvme subsystem host delete collection body
swagger:model NvmeSubsystemHostDeleteCollectionBody
*/
type NvmeSubsystemHostDeleteCollectionBody struct {

	// nvme subsystem host response inline records
	NvmeSubsystemHostResponseInlineRecords []*models.NvmeSubsystemHost `json:"records,omitempty"`
}

// Validate validates this nvme subsystem host delete collection body
func (o *NvmeSubsystemHostDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNvmeSubsystemHostResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostDeleteCollectionBody) validateNvmeSubsystemHostResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NvmeSubsystemHostResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NvmeSubsystemHostResponseInlineRecords); i++ {
		if swag.IsZero(o.NvmeSubsystemHostResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NvmeSubsystemHostResponseInlineRecords[i] != nil {
			if err := o.NvmeSubsystemHostResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this nvme subsystem host delete collection body based on the context it is used
func (o *NvmeSubsystemHostDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNvmeSubsystemHostResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostDeleteCollectionBody) contextValidateNvmeSubsystemHostResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NvmeSubsystemHostResponseInlineRecords); i++ {

		if o.NvmeSubsystemHostResponseInlineRecords[i] != nil {
			if err := o.NvmeSubsystemHostResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
