// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NvmeSubsystemHostDeleteReader is a Reader for the NvmeSubsystemHostDelete structure.
type NvmeSubsystemHostDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NvmeSubsystemHostDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNvmeSubsystemHostDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNvmeSubsystemHostDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNvmeSubsystemHostDeleteOK creates a NvmeSubsystemHostDeleteOK with default headers values
func NewNvmeSubsystemHostDeleteOK() *NvmeSubsystemHostDeleteOK {
	return &NvmeSubsystemHostDeleteOK{}
}

/*
NvmeSubsystemHostDeleteOK describes a response with status code 200, with default header values.

OK
*/
type NvmeSubsystemHostDeleteOK struct {
}

// IsSuccess returns true when this nvme subsystem host delete o k response has a 2xx status code
func (o *NvmeSubsystemHostDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme subsystem host delete o k response has a 3xx status code
func (o *NvmeSubsystemHostDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme subsystem host delete o k response has a 4xx status code
func (o *NvmeSubsystemHostDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme subsystem host delete o k response has a 5xx status code
func (o *NvmeSubsystemHostDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme subsystem host delete o k response a status code equal to that given
func (o *NvmeSubsystemHostDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nvme subsystem host delete o k response
func (o *NvmeSubsystemHostDeleteOK) Code() int {
	return 200
}

func (o *NvmeSubsystemHostDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/nvme/subsystems/{subsystem.uuid}/hosts/{nqn}][%d] nvmeSubsystemHostDeleteOK", 200)
}

func (o *NvmeSubsystemHostDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/nvme/subsystems/{subsystem.uuid}/hosts/{nqn}][%d] nvmeSubsystemHostDeleteOK", 200)
}

func (o *NvmeSubsystemHostDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNvmeSubsystemHostDeleteDefault creates a NvmeSubsystemHostDeleteDefault with default headers values
func NewNvmeSubsystemHostDeleteDefault(code int) *NvmeSubsystemHostDeleteDefault {
	return &NvmeSubsystemHostDeleteDefault{
		_statusCode: code,
	}
}

/*
	NvmeSubsystemHostDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 72089771 | The NQN is invalid. A non-empty qualifier is required after the prefix. An example of a valid NQN is _nqn.1992-01.com.example:string_. |
| 72089772 | The NQN is invalid. Add the prefix _'nqn'_. An example of a valid NQN is _nqn.1992-01.com.example:string_. |
| 72089773 | The NQN is invalid. The date field must be formatted _yyyy-mm_. An example of a valid NQN is _nqn.1992-01.com.example:string_. |
| 72090001 | The NVMe subsystem does not exist. |
| 72090004 | The NVMe subsystem host does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NvmeSubsystemHostDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nvme subsystem host delete default response has a 2xx status code
func (o *NvmeSubsystemHostDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nvme subsystem host delete default response has a 3xx status code
func (o *NvmeSubsystemHostDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nvme subsystem host delete default response has a 4xx status code
func (o *NvmeSubsystemHostDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nvme subsystem host delete default response has a 5xx status code
func (o *NvmeSubsystemHostDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nvme subsystem host delete default response a status code equal to that given
func (o *NvmeSubsystemHostDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nvme subsystem host delete default response
func (o *NvmeSubsystemHostDeleteDefault) Code() int {
	return o._statusCode
}

func (o *NvmeSubsystemHostDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nvme/subsystems/{subsystem.uuid}/hosts/{nqn}][%d] nvme_subsystem_host_delete default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemHostDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nvme/subsystems/{subsystem.uuid}/hosts/{nqn}][%d] nvme_subsystem_host_delete default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemHostDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NvmeSubsystemHostDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
