// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNvmeSubsystemHostGetParams creates a new NvmeSubsystemHostGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNvmeSubsystemHostGetParams() *NvmeSubsystemHostGetParams {
	return &NvmeSubsystemHostGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNvmeSubsystemHostGetParamsWithTimeout creates a new NvmeSubsystemHostGetParams object
// with the ability to set a timeout on a request.
func NewNvmeSubsystemHostGetParamsWithTimeout(timeout time.Duration) *NvmeSubsystemHostGetParams {
	return &NvmeSubsystemHostGetParams{
		timeout: timeout,
	}
}

// NewNvmeSubsystemHostGetParamsWithContext creates a new NvmeSubsystemHostGetParams object
// with the ability to set a context for a request.
func NewNvmeSubsystemHostGetParamsWithContext(ctx context.Context) *NvmeSubsystemHostGetParams {
	return &NvmeSubsystemHostGetParams{
		Context: ctx,
	}
}

// NewNvmeSubsystemHostGetParamsWithHTTPClient creates a new NvmeSubsystemHostGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNvmeSubsystemHostGetParamsWithHTTPClient(client *http.Client) *NvmeSubsystemHostGetParams {
	return &NvmeSubsystemHostGetParams{
		HTTPClient: client,
	}
}

/*
NvmeSubsystemHostGetParams contains all the parameters to send to the API endpoint

	for the nvme subsystem host get operation.

	Typically these are written to a http.Request.
*/
type NvmeSubsystemHostGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Nqn.

	   The NVMe qualified name (NQN) used to identify the NVMe subsystem host.

	*/
	Nqn string

	/* SubsystemUUID.

	   The unique identifier of the NVMe subsystem.

	*/
	SubsystemUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nvme subsystem host get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeSubsystemHostGetParams) WithDefaults() *NvmeSubsystemHostGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nvme subsystem host get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeSubsystemHostGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the nvme subsystem host get params
func (o *NvmeSubsystemHostGetParams) WithTimeout(timeout time.Duration) *NvmeSubsystemHostGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nvme subsystem host get params
func (o *NvmeSubsystemHostGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nvme subsystem host get params
func (o *NvmeSubsystemHostGetParams) WithContext(ctx context.Context) *NvmeSubsystemHostGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nvme subsystem host get params
func (o *NvmeSubsystemHostGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nvme subsystem host get params
func (o *NvmeSubsystemHostGetParams) WithHTTPClient(client *http.Client) *NvmeSubsystemHostGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nvme subsystem host get params
func (o *NvmeSubsystemHostGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the nvme subsystem host get params
func (o *NvmeSubsystemHostGetParams) WithFields(fields []string) *NvmeSubsystemHostGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the nvme subsystem host get params
func (o *NvmeSubsystemHostGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithNqn adds the nqn to the nvme subsystem host get params
func (o *NvmeSubsystemHostGetParams) WithNqn(nqn string) *NvmeSubsystemHostGetParams {
	o.SetNqn(nqn)
	return o
}

// SetNqn adds the nqn to the nvme subsystem host get params
func (o *NvmeSubsystemHostGetParams) SetNqn(nqn string) {
	o.Nqn = nqn
}

// WithSubsystemUUID adds the subsystemUUID to the nvme subsystem host get params
func (o *NvmeSubsystemHostGetParams) WithSubsystemUUID(subsystemUUID string) *NvmeSubsystemHostGetParams {
	o.SetSubsystemUUID(subsystemUUID)
	return o
}

// SetSubsystemUUID adds the subsystemUuid to the nvme subsystem host get params
func (o *NvmeSubsystemHostGetParams) SetSubsystemUUID(subsystemUUID string) {
	o.SubsystemUUID = subsystemUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NvmeSubsystemHostGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param nqn
	if err := r.SetPathParam("nqn", o.Nqn); err != nil {
		return err
	}

	// path param subsystem.uuid
	if err := r.SetPathParam("subsystem.uuid", o.SubsystemUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNvmeSubsystemHostGet binds the parameter fields
func (o *NvmeSubsystemHostGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
