// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NvmeSubsystemHostModifyCollectionReader is a Reader for the NvmeSubsystemHostModifyCollection structure.
type NvmeSubsystemHostModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NvmeSubsystemHostModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNvmeSubsystemHostModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNvmeSubsystemHostModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNvmeSubsystemHostModifyCollectionOK creates a NvmeSubsystemHostModifyCollectionOK with default headers values
func NewNvmeSubsystemHostModifyCollectionOK() *NvmeSubsystemHostModifyCollectionOK {
	return &NvmeSubsystemHostModifyCollectionOK{}
}

/*
NvmeSubsystemHostModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NvmeSubsystemHostModifyCollectionOK struct {
}

// IsSuccess returns true when this nvme subsystem host modify collection o k response has a 2xx status code
func (o *NvmeSubsystemHostModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme subsystem host modify collection o k response has a 3xx status code
func (o *NvmeSubsystemHostModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme subsystem host modify collection o k response has a 4xx status code
func (o *NvmeSubsystemHostModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme subsystem host modify collection o k response has a 5xx status code
func (o *NvmeSubsystemHostModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme subsystem host modify collection o k response a status code equal to that given
func (o *NvmeSubsystemHostModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nvme subsystem host modify collection o k response
func (o *NvmeSubsystemHostModifyCollectionOK) Code() int {
	return 200
}

func (o *NvmeSubsystemHostModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/nvme/subsystems/{subsystem.uuid}/hosts][%d] nvmeSubsystemHostModifyCollectionOK", 200)
}

func (o *NvmeSubsystemHostModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/nvme/subsystems/{subsystem.uuid}/hosts][%d] nvmeSubsystemHostModifyCollectionOK", 200)
}

func (o *NvmeSubsystemHostModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNvmeSubsystemHostModifyCollectionDefault creates a NvmeSubsystemHostModifyCollectionDefault with default headers values
func NewNvmeSubsystemHostModifyCollectionDefault(code int) *NvmeSubsystemHostModifyCollectionDefault {
	return &NvmeSubsystemHostModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	NvmeSubsystemHostModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5376354 | The SVM peer relationship does not exist. |
| 26345675 | The SVM peer relationship contains local SVM name mismatch. |
| 72090001 | The NVMe subsystem does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NvmeSubsystemHostModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nvme subsystem host modify collection default response has a 2xx status code
func (o *NvmeSubsystemHostModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nvme subsystem host modify collection default response has a 3xx status code
func (o *NvmeSubsystemHostModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nvme subsystem host modify collection default response has a 4xx status code
func (o *NvmeSubsystemHostModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nvme subsystem host modify collection default response has a 5xx status code
func (o *NvmeSubsystemHostModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nvme subsystem host modify collection default response a status code equal to that given
func (o *NvmeSubsystemHostModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nvme subsystem host modify collection default response
func (o *NvmeSubsystemHostModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NvmeSubsystemHostModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nvme/subsystems/{subsystem.uuid}/hosts][%d] nvme_subsystem_host_modify_collection default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemHostModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nvme/subsystems/{subsystem.uuid}/hosts][%d] nvme_subsystem_host_modify_collection default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemHostModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NvmeSubsystemHostModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NvmeSubsystemHostModifyCollectionBody nvme subsystem host modify collection body
swagger:model NvmeSubsystemHostModifyCollectionBody
*/
type NvmeSubsystemHostModifyCollectionBody struct {

	// links
	Links *models.NvmeSubsystemHostInlineLinks `json:"_links,omitempty"`

	// dh hmac chap
	DhHmacChap *models.NvmeSubsystemHostInlineDhHmacChap `json:"dh_hmac_chap,omitempty"`

	// io queue
	IoQueue *models.NvmeSubsystemHostInlineIoQueue `json:"io_queue,omitempty"`

	// The NVMe qualified name (NQN) used to identify the NVMe storage target.
	//
	// Example: nqn.1992-01.example.com:string
	Nqn *string `json:"nqn,omitempty"`

	// An array of NVMe hosts specified to add multiple NVMe hosts to an NVMe subsystem in a single API call. Valid in POST only.
	//
	NvmeSubsystemHostInlineRecords []*models.NvmeSubsystemHostInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// The host priority setting allocates appropriate NVMe I/O queues (count and depth) for the host to submit I/O commands. Absence of this property in GET implies io_queue count and I/O queue depth are being used.
	//
	// Enum: ["regular","high"]
	Priority *string `json:"priority,omitempty"`

	// proximity
	Proximity *models.NvmeSubsystemHostInlineProximity `json:"proximity,omitempty"`

	// subsystem
	Subsystem *models.NvmeSubsystemHostInlineSubsystem `json:"subsystem,omitempty"`

	// tls
	TLS *models.NvmeSubsystemHostInlineTLS `json:"tls,omitempty"`
}

// Validate validates this nvme subsystem host modify collection body
func (o *NvmeSubsystemHostModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDhHmacChap(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIoQueue(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNvmeSubsystemHostInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePriority(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTLS(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) validateDhHmacChap(formats strfmt.Registry) error {
	if swag.IsZero(o.DhHmacChap) { // not required
		return nil
	}

	if o.DhHmacChap != nil {
		if err := o.DhHmacChap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) validateIoQueue(formats strfmt.Registry) error {
	if swag.IsZero(o.IoQueue) { // not required
		return nil
	}

	if o.IoQueue != nil {
		if err := o.IoQueue.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "io_queue")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) validateNvmeSubsystemHostInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NvmeSubsystemHostInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NvmeSubsystemHostInlineRecords); i++ {
		if swag.IsZero(o.NvmeSubsystemHostInlineRecords[i]) { // not required
			continue
		}

		if o.NvmeSubsystemHostInlineRecords[i] != nil {
			if err := o.NvmeSubsystemHostInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nvmeSubsystemHostModifyCollectionBodyTypePriorityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["regular","high"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostModifyCollectionBodyTypePriorityPropEnum = append(nvmeSubsystemHostModifyCollectionBodyTypePriorityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NvmeSubsystemHostModifyCollectionBody
	// NvmeSubsystemHostModifyCollectionBody
	// priority
	// Priority
	// regular
	// END DEBUGGING
	// NvmeSubsystemHostModifyCollectionBodyPriorityRegular captures enum value "regular"
	NvmeSubsystemHostModifyCollectionBodyPriorityRegular string = "regular"

	// BEGIN DEBUGGING
	// NvmeSubsystemHostModifyCollectionBody
	// NvmeSubsystemHostModifyCollectionBody
	// priority
	// Priority
	// high
	// END DEBUGGING
	// NvmeSubsystemHostModifyCollectionBodyPriorityHigh captures enum value "high"
	NvmeSubsystemHostModifyCollectionBodyPriorityHigh string = "high"
)

// prop value enum
func (o *NvmeSubsystemHostModifyCollectionBody) validatePriorityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostModifyCollectionBodyTypePriorityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) validatePriority(formats strfmt.Registry) error {
	if swag.IsZero(o.Priority) { // not required
		return nil
	}

	// value enum
	if err := o.validatePriorityEnum("info"+"."+"priority", "body", *o.Priority); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(o.Proximity) { // not required
		return nil
	}

	if o.Proximity != nil {
		if err := o.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "proximity")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(o.Subsystem) { // not required
		return nil
	}

	if o.Subsystem != nil {
		if err := o.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) validateTLS(formats strfmt.Registry) error {
	if swag.IsZero(o.TLS) { // not required
		return nil
	}

	if o.TLS != nil {
		if err := o.TLS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "tls")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host modify collection body based on the context it is used
func (o *NvmeSubsystemHostModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDhHmacChap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIoQueue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNvmeSubsystemHostInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTLS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) contextValidateDhHmacChap(ctx context.Context, formats strfmt.Registry) error {

	if o.DhHmacChap != nil {
		if err := o.DhHmacChap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) contextValidateIoQueue(ctx context.Context, formats strfmt.Registry) error {

	if o.IoQueue != nil {
		if err := o.IoQueue.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "io_queue")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) contextValidateNvmeSubsystemHostInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NvmeSubsystemHostInlineRecords); i++ {

		if o.NvmeSubsystemHostInlineRecords[i] != nil {
			if err := o.NvmeSubsystemHostInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if o.Proximity != nil {
		if err := o.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "proximity")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if o.Subsystem != nil {
		if err := o.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostModifyCollectionBody) contextValidateTLS(ctx context.Context, formats strfmt.Registry) error {

	if o.TLS != nil {
		if err := o.TLS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "tls")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0 A reference to an SVM peer relationship.
swagger:model NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0
*/
type NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0 struct {

	// links
	Links *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem host modify collection params body proximity peer svms items0
func (o *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host modify collection params body proximity peer svms items0 based on the context it is used
func (o *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0Links nvme subsystem host modify collection params body proximity peer svms items0 links
swagger:model NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0Links
*/
type NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem host modify collection params body proximity peer svms items0 links
func (o *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host modify collection params body proximity peer svms items0 links based on the context it is used
func (o *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineLinks nvme subsystem host inline links
swagger:model nvme_subsystem_host_inline__links
*/
type NvmeSubsystemHostInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem host inline links
func (o *NvmeSubsystemHostInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline links based on the context it is used
func (o *NvmeSubsystemHostInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineDhHmacChap A container for the configuration of NVMe in-band authentication using the DH-HMAC-CHAP protocol for a host.
//
swagger:model nvme_subsystem_host_inline_dh_hmac_chap
*/
type NvmeSubsystemHostInlineDhHmacChap struct {

	// The controller secret for NVMe in-band authentication. The value of this property is used by the NVMe host to authenticate the NVMe controller while establishing a connection. If unset, the controller is not authenticated. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.<br/>
	// This property is write-only. The `mode` property can be used to identify if a controller secret has been set for the host, but the controller secret value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: DHHC-1:00:ia6zGodOr4SEG0Zzaw398rpY0wqipUWj4jWjUh4HWUz6aQ2n:
	ControllerSecretKey *string `json:"controller_secret_key,omitempty"`

	// The Diffie-Hellman group size for NVMe in-band authentication. When property `host_secret_key` is provided, this property defaults to `2048_bit`. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.
	//
	// Enum: ["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]
	GroupSize *string `json:"group_size,omitempty"`

	// The hash function for NVMe in-band authentication. When property `host_secret_key` is provided, this property defaults to `sha_256`. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.
	//
	// Enum: ["sha_256","sha_512"]
	HashFunction *string `json:"hash_function,omitempty"`

	// The host secret for NVMe in-band authentication. The value of this property is used by the NVMe controller to authenticate the NVMe host while establishing a connection. If unset, no authentication is performed by the host or controller. This property must be supplied if any other NVMe in-band authentication properties are supplied. Optional in POST.<br/>
	// This property is write-only. The `mode` property can be used to identify if a host secret has been set for the host, but the host secret value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: DHHC-1:00:ia6zGodOr4SEG0Zzaw398rpY0wqipUWj4jWjUh4HWUz6aQ2n:
	HostSecretKey *string `json:"host_secret_key,omitempty"`

	// The expected NVMe in-band authentication mode for the host. This property is an indication of which secrets are configured for the host. When set to:
	// - none: The host has neither the host nor controller secret configured, and no authentication is performed.
	// - unidirectional: The host has a host secret configured. The controller will authenticate the host.
	// - bidirectional: The host has both a host and controller secret configured. The controller will authenticate the host and the host will authenticate the controller.
	//
	// Example: bidirectional
	// Read Only: true
	// Enum: ["none","unidirectional","bidirectional"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this nvme subsystem host inline dh hmac chap
func (o *NvmeSubsystemHostInlineDhHmacChap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGroupSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHashFunction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemHostInlineDhHmacChapTypeGroupSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineDhHmacChapTypeGroupSizePropEnum = append(nvmeSubsystemHostInlineDhHmacChapTypeGroupSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// group_size
	// GroupSize
	// none
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapGroupSizeNone captures enum value "none"
	NvmeSubsystemHostInlineDhHmacChapGroupSizeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// group_size
	// GroupSize
	// 2048_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapGroupSizeNr2048Bit captures enum value "2048_bit"
	NvmeSubsystemHostInlineDhHmacChapGroupSizeNr2048Bit string = "2048_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// group_size
	// GroupSize
	// 3072_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapGroupSizeNr3072Bit captures enum value "3072_bit"
	NvmeSubsystemHostInlineDhHmacChapGroupSizeNr3072Bit string = "3072_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// group_size
	// GroupSize
	// 4096_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapGroupSizeNr4096Bit captures enum value "4096_bit"
	NvmeSubsystemHostInlineDhHmacChapGroupSizeNr4096Bit string = "4096_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// group_size
	// GroupSize
	// 6144_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapGroupSizeNr6144Bit captures enum value "6144_bit"
	NvmeSubsystemHostInlineDhHmacChapGroupSizeNr6144Bit string = "6144_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// group_size
	// GroupSize
	// 8192_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapGroupSizeNr8192Bit captures enum value "8192_bit"
	NvmeSubsystemHostInlineDhHmacChapGroupSizeNr8192Bit string = "8192_bit"
)

// prop value enum
func (o *NvmeSubsystemHostInlineDhHmacChap) validateGroupSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineDhHmacChapTypeGroupSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemHostInlineDhHmacChap) validateGroupSize(formats strfmt.Registry) error {
	if swag.IsZero(o.GroupSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateGroupSizeEnum("info"+"."+"dh_hmac_chap"+"."+"group_size", "body", *o.GroupSize); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemHostInlineDhHmacChapTypeHashFunctionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sha_256","sha_512"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineDhHmacChapTypeHashFunctionPropEnum = append(nvmeSubsystemHostInlineDhHmacChapTypeHashFunctionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_256
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapHashFunctionSha256 captures enum value "sha_256"
	NvmeSubsystemHostInlineDhHmacChapHashFunctionSha256 string = "sha_256"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_512
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapHashFunctionSha512 captures enum value "sha_512"
	NvmeSubsystemHostInlineDhHmacChapHashFunctionSha512 string = "sha_512"
)

// prop value enum
func (o *NvmeSubsystemHostInlineDhHmacChap) validateHashFunctionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineDhHmacChapTypeHashFunctionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemHostInlineDhHmacChap) validateHashFunction(formats strfmt.Registry) error {
	if swag.IsZero(o.HashFunction) { // not required
		return nil
	}

	// value enum
	if err := o.validateHashFunctionEnum("info"+"."+"dh_hmac_chap"+"."+"hash_function", "body", *o.HashFunction); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemHostInlineDhHmacChapTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","unidirectional","bidirectional"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineDhHmacChapTypeModePropEnum = append(nvmeSubsystemHostInlineDhHmacChapTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// mode
	// Mode
	// none
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapModeNone captures enum value "none"
	NvmeSubsystemHostInlineDhHmacChapModeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// mode
	// Mode
	// unidirectional
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapModeUnidirectional captures enum value "unidirectional"
	NvmeSubsystemHostInlineDhHmacChapModeUnidirectional string = "unidirectional"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// mode
	// Mode
	// bidirectional
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapModeBidirectional captures enum value "bidirectional"
	NvmeSubsystemHostInlineDhHmacChapModeBidirectional string = "bidirectional"
)

// prop value enum
func (o *NvmeSubsystemHostInlineDhHmacChap) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineDhHmacChapTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemHostInlineDhHmacChap) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(o.Mode) { // not required
		return nil
	}

	// value enum
	if err := o.validateModeEnum("info"+"."+"dh_hmac_chap"+"."+"mode", "body", *o.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline dh hmac chap based on the context it is used
func (o *NvmeSubsystemHostInlineDhHmacChap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineDhHmacChap) contextValidateMode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"dh_hmac_chap"+"."+"mode", "body", o.Mode); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineDhHmacChap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineDhHmacChap) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineDhHmacChap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineIoQueue The properties of the submission queue used to submit I/O commands for execution by the NVMe controller.
//
swagger:model nvme_subsystem_host_inline_io_queue
*/
type NvmeSubsystemHostInlineIoQueue struct {

	// The number of I/O queue pairs. Absence of this property in GET implies property priority is set and platform and transport protocol specific values for I/O queue count is being used. Valid in GET only.
	//
	// Example: 4
	// Read Only: true
	// Maximum: 15
	// Minimum: 1
	Count *int64 `json:"count,omitempty"`

	// The I/O queue depth. Absence of this property in GET implies property priority is set and platform and transport protocol specific values for I/O queue depth is being used. Valid in GET only.
	//
	// Example: 32
	// Read Only: true
	// Maximum: 128
	// Minimum: 16
	Depth *int64 `json:"depth,omitempty"`
}

// Validate validates this nvme subsystem host inline io queue
func (o *NvmeSubsystemHostInlineIoQueue) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCount(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDepth(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineIoQueue) validateCount(formats strfmt.Registry) error {
	if swag.IsZero(o.Count) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"io_queue"+"."+"count", "body", *o.Count, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"io_queue"+"."+"count", "body", *o.Count, 15, false); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemHostInlineIoQueue) validateDepth(formats strfmt.Registry) error {
	if swag.IsZero(o.Depth) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"io_queue"+"."+"depth", "body", *o.Depth, 16, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"io_queue"+"."+"depth", "body", *o.Depth, 128, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline io queue based on the context it is used
func (o *NvmeSubsystemHostInlineIoQueue) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDepth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineIoQueue) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"io_queue"+"."+"count", "body", o.Count); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemHostInlineIoQueue) contextValidateDepth(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"io_queue"+"."+"depth", "body", o.Depth); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineIoQueue) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineIoQueue) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineIoQueue
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineProximity Properties that define the SVMs to which the host is proximal. This information is used to properly report active optimized and active non-optimized network paths using an NVMe controller. If no configuration has been specified for the host, the sub-object is not present in GET requests.<br/>
// These properties apply to all instances of the host in the NVMe subsystem in the SVM and its peers.
//
swagger:model nvme_subsystem_host_inline_proximity
*/
type NvmeSubsystemHostInlineProximity struct {

	// A boolean that indicates if the host is proximal to the SVM for which it is configured.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the host is proximal.
	//
	PeerSvms []*NvmeSubsystemHostModifyCollectionParamsBodyProximityPeerSvmsItems0 `json:"peer_svms,omitempty"`
}

// Validate validates this nvme subsystem host inline proximity
func (o *NvmeSubsystemHostInlineProximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineProximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(o.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(o.PeerSvms); i++ {
		if swag.IsZero(o.PeerSvms[i]) { // not required
			continue
		}

		if o.PeerSvms[i] != nil {
			if err := o.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline proximity based on the context it is used
func (o *NvmeSubsystemHostInlineProximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineProximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.PeerSvms); i++ {

		if o.PeerSvms[i] != nil {
			if err := o.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineProximity) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineProximity) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineProximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineRecordsInlineArrayItem The NVMe host provisioned to access NVMe namespaces mapped to a subsystem.
//
swagger:model nvme_subsystem_host_inline_records_inline_array_item
*/
type NvmeSubsystemHostInlineRecordsInlineArrayItem struct {

	// links
	Links *models.NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// dh hmac chap
	DhHmacChap *models.NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap `json:"dh_hmac_chap,omitempty"`

	// io queue
	IoQueue *models.NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue `json:"io_queue,omitempty"`

	// The NVMe qualified name (NQN) used to identify the NVMe storage target. Not allowed in POST when the `records` property is used.
	//
	// Example: nqn.1992-01.example.com:string
	Nqn *string `json:"nqn,omitempty"`

	// subsystem
	Subsystem *models.NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem `json:"subsystem,omitempty"`

	// tls
	TLS *models.NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS `json:"tls,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDhHmacChap(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIoQueue(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTLS(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) validateDhHmacChap(formats strfmt.Registry) error {
	if swag.IsZero(o.DhHmacChap) { // not required
		return nil
	}

	if o.DhHmacChap != nil {
		if err := o.DhHmacChap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) validateIoQueue(formats strfmt.Registry) error {
	if swag.IsZero(o.IoQueue) { // not required
		return nil
	}

	if o.IoQueue != nil {
		if err := o.IoQueue.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("io_queue")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(o.Subsystem) { // not required
		return nil
	}

	if o.Subsystem != nil {
		if err := o.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) validateTLS(formats strfmt.Registry) error {
	if swag.IsZero(o.TLS) { // not required
		return nil
	}

	if o.TLS != nil {
		if err := o.TLS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline records inline array item based on the context it is used
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDhHmacChap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIoQueue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTLS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) contextValidateDhHmacChap(ctx context.Context, formats strfmt.Registry) error {

	if o.DhHmacChap != nil {
		if err := o.DhHmacChap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) contextValidateIoQueue(ctx context.Context, formats strfmt.Registry) error {

	if o.IoQueue != nil {
		if err := o.IoQueue.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("io_queue")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if o.Subsystem != nil {
		if err := o.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) contextValidateTLS(ctx context.Context, formats strfmt.Registry) error {

	if o.TLS != nil {
		if err := o.TLS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks nvme subsystem host inline records inline array item inline links
swagger:model nvme_subsystem_host_inline_records_inline_array_item_inline__links
*/
type NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item inline links
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline records inline array item inline links based on the context it is used
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap A container for the configuration of NVMe in-band authentication using the DH-HMAC-CHAP protocol for a host.
//
swagger:model nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
*/
type NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap struct {

	// The controller secret for NVMe in-band authentication. The value of this property is used by the NVMe host to authenticate the NVMe controller while establishing a connection. If unset, the controller is not authenticated. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.<br/>
	// This property is write-only. The `mode` property can be used to identify if a controller secret has been set for the host, but the controller secret value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: DHHC-1:00:ia6zGodOr4SEG0Zzaw398rpY0wqipUWj4jWjUh4HWUz6aQ2n:
	ControllerSecretKey *string `json:"controller_secret_key,omitempty"`

	// The Diffie-Hellman group size for NVMe in-band authentication. When property `host_secret_key` is provided, this property defaults to `2048_bit`. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.
	//
	// Enum: ["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]
	GroupSize *string `json:"group_size,omitempty"`

	// The hash function for NVMe in-band authentication. When property `host_secret_key` is provided, this property defaults to `sha_256`. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.
	//
	// Enum: ["sha_256","sha_512"]
	HashFunction *string `json:"hash_function,omitempty"`

	// The host secret for NVMe in-band authentication. The value of this property is used by the NVMe controller to authenticate the NVMe host while establishing a connection. If unset, no authentication is performed by the host or controller. This property must be supplied if any other NVMe in-band authentication properties are supplied. Optional in POST.<br/>
	// This property is write-only. The `mode` property can be used to identify if a host secret has been set for the host, but the host secret value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: DHHC-1:00:ia6zGodOr4SEG0Zzaw398rpY0wqipUWj4jWjUh4HWUz6aQ2n:
	HostSecretKey *string `json:"host_secret_key,omitempty"`

	// The expected NVMe in-band authentication mode for the host. This property is an indication of which secrets are configured for the host. When set to:
	// - none: The host has neither the host nor controller secret configured, and no authentication is performed.
	// - unidirectional: The host has a host secret configured. The controller will authenticate the host.
	// - bidirectional: The host has both a host and controller secret configured. The controller will authenticate the host and the host will authenticate the controller.
	//
	// Example: bidirectional
	// Read Only: true
	// Enum: ["none","unidirectional","bidirectional"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item inline dh hmac chap
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGroupSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHashFunction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum = append(nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// none
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNone captures enum value "none"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 2048_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr2048Bit captures enum value "2048_bit"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr2048Bit string = "2048_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 3072_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr3072Bit captures enum value "3072_bit"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr3072Bit string = "3072_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 4096_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr4096Bit captures enum value "4096_bit"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr4096Bit string = "4096_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 6144_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr6144Bit captures enum value "6144_bit"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr6144Bit string = "6144_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 8192_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr8192Bit captures enum value "8192_bit"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr8192Bit string = "8192_bit"
)

// prop value enum
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) validateGroupSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) validateGroupSize(formats strfmt.Registry) error {
	if swag.IsZero(o.GroupSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateGroupSizeEnum("dh_hmac_chap"+"."+"group_size", "body", *o.GroupSize); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sha_256","sha_512"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum = append(nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_256
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapHashFunctionSha256 captures enum value "sha_256"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapHashFunctionSha256 string = "sha_256"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_512
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapHashFunctionSha512 captures enum value "sha_512"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapHashFunctionSha512 string = "sha_512"
)

// prop value enum
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) validateHashFunctionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) validateHashFunction(formats strfmt.Registry) error {
	if swag.IsZero(o.HashFunction) { // not required
		return nil
	}

	// value enum
	if err := o.validateHashFunctionEnum("dh_hmac_chap"+"."+"hash_function", "body", *o.HashFunction); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","unidirectional","bidirectional"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeModePropEnum = append(nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// mode
	// Mode
	// none
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapModeNone captures enum value "none"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapModeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// mode
	// Mode
	// unidirectional
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapModeUnidirectional captures enum value "unidirectional"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapModeUnidirectional string = "unidirectional"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// mode
	// Mode
	// bidirectional
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapModeBidirectional captures enum value "bidirectional"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapModeBidirectional string = "bidirectional"
)

// prop value enum
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(o.Mode) { // not required
		return nil
	}

	// value enum
	if err := o.validateModeEnum("dh_hmac_chap"+"."+"mode", "body", *o.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline records inline array item inline dh hmac chap based on the context it is used
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) contextValidateMode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "dh_hmac_chap"+"."+"mode", "body", o.Mode); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue The properties of the submission queue used to submit I/O commands for execution by the NVMe controller.
//
swagger:model nvme_subsystem_host_inline_records_inline_array_item_inline_io_queue
*/
type NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue struct {

	// The number of I/O queue pairs. The default value is inherited from the owning NVMe subsystem.
	//
	// Example: 4
	// Read Only: true
	// Maximum: 15
	// Minimum: 1
	Count *int64 `json:"count,omitempty"`

	// The I/O queue depth. The default value is inherited from the owning NVMe subsystem.
	//
	// Example: 32
	// Read Only: true
	// Maximum: 128
	// Minimum: 16
	Depth *int64 `json:"depth,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item inline io queue
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCount(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDepth(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) validateCount(formats strfmt.Registry) error {
	if swag.IsZero(o.Count) { // not required
		return nil
	}

	if err := validate.MinimumInt("io_queue"+"."+"count", "body", *o.Count, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("io_queue"+"."+"count", "body", *o.Count, 15, false); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) validateDepth(formats strfmt.Registry) error {
	if swag.IsZero(o.Depth) { // not required
		return nil
	}

	if err := validate.MinimumInt("io_queue"+"."+"depth", "body", *o.Depth, 16, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("io_queue"+"."+"depth", "body", *o.Depth, 128, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline records inline array item inline io queue based on the context it is used
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDepth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "io_queue"+"."+"count", "body", o.Count); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) contextValidateDepth(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "io_queue"+"."+"depth", "body", o.Depth); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem The NVMe subsystem to which the NVMe host has been provisioned.
//
swagger:model nvme_subsystem_host_inline_records_inline_array_item_inline_subsystem
*/
type NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem struct {

	// links
	Links *models.NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks `json:"_links,omitempty"`

	// The name of the NVMe subsystem.
	//
	// Example: subsystem1
	// Read Only: true
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item inline subsystem
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("subsystem"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("subsystem"+"."+"name", "body", *o.Name, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline records inline array item inline subsystem based on the context it is used
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks nvme subsystem host inline records inline array item inline subsystem inline links
swagger:model nvme_subsystem_host_inline_records_inline_array_item_inline_subsystem_inline__links
*/
type NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item inline subsystem inline links
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline records inline array item inline subsystem inline links based on the context it is used
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS A container for the configuration for NVMe/TCP-TLS transport session for the host.
//
swagger:model nvme_subsystem_host_inline_records_inline_array_item_inline_tls
*/
type NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS struct {

	// A user supplied pre-shared key (PSK) value in PSK Interchange Format. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree. This property is only allowed when `key_type` is `configured`. If `configured_psk` is supplied and `key_type` is unset, `key_type` defaults to `configured`.</br>
	// This property is write-only. The `key_type` property can be used to identify if a configured PSK has been set for the host, but the PSK value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: NVMeTLSkey-1:01:VRLbtnN9AQb2WXW3c9+wEf/DRLz0QuLdbYvEhwtdWwNf9LrZ:
	ConfiguredPsk *string `json:"configured_psk,omitempty"`

	// The method by which the TLS pre-shared key (PSK) is configured for the host. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree.</br>
	// Possible values:
	// - `none` - TLS is not configured for the host connection. No value is allowed for property `configured_psk`.
	// - `configured` - A user supplied PSK is configured for the NVMe/TCP-TLS transport connection between the host and the NVMe subsystem. A valid value for property `configured_psk` is required.
	// </br>
	// This property defaults to `none` unless a value is supplied for `configured_psk` in which case it defaults to `configured`.
	//
	// Example: configured
	// Enum: ["none","configured"]
	KeyType *string `json:"key_type,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item inline tls
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateKeyType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemHostInlineRecordsInlineArrayItemInlineTlsTypeKeyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","configured"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineRecordsInlineArrayItemInlineTlsTypeKeyTypePropEnum = append(nvmeSubsystemHostInlineRecordsInlineArrayItemInlineTlsTypeKeyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_tls
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS
	// key_type
	// KeyType
	// none
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLSKeyTypeNone captures enum value "none"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLSKeyTypeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_tls
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS
	// key_type
	// KeyType
	// configured
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLSKeyTypeConfigured captures enum value "configured"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLSKeyTypeConfigured string = "configured"
)

// prop value enum
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS) validateKeyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineRecordsInlineArrayItemInlineTlsTypeKeyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS) validateKeyType(formats strfmt.Registry) error {
	if swag.IsZero(o.KeyType) { // not required
		return nil
	}

	// value enum
	if err := o.validateKeyTypeEnum("tls"+"."+"key_type", "body", *o.KeyType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nvme subsystem host inline records inline array item inline tls based on context it is used
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineSubsystem The NVMe subsystem to which the NVMe host has been provisioned.
//
swagger:model nvme_subsystem_host_inline_subsystem
*/
type NvmeSubsystemHostInlineSubsystem struct {

	// links
	Links *models.NvmeSubsystemHostInlineSubsystemInlineLinks `json:"_links,omitempty"`

	// The name of the NVMe subsystem.
	//
	// Example: subsystem1
	// Read Only: true
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem host inline subsystem
func (o *NvmeSubsystemHostInlineSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineSubsystem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostInlineSubsystem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"subsystem"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"subsystem"+"."+"name", "body", *o.Name, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline subsystem based on the context it is used
func (o *NvmeSubsystemHostInlineSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineSubsystem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemHostInlineSubsystem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"subsystem"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemHostInlineSubsystem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"subsystem"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineSubsystem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineSubsystem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineSubsystemInlineLinks nvme subsystem host inline subsystem inline links
swagger:model nvme_subsystem_host_inline_subsystem_inline__links
*/
type NvmeSubsystemHostInlineSubsystemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem host inline subsystem inline links
func (o *NvmeSubsystemHostInlineSubsystemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineSubsystemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline subsystem inline links based on the context it is used
func (o *NvmeSubsystemHostInlineSubsystemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemHostInlineSubsystemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineSubsystemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineSubsystemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineSubsystemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemHostInlineTLS A container for the configuration for NVMe/TCP-TLS transport session for the host.
//
swagger:model nvme_subsystem_host_inline_tls
*/
type NvmeSubsystemHostInlineTLS struct {

	// A user supplied pre-shared key (PSK) value in PSK Interchange Format. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree. This property is only allowed when `key_type` is `configured`. If `configured_psk` is supplied and `key_type` is unset, `key_type` defaults to `configured`.</br>
	// This property is write-only. The `key_type` property can be used to identify if a configured PSK has been set for the host, but the PSK value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: NVMeTLSkey-1:01:VRLbtnN9AQb2WXW3c9+wEf/DRLz0QuLdbYvEhwtdWwNf9LrZ:
	ConfiguredPsk *string `json:"configured_psk,omitempty"`

	// The method by which the TLS pre-shared key (PSK) is configured for the host. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree.</br>
	// Possible values:
	// - `none` - TLS is not configured for the host connection. No value is allowed for property `configured_psk`.
	// - `configured` - A user supplied PSK is configured for the NVMe/TCP-TLS transport connection between the host and the NVMe subsystem. A valid value for property `configured_psk` is required.
	// </br>
	// This property defaults to `none` unless a value is supplied for `configured_psk` in which case it defaults to `configured`.
	//
	// Example: configured
	// Enum: ["none","configured"]
	KeyType *string `json:"key_type,omitempty"`
}

// Validate validates this nvme subsystem host inline tls
func (o *NvmeSubsystemHostInlineTLS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateKeyType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemHostInlineTlsTypeKeyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","configured"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineTlsTypeKeyTypePropEnum = append(nvmeSubsystemHostInlineTlsTypeKeyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_tls
	// NvmeSubsystemHostInlineTLS
	// key_type
	// KeyType
	// none
	// END DEBUGGING
	// NvmeSubsystemHostInlineTLSKeyTypeNone captures enum value "none"
	NvmeSubsystemHostInlineTLSKeyTypeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_tls
	// NvmeSubsystemHostInlineTLS
	// key_type
	// KeyType
	// configured
	// END DEBUGGING
	// NvmeSubsystemHostInlineTLSKeyTypeConfigured captures enum value "configured"
	NvmeSubsystemHostInlineTLSKeyTypeConfigured string = "configured"
)

// prop value enum
func (o *NvmeSubsystemHostInlineTLS) validateKeyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineTlsTypeKeyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemHostInlineTLS) validateKeyType(formats strfmt.Registry) error {
	if swag.IsZero(o.KeyType) { // not required
		return nil
	}

	// value enum
	if err := o.validateKeyTypeEnum("info"+"."+"tls"+"."+"key_type", "body", *o.KeyType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nvme subsystem host inline tls based on context it is used
func (o *NvmeSubsystemHostInlineTLS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineTLS) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemHostInlineTLS) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineTLS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
