// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NvmeSubsystemHostModifyReader is a Reader for the NvmeSubsystemHostModify structure.
type NvmeSubsystemHostModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NvmeSubsystemHostModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNvmeSubsystemHostModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNvmeSubsystemHostModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNvmeSubsystemHostModifyOK creates a NvmeSubsystemHostModifyOK with default headers values
func NewNvmeSubsystemHostModifyOK() *NvmeSubsystemHostModifyOK {
	return &NvmeSubsystemHostModifyOK{}
}

/*
NvmeSubsystemHostModifyOK describes a response with status code 200, with default header values.

OK
*/
type NvmeSubsystemHostModifyOK struct {
}

// IsSuccess returns true when this nvme subsystem host modify o k response has a 2xx status code
func (o *NvmeSubsystemHostModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme subsystem host modify o k response has a 3xx status code
func (o *NvmeSubsystemHostModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme subsystem host modify o k response has a 4xx status code
func (o *NvmeSubsystemHostModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme subsystem host modify o k response has a 5xx status code
func (o *NvmeSubsystemHostModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme subsystem host modify o k response a status code equal to that given
func (o *NvmeSubsystemHostModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nvme subsystem host modify o k response
func (o *NvmeSubsystemHostModifyOK) Code() int {
	return 200
}

func (o *NvmeSubsystemHostModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/nvme/subsystems/{subsystem.uuid}/hosts/{nqn}][%d] nvmeSubsystemHostModifyOK", 200)
}

func (o *NvmeSubsystemHostModifyOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/nvme/subsystems/{subsystem.uuid}/hosts/{nqn}][%d] nvmeSubsystemHostModifyOK", 200)
}

func (o *NvmeSubsystemHostModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNvmeSubsystemHostModifyDefault creates a NvmeSubsystemHostModifyDefault with default headers values
func NewNvmeSubsystemHostModifyDefault(code int) *NvmeSubsystemHostModifyDefault {
	return &NvmeSubsystemHostModifyDefault{
		_statusCode: code,
	}
}

/*
	NvmeSubsystemHostModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5376354 | The SVM peer relationship does not exist. |
| 26345675 | The SVM peer relationship contains local SVM name mismatch. |
| 72090001 | The NVMe subsystem does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NvmeSubsystemHostModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nvme subsystem host modify default response has a 2xx status code
func (o *NvmeSubsystemHostModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nvme subsystem host modify default response has a 3xx status code
func (o *NvmeSubsystemHostModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nvme subsystem host modify default response has a 4xx status code
func (o *NvmeSubsystemHostModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nvme subsystem host modify default response has a 5xx status code
func (o *NvmeSubsystemHostModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nvme subsystem host modify default response a status code equal to that given
func (o *NvmeSubsystemHostModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nvme subsystem host modify default response
func (o *NvmeSubsystemHostModifyDefault) Code() int {
	return o._statusCode
}

func (o *NvmeSubsystemHostModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nvme/subsystems/{subsystem.uuid}/hosts/{nqn}][%d] nvme_subsystem_host_modify default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemHostModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nvme/subsystems/{subsystem.uuid}/hosts/{nqn}][%d] nvme_subsystem_host_modify default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemHostModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NvmeSubsystemHostModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
