// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNvmeSubsystemMapCollectionGetParams creates a new NvmeSubsystemMapCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNvmeSubsystemMapCollectionGetParams() *NvmeSubsystemMapCollectionGetParams {
	return &NvmeSubsystemMapCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNvmeSubsystemMapCollectionGetParamsWithTimeout creates a new NvmeSubsystemMapCollectionGetParams object
// with the ability to set a timeout on a request.
func NewNvmeSubsystemMapCollectionGetParamsWithTimeout(timeout time.Duration) *NvmeSubsystemMapCollectionGetParams {
	return &NvmeSubsystemMapCollectionGetParams{
		timeout: timeout,
	}
}

// NewNvmeSubsystemMapCollectionGetParamsWithContext creates a new NvmeSubsystemMapCollectionGetParams object
// with the ability to set a context for a request.
func NewNvmeSubsystemMapCollectionGetParamsWithContext(ctx context.Context) *NvmeSubsystemMapCollectionGetParams {
	return &NvmeSubsystemMapCollectionGetParams{
		Context: ctx,
	}
}

// NewNvmeSubsystemMapCollectionGetParamsWithHTTPClient creates a new NvmeSubsystemMapCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNvmeSubsystemMapCollectionGetParamsWithHTTPClient(client *http.Client) *NvmeSubsystemMapCollectionGetParams {
	return &NvmeSubsystemMapCollectionGetParams{
		HTTPClient: client,
	}
}

/*
NvmeSubsystemMapCollectionGetParams contains all the parameters to send to the API endpoint

	for the nvme subsystem map collection get operation.

	Typically these are written to a http.Request.
*/
type NvmeSubsystemMapCollectionGetParams struct {

	/* Anagrpid.

	   Filter by anagrpid
	*/
	Anagrpid *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NamespaceName.

	   Filter by namespace.name
	*/
	NamespaceName *string

	/* NamespaceNodeName.

	   Filter by namespace.node.name
	*/
	NamespaceNodeName *string

	/* NamespaceNodeUUID.

	   Filter by namespace.node.uuid
	*/
	NamespaceNodeUUID *string

	/* NamespaceUUID.

	   Filter by namespace.uuid
	*/
	NamespaceUUID *string

	/* Nsid.

	   Filter by nsid
	*/
	Nsid *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SubsystemName.

	   Filter by subsystem.name
	*/
	SubsystemName *string

	/* SubsystemUUID.

	   Filter by subsystem.uuid
	*/
	SubsystemUUID *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nvme subsystem map collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeSubsystemMapCollectionGetParams) WithDefaults() *NvmeSubsystemMapCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nvme subsystem map collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NvmeSubsystemMapCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NvmeSubsystemMapCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithTimeout(timeout time.Duration) *NvmeSubsystemMapCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithContext(ctx context.Context) *NvmeSubsystemMapCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithHTTPClient(client *http.Client) *NvmeSubsystemMapCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAnagrpid adds the anagrpid to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithAnagrpid(anagrpid *string) *NvmeSubsystemMapCollectionGetParams {
	o.SetAnagrpid(anagrpid)
	return o
}

// SetAnagrpid adds the anagrpid to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetAnagrpid(anagrpid *string) {
	o.Anagrpid = anagrpid
}

// WithFields adds the fields to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithFields(fields []string) *NvmeSubsystemMapCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithMaxRecords(maxRecords *int64) *NvmeSubsystemMapCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNamespaceName adds the namespaceName to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithNamespaceName(namespaceName *string) *NvmeSubsystemMapCollectionGetParams {
	o.SetNamespaceName(namespaceName)
	return o
}

// SetNamespaceName adds the namespaceName to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetNamespaceName(namespaceName *string) {
	o.NamespaceName = namespaceName
}

// WithNamespaceNodeName adds the namespaceNodeName to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithNamespaceNodeName(namespaceNodeName *string) *NvmeSubsystemMapCollectionGetParams {
	o.SetNamespaceNodeName(namespaceNodeName)
	return o
}

// SetNamespaceNodeName adds the namespaceNodeName to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetNamespaceNodeName(namespaceNodeName *string) {
	o.NamespaceNodeName = namespaceNodeName
}

// WithNamespaceNodeUUID adds the namespaceNodeUUID to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithNamespaceNodeUUID(namespaceNodeUUID *string) *NvmeSubsystemMapCollectionGetParams {
	o.SetNamespaceNodeUUID(namespaceNodeUUID)
	return o
}

// SetNamespaceNodeUUID adds the namespaceNodeUuid to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetNamespaceNodeUUID(namespaceNodeUUID *string) {
	o.NamespaceNodeUUID = namespaceNodeUUID
}

// WithNamespaceUUID adds the namespaceUUID to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithNamespaceUUID(namespaceUUID *string) *NvmeSubsystemMapCollectionGetParams {
	o.SetNamespaceUUID(namespaceUUID)
	return o
}

// SetNamespaceUUID adds the namespaceUuid to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetNamespaceUUID(namespaceUUID *string) {
	o.NamespaceUUID = namespaceUUID
}

// WithNsid adds the nsid to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithNsid(nsid *string) *NvmeSubsystemMapCollectionGetParams {
	o.SetNsid(nsid)
	return o
}

// SetNsid adds the nsid to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetNsid(nsid *string) {
	o.Nsid = nsid
}

// WithOrderBy adds the orderBy to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithOrderBy(orderBy []string) *NvmeSubsystemMapCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithReturnRecords(returnRecords *bool) *NvmeSubsystemMapCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *NvmeSubsystemMapCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSubsystemName adds the subsystemName to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithSubsystemName(subsystemName *string) *NvmeSubsystemMapCollectionGetParams {
	o.SetSubsystemName(subsystemName)
	return o
}

// SetSubsystemName adds the subsystemName to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetSubsystemName(subsystemName *string) {
	o.SubsystemName = subsystemName
}

// WithSubsystemUUID adds the subsystemUUID to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithSubsystemUUID(subsystemUUID *string) *NvmeSubsystemMapCollectionGetParams {
	o.SetSubsystemUUID(subsystemUUID)
	return o
}

// SetSubsystemUUID adds the subsystemUuid to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetSubsystemUUID(subsystemUUID *string) {
	o.SubsystemUUID = subsystemUUID
}

// WithSvmName adds the svmName to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithSvmName(svmName *string) *NvmeSubsystemMapCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) WithSvmUUID(svmUUID *string) *NvmeSubsystemMapCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the nvme subsystem map collection get params
func (o *NvmeSubsystemMapCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NvmeSubsystemMapCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Anagrpid != nil {

		// query param anagrpid
		var qrAnagrpid string

		if o.Anagrpid != nil {
			qrAnagrpid = *o.Anagrpid
		}
		qAnagrpid := qrAnagrpid
		if qAnagrpid != "" {

			if err := r.SetQueryParam("anagrpid", qAnagrpid); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NamespaceName != nil {

		// query param namespace.name
		var qrNamespaceName string

		if o.NamespaceName != nil {
			qrNamespaceName = *o.NamespaceName
		}
		qNamespaceName := qrNamespaceName
		if qNamespaceName != "" {

			if err := r.SetQueryParam("namespace.name", qNamespaceName); err != nil {
				return err
			}
		}
	}

	if o.NamespaceNodeName != nil {

		// query param namespace.node.name
		var qrNamespaceNodeName string

		if o.NamespaceNodeName != nil {
			qrNamespaceNodeName = *o.NamespaceNodeName
		}
		qNamespaceNodeName := qrNamespaceNodeName
		if qNamespaceNodeName != "" {

			if err := r.SetQueryParam("namespace.node.name", qNamespaceNodeName); err != nil {
				return err
			}
		}
	}

	if o.NamespaceNodeUUID != nil {

		// query param namespace.node.uuid
		var qrNamespaceNodeUUID string

		if o.NamespaceNodeUUID != nil {
			qrNamespaceNodeUUID = *o.NamespaceNodeUUID
		}
		qNamespaceNodeUUID := qrNamespaceNodeUUID
		if qNamespaceNodeUUID != "" {

			if err := r.SetQueryParam("namespace.node.uuid", qNamespaceNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceUUID != nil {

		// query param namespace.uuid
		var qrNamespaceUUID string

		if o.NamespaceUUID != nil {
			qrNamespaceUUID = *o.NamespaceUUID
		}
		qNamespaceUUID := qrNamespaceUUID
		if qNamespaceUUID != "" {

			if err := r.SetQueryParam("namespace.uuid", qNamespaceUUID); err != nil {
				return err
			}
		}
	}

	if o.Nsid != nil {

		// query param nsid
		var qrNsid string

		if o.Nsid != nil {
			qrNsid = *o.Nsid
		}
		qNsid := qrNsid
		if qNsid != "" {

			if err := r.SetQueryParam("nsid", qNsid); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SubsystemName != nil {

		// query param subsystem.name
		var qrSubsystemName string

		if o.SubsystemName != nil {
			qrSubsystemName = *o.SubsystemName
		}
		qSubsystemName := qrSubsystemName
		if qSubsystemName != "" {

			if err := r.SetQueryParam("subsystem.name", qSubsystemName); err != nil {
				return err
			}
		}
	}

	if o.SubsystemUUID != nil {

		// query param subsystem.uuid
		var qrSubsystemUUID string

		if o.SubsystemUUID != nil {
			qrSubsystemUUID = *o.SubsystemUUID
		}
		qSubsystemUUID := qrSubsystemUUID
		if qSubsystemUUID != "" {

			if err := r.SetQueryParam("subsystem.uuid", qSubsystemUUID); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNvmeSubsystemMapCollectionGet binds the parameter fields
func (o *NvmeSubsystemMapCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNvmeSubsystemMapCollectionGet binds the parameter order_by
func (o *NvmeSubsystemMapCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
