// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NvmeSubsystemMapDeleteReader is a Reader for the NvmeSubsystemMapDelete structure.
type NvmeSubsystemMapDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NvmeSubsystemMapDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNvmeSubsystemMapDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNvmeSubsystemMapDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNvmeSubsystemMapDeleteOK creates a NvmeSubsystemMapDeleteOK with default headers values
func NewNvmeSubsystemMapDeleteOK() *NvmeSubsystemMapDeleteOK {
	return &NvmeSubsystemMapDeleteOK{}
}

/*
NvmeSubsystemMapDeleteOK describes a response with status code 200, with default header values.

OK
*/
type NvmeSubsystemMapDeleteOK struct {
	Payload *models.NvmeSubsystemMapResponse
}

// IsSuccess returns true when this nvme subsystem map delete o k response has a 2xx status code
func (o *NvmeSubsystemMapDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme subsystem map delete o k response has a 3xx status code
func (o *NvmeSubsystemMapDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme subsystem map delete o k response has a 4xx status code
func (o *NvmeSubsystemMapDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme subsystem map delete o k response has a 5xx status code
func (o *NvmeSubsystemMapDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme subsystem map delete o k response a status code equal to that given
func (o *NvmeSubsystemMapDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nvme subsystem map delete o k response
func (o *NvmeSubsystemMapDeleteOK) Code() int {
	return 200
}

func (o *NvmeSubsystemMapDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nvme/subsystem-maps/{subsystem.uuid}/{namespace.uuid}][%d] nvmeSubsystemMapDeleteOK %s", 200, payload)
}

func (o *NvmeSubsystemMapDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nvme/subsystem-maps/{subsystem.uuid}/{namespace.uuid}][%d] nvmeSubsystemMapDeleteOK %s", 200, payload)
}

func (o *NvmeSubsystemMapDeleteOK) GetPayload() *models.NvmeSubsystemMapResponse {
	return o.Payload
}

func (o *NvmeSubsystemMapDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NvmeSubsystemMapResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNvmeSubsystemMapDeleteDefault creates a NvmeSubsystemMapDeleteDefault with default headers values
func NewNvmeSubsystemMapDeleteDefault(code int) *NvmeSubsystemMapDeleteDefault {
	return &NvmeSubsystemMapDeleteDefault{
		_statusCode: code,
	}
}

/*
	NvmeSubsystemMapDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 72090019 | The specified NVMe namespace is not mapped to the specified NVMe subsystem. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NvmeSubsystemMapDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nvme subsystem map delete default response has a 2xx status code
func (o *NvmeSubsystemMapDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nvme subsystem map delete default response has a 3xx status code
func (o *NvmeSubsystemMapDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nvme subsystem map delete default response has a 4xx status code
func (o *NvmeSubsystemMapDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nvme subsystem map delete default response has a 5xx status code
func (o *NvmeSubsystemMapDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nvme subsystem map delete default response a status code equal to that given
func (o *NvmeSubsystemMapDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nvme subsystem map delete default response
func (o *NvmeSubsystemMapDeleteDefault) Code() int {
	return o._statusCode
}

func (o *NvmeSubsystemMapDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nvme/subsystem-maps/{subsystem.uuid}/{namespace.uuid}][%d] nvme_subsystem_map_delete default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemMapDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nvme/subsystem-maps/{subsystem.uuid}/{namespace.uuid}][%d] nvme_subsystem_map_delete default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemMapDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NvmeSubsystemMapDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
