// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NvmeSubsystemMapGetReader is a Reader for the NvmeSubsystemMapGet structure.
type NvmeSubsystemMapGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NvmeSubsystemMapGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNvmeSubsystemMapGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNvmeSubsystemMapGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNvmeSubsystemMapGetOK creates a NvmeSubsystemMapGetOK with default headers values
func NewNvmeSubsystemMapGetOK() *NvmeSubsystemMapGetOK {
	return &NvmeSubsystemMapGetOK{}
}

/*
NvmeSubsystemMapGetOK describes a response with status code 200, with default header values.

OK
*/
type NvmeSubsystemMapGetOK struct {
	Payload *models.NvmeSubsystemMap
}

// IsSuccess returns true when this nvme subsystem map get o k response has a 2xx status code
func (o *NvmeSubsystemMapGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme subsystem map get o k response has a 3xx status code
func (o *NvmeSubsystemMapGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme subsystem map get o k response has a 4xx status code
func (o *NvmeSubsystemMapGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme subsystem map get o k response has a 5xx status code
func (o *NvmeSubsystemMapGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme subsystem map get o k response a status code equal to that given
func (o *NvmeSubsystemMapGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nvme subsystem map get o k response
func (o *NvmeSubsystemMapGetOK) Code() int {
	return 200
}

func (o *NvmeSubsystemMapGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nvme/subsystem-maps/{subsystem.uuid}/{namespace.uuid}][%d] nvmeSubsystemMapGetOK %s", 200, payload)
}

func (o *NvmeSubsystemMapGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nvme/subsystem-maps/{subsystem.uuid}/{namespace.uuid}][%d] nvmeSubsystemMapGetOK %s", 200, payload)
}

func (o *NvmeSubsystemMapGetOK) GetPayload() *models.NvmeSubsystemMap {
	return o.Payload
}

func (o *NvmeSubsystemMapGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NvmeSubsystemMap)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNvmeSubsystemMapGetDefault creates a NvmeSubsystemMapGetDefault with default headers values
func NewNvmeSubsystemMapGetDefault(code int) *NvmeSubsystemMapGetDefault {
	return &NvmeSubsystemMapGetDefault{
		_statusCode: code,
	}
}

/*
	NvmeSubsystemMapGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 72090019 | The specified NVMe namespace is not mapped to the specified NVMe subsystem. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NvmeSubsystemMapGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nvme subsystem map get default response has a 2xx status code
func (o *NvmeSubsystemMapGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nvme subsystem map get default response has a 3xx status code
func (o *NvmeSubsystemMapGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nvme subsystem map get default response has a 4xx status code
func (o *NvmeSubsystemMapGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nvme subsystem map get default response has a 5xx status code
func (o *NvmeSubsystemMapGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nvme subsystem map get default response a status code equal to that given
func (o *NvmeSubsystemMapGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nvme subsystem map get default response
func (o *NvmeSubsystemMapGetDefault) Code() int {
	return o._statusCode
}

func (o *NvmeSubsystemMapGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nvme/subsystem-maps/{subsystem.uuid}/{namespace.uuid}][%d] nvme_subsystem_map_get default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemMapGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/nvme/subsystem-maps/{subsystem.uuid}/{namespace.uuid}][%d] nvme_subsystem_map_get default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemMapGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NvmeSubsystemMapGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
