// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NvmeSubsystemModifyCollectionReader is a Reader for the NvmeSubsystemModifyCollection structure.
type NvmeSubsystemModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NvmeSubsystemModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNvmeSubsystemModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNvmeSubsystemModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNvmeSubsystemModifyCollectionOK creates a NvmeSubsystemModifyCollectionOK with default headers values
func NewNvmeSubsystemModifyCollectionOK() *NvmeSubsystemModifyCollectionOK {
	return &NvmeSubsystemModifyCollectionOK{}
}

/*
NvmeSubsystemModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NvmeSubsystemModifyCollectionOK struct {
}

// IsSuccess returns true when this nvme subsystem modify collection o k response has a 2xx status code
func (o *NvmeSubsystemModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nvme subsystem modify collection o k response has a 3xx status code
func (o *NvmeSubsystemModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nvme subsystem modify collection o k response has a 4xx status code
func (o *NvmeSubsystemModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nvme subsystem modify collection o k response has a 5xx status code
func (o *NvmeSubsystemModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nvme subsystem modify collection o k response a status code equal to that given
func (o *NvmeSubsystemModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nvme subsystem modify collection o k response
func (o *NvmeSubsystemModifyCollectionOK) Code() int {
	return 200
}

func (o *NvmeSubsystemModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/nvme/subsystems][%d] nvmeSubsystemModifyCollectionOK", 200)
}

func (o *NvmeSubsystemModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/nvme/subsystems][%d] nvmeSubsystemModifyCollectionOK", 200)
}

func (o *NvmeSubsystemModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNvmeSubsystemModifyCollectionDefault creates a NvmeSubsystemModifyCollectionDefault with default headers values
func NewNvmeSubsystemModifyCollectionDefault(code int) *NvmeSubsystemModifyCollectionDefault {
	return &NvmeSubsystemModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	NvmeSubsystemModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 72090001 | The NVMe subsystem does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type NvmeSubsystemModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nvme subsystem modify collection default response has a 2xx status code
func (o *NvmeSubsystemModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nvme subsystem modify collection default response has a 3xx status code
func (o *NvmeSubsystemModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nvme subsystem modify collection default response has a 4xx status code
func (o *NvmeSubsystemModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nvme subsystem modify collection default response has a 5xx status code
func (o *NvmeSubsystemModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nvme subsystem modify collection default response a status code equal to that given
func (o *NvmeSubsystemModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nvme subsystem modify collection default response
func (o *NvmeSubsystemModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NvmeSubsystemModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nvme/subsystems][%d] nvme_subsystem_modify_collection default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nvme/subsystems][%d] nvme_subsystem_modify_collection default %s", o._statusCode, payload)
}

func (o *NvmeSubsystemModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NvmeSubsystemModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NvmeSubsystemModifyCollectionBody nvme subsystem modify collection body
swagger:model NvmeSubsystemModifyCollectionBody
*/
type NvmeSubsystemModifyCollectionBody struct {

	// links
	Links *models.NvmeSubsystemInlineLinks `json:"_links,omitempty"`

	// A configurable comment for the NVMe subsystem. Optional in POST and PATCH.
	//
	// Max Length: 255
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// An option that causes the subsystem to be deleted when the last subsystem map associated with it is deleted. Optional in POST and PATCH. This property defaults to _false_ when the subsystem is created.
	//
	DeleteOnUnmap *bool `json:"delete_on_unmap,omitempty"`

	// io queue
	IoQueue *models.NvmeSubsystemInlineIoQueue `json:"io_queue,omitempty"`

	// The name of the NVMe subsystem. Once created, an NVMe subsystem cannot be renamed. Required in POST.
	//
	// Example: subsystem1
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The NVMe hosts configured for access to the NVMe subsystem. Optional in POST.
	//
	NvmeSubsystemInlineHosts []*models.NvmeSubsystemInlineHostsInlineArrayItem `json:"hosts,omitempty"`

	// The NVMe namespaces mapped to the NVMe subsystem.<br/>
	// There is an added computational cost to retrieving property values for `subsystem_maps`. They are not populated for a GET request unless explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	NvmeSubsystemInlineSubsystemMaps []*models.NvmeSubsystemInlineSubsystemMapsInlineArrayItem `json:"subsystem_maps,omitempty"`

	// Vendor-specific identifiers (UUIDs) optionally assigned to an NVMe subsystem when the subsystem is created. The identifiers are used to enable vendor-specific NVMe protocol features. The identifiers are provided by a host application vendor and shared with NetApp prior to a joint product release. Creating an NVMe subsystem with an unknown or non-specific identifier will have no effect on the NVMe subsystem. Refer to the ONTAP SAN Administration Guide for a list of the supported vendor-specific identifiers. After a subsystem is created, the vendor-specific identifiers cannot be changed or removed. Optional in POST.
	//
	NvmeSubsystemInlineVendorUuids []*string `json:"vendor_uuids,omitempty"`

	// nvme subsystem response inline records
	NvmeSubsystemResponseInlineRecords []*models.NvmeSubsystem `json:"records,omitempty"`

	// The host operating system of the NVMe subsystem's hosts. Required in POST.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// replication
	Replication *models.NvmeSubsystemInlineReplication `json:"replication,omitempty"`

	// The serial number of the NVMe subsystem.
	//
	// Example: wCVsgFMiuMhVAAAAAAAB
	// Read Only: true
	// Max Length: 20
	// Min Length: 20
	SerialNumber *string `json:"serial_number,omitempty"`

	// svm
	Svm *models.NvmeSubsystemInlineSvm `json:"svm,omitempty"`

	// The NVMe qualified name (NQN) used to identify the NVMe storage target.
	//
	// Example: nqn.1992-01.example.com:string
	// Read Only: true
	// Max Length: 223
	// Min Length: 1
	TargetNqn *string `json:"target_nqn,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem modify collection body
func (o *NvmeSubsystemModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIoQueue(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNvmeSubsystemInlineHosts(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNvmeSubsystemInlineSubsystemMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNvmeSubsystemResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateReplication(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTargetNqn(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 255); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) validateIoQueue(formats strfmt.Registry) error {
	if swag.IsZero(o.IoQueue) { // not required
		return nil
	}

	if o.IoQueue != nil {
		if err := o.IoQueue.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "io_queue")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 64); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) validateNvmeSubsystemInlineHosts(formats strfmt.Registry) error {
	if swag.IsZero(o.NvmeSubsystemInlineHosts) { // not required
		return nil
	}

	for i := 0; i < len(o.NvmeSubsystemInlineHosts); i++ {
		if swag.IsZero(o.NvmeSubsystemInlineHosts[i]) { // not required
			continue
		}

		if o.NvmeSubsystemInlineHosts[i] != nil {
			if err := o.NvmeSubsystemInlineHosts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) validateNvmeSubsystemInlineSubsystemMaps(formats strfmt.Registry) error {
	if swag.IsZero(o.NvmeSubsystemInlineSubsystemMaps) { // not required
		return nil
	}

	for i := 0; i < len(o.NvmeSubsystemInlineSubsystemMaps); i++ {
		if swag.IsZero(o.NvmeSubsystemInlineSubsystemMaps[i]) { // not required
			continue
		}

		if o.NvmeSubsystemInlineSubsystemMaps[i] != nil {
			if err := o.NvmeSubsystemInlineSubsystemMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "subsystem_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) validateNvmeSubsystemResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NvmeSubsystemResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NvmeSubsystemResponseInlineRecords); i++ {
		if swag.IsZero(o.NvmeSubsystemResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NvmeSubsystemResponseInlineRecords[i] != nil {
			if err := o.NvmeSubsystemResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nvmeSubsystemModifyCollectionBodyTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemModifyCollectionBodyTypeOsTypePropEnum = append(nvmeSubsystemModifyCollectionBodyTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NvmeSubsystemModifyCollectionBody
	// NvmeSubsystemModifyCollectionBody
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// NvmeSubsystemModifyCollectionBodyOsTypeAix captures enum value "aix"
	NvmeSubsystemModifyCollectionBodyOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// NvmeSubsystemModifyCollectionBody
	// NvmeSubsystemModifyCollectionBody
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// NvmeSubsystemModifyCollectionBodyOsTypeLinux captures enum value "linux"
	NvmeSubsystemModifyCollectionBodyOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// NvmeSubsystemModifyCollectionBody
	// NvmeSubsystemModifyCollectionBody
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// NvmeSubsystemModifyCollectionBodyOsTypeVmware captures enum value "vmware"
	NvmeSubsystemModifyCollectionBodyOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// NvmeSubsystemModifyCollectionBody
	// NvmeSubsystemModifyCollectionBody
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// NvmeSubsystemModifyCollectionBodyOsTypeWindows captures enum value "windows"
	NvmeSubsystemModifyCollectionBodyOsTypeWindows string = "windows"
)

// prop value enum
func (o *NvmeSubsystemModifyCollectionBody) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemModifyCollectionBodyTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("info"+"."+"os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) validateReplication(formats strfmt.Registry) error {
	if swag.IsZero(o.Replication) { // not required
		return nil
	}

	if o.Replication != nil {
		if err := o.Replication.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(o.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"serial_number", "body", *o.SerialNumber, 20); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"serial_number", "body", *o.SerialNumber, 20); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) validateTargetNqn(formats strfmt.Registry) error {
	if swag.IsZero(o.TargetNqn) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"target_nqn", "body", *o.TargetNqn, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"target_nqn", "body", *o.TargetNqn, 223); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem modify collection body based on the context it is used
func (o *NvmeSubsystemModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIoQueue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNvmeSubsystemInlineHosts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNvmeSubsystemInlineSubsystemMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNvmeSubsystemResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTargetNqn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) contextValidateIoQueue(ctx context.Context, formats strfmt.Registry) error {

	if o.IoQueue != nil {
		if err := o.IoQueue.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "io_queue")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) contextValidateNvmeSubsystemInlineHosts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NvmeSubsystemInlineHosts); i++ {

		if o.NvmeSubsystemInlineHosts[i] != nil {
			if err := o.NvmeSubsystemInlineHosts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) contextValidateNvmeSubsystemInlineSubsystemMaps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"subsystem_maps", "body", []*models.NvmeSubsystemInlineSubsystemMapsInlineArrayItem(o.NvmeSubsystemInlineSubsystemMaps)); err != nil {
		return err
	}

	for i := 0; i < len(o.NvmeSubsystemInlineSubsystemMaps); i++ {

		if o.NvmeSubsystemInlineSubsystemMaps[i] != nil {
			if err := o.NvmeSubsystemInlineSubsystemMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "subsystem_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) contextValidateNvmeSubsystemResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NvmeSubsystemResponseInlineRecords); i++ {

		if o.NvmeSubsystemResponseInlineRecords[i] != nil {
			if err := o.NvmeSubsystemResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) contextValidateReplication(ctx context.Context, formats strfmt.Registry) error {

	if o.Replication != nil {
		if err := o.Replication.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) contextValidateTargetNqn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"target_nqn", "body", o.TargetNqn); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0 A reference to an SVM peer relationship.
swagger:model NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0
*/
type NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0 struct {

	// links
	Links *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem modify collection params body hosts items0 proximity peer svms items0
func (o *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem modify collection params body hosts items0 proximity peer svms items0 based on the context it is used
func (o *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0Links nvme subsystem modify collection params body hosts items0 proximity peer svms items0 links
swagger:model NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0Links
*/
type NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem modify collection params body hosts items0 proximity peer svms items0 links
func (o *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem modify collection params body hosts items0 proximity peer svms items0 links based on the context it is used
func (o *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineLinks nvme subsystem inline links
swagger:model nvme_subsystem_inline__links
*/
type NvmeSubsystemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem inline links
func (o *NvmeSubsystemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline links based on the context it is used
func (o *NvmeSubsystemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineHostsInlineArrayItem nvme subsystem inline hosts inline array item
swagger:model nvme_subsystem_inline_hosts_inline_array_item
*/
type NvmeSubsystemInlineHostsInlineArrayItem struct {

	// links
	Links *models.NvmeSubsystemInlineHostsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// dh hmac chap
	DhHmacChap *models.NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap `json:"dh_hmac_chap,omitempty"`

	// The NVMe qualified name (NQN) used to identify the NVMe storage target.
	//
	// Example: nqn.1992-01.example.com:string
	Nqn *string `json:"nqn,omitempty"`

	// The host priority setting allocates appropriate NVMe I/O queues (count and depth) for the host to submit I/O commands. Absence of this property in GET implies user configured values of I/O queue count and I/O queue depth are being used.
	//
	// Enum: ["regular","high"]
	Priority *string `json:"priority,omitempty"`

	// proximity
	Proximity *models.NvmeSubsystemInlineHostsInlineArrayItemInlineProximity `json:"proximity,omitempty"`

	// tls
	TLS *models.NvmeSubsystemInlineHostsInlineArrayItemInlineTLS `json:"tls,omitempty"`
}

// Validate validates this nvme subsystem inline hosts inline array item
func (o *NvmeSubsystemInlineHostsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDhHmacChap(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePriority(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTLS(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItem) validateDhHmacChap(formats strfmt.Registry) error {
	if swag.IsZero(o.DhHmacChap) { // not required
		return nil
	}

	if o.DhHmacChap != nil {
		if err := o.DhHmacChap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

var nvmeSubsystemInlineHostsInlineArrayItemTypePriorityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["regular","high"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemInlineHostsInlineArrayItemTypePriorityPropEnum = append(nvmeSubsystemInlineHostsInlineArrayItemTypePriorityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item
	// NvmeSubsystemInlineHostsInlineArrayItem
	// priority
	// Priority
	// regular
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemPriorityRegular captures enum value "regular"
	NvmeSubsystemInlineHostsInlineArrayItemPriorityRegular string = "regular"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item
	// NvmeSubsystemInlineHostsInlineArrayItem
	// priority
	// Priority
	// high
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemPriorityHigh captures enum value "high"
	NvmeSubsystemInlineHostsInlineArrayItemPriorityHigh string = "high"
)

// prop value enum
func (o *NvmeSubsystemInlineHostsInlineArrayItem) validatePriorityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemInlineHostsInlineArrayItemTypePriorityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItem) validatePriority(formats strfmt.Registry) error {
	if swag.IsZero(o.Priority) { // not required
		return nil
	}

	// value enum
	if err := o.validatePriorityEnum("priority", "body", *o.Priority); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItem) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(o.Proximity) { // not required
		return nil
	}

	if o.Proximity != nil {
		if err := o.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItem) validateTLS(formats strfmt.Registry) error {
	if swag.IsZero(o.TLS) { // not required
		return nil
	}

	if o.TLS != nil {
		if err := o.TLS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline hosts inline array item based on the context it is used
func (o *NvmeSubsystemInlineHostsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDhHmacChap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTLS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItem) contextValidateDhHmacChap(ctx context.Context, formats strfmt.Registry) error {

	if o.DhHmacChap != nil {
		if err := o.DhHmacChap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItem) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if o.Proximity != nil {
		if err := o.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItem) contextValidateTLS(ctx context.Context, formats strfmt.Registry) error {

	if o.TLS != nil {
		if err := o.TLS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineHostsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineHostsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineHostsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineHostsInlineArrayItemInlineLinks nvme subsystem inline hosts inline array item inline links
swagger:model nvme_subsystem_inline_hosts_inline_array_item_inline__links
*/
type NvmeSubsystemInlineHostsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem inline hosts inline array item inline links
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline hosts inline array item inline links based on the context it is used
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineHostsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap A container for the configuration of NVMe in-band authentication using the DH-HMAC-CHAP protocol for a host.
//
swagger:model nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
*/
type NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap struct {

	// The controller secret for NVMe in-band authentication. The value of this property is used by the NVMe host to authenticate the NVMe controller while establishing a connection. If unset, the controller is not authenticated. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.<br/>
	// This property is write-only. The `mode` property can be used to identify if a controller secret has been set for the host, but the controller secret value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: DHHC-1:00:ia6zGodOr4SEG0Zzaw398rpY0wqipUWj4jWjUh4HWUz6aQ2n:
	ControllerSecretKey *string `json:"controller_secret_key,omitempty"`

	// The Diffie-Hellman group size for NVMe in-band authentication. When property `host_secret_key` is provided, this property defaults to `2048_bit`. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.
	//
	// Enum: ["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]
	GroupSize *string `json:"group_size,omitempty"`

	// The hash function for NVMe in-band authentication. When property `host_secret_key` is provided, this property defaults to `sha_256`. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.
	//
	// Enum: ["sha_256","sha_512"]
	HashFunction *string `json:"hash_function,omitempty"`

	// The host secret for NVMe in-band authentication. The value of this property is used by the NVMe controller to authenticate the NVMe host while establishing a connection. If unset, no authentication is performed by the host or controller. This property must be supplied if any other NVMe in-band authentication properties are supplied. Optional in POST.<br/>
	// This property is write-only. The `mode` property can be used to identify if a host secret has been set for the host, but the host secret value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: DHHC-1:00:ia6zGodOr4SEG0Zzaw398rpY0wqipUWj4jWjUh4HWUz6aQ2n:
	HostSecretKey *string `json:"host_secret_key,omitempty"`

	// The expected NVMe in-band authentication mode for the host. This property is an indication of which secrets are configured for the host. When set to:
	// - none: The host has neither the host nor controller secret configured, and no authentication is performed.
	// - unidirectional: The host has a host secret configured. The controller will authenticate the host.
	// - bidirectional: The host has both a host and controller secret configured. The controller will authenticate the host and the host will authenticate the controller.
	//
	// Example: bidirectional
	// Read Only: true
	// Enum: ["none","unidirectional","bidirectional"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this nvme subsystem inline hosts inline array item inline dh hmac chap
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGroupSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHashFunction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum = append(nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// none
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNone captures enum value "none"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 2048_bit
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr2048Bit captures enum value "2048_bit"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr2048Bit string = "2048_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 3072_bit
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr3072Bit captures enum value "3072_bit"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr3072Bit string = "3072_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 4096_bit
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr4096Bit captures enum value "4096_bit"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr4096Bit string = "4096_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 6144_bit
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr6144Bit captures enum value "6144_bit"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr6144Bit string = "6144_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 8192_bit
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr8192Bit captures enum value "8192_bit"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr8192Bit string = "8192_bit"
)

// prop value enum
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) validateGroupSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) validateGroupSize(formats strfmt.Registry) error {
	if swag.IsZero(o.GroupSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateGroupSizeEnum("dh_hmac_chap"+"."+"group_size", "body", *o.GroupSize); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sha_256","sha_512"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum = append(nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_256
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapHashFunctionSha256 captures enum value "sha_256"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapHashFunctionSha256 string = "sha_256"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_512
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapHashFunctionSha512 captures enum value "sha_512"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapHashFunctionSha512 string = "sha_512"
)

// prop value enum
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) validateHashFunctionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) validateHashFunction(formats strfmt.Registry) error {
	if swag.IsZero(o.HashFunction) { // not required
		return nil
	}

	// value enum
	if err := o.validateHashFunctionEnum("dh_hmac_chap"+"."+"hash_function", "body", *o.HashFunction); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","unidirectional","bidirectional"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeModePropEnum = append(nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// mode
	// Mode
	// none
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapModeNone captures enum value "none"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapModeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// mode
	// Mode
	// unidirectional
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapModeUnidirectional captures enum value "unidirectional"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapModeUnidirectional string = "unidirectional"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// mode
	// Mode
	// bidirectional
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapModeBidirectional captures enum value "bidirectional"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapModeBidirectional string = "bidirectional"
)

// prop value enum
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(o.Mode) { // not required
		return nil
	}

	// value enum
	if err := o.validateModeEnum("dh_hmac_chap"+"."+"mode", "body", *o.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline hosts inline array item inline dh hmac chap based on the context it is used
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) contextValidateMode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "dh_hmac_chap"+"."+"mode", "body", o.Mode); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineHostsInlineArrayItemInlineProximity Properties that define the SVMs to which the host is proximal. This information is used to properly report active optimized and active non-optimized network paths using an NVMe controller. If no configuration has been specified for the host, the sub-object is not present in GET requests.<br/>
// These properties apply to all instances of the host in the NVMe subsystem in the SVM and its peers.
//
swagger:model nvme_subsystem_inline_hosts_inline_array_item_inline_proximity
*/
type NvmeSubsystemInlineHostsInlineArrayItemInlineProximity struct {

	// A boolean that indicates if the host is proximal to the SVM for which it is configured.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the host is proximal.
	//
	PeerSvms []*NvmeSubsystemModifyCollectionParamsBodyHostsItems0ProximityPeerSvmsItems0 `json:"peer_svms"`
}

// Validate validates this nvme subsystem inline hosts inline array item inline proximity
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(o.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(o.PeerSvms); i++ {
		if swag.IsZero(o.PeerSvms[i]) { // not required
			continue
		}

		if o.PeerSvms[i] != nil {
			if err := o.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this nvme subsystem inline hosts inline array item inline proximity based on the context it is used
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.PeerSvms); i++ {

		if o.PeerSvms[i] != nil {
			if err := o.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineHostsInlineArrayItemInlineProximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineHostsInlineArrayItemInlineTLS A container for the configuration for NVMe/TCP-TLS transport session for the host.
//
swagger:model nvme_subsystem_inline_hosts_inline_array_item_inline_tls
*/
type NvmeSubsystemInlineHostsInlineArrayItemInlineTLS struct {

	// A user supplied pre-shared key (PSK) value in PSK Interchange Format. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree. This property is only allowed when `key_type` is `configured`. If `configured_psk` is supplied and `key_type` is unset, `key_type` defaults to `configured`.</br>
	// This property is write-only. The `key_type` property can be used to identify if a configured PSK has been set for the host, but the PSK value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: NVMeTLSkey-1:01:VRLbtnN9AQb2WXW3c9+wEf/DRLz0QuLdbYvEhwtdWwNf9LrZ:
	ConfiguredPsk *string `json:"configured_psk,omitempty"`

	// The method by which the TLS pre-shared key (PSK) is configured for the host. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree.</br>
	// Possible values:
	// - `none` - TLS is not configured for the host connection. No value is allowed for property `configured_psk`.
	// - `configured` - A user supplied PSK is configured for the NVMe/TCP-TLS transport connection between the host and the NVMe subsystem. A valid value for property `configured_psk` is required.
	// </br>
	// This property defaults to `none` unless a value is supplied for `configured_psk` in which case it defaults to `configured`.
	//
	// Example: configured
	// Enum: ["none","configured"]
	KeyType *string `json:"key_type,omitempty"`
}

// Validate validates this nvme subsystem inline hosts inline array item inline tls
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateKeyType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemInlineHostsInlineArrayItemInlineTlsTypeKeyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","configured"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemInlineHostsInlineArrayItemInlineTlsTypeKeyTypePropEnum = append(nvmeSubsystemInlineHostsInlineArrayItemInlineTlsTypeKeyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_tls
	// NvmeSubsystemInlineHostsInlineArrayItemInlineTLS
	// key_type
	// KeyType
	// none
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineTLSKeyTypeNone captures enum value "none"
	NvmeSubsystemInlineHostsInlineArrayItemInlineTLSKeyTypeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_tls
	// NvmeSubsystemInlineHostsInlineArrayItemInlineTLS
	// key_type
	// KeyType
	// configured
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineTLSKeyTypeConfigured captures enum value "configured"
	NvmeSubsystemInlineHostsInlineArrayItemInlineTLSKeyTypeConfigured string = "configured"
)

// prop value enum
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS) validateKeyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemInlineHostsInlineArrayItemInlineTlsTypeKeyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS) validateKeyType(formats strfmt.Registry) error {
	if swag.IsZero(o.KeyType) { // not required
		return nil
	}

	// value enum
	if err := o.validateKeyTypeEnum("tls"+"."+"key_type", "body", *o.KeyType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nvme subsystem inline hosts inline array item inline tls based on context it is used
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineHostsInlineArrayItemInlineTLS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineIoQueue The properties of the submission queue used to submit I/O commands for execution by the NVMe controller.
//
swagger:model nvme_subsystem_inline_io_queue
*/
type NvmeSubsystemInlineIoQueue struct {

	// default
	Default *models.NvmeSubsystemInlineIoQueueInlineDefault `json:"default,omitempty"`
}

// Validate validates this nvme subsystem inline io queue
func (o *NvmeSubsystemInlineIoQueue) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDefault(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineIoQueue) validateDefault(formats strfmt.Registry) error {
	if swag.IsZero(o.Default) { // not required
		return nil
	}

	if o.Default != nil {
		if err := o.Default.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "io_queue" + "." + "default")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline io queue based on the context it is used
func (o *NvmeSubsystemInlineIoQueue) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDefault(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineIoQueue) contextValidateDefault(ctx context.Context, formats strfmt.Registry) error {

	if o.Default != nil {
		if err := o.Default.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "io_queue" + "." + "default")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineIoQueue) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineIoQueue) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineIoQueue
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineIoQueueInlineDefault Important: Support for this field will be removed in a future release.
// The default I/O queue parameters inherited by NVMe hosts in the NVMe subsystem.
//
swagger:model nvme_subsystem_inline_io_queue_inline_default
*/
type NvmeSubsystemInlineIoQueueInlineDefault struct {

	// The number of host I/O queue pairs.
	//
	// Example: 4
	// Read Only: true
	// Maximum: 15
	// Minimum: 1
	Count *int64 `json:"count,omitempty"`

	// The host I/O queue depth.
	//
	// Example: 16
	// Read Only: true
	// Maximum: 128
	// Minimum: 16
	Depth *int64 `json:"depth,omitempty"`
}

// Validate validates this nvme subsystem inline io queue inline default
func (o *NvmeSubsystemInlineIoQueueInlineDefault) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCount(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDepth(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineIoQueueInlineDefault) validateCount(formats strfmt.Registry) error {
	if swag.IsZero(o.Count) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"io_queue"+"."+"default"+"."+"count", "body", *o.Count, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"io_queue"+"."+"default"+"."+"count", "body", *o.Count, 15, false); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemInlineIoQueueInlineDefault) validateDepth(formats strfmt.Registry) error {
	if swag.IsZero(o.Depth) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"io_queue"+"."+"default"+"."+"depth", "body", *o.Depth, 16, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"io_queue"+"."+"default"+"."+"depth", "body", *o.Depth, 128, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline io queue inline default based on the context it is used
func (o *NvmeSubsystemInlineIoQueueInlineDefault) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDepth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineIoQueueInlineDefault) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"io_queue"+"."+"default"+"."+"count", "body", o.Count); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemInlineIoQueueInlineDefault) contextValidateDepth(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"io_queue"+"."+"default"+"."+"depth", "body", o.Depth); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineIoQueueInlineDefault) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineIoQueueInlineDefault) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineIoQueueInlineDefault
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineReplication Properties related to subsystem replication.
//
swagger:model nvme_subsystem_inline_replication
*/
type NvmeSubsystemInlineReplication struct {

	// error
	Error *models.NvmeSubsystemInlineReplicationInlineError `json:"error,omitempty"`

	// peer subsystem
	PeerSubsystem *models.NvmeSubsystemInlineReplicationInlinePeerSubsystem `json:"peer_subsystem,omitempty"`

	// peer svm
	PeerSvm *models.NvmeSubsystemInlineReplicationInlinePeerSvm `json:"peer_svm,omitempty"`

	// The state of the replication queue associated with this subsystem. If this subsystem is not in the replication queue, the state is reported as _ok_. If this subsystem is in the replication queue, but no errors have been encountered, the state is reported as _replicating_. If this subsystem is in the replication queue and the queue is blocked by an error, the state is reported as _error_. When in the _error_ state, additional context is provided by the `replication.error` property.
	//
	// Read Only: true
	// Enum: ["ok","replicating","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this nvme subsystem inline replication
func (o *NvmeSubsystemInlineReplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePeerSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePeerSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplication) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineReplication) validatePeerSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(o.PeerSubsystem) { // not required
		return nil
	}

	if o.PeerSubsystem != nil {
		if err := o.PeerSubsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_subsystem")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineReplication) validatePeerSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.PeerSvm) { // not required
		return nil
	}

	if o.PeerSvm != nil {
		if err := o.PeerSvm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_svm")
			}
			return err
		}
	}

	return nil
}

var nvmeSubsystemInlineReplicationTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","replicating","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemInlineReplicationTypeStatePropEnum = append(nvmeSubsystemInlineReplicationTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_replication
	// NvmeSubsystemInlineReplication
	// state
	// State
	// ok
	// END DEBUGGING
	// NvmeSubsystemInlineReplicationStateOk captures enum value "ok"
	NvmeSubsystemInlineReplicationStateOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_replication
	// NvmeSubsystemInlineReplication
	// state
	// State
	// replicating
	// END DEBUGGING
	// NvmeSubsystemInlineReplicationStateReplicating captures enum value "replicating"
	NvmeSubsystemInlineReplicationStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_replication
	// NvmeSubsystemInlineReplication
	// state
	// State
	// error
	// END DEBUGGING
	// NvmeSubsystemInlineReplicationStateError captures enum value "error"
	NvmeSubsystemInlineReplicationStateError string = "error"
)

// prop value enum
func (o *NvmeSubsystemInlineReplication) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemInlineReplicationTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *NvmeSubsystemInlineReplication) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"replication"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline replication based on the context it is used
func (o *NvmeSubsystemInlineReplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePeerSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePeerSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplication) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineReplication) contextValidatePeerSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if o.PeerSubsystem != nil {
		if err := o.PeerSubsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_subsystem")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineReplication) contextValidatePeerSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.PeerSvm != nil {
		if err := o.PeerSvm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_svm")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineReplication) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplication) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplication) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineReplicationInlineError Information about asynchronous errors encountered while replicating this subsystem. Subsystems within a peering relationship are replicated in the same stream, so the error reported here might be related to this subsystem or a prior replicated subsystem that is now blocking the replication of this subsystem. Both the error information and the subsystem encountering the error are reported. If the error is configuration related, it can be corrected on the referenced subsystem. The replication is retried using exponential backoff up to a maximum of one retry every 5 minutes. Every operation on the same stream triggers an immediate retry and restarts the exponential backoff starting with a 1 second delay. If the error is system related, the retries should correct the error when the system enters a healthy state.
//
swagger:model nvme_subsystem_inline_replication_inline_error
*/
type NvmeSubsystemInlineReplicationInlineError struct {

	// subsystem
	Subsystem *models.NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem `json:"subsystem,omitempty"`

	// summary
	Summary *models.NvmeSubsystemInlineReplicationInlineErrorInlineSummary `json:"summary,omitempty"`
}

// Validate validates this nvme subsystem inline replication inline error
func (o *NvmeSubsystemInlineReplicationInlineError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplicationInlineError) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(o.Subsystem) { // not required
		return nil
	}

	if o.Subsystem != nil {
		if err := o.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "error" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineReplicationInlineError) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(o.Summary) { // not required
		return nil
	}

	if o.Summary != nil {
		if err := o.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "error" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline replication inline error based on the context it is used
func (o *NvmeSubsystemInlineReplicationInlineError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplicationInlineError) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if o.Subsystem != nil {
		if err := o.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "error" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineReplicationInlineError) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if o.Summary != nil {
		if err := o.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "error" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplicationInlineError) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplicationInlineError) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplicationInlineError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem An NVMe subsystem maintains configuration state and NVMe namespace access control for a set of NVMe-connected hosts.
//
swagger:model nvme_subsystem_inline_replication_inline_error_inline_subsystem
*/
type NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem struct {

	// Indicates whether the reported subsystem is on the local SVM or the peer SVM. When deleting a replicated subsystem, the local copy is deleted first and then the peer copy is deleted. If the error is encountered between these two operations and only the peer subsystem remains, the peer subsystem is reported and the problem might need to be corrected on the peer cluster.
	//
	// Read Only: true
	LocalSvm *bool `json:"local_svm,omitempty"`

	// The name of the NVMe subsystem.
	//
	// Example: subsystem1
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem inline replication inline error inline subsystem
func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"replication"+"."+"error"+"."+"subsystem"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"replication"+"."+"error"+"."+"subsystem"+"."+"name", "body", *o.Name, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline replication inline error inline subsystem based on the context it is used
func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocalSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem) contextValidateLocalSvm(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication"+"."+"error"+"."+"subsystem"+"."+"local_svm", "body", o.LocalSvm); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineReplicationInlineErrorInlineSummary A user friendly message describing the error.
//
swagger:model nvme_subsystem_inline_replication_inline_error_inline_summary
*/
type NvmeSubsystemInlineReplicationInlineErrorInlineSummary struct {

	// Message arguments
	// Read Only: true
	Arguments []*models.ErrorArguments `json:"arguments,omitempty"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this nvme subsystem inline replication inline error inline summary
func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(o.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(o.Arguments); i++ {
		if swag.IsZero(o.Arguments[i]) { // not required
			continue
		}

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "replication" + "." + "error" + "." + "summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this nvme subsystem inline replication inline error inline summary based on the context it is used
func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication"+"."+"error"+"."+"summary"+"."+"arguments", "body", []*models.ErrorArguments(o.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(o.Arguments); i++ {

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "replication" + "." + "error" + "." + "summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication"+"."+"error"+"."+"summary"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication"+"."+"error"+"."+"summary"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplicationInlineErrorInlineSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineReplicationInlinePeerSubsystem nvme subsystem inline replication inline peer subsystem
swagger:model nvme_subsystem_inline_replication_inline_peer_subsystem
*/
type NvmeSubsystemInlineReplicationInlinePeerSubsystem struct {

	// The unique identifier of the peer subsystem.
	//
	// Example: 1cd8a443-86d2-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem inline replication inline peer subsystem
func (o *NvmeSubsystemInlineReplicationInlinePeerSubsystem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme subsystem inline replication inline peer subsystem based on the context it is used
func (o *NvmeSubsystemInlineReplicationInlinePeerSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplicationInlinePeerSubsystem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication"+"."+"peer_subsystem"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplicationInlinePeerSubsystem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplicationInlinePeerSubsystem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplicationInlinePeerSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineReplicationInlinePeerSvm The peered SVM to which the subsystem is replicated. Subsystem are are automatically replicated when mapped to a namespace in a SnapMirror active sync relationship. When a subsystem is mapped to a namespace in an active sync relationship, the subsystem is restricted to only be mapped to namespaces that are members of the same consistency group.
//
swagger:model nvme_subsystem_inline_replication_inline_peer_svm
*/
type NvmeSubsystemInlineReplicationInlinePeerSvm struct {

	// links
	Links *models.NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem inline replication inline peer svm
func (o *NvmeSubsystemInlineReplicationInlinePeerSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplicationInlinePeerSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline replication inline peer svm based on the context it is used
func (o *NvmeSubsystemInlineReplicationInlinePeerSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplicationInlinePeerSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplicationInlinePeerSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplicationInlinePeerSvm) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplicationInlinePeerSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks nvme subsystem inline replication inline peer svm inline links
swagger:model nvme_subsystem_inline_replication_inline_peer_svm_inline__links
*/
type NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem inline replication inline peer svm inline links
func (o *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline replication inline peer svm inline links based on the context it is used
func (o *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineSubsystemMapsInlineArrayItem An NVMe namespace mapped to the NVMe subsystem.
//
swagger:model nvme_subsystem_inline_subsystem_maps_inline_array_item
*/
type NvmeSubsystemInlineSubsystemMapsInlineArrayItem struct {

	// links
	Links *models.NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPIP is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// namespace
	Namespace *models.NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace `json:"namespace,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`
}

// Validate validates this nvme subsystem inline subsystem maps inline array item
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNamespace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) validateNamespace(formats strfmt.Registry) error {
	if swag.IsZero(o.Namespace) { // not required
		return nil
	}

	if o.Namespace != nil {
		if err := o.Namespace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline subsystem maps inline array item based on the context it is used
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNamespace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anagrpid", "body", o.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) contextValidateNamespace(ctx context.Context, formats strfmt.Registry) error {

	if o.Namespace != nil {
		if err := o.Namespace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nsid", "body", o.Nsid); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineSubsystemMapsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks nvme subsystem inline subsystem maps inline array item inline links
swagger:model nvme_subsystem_inline_subsystem_maps_inline_array_item_inline__links
*/
type NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem inline subsystem maps inline array item inline links
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline subsystem maps inline array item inline links based on the context it is used
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace An NVMe namespace mapped to the NVMe subsystem.
//
swagger:model nvme_subsystem_inline_subsystem_maps_inline_array_item_inline_namespace
*/
type NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace struct {

	// links
	Links *models.NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks `json:"_links,omitempty"`

	// The name of the NVMe namespace.
	//
	// Example: /vol/vol1/namespace1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem inline subsystem maps inline array item inline namespace
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline subsystem maps inline array item inline namespace based on the context it is used
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "namespace"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "namespace"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks nvme subsystem inline subsystem maps inline array item inline namespace inline links
swagger:model nvme_subsystem_inline_subsystem_maps_inline_array_item_inline_namespace_inline__links
*/
type NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem inline subsystem maps inline array item inline namespace inline links
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline subsystem maps inline array item inline namespace inline links based on the context it is used
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model nvme_subsystem_inline_svm
*/
type NvmeSubsystemInlineSvm struct {

	// links
	Links *models.NvmeSubsystemInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem inline svm
func (o *NvmeSubsystemInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline svm based on the context it is used
func (o *NvmeSubsystemInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineSvm) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NvmeSubsystemInlineSvmInlineLinks nvme subsystem inline svm inline links
swagger:model nvme_subsystem_inline_svm_inline__links
*/
type NvmeSubsystemInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem inline svm inline links
func (o *NvmeSubsystemInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline svm inline links based on the context it is used
func (o *NvmeSubsystemInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NvmeSubsystemInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NvmeSubsystemInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NvmeSubsystemInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
