// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPerformanceNamespaceMetricGetParams creates a new PerformanceNamespaceMetricGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPerformanceNamespaceMetricGetParams() *PerformanceNamespaceMetricGetParams {
	return &PerformanceNamespaceMetricGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPerformanceNamespaceMetricGetParamsWithTimeout creates a new PerformanceNamespaceMetricGetParams object
// with the ability to set a timeout on a request.
func NewPerformanceNamespaceMetricGetParamsWithTimeout(timeout time.Duration) *PerformanceNamespaceMetricGetParams {
	return &PerformanceNamespaceMetricGetParams{
		timeout: timeout,
	}
}

// NewPerformanceNamespaceMetricGetParamsWithContext creates a new PerformanceNamespaceMetricGetParams object
// with the ability to set a context for a request.
func NewPerformanceNamespaceMetricGetParamsWithContext(ctx context.Context) *PerformanceNamespaceMetricGetParams {
	return &PerformanceNamespaceMetricGetParams{
		Context: ctx,
	}
}

// NewPerformanceNamespaceMetricGetParamsWithHTTPClient creates a new PerformanceNamespaceMetricGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPerformanceNamespaceMetricGetParamsWithHTTPClient(client *http.Client) *PerformanceNamespaceMetricGetParams {
	return &PerformanceNamespaceMetricGetParams{
		HTTPClient: client,
	}
}

/*
PerformanceNamespaceMetricGetParams contains all the parameters to send to the API endpoint

	for the performance namespace metric get operation.

	Typically these are written to a http.Request.
*/
type PerformanceNamespaceMetricGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* NvmeNamespaceUUID.

	   The unique identifier of the NVMe namespace.

	*/
	NvmeNamespaceUUID string

	/* Timestamp.

	   The timestamp of the performance data.


	   Format: date-time
	*/
	Timestamp strfmt.DateTime

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the performance namespace metric get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformanceNamespaceMetricGetParams) WithDefaults() *PerformanceNamespaceMetricGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the performance namespace metric get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformanceNamespaceMetricGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the performance namespace metric get params
func (o *PerformanceNamespaceMetricGetParams) WithTimeout(timeout time.Duration) *PerformanceNamespaceMetricGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the performance namespace metric get params
func (o *PerformanceNamespaceMetricGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the performance namespace metric get params
func (o *PerformanceNamespaceMetricGetParams) WithContext(ctx context.Context) *PerformanceNamespaceMetricGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the performance namespace metric get params
func (o *PerformanceNamespaceMetricGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the performance namespace metric get params
func (o *PerformanceNamespaceMetricGetParams) WithHTTPClient(client *http.Client) *PerformanceNamespaceMetricGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the performance namespace metric get params
func (o *PerformanceNamespaceMetricGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the performance namespace metric get params
func (o *PerformanceNamespaceMetricGetParams) WithFields(fields []string) *PerformanceNamespaceMetricGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the performance namespace metric get params
func (o *PerformanceNamespaceMetricGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithNvmeNamespaceUUID adds the nvmeNamespaceUUID to the performance namespace metric get params
func (o *PerformanceNamespaceMetricGetParams) WithNvmeNamespaceUUID(nvmeNamespaceUUID string) *PerformanceNamespaceMetricGetParams {
	o.SetNvmeNamespaceUUID(nvmeNamespaceUUID)
	return o
}

// SetNvmeNamespaceUUID adds the nvmeNamespaceUuid to the performance namespace metric get params
func (o *PerformanceNamespaceMetricGetParams) SetNvmeNamespaceUUID(nvmeNamespaceUUID string) {
	o.NvmeNamespaceUUID = nvmeNamespaceUUID
}

// WithTimestamp adds the timestamp to the performance namespace metric get params
func (o *PerformanceNamespaceMetricGetParams) WithTimestamp(timestamp strfmt.DateTime) *PerformanceNamespaceMetricGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the performance namespace metric get params
func (o *PerformanceNamespaceMetricGetParams) SetTimestamp(timestamp strfmt.DateTime) {
	o.Timestamp = timestamp
}

// WriteToRequest writes these params to a swagger request
func (o *PerformanceNamespaceMetricGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param nvme_namespace.uuid
	if err := r.SetPathParam("nvme_namespace.uuid", o.NvmeNamespaceUUID); err != nil {
		return err
	}

	// path param timestamp
	if err := r.SetPathParam("timestamp", o.Timestamp.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPerformanceNamespaceMetricGet binds the parameter fields
func (o *PerformanceNamespaceMetricGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
