// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPerformanceNvmeMetricCollectionGetParams creates a new PerformanceNvmeMetricCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPerformanceNvmeMetricCollectionGetParams() *PerformanceNvmeMetricCollectionGetParams {
	return &PerformanceNvmeMetricCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPerformanceNvmeMetricCollectionGetParamsWithTimeout creates a new PerformanceNvmeMetricCollectionGetParams object
// with the ability to set a timeout on a request.
func NewPerformanceNvmeMetricCollectionGetParamsWithTimeout(timeout time.Duration) *PerformanceNvmeMetricCollectionGetParams {
	return &PerformanceNvmeMetricCollectionGetParams{
		timeout: timeout,
	}
}

// NewPerformanceNvmeMetricCollectionGetParamsWithContext creates a new PerformanceNvmeMetricCollectionGetParams object
// with the ability to set a context for a request.
func NewPerformanceNvmeMetricCollectionGetParamsWithContext(ctx context.Context) *PerformanceNvmeMetricCollectionGetParams {
	return &PerformanceNvmeMetricCollectionGetParams{
		Context: ctx,
	}
}

// NewPerformanceNvmeMetricCollectionGetParamsWithHTTPClient creates a new PerformanceNvmeMetricCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPerformanceNvmeMetricCollectionGetParamsWithHTTPClient(client *http.Client) *PerformanceNvmeMetricCollectionGetParams {
	return &PerformanceNvmeMetricCollectionGetParams{
		HTTPClient: client,
	}
}

/*
PerformanceNvmeMetricCollectionGetParams contains all the parameters to send to the API endpoint

	for the performance nvme metric collection get operation.

	Typically these are written to a http.Request.
*/
type PerformanceNvmeMetricCollectionGetParams struct {

	/* Duration.

	   Filter by duration
	*/
	Duration *string

	/* FcDuration.

	   Filter by fc.duration
	*/
	FcDuration *string

	/* FcIopsOther.

	   Filter by fc.iops.other
	*/
	FcIopsOther *int64

	/* FcIopsRead.

	   Filter by fc.iops.read
	*/
	FcIopsRead *int64

	/* FcIopsTotal.

	   Filter by fc.iops.total
	*/
	FcIopsTotal *int64

	/* FcIopsWrite.

	   Filter by fc.iops.write
	*/
	FcIopsWrite *int64

	/* FcLatencyOther.

	   Filter by fc.latency.other
	*/
	FcLatencyOther *int64

	/* FcLatencyRead.

	   Filter by fc.latency.read
	*/
	FcLatencyRead *int64

	/* FcLatencyTotal.

	   Filter by fc.latency.total
	*/
	FcLatencyTotal *int64

	/* FcLatencyWrite.

	   Filter by fc.latency.write
	*/
	FcLatencyWrite *int64

	/* FcStatus.

	   Filter by fc.status
	*/
	FcStatus *string

	/* FcThroughputRead.

	   Filter by fc.throughput.read
	*/
	FcThroughputRead *int64

	/* FcThroughputTotal.

	   Filter by fc.throughput.total
	*/
	FcThroughputTotal *int64

	/* FcThroughputWrite.

	   Filter by fc.throughput.write
	*/
	FcThroughputWrite *int64

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Interval.

	     The time range for the data. Examples can be 1h, 1d, 1m, 1w, 1y.
	The period for each time range is as follows:
	* 1h: Metrics over the most recent hour sampled over 15 seconds.
	* 1d: Metrics over the most recent day sampled over 5 minutes.
	* 1w: Metrics over the most recent week sampled over 30 minutes.
	* 1m: Metrics over the most recent month sampled over 2 hours.
	* 1y: Metrics over the most recent year sampled over a day.


	     Default: "1h"
	*/
	Interval *string

	/* IopsOther.

	   Filter by iops.other
	*/
	IopsOther *int64

	/* IopsRead.

	   Filter by iops.read
	*/
	IopsRead *int64

	/* IopsTotal.

	   Filter by iops.total
	*/
	IopsTotal *int64

	/* IopsWrite.

	   Filter by iops.write
	*/
	IopsWrite *int64

	/* LatencyOther.

	   Filter by latency.other
	*/
	LatencyOther *int64

	/* LatencyRead.

	   Filter by latency.read
	*/
	LatencyRead *int64

	/* LatencyTotal.

	   Filter by latency.total
	*/
	LatencyTotal *int64

	/* LatencyWrite.

	   Filter by latency.write
	*/
	LatencyWrite *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Status.

	   Filter by status
	*/
	Status *string

	/* SvmUUID.

	   The unique identifier of the SVM.

	*/
	SvmUUID string

	/* TCPDuration.

	   Filter by tcp.duration
	*/
	TCPDuration *string

	/* TCPIopsOther.

	   Filter by tcp.iops.other
	*/
	TCPIopsOther *int64

	/* TCPIopsRead.

	   Filter by tcp.iops.read
	*/
	TCPIopsRead *int64

	/* TCPIopsTotal.

	   Filter by tcp.iops.total
	*/
	TCPIopsTotal *int64

	/* TCPIopsWrite.

	   Filter by tcp.iops.write
	*/
	TCPIopsWrite *int64

	/* TCPLatencyOther.

	   Filter by tcp.latency.other
	*/
	TCPLatencyOther *int64

	/* TCPLatencyRead.

	   Filter by tcp.latency.read
	*/
	TCPLatencyRead *int64

	/* TCPLatencyTotal.

	   Filter by tcp.latency.total
	*/
	TCPLatencyTotal *int64

	/* TCPLatencyWrite.

	   Filter by tcp.latency.write
	*/
	TCPLatencyWrite *int64

	/* TCPStatus.

	   Filter by tcp.status
	*/
	TCPStatus *string

	/* TCPThroughputRead.

	   Filter by tcp.throughput.read
	*/
	TCPThroughputRead *int64

	/* TCPThroughputTotal.

	   Filter by tcp.throughput.total
	*/
	TCPThroughputTotal *int64

	/* TCPThroughputWrite.

	   Filter by tcp.throughput.write
	*/
	TCPThroughputWrite *int64

	/* ThroughputRead.

	   Filter by throughput.read
	*/
	ThroughputRead *int64

	/* ThroughputTotal.

	   Filter by throughput.total
	*/
	ThroughputTotal *int64

	/* ThroughputWrite.

	   Filter by throughput.write
	*/
	ThroughputWrite *int64

	/* Timestamp.

	   Filter by timestamp
	*/
	Timestamp *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the performance nvme metric collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformanceNvmeMetricCollectionGetParams) WithDefaults() *PerformanceNvmeMetricCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the performance nvme metric collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformanceNvmeMetricCollectionGetParams) SetDefaults() {
	var (
		intervalDefault = string("1h")

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := PerformanceNvmeMetricCollectionGetParams{
		Interval:      &intervalDefault,
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTimeout(timeout time.Duration) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithContext(ctx context.Context) *PerformanceNvmeMetricCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithHTTPClient(client *http.Client) *PerformanceNvmeMetricCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDuration adds the duration to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithDuration(duration *string) *PerformanceNvmeMetricCollectionGetParams {
	o.SetDuration(duration)
	return o
}

// SetDuration adds the duration to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetDuration(duration *string) {
	o.Duration = duration
}

// WithFcDuration adds the fcDuration to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcDuration(fcDuration *string) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcDuration(fcDuration)
	return o
}

// SetFcDuration adds the fcDuration to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcDuration(fcDuration *string) {
	o.FcDuration = fcDuration
}

// WithFcIopsOther adds the fcIopsOther to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcIopsOther(fcIopsOther *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcIopsOther(fcIopsOther)
	return o
}

// SetFcIopsOther adds the fcIopsOther to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcIopsOther(fcIopsOther *int64) {
	o.FcIopsOther = fcIopsOther
}

// WithFcIopsRead adds the fcIopsRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcIopsRead(fcIopsRead *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcIopsRead(fcIopsRead)
	return o
}

// SetFcIopsRead adds the fcIopsRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcIopsRead(fcIopsRead *int64) {
	o.FcIopsRead = fcIopsRead
}

// WithFcIopsTotal adds the fcIopsTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcIopsTotal(fcIopsTotal *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcIopsTotal(fcIopsTotal)
	return o
}

// SetFcIopsTotal adds the fcIopsTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcIopsTotal(fcIopsTotal *int64) {
	o.FcIopsTotal = fcIopsTotal
}

// WithFcIopsWrite adds the fcIopsWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcIopsWrite(fcIopsWrite *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcIopsWrite(fcIopsWrite)
	return o
}

// SetFcIopsWrite adds the fcIopsWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcIopsWrite(fcIopsWrite *int64) {
	o.FcIopsWrite = fcIopsWrite
}

// WithFcLatencyOther adds the fcLatencyOther to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcLatencyOther(fcLatencyOther *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcLatencyOther(fcLatencyOther)
	return o
}

// SetFcLatencyOther adds the fcLatencyOther to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcLatencyOther(fcLatencyOther *int64) {
	o.FcLatencyOther = fcLatencyOther
}

// WithFcLatencyRead adds the fcLatencyRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcLatencyRead(fcLatencyRead *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcLatencyRead(fcLatencyRead)
	return o
}

// SetFcLatencyRead adds the fcLatencyRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcLatencyRead(fcLatencyRead *int64) {
	o.FcLatencyRead = fcLatencyRead
}

// WithFcLatencyTotal adds the fcLatencyTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcLatencyTotal(fcLatencyTotal *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcLatencyTotal(fcLatencyTotal)
	return o
}

// SetFcLatencyTotal adds the fcLatencyTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcLatencyTotal(fcLatencyTotal *int64) {
	o.FcLatencyTotal = fcLatencyTotal
}

// WithFcLatencyWrite adds the fcLatencyWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcLatencyWrite(fcLatencyWrite *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcLatencyWrite(fcLatencyWrite)
	return o
}

// SetFcLatencyWrite adds the fcLatencyWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcLatencyWrite(fcLatencyWrite *int64) {
	o.FcLatencyWrite = fcLatencyWrite
}

// WithFcStatus adds the fcStatus to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcStatus(fcStatus *string) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcStatus(fcStatus)
	return o
}

// SetFcStatus adds the fcStatus to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcStatus(fcStatus *string) {
	o.FcStatus = fcStatus
}

// WithFcThroughputRead adds the fcThroughputRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcThroughputRead(fcThroughputRead *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcThroughputRead(fcThroughputRead)
	return o
}

// SetFcThroughputRead adds the fcThroughputRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcThroughputRead(fcThroughputRead *int64) {
	o.FcThroughputRead = fcThroughputRead
}

// WithFcThroughputTotal adds the fcThroughputTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcThroughputTotal(fcThroughputTotal *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcThroughputTotal(fcThroughputTotal)
	return o
}

// SetFcThroughputTotal adds the fcThroughputTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcThroughputTotal(fcThroughputTotal *int64) {
	o.FcThroughputTotal = fcThroughputTotal
}

// WithFcThroughputWrite adds the fcThroughputWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFcThroughputWrite(fcThroughputWrite *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFcThroughputWrite(fcThroughputWrite)
	return o
}

// SetFcThroughputWrite adds the fcThroughputWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFcThroughputWrite(fcThroughputWrite *int64) {
	o.FcThroughputWrite = fcThroughputWrite
}

// WithFields adds the fields to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithFields(fields []string) *PerformanceNvmeMetricCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInterval adds the interval to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithInterval(interval *string) *PerformanceNvmeMetricCollectionGetParams {
	o.SetInterval(interval)
	return o
}

// SetInterval adds the interval to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetInterval(interval *string) {
	o.Interval = interval
}

// WithIopsOther adds the iopsOther to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithIopsOther(iopsOther *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetIopsOther(iopsOther)
	return o
}

// SetIopsOther adds the iopsOther to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetIopsOther(iopsOther *int64) {
	o.IopsOther = iopsOther
}

// WithIopsRead adds the iopsRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithIopsRead(iopsRead *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetIopsRead(iopsRead)
	return o
}

// SetIopsRead adds the iopsRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetIopsRead(iopsRead *int64) {
	o.IopsRead = iopsRead
}

// WithIopsTotal adds the iopsTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithIopsTotal(iopsTotal *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetIopsTotal(iopsTotal)
	return o
}

// SetIopsTotal adds the iopsTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetIopsTotal(iopsTotal *int64) {
	o.IopsTotal = iopsTotal
}

// WithIopsWrite adds the iopsWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithIopsWrite(iopsWrite *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetIopsWrite(iopsWrite)
	return o
}

// SetIopsWrite adds the iopsWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetIopsWrite(iopsWrite *int64) {
	o.IopsWrite = iopsWrite
}

// WithLatencyOther adds the latencyOther to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithLatencyOther(latencyOther *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetLatencyOther(latencyOther)
	return o
}

// SetLatencyOther adds the latencyOther to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetLatencyOther(latencyOther *int64) {
	o.LatencyOther = latencyOther
}

// WithLatencyRead adds the latencyRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithLatencyRead(latencyRead *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetLatencyRead(latencyRead)
	return o
}

// SetLatencyRead adds the latencyRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetLatencyRead(latencyRead *int64) {
	o.LatencyRead = latencyRead
}

// WithLatencyTotal adds the latencyTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithLatencyTotal(latencyTotal *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetLatencyTotal(latencyTotal)
	return o
}

// SetLatencyTotal adds the latencyTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetLatencyTotal(latencyTotal *int64) {
	o.LatencyTotal = latencyTotal
}

// WithLatencyWrite adds the latencyWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithLatencyWrite(latencyWrite *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetLatencyWrite(latencyWrite)
	return o
}

// SetLatencyWrite adds the latencyWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetLatencyWrite(latencyWrite *int64) {
	o.LatencyWrite = latencyWrite
}

// WithMaxRecords adds the maxRecords to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithMaxRecords(maxRecords *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithOrderBy(orderBy []string) *PerformanceNvmeMetricCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithReturnRecords(returnRecords *bool) *PerformanceNvmeMetricCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStatus adds the status to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithStatus(status *string) *PerformanceNvmeMetricCollectionGetParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetStatus(status *string) {
	o.Status = status
}

// WithSvmUUID adds the svmUUID to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithSvmUUID(svmUUID string) *PerformanceNvmeMetricCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithTCPDuration adds the tCPDuration to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPDuration(tCPDuration *string) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPDuration(tCPDuration)
	return o
}

// SetTCPDuration adds the tcpDuration to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPDuration(tCPDuration *string) {
	o.TCPDuration = tCPDuration
}

// WithTCPIopsOther adds the tCPIopsOther to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPIopsOther(tCPIopsOther *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPIopsOther(tCPIopsOther)
	return o
}

// SetTCPIopsOther adds the tcpIopsOther to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPIopsOther(tCPIopsOther *int64) {
	o.TCPIopsOther = tCPIopsOther
}

// WithTCPIopsRead adds the tCPIopsRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPIopsRead(tCPIopsRead *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPIopsRead(tCPIopsRead)
	return o
}

// SetTCPIopsRead adds the tcpIopsRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPIopsRead(tCPIopsRead *int64) {
	o.TCPIopsRead = tCPIopsRead
}

// WithTCPIopsTotal adds the tCPIopsTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPIopsTotal(tCPIopsTotal *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPIopsTotal(tCPIopsTotal)
	return o
}

// SetTCPIopsTotal adds the tcpIopsTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPIopsTotal(tCPIopsTotal *int64) {
	o.TCPIopsTotal = tCPIopsTotal
}

// WithTCPIopsWrite adds the tCPIopsWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPIopsWrite(tCPIopsWrite *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPIopsWrite(tCPIopsWrite)
	return o
}

// SetTCPIopsWrite adds the tcpIopsWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPIopsWrite(tCPIopsWrite *int64) {
	o.TCPIopsWrite = tCPIopsWrite
}

// WithTCPLatencyOther adds the tCPLatencyOther to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPLatencyOther(tCPLatencyOther *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPLatencyOther(tCPLatencyOther)
	return o
}

// SetTCPLatencyOther adds the tcpLatencyOther to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPLatencyOther(tCPLatencyOther *int64) {
	o.TCPLatencyOther = tCPLatencyOther
}

// WithTCPLatencyRead adds the tCPLatencyRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPLatencyRead(tCPLatencyRead *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPLatencyRead(tCPLatencyRead)
	return o
}

// SetTCPLatencyRead adds the tcpLatencyRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPLatencyRead(tCPLatencyRead *int64) {
	o.TCPLatencyRead = tCPLatencyRead
}

// WithTCPLatencyTotal adds the tCPLatencyTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPLatencyTotal(tCPLatencyTotal *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPLatencyTotal(tCPLatencyTotal)
	return o
}

// SetTCPLatencyTotal adds the tcpLatencyTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPLatencyTotal(tCPLatencyTotal *int64) {
	o.TCPLatencyTotal = tCPLatencyTotal
}

// WithTCPLatencyWrite adds the tCPLatencyWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPLatencyWrite(tCPLatencyWrite *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPLatencyWrite(tCPLatencyWrite)
	return o
}

// SetTCPLatencyWrite adds the tcpLatencyWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPLatencyWrite(tCPLatencyWrite *int64) {
	o.TCPLatencyWrite = tCPLatencyWrite
}

// WithTCPStatus adds the tCPStatus to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPStatus(tCPStatus *string) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPStatus(tCPStatus)
	return o
}

// SetTCPStatus adds the tcpStatus to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPStatus(tCPStatus *string) {
	o.TCPStatus = tCPStatus
}

// WithTCPThroughputRead adds the tCPThroughputRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPThroughputRead(tCPThroughputRead *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPThroughputRead(tCPThroughputRead)
	return o
}

// SetTCPThroughputRead adds the tcpThroughputRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPThroughputRead(tCPThroughputRead *int64) {
	o.TCPThroughputRead = tCPThroughputRead
}

// WithTCPThroughputTotal adds the tCPThroughputTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPThroughputTotal(tCPThroughputTotal *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPThroughputTotal(tCPThroughputTotal)
	return o
}

// SetTCPThroughputTotal adds the tcpThroughputTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPThroughputTotal(tCPThroughputTotal *int64) {
	o.TCPThroughputTotal = tCPThroughputTotal
}

// WithTCPThroughputWrite adds the tCPThroughputWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTCPThroughputWrite(tCPThroughputWrite *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTCPThroughputWrite(tCPThroughputWrite)
	return o
}

// SetTCPThroughputWrite adds the tcpThroughputWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTCPThroughputWrite(tCPThroughputWrite *int64) {
	o.TCPThroughputWrite = tCPThroughputWrite
}

// WithThroughputRead adds the throughputRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithThroughputRead(throughputRead *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetThroughputRead(throughputRead)
	return o
}

// SetThroughputRead adds the throughputRead to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetThroughputRead(throughputRead *int64) {
	o.ThroughputRead = throughputRead
}

// WithThroughputTotal adds the throughputTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithThroughputTotal(throughputTotal *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetThroughputTotal(throughputTotal)
	return o
}

// SetThroughputTotal adds the throughputTotal to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetThroughputTotal(throughputTotal *int64) {
	o.ThroughputTotal = throughputTotal
}

// WithThroughputWrite adds the throughputWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithThroughputWrite(throughputWrite *int64) *PerformanceNvmeMetricCollectionGetParams {
	o.SetThroughputWrite(throughputWrite)
	return o
}

// SetThroughputWrite adds the throughputWrite to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetThroughputWrite(throughputWrite *int64) {
	o.ThroughputWrite = throughputWrite
}

// WithTimestamp adds the timestamp to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) WithTimestamp(timestamp *string) *PerformanceNvmeMetricCollectionGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the performance nvme metric collection get params
func (o *PerformanceNvmeMetricCollectionGetParams) SetTimestamp(timestamp *string) {
	o.Timestamp = timestamp
}

// WriteToRequest writes these params to a swagger request
func (o *PerformanceNvmeMetricCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Duration != nil {

		// query param duration
		var qrDuration string

		if o.Duration != nil {
			qrDuration = *o.Duration
		}
		qDuration := qrDuration
		if qDuration != "" {

			if err := r.SetQueryParam("duration", qDuration); err != nil {
				return err
			}
		}
	}

	if o.FcDuration != nil {

		// query param fc.duration
		var qrFcDuration string

		if o.FcDuration != nil {
			qrFcDuration = *o.FcDuration
		}
		qFcDuration := qrFcDuration
		if qFcDuration != "" {

			if err := r.SetQueryParam("fc.duration", qFcDuration); err != nil {
				return err
			}
		}
	}

	if o.FcIopsOther != nil {

		// query param fc.iops.other
		var qrFcIopsOther int64

		if o.FcIopsOther != nil {
			qrFcIopsOther = *o.FcIopsOther
		}
		qFcIopsOther := swag.FormatInt64(qrFcIopsOther)
		if qFcIopsOther != "" {

			if err := r.SetQueryParam("fc.iops.other", qFcIopsOther); err != nil {
				return err
			}
		}
	}

	if o.FcIopsRead != nil {

		// query param fc.iops.read
		var qrFcIopsRead int64

		if o.FcIopsRead != nil {
			qrFcIopsRead = *o.FcIopsRead
		}
		qFcIopsRead := swag.FormatInt64(qrFcIopsRead)
		if qFcIopsRead != "" {

			if err := r.SetQueryParam("fc.iops.read", qFcIopsRead); err != nil {
				return err
			}
		}
	}

	if o.FcIopsTotal != nil {

		// query param fc.iops.total
		var qrFcIopsTotal int64

		if o.FcIopsTotal != nil {
			qrFcIopsTotal = *o.FcIopsTotal
		}
		qFcIopsTotal := swag.FormatInt64(qrFcIopsTotal)
		if qFcIopsTotal != "" {

			if err := r.SetQueryParam("fc.iops.total", qFcIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.FcIopsWrite != nil {

		// query param fc.iops.write
		var qrFcIopsWrite int64

		if o.FcIopsWrite != nil {
			qrFcIopsWrite = *o.FcIopsWrite
		}
		qFcIopsWrite := swag.FormatInt64(qrFcIopsWrite)
		if qFcIopsWrite != "" {

			if err := r.SetQueryParam("fc.iops.write", qFcIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.FcLatencyOther != nil {

		// query param fc.latency.other
		var qrFcLatencyOther int64

		if o.FcLatencyOther != nil {
			qrFcLatencyOther = *o.FcLatencyOther
		}
		qFcLatencyOther := swag.FormatInt64(qrFcLatencyOther)
		if qFcLatencyOther != "" {

			if err := r.SetQueryParam("fc.latency.other", qFcLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.FcLatencyRead != nil {

		// query param fc.latency.read
		var qrFcLatencyRead int64

		if o.FcLatencyRead != nil {
			qrFcLatencyRead = *o.FcLatencyRead
		}
		qFcLatencyRead := swag.FormatInt64(qrFcLatencyRead)
		if qFcLatencyRead != "" {

			if err := r.SetQueryParam("fc.latency.read", qFcLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.FcLatencyTotal != nil {

		// query param fc.latency.total
		var qrFcLatencyTotal int64

		if o.FcLatencyTotal != nil {
			qrFcLatencyTotal = *o.FcLatencyTotal
		}
		qFcLatencyTotal := swag.FormatInt64(qrFcLatencyTotal)
		if qFcLatencyTotal != "" {

			if err := r.SetQueryParam("fc.latency.total", qFcLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.FcLatencyWrite != nil {

		// query param fc.latency.write
		var qrFcLatencyWrite int64

		if o.FcLatencyWrite != nil {
			qrFcLatencyWrite = *o.FcLatencyWrite
		}
		qFcLatencyWrite := swag.FormatInt64(qrFcLatencyWrite)
		if qFcLatencyWrite != "" {

			if err := r.SetQueryParam("fc.latency.write", qFcLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.FcStatus != nil {

		// query param fc.status
		var qrFcStatus string

		if o.FcStatus != nil {
			qrFcStatus = *o.FcStatus
		}
		qFcStatus := qrFcStatus
		if qFcStatus != "" {

			if err := r.SetQueryParam("fc.status", qFcStatus); err != nil {
				return err
			}
		}
	}

	if o.FcThroughputRead != nil {

		// query param fc.throughput.read
		var qrFcThroughputRead int64

		if o.FcThroughputRead != nil {
			qrFcThroughputRead = *o.FcThroughputRead
		}
		qFcThroughputRead := swag.FormatInt64(qrFcThroughputRead)
		if qFcThroughputRead != "" {

			if err := r.SetQueryParam("fc.throughput.read", qFcThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.FcThroughputTotal != nil {

		// query param fc.throughput.total
		var qrFcThroughputTotal int64

		if o.FcThroughputTotal != nil {
			qrFcThroughputTotal = *o.FcThroughputTotal
		}
		qFcThroughputTotal := swag.FormatInt64(qrFcThroughputTotal)
		if qFcThroughputTotal != "" {

			if err := r.SetQueryParam("fc.throughput.total", qFcThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.FcThroughputWrite != nil {

		// query param fc.throughput.write
		var qrFcThroughputWrite int64

		if o.FcThroughputWrite != nil {
			qrFcThroughputWrite = *o.FcThroughputWrite
		}
		qFcThroughputWrite := swag.FormatInt64(qrFcThroughputWrite)
		if qFcThroughputWrite != "" {

			if err := r.SetQueryParam("fc.throughput.write", qFcThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Interval != nil {

		// query param interval
		var qrInterval string

		if o.Interval != nil {
			qrInterval = *o.Interval
		}
		qInterval := qrInterval
		if qInterval != "" {

			if err := r.SetQueryParam("interval", qInterval); err != nil {
				return err
			}
		}
	}

	if o.IopsOther != nil {

		// query param iops.other
		var qrIopsOther int64

		if o.IopsOther != nil {
			qrIopsOther = *o.IopsOther
		}
		qIopsOther := swag.FormatInt64(qrIopsOther)
		if qIopsOther != "" {

			if err := r.SetQueryParam("iops.other", qIopsOther); err != nil {
				return err
			}
		}
	}

	if o.IopsRead != nil {

		// query param iops.read
		var qrIopsRead int64

		if o.IopsRead != nil {
			qrIopsRead = *o.IopsRead
		}
		qIopsRead := swag.FormatInt64(qrIopsRead)
		if qIopsRead != "" {

			if err := r.SetQueryParam("iops.read", qIopsRead); err != nil {
				return err
			}
		}
	}

	if o.IopsTotal != nil {

		// query param iops.total
		var qrIopsTotal int64

		if o.IopsTotal != nil {
			qrIopsTotal = *o.IopsTotal
		}
		qIopsTotal := swag.FormatInt64(qrIopsTotal)
		if qIopsTotal != "" {

			if err := r.SetQueryParam("iops.total", qIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.IopsWrite != nil {

		// query param iops.write
		var qrIopsWrite int64

		if o.IopsWrite != nil {
			qrIopsWrite = *o.IopsWrite
		}
		qIopsWrite := swag.FormatInt64(qrIopsWrite)
		if qIopsWrite != "" {

			if err := r.SetQueryParam("iops.write", qIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.LatencyOther != nil {

		// query param latency.other
		var qrLatencyOther int64

		if o.LatencyOther != nil {
			qrLatencyOther = *o.LatencyOther
		}
		qLatencyOther := swag.FormatInt64(qrLatencyOther)
		if qLatencyOther != "" {

			if err := r.SetQueryParam("latency.other", qLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.LatencyRead != nil {

		// query param latency.read
		var qrLatencyRead int64

		if o.LatencyRead != nil {
			qrLatencyRead = *o.LatencyRead
		}
		qLatencyRead := swag.FormatInt64(qrLatencyRead)
		if qLatencyRead != "" {

			if err := r.SetQueryParam("latency.read", qLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.LatencyTotal != nil {

		// query param latency.total
		var qrLatencyTotal int64

		if o.LatencyTotal != nil {
			qrLatencyTotal = *o.LatencyTotal
		}
		qLatencyTotal := swag.FormatInt64(qrLatencyTotal)
		if qLatencyTotal != "" {

			if err := r.SetQueryParam("latency.total", qLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.LatencyWrite != nil {

		// query param latency.write
		var qrLatencyWrite int64

		if o.LatencyWrite != nil {
			qrLatencyWrite = *o.LatencyWrite
		}
		qLatencyWrite := swag.FormatInt64(qrLatencyWrite)
		if qLatencyWrite != "" {

			if err := r.SetQueryParam("latency.write", qLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.TCPDuration != nil {

		// query param tcp.duration
		var qrTCPDuration string

		if o.TCPDuration != nil {
			qrTCPDuration = *o.TCPDuration
		}
		qTCPDuration := qrTCPDuration
		if qTCPDuration != "" {

			if err := r.SetQueryParam("tcp.duration", qTCPDuration); err != nil {
				return err
			}
		}
	}

	if o.TCPIopsOther != nil {

		// query param tcp.iops.other
		var qrTCPIopsOther int64

		if o.TCPIopsOther != nil {
			qrTCPIopsOther = *o.TCPIopsOther
		}
		qTCPIopsOther := swag.FormatInt64(qrTCPIopsOther)
		if qTCPIopsOther != "" {

			if err := r.SetQueryParam("tcp.iops.other", qTCPIopsOther); err != nil {
				return err
			}
		}
	}

	if o.TCPIopsRead != nil {

		// query param tcp.iops.read
		var qrTCPIopsRead int64

		if o.TCPIopsRead != nil {
			qrTCPIopsRead = *o.TCPIopsRead
		}
		qTCPIopsRead := swag.FormatInt64(qrTCPIopsRead)
		if qTCPIopsRead != "" {

			if err := r.SetQueryParam("tcp.iops.read", qTCPIopsRead); err != nil {
				return err
			}
		}
	}

	if o.TCPIopsTotal != nil {

		// query param tcp.iops.total
		var qrTCPIopsTotal int64

		if o.TCPIopsTotal != nil {
			qrTCPIopsTotal = *o.TCPIopsTotal
		}
		qTCPIopsTotal := swag.FormatInt64(qrTCPIopsTotal)
		if qTCPIopsTotal != "" {

			if err := r.SetQueryParam("tcp.iops.total", qTCPIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.TCPIopsWrite != nil {

		// query param tcp.iops.write
		var qrTCPIopsWrite int64

		if o.TCPIopsWrite != nil {
			qrTCPIopsWrite = *o.TCPIopsWrite
		}
		qTCPIopsWrite := swag.FormatInt64(qrTCPIopsWrite)
		if qTCPIopsWrite != "" {

			if err := r.SetQueryParam("tcp.iops.write", qTCPIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.TCPLatencyOther != nil {

		// query param tcp.latency.other
		var qrTCPLatencyOther int64

		if o.TCPLatencyOther != nil {
			qrTCPLatencyOther = *o.TCPLatencyOther
		}
		qTCPLatencyOther := swag.FormatInt64(qrTCPLatencyOther)
		if qTCPLatencyOther != "" {

			if err := r.SetQueryParam("tcp.latency.other", qTCPLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.TCPLatencyRead != nil {

		// query param tcp.latency.read
		var qrTCPLatencyRead int64

		if o.TCPLatencyRead != nil {
			qrTCPLatencyRead = *o.TCPLatencyRead
		}
		qTCPLatencyRead := swag.FormatInt64(qrTCPLatencyRead)
		if qTCPLatencyRead != "" {

			if err := r.SetQueryParam("tcp.latency.read", qTCPLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.TCPLatencyTotal != nil {

		// query param tcp.latency.total
		var qrTCPLatencyTotal int64

		if o.TCPLatencyTotal != nil {
			qrTCPLatencyTotal = *o.TCPLatencyTotal
		}
		qTCPLatencyTotal := swag.FormatInt64(qrTCPLatencyTotal)
		if qTCPLatencyTotal != "" {

			if err := r.SetQueryParam("tcp.latency.total", qTCPLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.TCPLatencyWrite != nil {

		// query param tcp.latency.write
		var qrTCPLatencyWrite int64

		if o.TCPLatencyWrite != nil {
			qrTCPLatencyWrite = *o.TCPLatencyWrite
		}
		qTCPLatencyWrite := swag.FormatInt64(qrTCPLatencyWrite)
		if qTCPLatencyWrite != "" {

			if err := r.SetQueryParam("tcp.latency.write", qTCPLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.TCPStatus != nil {

		// query param tcp.status
		var qrTCPStatus string

		if o.TCPStatus != nil {
			qrTCPStatus = *o.TCPStatus
		}
		qTCPStatus := qrTCPStatus
		if qTCPStatus != "" {

			if err := r.SetQueryParam("tcp.status", qTCPStatus); err != nil {
				return err
			}
		}
	}

	if o.TCPThroughputRead != nil {

		// query param tcp.throughput.read
		var qrTCPThroughputRead int64

		if o.TCPThroughputRead != nil {
			qrTCPThroughputRead = *o.TCPThroughputRead
		}
		qTCPThroughputRead := swag.FormatInt64(qrTCPThroughputRead)
		if qTCPThroughputRead != "" {

			if err := r.SetQueryParam("tcp.throughput.read", qTCPThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.TCPThroughputTotal != nil {

		// query param tcp.throughput.total
		var qrTCPThroughputTotal int64

		if o.TCPThroughputTotal != nil {
			qrTCPThroughputTotal = *o.TCPThroughputTotal
		}
		qTCPThroughputTotal := swag.FormatInt64(qrTCPThroughputTotal)
		if qTCPThroughputTotal != "" {

			if err := r.SetQueryParam("tcp.throughput.total", qTCPThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.TCPThroughputWrite != nil {

		// query param tcp.throughput.write
		var qrTCPThroughputWrite int64

		if o.TCPThroughputWrite != nil {
			qrTCPThroughputWrite = *o.TCPThroughputWrite
		}
		qTCPThroughputWrite := swag.FormatInt64(qrTCPThroughputWrite)
		if qTCPThroughputWrite != "" {

			if err := r.SetQueryParam("tcp.throughput.write", qTCPThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.ThroughputRead != nil {

		// query param throughput.read
		var qrThroughputRead int64

		if o.ThroughputRead != nil {
			qrThroughputRead = *o.ThroughputRead
		}
		qThroughputRead := swag.FormatInt64(qrThroughputRead)
		if qThroughputRead != "" {

			if err := r.SetQueryParam("throughput.read", qThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.ThroughputTotal != nil {

		// query param throughput.total
		var qrThroughputTotal int64

		if o.ThroughputTotal != nil {
			qrThroughputTotal = *o.ThroughputTotal
		}
		qThroughputTotal := swag.FormatInt64(qrThroughputTotal)
		if qThroughputTotal != "" {

			if err := r.SetQueryParam("throughput.total", qThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.ThroughputWrite != nil {

		// query param throughput.write
		var qrThroughputWrite int64

		if o.ThroughputWrite != nil {
			qrThroughputWrite = *o.ThroughputWrite
		}
		qThroughputWrite := swag.FormatInt64(qrThroughputWrite)
		if qThroughputWrite != "" {

			if err := r.SetQueryParam("throughput.write", qThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.Timestamp != nil {

		// query param timestamp
		var qrTimestamp string

		if o.Timestamp != nil {
			qrTimestamp = *o.Timestamp
		}
		qTimestamp := qrTimestamp
		if qTimestamp != "" {

			if err := r.SetQueryParam("timestamp", qTimestamp); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPerformanceNvmeMetricCollectionGet binds the parameter fields
func (o *PerformanceNvmeMetricCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamPerformanceNvmeMetricCollectionGet binds the parameter order_by
func (o *PerformanceNvmeMetricCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
