// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPerformanceNvmeMetricGetParams creates a new PerformanceNvmeMetricGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPerformanceNvmeMetricGetParams() *PerformanceNvmeMetricGetParams {
	return &PerformanceNvmeMetricGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPerformanceNvmeMetricGetParamsWithTimeout creates a new PerformanceNvmeMetricGetParams object
// with the ability to set a timeout on a request.
func NewPerformanceNvmeMetricGetParamsWithTimeout(timeout time.Duration) *PerformanceNvmeMetricGetParams {
	return &PerformanceNvmeMetricGetParams{
		timeout: timeout,
	}
}

// NewPerformanceNvmeMetricGetParamsWithContext creates a new PerformanceNvmeMetricGetParams object
// with the ability to set a context for a request.
func NewPerformanceNvmeMetricGetParamsWithContext(ctx context.Context) *PerformanceNvmeMetricGetParams {
	return &PerformanceNvmeMetricGetParams{
		Context: ctx,
	}
}

// NewPerformanceNvmeMetricGetParamsWithHTTPClient creates a new PerformanceNvmeMetricGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPerformanceNvmeMetricGetParamsWithHTTPClient(client *http.Client) *PerformanceNvmeMetricGetParams {
	return &PerformanceNvmeMetricGetParams{
		HTTPClient: client,
	}
}

/*
PerformanceNvmeMetricGetParams contains all the parameters to send to the API endpoint

	for the performance nvme metric get operation.

	Typically these are written to a http.Request.
*/
type PerformanceNvmeMetricGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* SvmUUID.

	   The unique identifier of the SVM.

	*/
	SvmUUID string

	/* Timestamp.

	   The timestamp of the performance data.


	   Format: date-time
	*/
	Timestamp strfmt.DateTime

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the performance nvme metric get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformanceNvmeMetricGetParams) WithDefaults() *PerformanceNvmeMetricGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the performance nvme metric get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformanceNvmeMetricGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the performance nvme metric get params
func (o *PerformanceNvmeMetricGetParams) WithTimeout(timeout time.Duration) *PerformanceNvmeMetricGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the performance nvme metric get params
func (o *PerformanceNvmeMetricGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the performance nvme metric get params
func (o *PerformanceNvmeMetricGetParams) WithContext(ctx context.Context) *PerformanceNvmeMetricGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the performance nvme metric get params
func (o *PerformanceNvmeMetricGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the performance nvme metric get params
func (o *PerformanceNvmeMetricGetParams) WithHTTPClient(client *http.Client) *PerformanceNvmeMetricGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the performance nvme metric get params
func (o *PerformanceNvmeMetricGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the performance nvme metric get params
func (o *PerformanceNvmeMetricGetParams) WithFields(fields []string) *PerformanceNvmeMetricGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the performance nvme metric get params
func (o *PerformanceNvmeMetricGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithSvmUUID adds the svmUUID to the performance nvme metric get params
func (o *PerformanceNvmeMetricGetParams) WithSvmUUID(svmUUID string) *PerformanceNvmeMetricGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the performance nvme metric get params
func (o *PerformanceNvmeMetricGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithTimestamp adds the timestamp to the performance nvme metric get params
func (o *PerformanceNvmeMetricGetParams) WithTimestamp(timestamp strfmt.DateTime) *PerformanceNvmeMetricGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the performance nvme metric get params
func (o *PerformanceNvmeMetricGetParams) SetTimestamp(timestamp strfmt.DateTime) {
	o.Timestamp = timestamp
}

// WriteToRequest writes these params to a swagger request
func (o *PerformanceNvmeMetricGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	// path param timestamp
	if err := r.SetPathParam("timestamp", o.Timestamp.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPerformanceNvmeMetricGet binds the parameter fields
func (o *PerformanceNvmeMetricGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
