// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDNSCollectionGetParams creates a new DNSCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDNSCollectionGetParams() *DNSCollectionGetParams {
	return &DNSCollectionGetParams{
		requestTimeout: cr.DefaultTimeout,
	}
}

// NewDNSCollectionGetParamsWithTimeout creates a new DNSCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDNSCollectionGetParamsWithTimeout(timeout time.Duration) *DNSCollectionGetParams {
	return &DNSCollectionGetParams{
		requestTimeout: timeout,
	}
}

// NewDNSCollectionGetParamsWithContext creates a new DNSCollectionGetParams object
// with the ability to set a context for a request.
func NewDNSCollectionGetParamsWithContext(ctx context.Context) *DNSCollectionGetParams {
	return &DNSCollectionGetParams{
		Context: ctx,
	}
}

// NewDNSCollectionGetParamsWithHTTPClient creates a new DNSCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDNSCollectionGetParamsWithHTTPClient(client *http.Client) *DNSCollectionGetParams {
	return &DNSCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DNSCollectionGetParams contains all the parameters to send to the API endpoint

	for the dns collection get operation.

	Typically these are written to a http.Request.
*/
type DNSCollectionGetParams struct {

	/* Attempts.

	   Filter by attempts
	*/
	Attempts *int64

	/* Domains.

	   Filter by domains
	*/
	Domains *string

	/* DynamicDNSEnabled.

	   Filter by dynamic_dns.enabled
	*/
	DynamicDNSEnabled *bool

	/* DynamicDNSFqdn.

	   Filter by dynamic_dns.fqdn
	*/
	DynamicDNSFqdn *string

	/* DynamicDNSTimeToLive.

	   Filter by dynamic_dns.time_to_live
	*/
	DynamicDNSTimeToLive *string

	/* DynamicDNSUseSecure.

	   Filter by dynamic_dns.use_secure
	*/
	DynamicDNSUseSecure *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PacketQueryMatch.

	   Filter by packet_query_match
	*/
	PacketQueryMatch *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* Servers.

	   Filter by servers
	*/
	Servers *string

	/* ServiceAddressType.

	   The type of IP address to be looked up on the DNS server.

	   Default: "all"
	*/
	ServiceAddressType *string

	/* ServiceName.

	   The string required to look up the SRV record on the DNS server.
	*/
	ServiceName *string

	/* ServiceIps.

	   Filter by service_ips
	*/
	ServiceIps *string

	/* SourceAddressMatch.

	   Filter by source_address_match
	*/
	SourceAddressMatch *bool

	/* StatusCode.

	   Filter by status.code
	*/
	StatusCode *int64

	/* StatusMessage.

	   Filter by status.message
	*/
	StatusMessage *string

	/* StatusNameServer.

	   Filter by status.name_server
	*/
	StatusNameServer *string

	/* StatusState.

	   Filter by status.state
	*/
	StatusState *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Timeout.

	   Filter by timeout
	*/
	Timeout *int64

	/* TldQueryEnabled.

	   Filter by tld_query_enabled
	*/
	TldQueryEnabled *bool

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	requestTimeout time.Duration
	Context        context.Context
	HTTPClient     *http.Client
}

// WithDefaults hydrates default values in the dns collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DNSCollectionGetParams) WithDefaults() *DNSCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the dns collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DNSCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serviceAddressTypeDefault = string("all")
	)

	val := DNSCollectionGetParams{
		ReturnRecords:      &returnRecordsDefault,
		ReturnTimeout:      &returnTimeoutDefault,
		ServiceAddressType: &serviceAddressTypeDefault,
	}

	val.requestTimeout = o.requestTimeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithRequestTimeout adds the timeout to the dns collection get params
func (o *DNSCollectionGetParams) WithRequestTimeout(timeout time.Duration) *DNSCollectionGetParams {
	o.SetRequestTimeout(timeout)
	return o
}

// SetRequestTimeout adds the timeout to the dns collection get params
func (o *DNSCollectionGetParams) SetRequestTimeout(timeout time.Duration) {
	o.requestTimeout = timeout
}

// WithContext adds the context to the dns collection get params
func (o *DNSCollectionGetParams) WithContext(ctx context.Context) *DNSCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the dns collection get params
func (o *DNSCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the dns collection get params
func (o *DNSCollectionGetParams) WithHTTPClient(client *http.Client) *DNSCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the dns collection get params
func (o *DNSCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAttempts adds the attempts to the dns collection get params
func (o *DNSCollectionGetParams) WithAttempts(attempts *int64) *DNSCollectionGetParams {
	o.SetAttempts(attempts)
	return o
}

// SetAttempts adds the attempts to the dns collection get params
func (o *DNSCollectionGetParams) SetAttempts(attempts *int64) {
	o.Attempts = attempts
}

// WithDomains adds the domains to the dns collection get params
func (o *DNSCollectionGetParams) WithDomains(domains *string) *DNSCollectionGetParams {
	o.SetDomains(domains)
	return o
}

// SetDomains adds the domains to the dns collection get params
func (o *DNSCollectionGetParams) SetDomains(domains *string) {
	o.Domains = domains
}

// WithDynamicDNSEnabled adds the dynamicDNSEnabled to the dns collection get params
func (o *DNSCollectionGetParams) WithDynamicDNSEnabled(dynamicDNSEnabled *bool) *DNSCollectionGetParams {
	o.SetDynamicDNSEnabled(dynamicDNSEnabled)
	return o
}

// SetDynamicDNSEnabled adds the dynamicDnsEnabled to the dns collection get params
func (o *DNSCollectionGetParams) SetDynamicDNSEnabled(dynamicDNSEnabled *bool) {
	o.DynamicDNSEnabled = dynamicDNSEnabled
}

// WithDynamicDNSFqdn adds the dynamicDNSFqdn to the dns collection get params
func (o *DNSCollectionGetParams) WithDynamicDNSFqdn(dynamicDNSFqdn *string) *DNSCollectionGetParams {
	o.SetDynamicDNSFqdn(dynamicDNSFqdn)
	return o
}

// SetDynamicDNSFqdn adds the dynamicDnsFqdn to the dns collection get params
func (o *DNSCollectionGetParams) SetDynamicDNSFqdn(dynamicDNSFqdn *string) {
	o.DynamicDNSFqdn = dynamicDNSFqdn
}

// WithDynamicDNSTimeToLive adds the dynamicDNSTimeToLive to the dns collection get params
func (o *DNSCollectionGetParams) WithDynamicDNSTimeToLive(dynamicDNSTimeToLive *string) *DNSCollectionGetParams {
	o.SetDynamicDNSTimeToLive(dynamicDNSTimeToLive)
	return o
}

// SetDynamicDNSTimeToLive adds the dynamicDnsTimeToLive to the dns collection get params
func (o *DNSCollectionGetParams) SetDynamicDNSTimeToLive(dynamicDNSTimeToLive *string) {
	o.DynamicDNSTimeToLive = dynamicDNSTimeToLive
}

// WithDynamicDNSUseSecure adds the dynamicDNSUseSecure to the dns collection get params
func (o *DNSCollectionGetParams) WithDynamicDNSUseSecure(dynamicDNSUseSecure *bool) *DNSCollectionGetParams {
	o.SetDynamicDNSUseSecure(dynamicDNSUseSecure)
	return o
}

// SetDynamicDNSUseSecure adds the dynamicDnsUseSecure to the dns collection get params
func (o *DNSCollectionGetParams) SetDynamicDNSUseSecure(dynamicDNSUseSecure *bool) {
	o.DynamicDNSUseSecure = dynamicDNSUseSecure
}

// WithFields adds the fields to the dns collection get params
func (o *DNSCollectionGetParams) WithFields(fields []string) *DNSCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the dns collection get params
func (o *DNSCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the dns collection get params
func (o *DNSCollectionGetParams) WithMaxRecords(maxRecords *int64) *DNSCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the dns collection get params
func (o *DNSCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the dns collection get params
func (o *DNSCollectionGetParams) WithOrderBy(orderBy []string) *DNSCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the dns collection get params
func (o *DNSCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPacketQueryMatch adds the packetQueryMatch to the dns collection get params
func (o *DNSCollectionGetParams) WithPacketQueryMatch(packetQueryMatch *bool) *DNSCollectionGetParams {
	o.SetPacketQueryMatch(packetQueryMatch)
	return o
}

// SetPacketQueryMatch adds the packetQueryMatch to the dns collection get params
func (o *DNSCollectionGetParams) SetPacketQueryMatch(packetQueryMatch *bool) {
	o.PacketQueryMatch = packetQueryMatch
}

// WithReturnRecords adds the returnRecords to the dns collection get params
func (o *DNSCollectionGetParams) WithReturnRecords(returnRecords *bool) *DNSCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the dns collection get params
func (o *DNSCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the dns collection get params
func (o *DNSCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DNSCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the dns collection get params
func (o *DNSCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the dns collection get params
func (o *DNSCollectionGetParams) WithScope(scope *string) *DNSCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the dns collection get params
func (o *DNSCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithServers adds the servers to the dns collection get params
func (o *DNSCollectionGetParams) WithServers(servers *string) *DNSCollectionGetParams {
	o.SetServers(servers)
	return o
}

// SetServers adds the servers to the dns collection get params
func (o *DNSCollectionGetParams) SetServers(servers *string) {
	o.Servers = servers
}

// WithServiceAddressType adds the serviceAddressType to the dns collection get params
func (o *DNSCollectionGetParams) WithServiceAddressType(serviceAddressType *string) *DNSCollectionGetParams {
	o.SetServiceAddressType(serviceAddressType)
	return o
}

// SetServiceAddressType adds the serviceAddressType to the dns collection get params
func (o *DNSCollectionGetParams) SetServiceAddressType(serviceAddressType *string) {
	o.ServiceAddressType = serviceAddressType
}

// WithServiceName adds the serviceName to the dns collection get params
func (o *DNSCollectionGetParams) WithServiceName(serviceName *string) *DNSCollectionGetParams {
	o.SetServiceName(serviceName)
	return o
}

// SetServiceName adds the serviceName to the dns collection get params
func (o *DNSCollectionGetParams) SetServiceName(serviceName *string) {
	o.ServiceName = serviceName
}

// WithServiceIps adds the serviceIps to the dns collection get params
func (o *DNSCollectionGetParams) WithServiceIps(serviceIps *string) *DNSCollectionGetParams {
	o.SetServiceIps(serviceIps)
	return o
}

// SetServiceIps adds the serviceIps to the dns collection get params
func (o *DNSCollectionGetParams) SetServiceIps(serviceIps *string) {
	o.ServiceIps = serviceIps
}

// WithSourceAddressMatch adds the sourceAddressMatch to the dns collection get params
func (o *DNSCollectionGetParams) WithSourceAddressMatch(sourceAddressMatch *bool) *DNSCollectionGetParams {
	o.SetSourceAddressMatch(sourceAddressMatch)
	return o
}

// SetSourceAddressMatch adds the sourceAddressMatch to the dns collection get params
func (o *DNSCollectionGetParams) SetSourceAddressMatch(sourceAddressMatch *bool) {
	o.SourceAddressMatch = sourceAddressMatch
}

// WithStatusCode adds the statusCode to the dns collection get params
func (o *DNSCollectionGetParams) WithStatusCode(statusCode *int64) *DNSCollectionGetParams {
	o.SetStatusCode(statusCode)
	return o
}

// SetStatusCode adds the statusCode to the dns collection get params
func (o *DNSCollectionGetParams) SetStatusCode(statusCode *int64) {
	o.StatusCode = statusCode
}

// WithStatusMessage adds the statusMessage to the dns collection get params
func (o *DNSCollectionGetParams) WithStatusMessage(statusMessage *string) *DNSCollectionGetParams {
	o.SetStatusMessage(statusMessage)
	return o
}

// SetStatusMessage adds the statusMessage to the dns collection get params
func (o *DNSCollectionGetParams) SetStatusMessage(statusMessage *string) {
	o.StatusMessage = statusMessage
}

// WithStatusNameServer adds the statusNameServer to the dns collection get params
func (o *DNSCollectionGetParams) WithStatusNameServer(statusNameServer *string) *DNSCollectionGetParams {
	o.SetStatusNameServer(statusNameServer)
	return o
}

// SetStatusNameServer adds the statusNameServer to the dns collection get params
func (o *DNSCollectionGetParams) SetStatusNameServer(statusNameServer *string) {
	o.StatusNameServer = statusNameServer
}

// WithStatusState adds the statusState to the dns collection get params
func (o *DNSCollectionGetParams) WithStatusState(statusState *string) *DNSCollectionGetParams {
	o.SetStatusState(statusState)
	return o
}

// SetStatusState adds the statusState to the dns collection get params
func (o *DNSCollectionGetParams) SetStatusState(statusState *string) {
	o.StatusState = statusState
}

// WithSvmName adds the svmName to the dns collection get params
func (o *DNSCollectionGetParams) WithSvmName(svmName *string) *DNSCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the dns collection get params
func (o *DNSCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the dns collection get params
func (o *DNSCollectionGetParams) WithSvmUUID(svmUUID *string) *DNSCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the dns collection get params
func (o *DNSCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTimeout adds the timeout to the dns collection get params
func (o *DNSCollectionGetParams) WithTimeout(timeout *int64) *DNSCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the dns collection get params
func (o *DNSCollectionGetParams) SetTimeout(timeout *int64) {
	o.Timeout = timeout
}

// WithTldQueryEnabled adds the tldQueryEnabled to the dns collection get params
func (o *DNSCollectionGetParams) WithTldQueryEnabled(tldQueryEnabled *bool) *DNSCollectionGetParams {
	o.SetTldQueryEnabled(tldQueryEnabled)
	return o
}

// SetTldQueryEnabled adds the tldQueryEnabled to the dns collection get params
func (o *DNSCollectionGetParams) SetTldQueryEnabled(tldQueryEnabled *bool) {
	o.TldQueryEnabled = tldQueryEnabled
}

// WithUUID adds the uuid to the dns collection get params
func (o *DNSCollectionGetParams) WithUUID(uuid *string) *DNSCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the dns collection get params
func (o *DNSCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *DNSCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.requestTimeout); err != nil {
		return err
	}
	var res []error

	if o.Attempts != nil {

		// query param attempts
		var qrAttempts int64

		if o.Attempts != nil {
			qrAttempts = *o.Attempts
		}
		qAttempts := swag.FormatInt64(qrAttempts)
		if qAttempts != "" {

			if err := r.SetQueryParam("attempts", qAttempts); err != nil {
				return err
			}
		}
	}

	if o.Domains != nil {

		// query param domains
		var qrDomains string

		if o.Domains != nil {
			qrDomains = *o.Domains
		}
		qDomains := qrDomains
		if qDomains != "" {

			if err := r.SetQueryParam("domains", qDomains); err != nil {
				return err
			}
		}
	}

	if o.DynamicDNSEnabled != nil {

		// query param dynamic_dns.enabled
		var qrDynamicDNSEnabled bool

		if o.DynamicDNSEnabled != nil {
			qrDynamicDNSEnabled = *o.DynamicDNSEnabled
		}
		qDynamicDNSEnabled := swag.FormatBool(qrDynamicDNSEnabled)
		if qDynamicDNSEnabled != "" {

			if err := r.SetQueryParam("dynamic_dns.enabled", qDynamicDNSEnabled); err != nil {
				return err
			}
		}
	}

	if o.DynamicDNSFqdn != nil {

		// query param dynamic_dns.fqdn
		var qrDynamicDNSFqdn string

		if o.DynamicDNSFqdn != nil {
			qrDynamicDNSFqdn = *o.DynamicDNSFqdn
		}
		qDynamicDNSFqdn := qrDynamicDNSFqdn
		if qDynamicDNSFqdn != "" {

			if err := r.SetQueryParam("dynamic_dns.fqdn", qDynamicDNSFqdn); err != nil {
				return err
			}
		}
	}

	if o.DynamicDNSTimeToLive != nil {

		// query param dynamic_dns.time_to_live
		var qrDynamicDNSTimeToLive string

		if o.DynamicDNSTimeToLive != nil {
			qrDynamicDNSTimeToLive = *o.DynamicDNSTimeToLive
		}
		qDynamicDNSTimeToLive := qrDynamicDNSTimeToLive
		if qDynamicDNSTimeToLive != "" {

			if err := r.SetQueryParam("dynamic_dns.time_to_live", qDynamicDNSTimeToLive); err != nil {
				return err
			}
		}
	}

	if o.DynamicDNSUseSecure != nil {

		// query param dynamic_dns.use_secure
		var qrDynamicDNSUseSecure bool

		if o.DynamicDNSUseSecure != nil {
			qrDynamicDNSUseSecure = *o.DynamicDNSUseSecure
		}
		qDynamicDNSUseSecure := swag.FormatBool(qrDynamicDNSUseSecure)
		if qDynamicDNSUseSecure != "" {

			if err := r.SetQueryParam("dynamic_dns.use_secure", qDynamicDNSUseSecure); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PacketQueryMatch != nil {

		// query param packet_query_match
		var qrPacketQueryMatch bool

		if o.PacketQueryMatch != nil {
			qrPacketQueryMatch = *o.PacketQueryMatch
		}
		qPacketQueryMatch := swag.FormatBool(qrPacketQueryMatch)
		if qPacketQueryMatch != "" {

			if err := r.SetQueryParam("packet_query_match", qPacketQueryMatch); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.Servers != nil {

		// query param servers
		var qrServers string

		if o.Servers != nil {
			qrServers = *o.Servers
		}
		qServers := qrServers
		if qServers != "" {

			if err := r.SetQueryParam("servers", qServers); err != nil {
				return err
			}
		}
	}

	if o.ServiceAddressType != nil {

		// query param service.address_type
		var qrServiceAddressType string

		if o.ServiceAddressType != nil {
			qrServiceAddressType = *o.ServiceAddressType
		}
		qServiceAddressType := qrServiceAddressType
		if qServiceAddressType != "" {

			if err := r.SetQueryParam("service.address_type", qServiceAddressType); err != nil {
				return err
			}
		}
	}

	if o.ServiceName != nil {

		// query param service.name
		var qrServiceName string

		if o.ServiceName != nil {
			qrServiceName = *o.ServiceName
		}
		qServiceName := qrServiceName
		if qServiceName != "" {

			if err := r.SetQueryParam("service.name", qServiceName); err != nil {
				return err
			}
		}
	}

	if o.ServiceIps != nil {

		// query param service_ips
		var qrServiceIps string

		if o.ServiceIps != nil {
			qrServiceIps = *o.ServiceIps
		}
		qServiceIps := qrServiceIps
		if qServiceIps != "" {

			if err := r.SetQueryParam("service_ips", qServiceIps); err != nil {
				return err
			}
		}
	}

	if o.SourceAddressMatch != nil {

		// query param source_address_match
		var qrSourceAddressMatch bool

		if o.SourceAddressMatch != nil {
			qrSourceAddressMatch = *o.SourceAddressMatch
		}
		qSourceAddressMatch := swag.FormatBool(qrSourceAddressMatch)
		if qSourceAddressMatch != "" {

			if err := r.SetQueryParam("source_address_match", qSourceAddressMatch); err != nil {
				return err
			}
		}
	}

	if o.StatusCode != nil {

		// query param status.code
		var qrStatusCode int64

		if o.StatusCode != nil {
			qrStatusCode = *o.StatusCode
		}
		qStatusCode := swag.FormatInt64(qrStatusCode)
		if qStatusCode != "" {

			if err := r.SetQueryParam("status.code", qStatusCode); err != nil {
				return err
			}
		}
	}

	if o.StatusMessage != nil {

		// query param status.message
		var qrStatusMessage string

		if o.StatusMessage != nil {
			qrStatusMessage = *o.StatusMessage
		}
		qStatusMessage := qrStatusMessage
		if qStatusMessage != "" {

			if err := r.SetQueryParam("status.message", qStatusMessage); err != nil {
				return err
			}
		}
	}

	if o.StatusNameServer != nil {

		// query param status.name_server
		var qrStatusNameServer string

		if o.StatusNameServer != nil {
			qrStatusNameServer = *o.StatusNameServer
		}
		qStatusNameServer := qrStatusNameServer
		if qStatusNameServer != "" {

			if err := r.SetQueryParam("status.name_server", qStatusNameServer); err != nil {
				return err
			}
		}
	}

	if o.StatusState != nil {

		// query param status.state
		var qrStatusState string

		if o.StatusState != nil {
			qrStatusState = *o.StatusState
		}
		qStatusState := qrStatusState
		if qStatusState != "" {

			if err := r.SetQueryParam("status.state", qStatusState); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Timeout != nil {

		// query param timeout
		var qrTimeout int64

		if o.Timeout != nil {
			qrTimeout = *o.Timeout
		}
		qTimeout := swag.FormatInt64(qrTimeout)
		if qTimeout != "" {

			if err := r.SetQueryParam("timeout", qTimeout); err != nil {
				return err
			}
		}
	}

	if o.TldQueryEnabled != nil {

		// query param tld_query_enabled
		var qrTldQueryEnabled bool

		if o.TldQueryEnabled != nil {
			qrTldQueryEnabled = *o.TldQueryEnabled
		}
		qTldQueryEnabled := swag.FormatBool(qrTldQueryEnabled)
		if qTldQueryEnabled != "" {

			if err := r.SetQueryParam("tld_query_enabled", qTldQueryEnabled); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDNSCollectionGet binds the parameter fields
func (o *DNSCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDNSCollectionGet binds the parameter order_by
func (o *DNSCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
