// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DNSCollectionGetReader is a Reader for the DNSCollectionGet structure.
type DNSCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DNSCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDNSCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDNSCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDNSCollectionGetOK creates a DNSCollectionGetOK with default headers values
func NewDNSCollectionGetOK() *DNSCollectionGetOK {
	return &DNSCollectionGetOK{}
}

/*
DNSCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type DNSCollectionGetOK struct {
	Payload *models.DNSResponse
}

// IsSuccess returns true when this dns collection get o k response has a 2xx status code
func (o *DNSCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dns collection get o k response has a 3xx status code
func (o *DNSCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dns collection get o k response has a 4xx status code
func (o *DNSCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dns collection get o k response has a 5xx status code
func (o *DNSCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dns collection get o k response a status code equal to that given
func (o *DNSCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dns collection get o k response
func (o *DNSCollectionGetOK) Code() int {
	return 200
}

func (o *DNSCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/dns][%d] dnsCollectionGetOK %s", 200, payload)
}

func (o *DNSCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/dns][%d] dnsCollectionGetOK %s", 200, payload)
}

func (o *DNSCollectionGetOK) GetPayload() *models.DNSResponse {
	return o.Payload
}

func (o *DNSCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DNSResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDNSCollectionGetDefault creates a DNSCollectionGetDefault with default headers values
func NewDNSCollectionGetDefault(code int) *DNSCollectionGetDefault {
	return &DNSCollectionGetDefault{
		_statusCode: code,
	}
}

/*
DNSCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type DNSCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dns collection get default response has a 2xx status code
func (o *DNSCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dns collection get default response has a 3xx status code
func (o *DNSCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dns collection get default response has a 4xx status code
func (o *DNSCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dns collection get default response has a 5xx status code
func (o *DNSCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dns collection get default response a status code equal to that given
func (o *DNSCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dns collection get default response
func (o *DNSCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *DNSCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/dns][%d] dns_collection_get default %s", o._statusCode, payload)
}

func (o *DNSCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/dns][%d] dns_collection_get default %s", o._statusCode, payload)
}

func (o *DNSCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DNSCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
