// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDNSCreateParams creates a new DNSCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDNSCreateParams() *DNSCreateParams {
	return &DNSCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDNSCreateParamsWithTimeout creates a new DNSCreateParams object
// with the ability to set a timeout on a request.
func NewDNSCreateParamsWithTimeout(timeout time.Duration) *DNSCreateParams {
	return &DNSCreateParams{
		timeout: timeout,
	}
}

// NewDNSCreateParamsWithContext creates a new DNSCreateParams object
// with the ability to set a context for a request.
func NewDNSCreateParamsWithContext(ctx context.Context) *DNSCreateParams {
	return &DNSCreateParams{
		Context: ctx,
	}
}

// NewDNSCreateParamsWithHTTPClient creates a new DNSCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewDNSCreateParamsWithHTTPClient(client *http.Client) *DNSCreateParams {
	return &DNSCreateParams{
		HTTPClient: client,
	}
}

/*
DNSCreateParams contains all the parameters to send to the API endpoint

	for the dns create operation.

	Typically these are written to a http.Request.
*/
type DNSCreateParams struct {

	/* Async.

	   An asynchronous task.
	*/
	Async *bool

	/* Info.

	   Info specification
	*/
	Info *models.DNS

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the dns create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DNSCreateParams) WithDefaults() *DNSCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the dns create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DNSCreateParams) SetDefaults() {
	var (
		asyncDefault = bool(false)

		returnRecordsDefault = bool(false)
	)

	val := DNSCreateParams{
		Async:         &asyncDefault,
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the dns create params
func (o *DNSCreateParams) WithTimeout(timeout time.Duration) *DNSCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the dns create params
func (o *DNSCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the dns create params
func (o *DNSCreateParams) WithContext(ctx context.Context) *DNSCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the dns create params
func (o *DNSCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the dns create params
func (o *DNSCreateParams) WithHTTPClient(client *http.Client) *DNSCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the dns create params
func (o *DNSCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAsync adds the async to the dns create params
func (o *DNSCreateParams) WithAsync(async *bool) *DNSCreateParams {
	o.SetAsync(async)
	return o
}

// SetAsync adds the async to the dns create params
func (o *DNSCreateParams) SetAsync(async *bool) {
	o.Async = async
}

// WithInfo adds the info to the dns create params
func (o *DNSCreateParams) WithInfo(info *models.DNS) *DNSCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the dns create params
func (o *DNSCreateParams) SetInfo(info *models.DNS) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the dns create params
func (o *DNSCreateParams) WithReturnRecords(returnRecords *bool) *DNSCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the dns create params
func (o *DNSCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *DNSCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Async != nil {

		// query param async
		var qrAsync bool

		if o.Async != nil {
			qrAsync = *o.Async
		}
		qAsync := swag.FormatBool(qrAsync)
		if qAsync != "" {

			if err := r.SetQueryParam("async", qAsync); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
