// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDNSModifyCollectionParams creates a new DNSModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDNSModifyCollectionParams() *DNSModifyCollectionParams {
	return &DNSModifyCollectionParams{
		requestTimeout: cr.DefaultTimeout,
	}
}

// NewDNSModifyCollectionParamsWithTimeout creates a new DNSModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewDNSModifyCollectionParamsWithTimeout(timeout time.Duration) *DNSModifyCollectionParams {
	return &DNSModifyCollectionParams{
		requestTimeout: timeout,
	}
}

// NewDNSModifyCollectionParamsWithContext creates a new DNSModifyCollectionParams object
// with the ability to set a context for a request.
func NewDNSModifyCollectionParamsWithContext(ctx context.Context) *DNSModifyCollectionParams {
	return &DNSModifyCollectionParams{
		Context: ctx,
	}
}

// NewDNSModifyCollectionParamsWithHTTPClient creates a new DNSModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDNSModifyCollectionParamsWithHTTPClient(client *http.Client) *DNSModifyCollectionParams {
	return &DNSModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
DNSModifyCollectionParams contains all the parameters to send to the API endpoint

	for the dns modify collection operation.

	Typically these are written to a http.Request.
*/
type DNSModifyCollectionParams struct {

	/* Async.

	   An asynchronous task.
	*/
	Async *bool

	/* Attempts.

	   Filter by attempts
	*/
	Attempts *int64

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Domains.

	   Filter by domains
	*/
	Domains *string

	/* DynamicDNSEnabled.

	   Filter by dynamic_dns.enabled
	*/
	DynamicDNSEnabled *bool

	/* DynamicDNSFqdn.

	   Filter by dynamic_dns.fqdn
	*/
	DynamicDNSFqdn *string

	/* DynamicDNSTimeToLive.

	   Filter by dynamic_dns.time_to_live
	*/
	DynamicDNSTimeToLive *string

	/* DynamicDNSUseSecure.

	   Filter by dynamic_dns.use_secure
	*/
	DynamicDNSUseSecure *bool

	/* Info.

	   Info specification
	*/
	Info DNSModifyCollectionBody

	/* PacketQueryMatch.

	   Filter by packet_query_match
	*/
	PacketQueryMatch *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Servers.

	   Filter by servers
	*/
	Servers *string

	/* ServiceAddressType.

	   The type of IP address to be looked up on the DNS server.

	   Default: "all"
	*/
	ServiceAddressType *string

	/* ServiceName.

	   The string required to look up the SRV record on the DNS server.
	*/
	ServiceName *string

	/* ServiceIps.

	   Filter by service_ips
	*/
	ServiceIps *string

	/* SourceAddressMatch.

	   Filter by source_address_match
	*/
	SourceAddressMatch *bool

	/* StatusCode.

	   Filter by status.code
	*/
	StatusCode *int64

	/* StatusMessage.

	   Filter by status.message
	*/
	StatusMessage *string

	/* StatusNameServer.

	   Filter by status.name_server
	*/
	StatusNameServer *string

	/* StatusState.

	   Filter by status.state
	*/
	StatusState *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Timeout.

	   Filter by timeout
	*/
	Timeout *int64

	/* TldQueryEnabled.

	   Filter by tld_query_enabled
	*/
	TldQueryEnabled *bool

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	requestTimeout time.Duration
	Context        context.Context
	HTTPClient     *http.Client
}

// WithDefaults hydrates default values in the dns modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DNSModifyCollectionParams) WithDefaults() *DNSModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the dns modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DNSModifyCollectionParams) SetDefaults() {
	var (
		asyncDefault = bool(false)

		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)

		serviceAddressTypeDefault = string("all")
	)

	val := DNSModifyCollectionParams{
		Async:              &asyncDefault,
		ContinueOnFailure:  &continueOnFailureDefault,
		ReturnRecords:      &returnRecordsDefault,
		ReturnTimeout:      &returnTimeoutDefault,
		SerialRecords:      &serialRecordsDefault,
		ServiceAddressType: &serviceAddressTypeDefault,
	}

	val.requestTimeout = o.requestTimeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithRequestTimeout adds the timeout to the dns modify collection params
func (o *DNSModifyCollectionParams) WithRequestTimeout(timeout time.Duration) *DNSModifyCollectionParams {
	o.SetRequestTimeout(timeout)
	return o
}

// SetRequestTimeout adds the timeout to the dns modify collection params
func (o *DNSModifyCollectionParams) SetRequestTimeout(timeout time.Duration) {
	o.requestTimeout = timeout
}

// WithContext adds the context to the dns modify collection params
func (o *DNSModifyCollectionParams) WithContext(ctx context.Context) *DNSModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the dns modify collection params
func (o *DNSModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the dns modify collection params
func (o *DNSModifyCollectionParams) WithHTTPClient(client *http.Client) *DNSModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the dns modify collection params
func (o *DNSModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAsync adds the async to the dns modify collection params
func (o *DNSModifyCollectionParams) WithAsync(async *bool) *DNSModifyCollectionParams {
	o.SetAsync(async)
	return o
}

// SetAsync adds the async to the dns modify collection params
func (o *DNSModifyCollectionParams) SetAsync(async *bool) {
	o.Async = async
}

// WithAttempts adds the attempts to the dns modify collection params
func (o *DNSModifyCollectionParams) WithAttempts(attempts *int64) *DNSModifyCollectionParams {
	o.SetAttempts(attempts)
	return o
}

// SetAttempts adds the attempts to the dns modify collection params
func (o *DNSModifyCollectionParams) SetAttempts(attempts *int64) {
	o.Attempts = attempts
}

// WithContinueOnFailure adds the continueOnFailure to the dns modify collection params
func (o *DNSModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *DNSModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the dns modify collection params
func (o *DNSModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDomains adds the domains to the dns modify collection params
func (o *DNSModifyCollectionParams) WithDomains(domains *string) *DNSModifyCollectionParams {
	o.SetDomains(domains)
	return o
}

// SetDomains adds the domains to the dns modify collection params
func (o *DNSModifyCollectionParams) SetDomains(domains *string) {
	o.Domains = domains
}

// WithDynamicDNSEnabled adds the dynamicDNSEnabled to the dns modify collection params
func (o *DNSModifyCollectionParams) WithDynamicDNSEnabled(dynamicDNSEnabled *bool) *DNSModifyCollectionParams {
	o.SetDynamicDNSEnabled(dynamicDNSEnabled)
	return o
}

// SetDynamicDNSEnabled adds the dynamicDnsEnabled to the dns modify collection params
func (o *DNSModifyCollectionParams) SetDynamicDNSEnabled(dynamicDNSEnabled *bool) {
	o.DynamicDNSEnabled = dynamicDNSEnabled
}

// WithDynamicDNSFqdn adds the dynamicDNSFqdn to the dns modify collection params
func (o *DNSModifyCollectionParams) WithDynamicDNSFqdn(dynamicDNSFqdn *string) *DNSModifyCollectionParams {
	o.SetDynamicDNSFqdn(dynamicDNSFqdn)
	return o
}

// SetDynamicDNSFqdn adds the dynamicDnsFqdn to the dns modify collection params
func (o *DNSModifyCollectionParams) SetDynamicDNSFqdn(dynamicDNSFqdn *string) {
	o.DynamicDNSFqdn = dynamicDNSFqdn
}

// WithDynamicDNSTimeToLive adds the dynamicDNSTimeToLive to the dns modify collection params
func (o *DNSModifyCollectionParams) WithDynamicDNSTimeToLive(dynamicDNSTimeToLive *string) *DNSModifyCollectionParams {
	o.SetDynamicDNSTimeToLive(dynamicDNSTimeToLive)
	return o
}

// SetDynamicDNSTimeToLive adds the dynamicDnsTimeToLive to the dns modify collection params
func (o *DNSModifyCollectionParams) SetDynamicDNSTimeToLive(dynamicDNSTimeToLive *string) {
	o.DynamicDNSTimeToLive = dynamicDNSTimeToLive
}

// WithDynamicDNSUseSecure adds the dynamicDNSUseSecure to the dns modify collection params
func (o *DNSModifyCollectionParams) WithDynamicDNSUseSecure(dynamicDNSUseSecure *bool) *DNSModifyCollectionParams {
	o.SetDynamicDNSUseSecure(dynamicDNSUseSecure)
	return o
}

// SetDynamicDNSUseSecure adds the dynamicDnsUseSecure to the dns modify collection params
func (o *DNSModifyCollectionParams) SetDynamicDNSUseSecure(dynamicDNSUseSecure *bool) {
	o.DynamicDNSUseSecure = dynamicDNSUseSecure
}

// WithInfo adds the info to the dns modify collection params
func (o *DNSModifyCollectionParams) WithInfo(info DNSModifyCollectionBody) *DNSModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the dns modify collection params
func (o *DNSModifyCollectionParams) SetInfo(info DNSModifyCollectionBody) {
	o.Info = info
}

// WithPacketQueryMatch adds the packetQueryMatch to the dns modify collection params
func (o *DNSModifyCollectionParams) WithPacketQueryMatch(packetQueryMatch *bool) *DNSModifyCollectionParams {
	o.SetPacketQueryMatch(packetQueryMatch)
	return o
}

// SetPacketQueryMatch adds the packetQueryMatch to the dns modify collection params
func (o *DNSModifyCollectionParams) SetPacketQueryMatch(packetQueryMatch *bool) {
	o.PacketQueryMatch = packetQueryMatch
}

// WithReturnRecords adds the returnRecords to the dns modify collection params
func (o *DNSModifyCollectionParams) WithReturnRecords(returnRecords *bool) *DNSModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the dns modify collection params
func (o *DNSModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the dns modify collection params
func (o *DNSModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *DNSModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the dns modify collection params
func (o *DNSModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the dns modify collection params
func (o *DNSModifyCollectionParams) WithScope(scope *string) *DNSModifyCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the dns modify collection params
func (o *DNSModifyCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the dns modify collection params
func (o *DNSModifyCollectionParams) WithSerialRecords(serialRecords *bool) *DNSModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the dns modify collection params
func (o *DNSModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServers adds the servers to the dns modify collection params
func (o *DNSModifyCollectionParams) WithServers(servers *string) *DNSModifyCollectionParams {
	o.SetServers(servers)
	return o
}

// SetServers adds the servers to the dns modify collection params
func (o *DNSModifyCollectionParams) SetServers(servers *string) {
	o.Servers = servers
}

// WithServiceAddressType adds the serviceAddressType to the dns modify collection params
func (o *DNSModifyCollectionParams) WithServiceAddressType(serviceAddressType *string) *DNSModifyCollectionParams {
	o.SetServiceAddressType(serviceAddressType)
	return o
}

// SetServiceAddressType adds the serviceAddressType to the dns modify collection params
func (o *DNSModifyCollectionParams) SetServiceAddressType(serviceAddressType *string) {
	o.ServiceAddressType = serviceAddressType
}

// WithServiceName adds the serviceName to the dns modify collection params
func (o *DNSModifyCollectionParams) WithServiceName(serviceName *string) *DNSModifyCollectionParams {
	o.SetServiceName(serviceName)
	return o
}

// SetServiceName adds the serviceName to the dns modify collection params
func (o *DNSModifyCollectionParams) SetServiceName(serviceName *string) {
	o.ServiceName = serviceName
}

// WithServiceIps adds the serviceIps to the dns modify collection params
func (o *DNSModifyCollectionParams) WithServiceIps(serviceIps *string) *DNSModifyCollectionParams {
	o.SetServiceIps(serviceIps)
	return o
}

// SetServiceIps adds the serviceIps to the dns modify collection params
func (o *DNSModifyCollectionParams) SetServiceIps(serviceIps *string) {
	o.ServiceIps = serviceIps
}

// WithSourceAddressMatch adds the sourceAddressMatch to the dns modify collection params
func (o *DNSModifyCollectionParams) WithSourceAddressMatch(sourceAddressMatch *bool) *DNSModifyCollectionParams {
	o.SetSourceAddressMatch(sourceAddressMatch)
	return o
}

// SetSourceAddressMatch adds the sourceAddressMatch to the dns modify collection params
func (o *DNSModifyCollectionParams) SetSourceAddressMatch(sourceAddressMatch *bool) {
	o.SourceAddressMatch = sourceAddressMatch
}

// WithStatusCode adds the statusCode to the dns modify collection params
func (o *DNSModifyCollectionParams) WithStatusCode(statusCode *int64) *DNSModifyCollectionParams {
	o.SetStatusCode(statusCode)
	return o
}

// SetStatusCode adds the statusCode to the dns modify collection params
func (o *DNSModifyCollectionParams) SetStatusCode(statusCode *int64) {
	o.StatusCode = statusCode
}

// WithStatusMessage adds the statusMessage to the dns modify collection params
func (o *DNSModifyCollectionParams) WithStatusMessage(statusMessage *string) *DNSModifyCollectionParams {
	o.SetStatusMessage(statusMessage)
	return o
}

// SetStatusMessage adds the statusMessage to the dns modify collection params
func (o *DNSModifyCollectionParams) SetStatusMessage(statusMessage *string) {
	o.StatusMessage = statusMessage
}

// WithStatusNameServer adds the statusNameServer to the dns modify collection params
func (o *DNSModifyCollectionParams) WithStatusNameServer(statusNameServer *string) *DNSModifyCollectionParams {
	o.SetStatusNameServer(statusNameServer)
	return o
}

// SetStatusNameServer adds the statusNameServer to the dns modify collection params
func (o *DNSModifyCollectionParams) SetStatusNameServer(statusNameServer *string) {
	o.StatusNameServer = statusNameServer
}

// WithStatusState adds the statusState to the dns modify collection params
func (o *DNSModifyCollectionParams) WithStatusState(statusState *string) *DNSModifyCollectionParams {
	o.SetStatusState(statusState)
	return o
}

// SetStatusState adds the statusState to the dns modify collection params
func (o *DNSModifyCollectionParams) SetStatusState(statusState *string) {
	o.StatusState = statusState
}

// WithSvmName adds the svmName to the dns modify collection params
func (o *DNSModifyCollectionParams) WithSvmName(svmName *string) *DNSModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the dns modify collection params
func (o *DNSModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the dns modify collection params
func (o *DNSModifyCollectionParams) WithSvmUUID(svmUUID *string) *DNSModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the dns modify collection params
func (o *DNSModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTimeout adds the timeout to the dns modify collection params
func (o *DNSModifyCollectionParams) WithTimeout(timeout *int64) *DNSModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the dns modify collection params
func (o *DNSModifyCollectionParams) SetTimeout(timeout *int64) {
	o.Timeout = timeout
}

// WithTldQueryEnabled adds the tldQueryEnabled to the dns modify collection params
func (o *DNSModifyCollectionParams) WithTldQueryEnabled(tldQueryEnabled *bool) *DNSModifyCollectionParams {
	o.SetTldQueryEnabled(tldQueryEnabled)
	return o
}

// SetTldQueryEnabled adds the tldQueryEnabled to the dns modify collection params
func (o *DNSModifyCollectionParams) SetTldQueryEnabled(tldQueryEnabled *bool) {
	o.TldQueryEnabled = tldQueryEnabled
}

// WithUUID adds the uuid to the dns modify collection params
func (o *DNSModifyCollectionParams) WithUUID(uuid *string) *DNSModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the dns modify collection params
func (o *DNSModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *DNSModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.requestTimeout); err != nil {
		return err
	}
	var res []error

	if o.Async != nil {

		// query param async
		var qrAsync bool

		if o.Async != nil {
			qrAsync = *o.Async
		}
		qAsync := swag.FormatBool(qrAsync)
		if qAsync != "" {

			if err := r.SetQueryParam("async", qAsync); err != nil {
				return err
			}
		}
	}

	if o.Attempts != nil {

		// query param attempts
		var qrAttempts int64

		if o.Attempts != nil {
			qrAttempts = *o.Attempts
		}
		qAttempts := swag.FormatInt64(qrAttempts)
		if qAttempts != "" {

			if err := r.SetQueryParam("attempts", qAttempts); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Domains != nil {

		// query param domains
		var qrDomains string

		if o.Domains != nil {
			qrDomains = *o.Domains
		}
		qDomains := qrDomains
		if qDomains != "" {

			if err := r.SetQueryParam("domains", qDomains); err != nil {
				return err
			}
		}
	}

	if o.DynamicDNSEnabled != nil {

		// query param dynamic_dns.enabled
		var qrDynamicDNSEnabled bool

		if o.DynamicDNSEnabled != nil {
			qrDynamicDNSEnabled = *o.DynamicDNSEnabled
		}
		qDynamicDNSEnabled := swag.FormatBool(qrDynamicDNSEnabled)
		if qDynamicDNSEnabled != "" {

			if err := r.SetQueryParam("dynamic_dns.enabled", qDynamicDNSEnabled); err != nil {
				return err
			}
		}
	}

	if o.DynamicDNSFqdn != nil {

		// query param dynamic_dns.fqdn
		var qrDynamicDNSFqdn string

		if o.DynamicDNSFqdn != nil {
			qrDynamicDNSFqdn = *o.DynamicDNSFqdn
		}
		qDynamicDNSFqdn := qrDynamicDNSFqdn
		if qDynamicDNSFqdn != "" {

			if err := r.SetQueryParam("dynamic_dns.fqdn", qDynamicDNSFqdn); err != nil {
				return err
			}
		}
	}

	if o.DynamicDNSTimeToLive != nil {

		// query param dynamic_dns.time_to_live
		var qrDynamicDNSTimeToLive string

		if o.DynamicDNSTimeToLive != nil {
			qrDynamicDNSTimeToLive = *o.DynamicDNSTimeToLive
		}
		qDynamicDNSTimeToLive := qrDynamicDNSTimeToLive
		if qDynamicDNSTimeToLive != "" {

			if err := r.SetQueryParam("dynamic_dns.time_to_live", qDynamicDNSTimeToLive); err != nil {
				return err
			}
		}
	}

	if o.DynamicDNSUseSecure != nil {

		// query param dynamic_dns.use_secure
		var qrDynamicDNSUseSecure bool

		if o.DynamicDNSUseSecure != nil {
			qrDynamicDNSUseSecure = *o.DynamicDNSUseSecure
		}
		qDynamicDNSUseSecure := swag.FormatBool(qrDynamicDNSUseSecure)
		if qDynamicDNSUseSecure != "" {

			if err := r.SetQueryParam("dynamic_dns.use_secure", qDynamicDNSUseSecure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.PacketQueryMatch != nil {

		// query param packet_query_match
		var qrPacketQueryMatch bool

		if o.PacketQueryMatch != nil {
			qrPacketQueryMatch = *o.PacketQueryMatch
		}
		qPacketQueryMatch := swag.FormatBool(qrPacketQueryMatch)
		if qPacketQueryMatch != "" {

			if err := r.SetQueryParam("packet_query_match", qPacketQueryMatch); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Servers != nil {

		// query param servers
		var qrServers string

		if o.Servers != nil {
			qrServers = *o.Servers
		}
		qServers := qrServers
		if qServers != "" {

			if err := r.SetQueryParam("servers", qServers); err != nil {
				return err
			}
		}
	}

	if o.ServiceAddressType != nil {

		// query param service.address_type
		var qrServiceAddressType string

		if o.ServiceAddressType != nil {
			qrServiceAddressType = *o.ServiceAddressType
		}
		qServiceAddressType := qrServiceAddressType
		if qServiceAddressType != "" {

			if err := r.SetQueryParam("service.address_type", qServiceAddressType); err != nil {
				return err
			}
		}
	}

	if o.ServiceName != nil {

		// query param service.name
		var qrServiceName string

		if o.ServiceName != nil {
			qrServiceName = *o.ServiceName
		}
		qServiceName := qrServiceName
		if qServiceName != "" {

			if err := r.SetQueryParam("service.name", qServiceName); err != nil {
				return err
			}
		}
	}

	if o.ServiceIps != nil {

		// query param service_ips
		var qrServiceIps string

		if o.ServiceIps != nil {
			qrServiceIps = *o.ServiceIps
		}
		qServiceIps := qrServiceIps
		if qServiceIps != "" {

			if err := r.SetQueryParam("service_ips", qServiceIps); err != nil {
				return err
			}
		}
	}

	if o.SourceAddressMatch != nil {

		// query param source_address_match
		var qrSourceAddressMatch bool

		if o.SourceAddressMatch != nil {
			qrSourceAddressMatch = *o.SourceAddressMatch
		}
		qSourceAddressMatch := swag.FormatBool(qrSourceAddressMatch)
		if qSourceAddressMatch != "" {

			if err := r.SetQueryParam("source_address_match", qSourceAddressMatch); err != nil {
				return err
			}
		}
	}

	if o.StatusCode != nil {

		// query param status.code
		var qrStatusCode int64

		if o.StatusCode != nil {
			qrStatusCode = *o.StatusCode
		}
		qStatusCode := swag.FormatInt64(qrStatusCode)
		if qStatusCode != "" {

			if err := r.SetQueryParam("status.code", qStatusCode); err != nil {
				return err
			}
		}
	}

	if o.StatusMessage != nil {

		// query param status.message
		var qrStatusMessage string

		if o.StatusMessage != nil {
			qrStatusMessage = *o.StatusMessage
		}
		qStatusMessage := qrStatusMessage
		if qStatusMessage != "" {

			if err := r.SetQueryParam("status.message", qStatusMessage); err != nil {
				return err
			}
		}
	}

	if o.StatusNameServer != nil {

		// query param status.name_server
		var qrStatusNameServer string

		if o.StatusNameServer != nil {
			qrStatusNameServer = *o.StatusNameServer
		}
		qStatusNameServer := qrStatusNameServer
		if qStatusNameServer != "" {

			if err := r.SetQueryParam("status.name_server", qStatusNameServer); err != nil {
				return err
			}
		}
	}

	if o.StatusState != nil {

		// query param status.state
		var qrStatusState string

		if o.StatusState != nil {
			qrStatusState = *o.StatusState
		}
		qStatusState := qrStatusState
		if qStatusState != "" {

			if err := r.SetQueryParam("status.state", qStatusState); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Timeout != nil {

		// query param timeout
		var qrTimeout int64

		if o.Timeout != nil {
			qrTimeout = *o.Timeout
		}
		qTimeout := swag.FormatInt64(qrTimeout)
		if qTimeout != "" {

			if err := r.SetQueryParam("timeout", qTimeout); err != nil {
				return err
			}
		}
	}

	if o.TldQueryEnabled != nil {

		// query param tld_query_enabled
		var qrTldQueryEnabled bool

		if o.TldQueryEnabled != nil {
			qrTldQueryEnabled = *o.TldQueryEnabled
		}
		qTldQueryEnabled := swag.FormatBool(qrTldQueryEnabled)
		if qTldQueryEnabled != "" {

			if err := r.SetQueryParam("tld_query_enabled", qTldQueryEnabled); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
