// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// GlobalCacheSettingGetReader is a Reader for the GlobalCacheSettingGet structure.
type GlobalCacheSettingGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GlobalCacheSettingGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGlobalCacheSettingGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGlobalCacheSettingGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGlobalCacheSettingGetOK creates a GlobalCacheSettingGetOK with default headers values
func NewGlobalCacheSettingGetOK() *GlobalCacheSettingGetOK {
	return &GlobalCacheSettingGetOK{}
}

/*
GlobalCacheSettingGetOK describes a response with status code 200, with default header values.

OK
*/
type GlobalCacheSettingGetOK struct {
	Payload *models.GlobalCacheSetting
}

// IsSuccess returns true when this global cache setting get o k response has a 2xx status code
func (o *GlobalCacheSettingGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this global cache setting get o k response has a 3xx status code
func (o *GlobalCacheSettingGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this global cache setting get o k response has a 4xx status code
func (o *GlobalCacheSettingGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this global cache setting get o k response has a 5xx status code
func (o *GlobalCacheSettingGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this global cache setting get o k response a status code equal to that given
func (o *GlobalCacheSettingGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the global cache setting get o k response
func (o *GlobalCacheSettingGetOK) Code() int {
	return 200
}

func (o *GlobalCacheSettingGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/setting][%d] globalCacheSettingGetOK %s", 200, payload)
}

func (o *GlobalCacheSettingGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/setting][%d] globalCacheSettingGetOK %s", 200, payload)
}

func (o *GlobalCacheSettingGetOK) GetPayload() *models.GlobalCacheSetting {
	return o.Payload
}

func (o *GlobalCacheSettingGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GlobalCacheSetting)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGlobalCacheSettingGetDefault creates a GlobalCacheSettingGetDefault with default headers values
func NewGlobalCacheSettingGetDefault(code int) *GlobalCacheSettingGetDefault {
	return &GlobalCacheSettingGetDefault{
		_statusCode: code,
	}
}

/*
GlobalCacheSettingGetDefault describes a response with status code -1, with default header values.

Error
*/
type GlobalCacheSettingGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this global cache setting get default response has a 2xx status code
func (o *GlobalCacheSettingGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this global cache setting get default response has a 3xx status code
func (o *GlobalCacheSettingGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this global cache setting get default response has a 4xx status code
func (o *GlobalCacheSettingGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this global cache setting get default response has a 5xx status code
func (o *GlobalCacheSettingGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this global cache setting get default response a status code equal to that given
func (o *GlobalCacheSettingGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the global cache setting get default response
func (o *GlobalCacheSettingGetDefault) Code() int {
	return o._statusCode
}

func (o *GlobalCacheSettingGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/setting][%d] global_cache_setting_get default %s", o._statusCode, payload)
}

func (o *GlobalCacheSettingGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/setting][%d] global_cache_setting_get default %s", o._statusCode, payload)
}

func (o *GlobalCacheSettingGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GlobalCacheSettingGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
