// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// GlobalCacheSettingModifyReader is a Reader for the GlobalCacheSettingModify structure.
type GlobalCacheSettingModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GlobalCacheSettingModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGlobalCacheSettingModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGlobalCacheSettingModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGlobalCacheSettingModifyOK creates a GlobalCacheSettingModifyOK with default headers values
func NewGlobalCacheSettingModifyOK() *GlobalCacheSettingModifyOK {
	return &GlobalCacheSettingModifyOK{}
}

/*
GlobalCacheSettingModifyOK describes a response with status code 200, with default header values.

OK
*/
type GlobalCacheSettingModifyOK struct {
}

// IsSuccess returns true when this global cache setting modify o k response has a 2xx status code
func (o *GlobalCacheSettingModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this global cache setting modify o k response has a 3xx status code
func (o *GlobalCacheSettingModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this global cache setting modify o k response has a 4xx status code
func (o *GlobalCacheSettingModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this global cache setting modify o k response has a 5xx status code
func (o *GlobalCacheSettingModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this global cache setting modify o k response a status code equal to that given
func (o *GlobalCacheSettingModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the global cache setting modify o k response
func (o *GlobalCacheSettingModifyOK) Code() int {
	return 200
}

func (o *GlobalCacheSettingModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /name-services/cache/setting][%d] globalCacheSettingModifyOK", 200)
}

func (o *GlobalCacheSettingModifyOK) String() string {
	return fmt.Sprintf("[PATCH /name-services/cache/setting][%d] globalCacheSettingModifyOK", 200)
}

func (o *GlobalCacheSettingModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGlobalCacheSettingModifyDefault creates a GlobalCacheSettingModifyDefault with default headers values
func NewGlobalCacheSettingModifyDefault(code int) *GlobalCacheSettingModifyDefault {
	return &GlobalCacheSettingModifyDefault{
		_statusCode: code,
	}
}

/*
GlobalCacheSettingModifyDefault describes a response with status code -1, with default header values.

Error
*/
type GlobalCacheSettingModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this global cache setting modify default response has a 2xx status code
func (o *GlobalCacheSettingModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this global cache setting modify default response has a 3xx status code
func (o *GlobalCacheSettingModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this global cache setting modify default response has a 4xx status code
func (o *GlobalCacheSettingModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this global cache setting modify default response has a 5xx status code
func (o *GlobalCacheSettingModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this global cache setting modify default response a status code equal to that given
func (o *GlobalCacheSettingModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the global cache setting modify default response
func (o *GlobalCacheSettingModifyDefault) Code() int {
	return o._statusCode
}

func (o *GlobalCacheSettingModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/cache/setting][%d] global_cache_setting_modify default %s", o._statusCode, payload)
}

func (o *GlobalCacheSettingModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/cache/setting][%d] global_cache_setting_modify default %s", o._statusCode, payload)
}

func (o *GlobalCacheSettingModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GlobalCacheSettingModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
