// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGroupMembershipSettingsGetParams creates a new GroupMembershipSettingsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGroupMembershipSettingsGetParams() *GroupMembershipSettingsGetParams {
	return &GroupMembershipSettingsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGroupMembershipSettingsGetParamsWithTimeout creates a new GroupMembershipSettingsGetParams object
// with the ability to set a timeout on a request.
func NewGroupMembershipSettingsGetParamsWithTimeout(timeout time.Duration) *GroupMembershipSettingsGetParams {
	return &GroupMembershipSettingsGetParams{
		timeout: timeout,
	}
}

// NewGroupMembershipSettingsGetParamsWithContext creates a new GroupMembershipSettingsGetParams object
// with the ability to set a context for a request.
func NewGroupMembershipSettingsGetParamsWithContext(ctx context.Context) *GroupMembershipSettingsGetParams {
	return &GroupMembershipSettingsGetParams{
		Context: ctx,
	}
}

// NewGroupMembershipSettingsGetParamsWithHTTPClient creates a new GroupMembershipSettingsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewGroupMembershipSettingsGetParamsWithHTTPClient(client *http.Client) *GroupMembershipSettingsGetParams {
	return &GroupMembershipSettingsGetParams{
		HTTPClient: client,
	}
}

/*
GroupMembershipSettingsGetParams contains all the parameters to send to the API endpoint

	for the group membership settings get operation.

	Typically these are written to a http.Request.
*/
type GroupMembershipSettingsGetParams struct {

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   SVM UUID.
	*/
	SvmUUID string

	/* TTL.

	   Filter by ttl
	*/
	TTL *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the group membership settings get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupMembershipSettingsGetParams) WithDefaults() *GroupMembershipSettingsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the group membership settings get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupMembershipSettingsGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := GroupMembershipSettingsGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) WithTimeout(timeout time.Duration) *GroupMembershipSettingsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) WithContext(ctx context.Context) *GroupMembershipSettingsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) WithHTTPClient(client *http.Client) *GroupMembershipSettingsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEnabled adds the enabled to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) WithEnabled(enabled *bool) *GroupMembershipSettingsGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) WithFields(fields []string) *GroupMembershipSettingsGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) WithMaxRecords(maxRecords *int64) *GroupMembershipSettingsGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) WithOrderBy(orderBy []string) *GroupMembershipSettingsGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) WithReturnRecords(returnRecords *bool) *GroupMembershipSettingsGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) WithReturnTimeout(returnTimeout *int64) *GroupMembershipSettingsGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) WithSvmName(svmName *string) *GroupMembershipSettingsGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) WithSvmUUID(svmUUID string) *GroupMembershipSettingsGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithTTL adds the ttl to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) WithTTL(ttl *string) *GroupMembershipSettingsGetParams {
	o.SetTTL(ttl)
	return o
}

// SetTTL adds the ttl to the group membership settings get params
func (o *GroupMembershipSettingsGetParams) SetTTL(ttl *string) {
	o.TTL = ttl
}

// WriteToRequest writes these params to a swagger request
func (o *GroupMembershipSettingsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.TTL != nil {

		// query param ttl
		var qrTTL string

		if o.TTL != nil {
			qrTTL = *o.TTL
		}
		qTTL := qrTTL
		if qTTL != "" {

			if err := r.SetQueryParam("ttl", qTTL); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGroupMembershipSettingsGet binds the parameter fields
func (o *GroupMembershipSettingsGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamGroupMembershipSettingsGet binds the parameter order_by
func (o *GroupMembershipSettingsGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
