// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// GroupMembershipSettingsModifyCollectionReader is a Reader for the GroupMembershipSettingsModifyCollection structure.
type GroupMembershipSettingsModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupMembershipSettingsModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupMembershipSettingsModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupMembershipSettingsModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupMembershipSettingsModifyCollectionOK creates a GroupMembershipSettingsModifyCollectionOK with default headers values
func NewGroupMembershipSettingsModifyCollectionOK() *GroupMembershipSettingsModifyCollectionOK {
	return &GroupMembershipSettingsModifyCollectionOK{}
}

/*
GroupMembershipSettingsModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type GroupMembershipSettingsModifyCollectionOK struct {
}

// IsSuccess returns true when this group membership settings modify collection o k response has a 2xx status code
func (o *GroupMembershipSettingsModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this group membership settings modify collection o k response has a 3xx status code
func (o *GroupMembershipSettingsModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this group membership settings modify collection o k response has a 4xx status code
func (o *GroupMembershipSettingsModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this group membership settings modify collection o k response has a 5xx status code
func (o *GroupMembershipSettingsModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this group membership settings modify collection o k response a status code equal to that given
func (o *GroupMembershipSettingsModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the group membership settings modify collection o k response
func (o *GroupMembershipSettingsModifyCollectionOK) Code() int {
	return 200
}

func (o *GroupMembershipSettingsModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /name-services/cache/group-membership/settings][%d] groupMembershipSettingsModifyCollectionOK", 200)
}

func (o *GroupMembershipSettingsModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /name-services/cache/group-membership/settings][%d] groupMembershipSettingsModifyCollectionOK", 200)
}

func (o *GroupMembershipSettingsModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGroupMembershipSettingsModifyCollectionDefault creates a GroupMembershipSettingsModifyCollectionDefault with default headers values
func NewGroupMembershipSettingsModifyCollectionDefault(code int) *GroupMembershipSettingsModifyCollectionDefault {
	return &GroupMembershipSettingsModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	GroupMembershipSettingsModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 23724055 | Internal error. Configuration for Vserver failed. Verify that the cluster is healthy, then try the command again. For further assistance, contact technical support. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type GroupMembershipSettingsModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this group membership settings modify collection default response has a 2xx status code
func (o *GroupMembershipSettingsModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this group membership settings modify collection default response has a 3xx status code
func (o *GroupMembershipSettingsModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this group membership settings modify collection default response has a 4xx status code
func (o *GroupMembershipSettingsModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this group membership settings modify collection default response has a 5xx status code
func (o *GroupMembershipSettingsModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this group membership settings modify collection default response a status code equal to that given
func (o *GroupMembershipSettingsModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the group membership settings modify collection default response
func (o *GroupMembershipSettingsModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *GroupMembershipSettingsModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/cache/group-membership/settings][%d] group_membership_settings_modify_collection default %s", o._statusCode, payload)
}

func (o *GroupMembershipSettingsModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/cache/group-membership/settings][%d] group_membership_settings_modify_collection default %s", o._statusCode, payload)
}

func (o *GroupMembershipSettingsModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GroupMembershipSettingsModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GroupMembershipSettingsModifyCollectionBody group membership settings modify collection body
swagger:model GroupMembershipSettingsModifyCollectionBody
*/
type GroupMembershipSettingsModifyCollectionBody struct {

	// links
	Links *models.GroupMembershipSettingsInlineLinks `json:"_links,omitempty"`

	// Specifies whether or not the cache is enabled.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// group membership settings response inline records
	GroupMembershipSettingsResponseInlineRecords []*models.GroupMembershipSettings `json:"records,omitempty"`

	// svm
	Svm *models.GroupMembershipSettingsInlineSvm `json:"svm,omitempty"`

	// Specifies Time to Live for list of group members, in ISO 8601 format.
	//
	// Example: PT2H30M
	TTL *string `json:"ttl,omitempty"`
}

// Validate validates this group membership settings modify collection body
func (o *GroupMembershipSettingsModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGroupMembershipSettingsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupMembershipSettingsModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *GroupMembershipSettingsModifyCollectionBody) validateGroupMembershipSettingsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.GroupMembershipSettingsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.GroupMembershipSettingsResponseInlineRecords); i++ {
		if swag.IsZero(o.GroupMembershipSettingsResponseInlineRecords[i]) { // not required
			continue
		}

		if o.GroupMembershipSettingsResponseInlineRecords[i] != nil {
			if err := o.GroupMembershipSettingsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *GroupMembershipSettingsModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this group membership settings modify collection body based on the context it is used
func (o *GroupMembershipSettingsModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGroupMembershipSettingsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupMembershipSettingsModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *GroupMembershipSettingsModifyCollectionBody) contextValidateGroupMembershipSettingsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.GroupMembershipSettingsResponseInlineRecords); i++ {

		if o.GroupMembershipSettingsResponseInlineRecords[i] != nil {
			if err := o.GroupMembershipSettingsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *GroupMembershipSettingsModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GroupMembershipSettingsModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GroupMembershipSettingsModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res GroupMembershipSettingsModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GroupMembershipSettingsInlineLinks group membership settings inline links
swagger:model group_membership_settings_inline__links
*/
type GroupMembershipSettingsInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this group membership settings inline links
func (o *GroupMembershipSettingsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupMembershipSettingsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this group membership settings inline links based on the context it is used
func (o *GroupMembershipSettingsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupMembershipSettingsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GroupMembershipSettingsInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GroupMembershipSettingsInlineLinks) UnmarshalBinary(b []byte) error {
	var res GroupMembershipSettingsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GroupMembershipSettingsInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model group_membership_settings_inline_svm
*/
type GroupMembershipSettingsInlineSvm struct {

	// links
	Links *models.GroupMembershipSettingsInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this group membership settings inline svm
func (o *GroupMembershipSettingsInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupMembershipSettingsInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this group membership settings inline svm based on the context it is used
func (o *GroupMembershipSettingsInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupMembershipSettingsInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GroupMembershipSettingsInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GroupMembershipSettingsInlineSvm) UnmarshalBinary(b []byte) error {
	var res GroupMembershipSettingsInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GroupMembershipSettingsInlineSvmInlineLinks group membership settings inline svm inline links
swagger:model group_membership_settings_inline_svm_inline__links
*/
type GroupMembershipSettingsInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this group membership settings inline svm inline links
func (o *GroupMembershipSettingsInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupMembershipSettingsInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this group membership settings inline svm inline links based on the context it is used
func (o *GroupMembershipSettingsInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupMembershipSettingsInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GroupMembershipSettingsInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GroupMembershipSettingsInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res GroupMembershipSettingsInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
