// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// GroupMembershipSettingsModifyReader is a Reader for the GroupMembershipSettingsModify structure.
type GroupMembershipSettingsModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupMembershipSettingsModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupMembershipSettingsModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupMembershipSettingsModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupMembershipSettingsModifyOK creates a GroupMembershipSettingsModifyOK with default headers values
func NewGroupMembershipSettingsModifyOK() *GroupMembershipSettingsModifyOK {
	return &GroupMembershipSettingsModifyOK{}
}

/*
GroupMembershipSettingsModifyOK describes a response with status code 200, with default header values.

OK
*/
type GroupMembershipSettingsModifyOK struct {
}

// IsSuccess returns true when this group membership settings modify o k response has a 2xx status code
func (o *GroupMembershipSettingsModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this group membership settings modify o k response has a 3xx status code
func (o *GroupMembershipSettingsModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this group membership settings modify o k response has a 4xx status code
func (o *GroupMembershipSettingsModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this group membership settings modify o k response has a 5xx status code
func (o *GroupMembershipSettingsModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this group membership settings modify o k response a status code equal to that given
func (o *GroupMembershipSettingsModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the group membership settings modify o k response
func (o *GroupMembershipSettingsModifyOK) Code() int {
	return 200
}

func (o *GroupMembershipSettingsModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /name-services/cache/group-membership/settings/{svm.uuid}][%d] groupMembershipSettingsModifyOK", 200)
}

func (o *GroupMembershipSettingsModifyOK) String() string {
	return fmt.Sprintf("[PATCH /name-services/cache/group-membership/settings/{svm.uuid}][%d] groupMembershipSettingsModifyOK", 200)
}

func (o *GroupMembershipSettingsModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGroupMembershipSettingsModifyDefault creates a GroupMembershipSettingsModifyDefault with default headers values
func NewGroupMembershipSettingsModifyDefault(code int) *GroupMembershipSettingsModifyDefault {
	return &GroupMembershipSettingsModifyDefault{
		_statusCode: code,
	}
}

/*
	GroupMembershipSettingsModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 23724055 | Internal error. Configuration for Vserver failed. Verify that the cluster is healthy, then try the command again. For further assistance, contact technical support. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type GroupMembershipSettingsModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this group membership settings modify default response has a 2xx status code
func (o *GroupMembershipSettingsModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this group membership settings modify default response has a 3xx status code
func (o *GroupMembershipSettingsModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this group membership settings modify default response has a 4xx status code
func (o *GroupMembershipSettingsModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this group membership settings modify default response has a 5xx status code
func (o *GroupMembershipSettingsModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this group membership settings modify default response a status code equal to that given
func (o *GroupMembershipSettingsModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the group membership settings modify default response
func (o *GroupMembershipSettingsModifyDefault) Code() int {
	return o._statusCode
}

func (o *GroupMembershipSettingsModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/cache/group-membership/settings/{svm.uuid}][%d] group_membership_settings_modify default %s", o._statusCode, payload)
}

func (o *GroupMembershipSettingsModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/cache/group-membership/settings/{svm.uuid}][%d] group_membership_settings_modify default %s", o._statusCode, payload)
}

func (o *GroupMembershipSettingsModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GroupMembershipSettingsModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
