// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewHostRecordGetParams creates a new HostRecordGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewHostRecordGetParams() *HostRecordGetParams {
	return &HostRecordGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewHostRecordGetParamsWithTimeout creates a new HostRecordGetParams object
// with the ability to set a timeout on a request.
func NewHostRecordGetParamsWithTimeout(timeout time.Duration) *HostRecordGetParams {
	return &HostRecordGetParams{
		timeout: timeout,
	}
}

// NewHostRecordGetParamsWithContext creates a new HostRecordGetParams object
// with the ability to set a context for a request.
func NewHostRecordGetParamsWithContext(ctx context.Context) *HostRecordGetParams {
	return &HostRecordGetParams{
		Context: ctx,
	}
}

// NewHostRecordGetParamsWithHTTPClient creates a new HostRecordGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewHostRecordGetParamsWithHTTPClient(client *http.Client) *HostRecordGetParams {
	return &HostRecordGetParams{
		HTTPClient: client,
	}
}

/*
HostRecordGetParams contains all the parameters to send to the API endpoint

	for the host record get operation.

	Typically these are written to a http.Request.
*/
type HostRecordGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Host.

	   Hostname or IP address.
	*/
	Host string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* UseCache.

	   Enables or disables the cache.
	*/
	UseCache *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the host record get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HostRecordGetParams) WithDefaults() *HostRecordGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the host record get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HostRecordGetParams) SetDefaults() {
	var (
		useCacheDefault = bool(false)
	)

	val := HostRecordGetParams{
		UseCache: &useCacheDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the host record get params
func (o *HostRecordGetParams) WithTimeout(timeout time.Duration) *HostRecordGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the host record get params
func (o *HostRecordGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the host record get params
func (o *HostRecordGetParams) WithContext(ctx context.Context) *HostRecordGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the host record get params
func (o *HostRecordGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the host record get params
func (o *HostRecordGetParams) WithHTTPClient(client *http.Client) *HostRecordGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the host record get params
func (o *HostRecordGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the host record get params
func (o *HostRecordGetParams) WithFields(fields []string) *HostRecordGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the host record get params
func (o *HostRecordGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithHost adds the host to the host record get params
func (o *HostRecordGetParams) WithHost(host string) *HostRecordGetParams {
	o.SetHost(host)
	return o
}

// SetHost adds the host to the host record get params
func (o *HostRecordGetParams) SetHost(host string) {
	o.Host = host
}

// WithSvmUUID adds the svmUUID to the host record get params
func (o *HostRecordGetParams) WithSvmUUID(svmUUID string) *HostRecordGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the host record get params
func (o *HostRecordGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithUseCache adds the useCache to the host record get params
func (o *HostRecordGetParams) WithUseCache(useCache *bool) *HostRecordGetParams {
	o.SetUseCache(useCache)
	return o
}

// SetUseCache adds the useCache to the host record get params
func (o *HostRecordGetParams) SetUseCache(useCache *bool) {
	o.UseCache = useCache
}

// WriteToRequest writes these params to a swagger request
func (o *HostRecordGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param host
	if err := r.SetPathParam("host", o.Host); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.UseCache != nil {

		// query param use_cache
		var qrUseCache bool

		if o.UseCache != nil {
			qrUseCache = *o.UseCache
		}
		qUseCache := swag.FormatBool(qrUseCache)
		if qUseCache != "" {

			if err := r.SetQueryParam("use_cache", qUseCache); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamHostRecordGet binds the parameter fields
func (o *HostRecordGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
