// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewHostsSettingsCollectionGetParams creates a new HostsSettingsCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewHostsSettingsCollectionGetParams() *HostsSettingsCollectionGetParams {
	return &HostsSettingsCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewHostsSettingsCollectionGetParamsWithTimeout creates a new HostsSettingsCollectionGetParams object
// with the ability to set a timeout on a request.
func NewHostsSettingsCollectionGetParamsWithTimeout(timeout time.Duration) *HostsSettingsCollectionGetParams {
	return &HostsSettingsCollectionGetParams{
		timeout: timeout,
	}
}

// NewHostsSettingsCollectionGetParamsWithContext creates a new HostsSettingsCollectionGetParams object
// with the ability to set a context for a request.
func NewHostsSettingsCollectionGetParamsWithContext(ctx context.Context) *HostsSettingsCollectionGetParams {
	return &HostsSettingsCollectionGetParams{
		Context: ctx,
	}
}

// NewHostsSettingsCollectionGetParamsWithHTTPClient creates a new HostsSettingsCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewHostsSettingsCollectionGetParamsWithHTTPClient(client *http.Client) *HostsSettingsCollectionGetParams {
	return &HostsSettingsCollectionGetParams{
		HTTPClient: client,
	}
}

/*
HostsSettingsCollectionGetParams contains all the parameters to send to the API endpoint

	for the hosts settings collection get operation.

	Typically these are written to a http.Request.
*/
type HostsSettingsCollectionGetParams struct {

	/* DNSTTLEnabled.

	   Filter by dns_ttl_enabled
	*/
	DNSTTLEnabled *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NegativeCacheEnabled.

	   Filter by negative_cache_enabled
	*/
	NegativeCacheEnabled *bool

	/* NegativeTTL.

	   Filter by negative_ttl
	*/
	NegativeTTL *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TTL.

	   Filter by ttl
	*/
	TTL *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the hosts settings collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HostsSettingsCollectionGetParams) WithDefaults() *HostsSettingsCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the hosts settings collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HostsSettingsCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := HostsSettingsCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithTimeout(timeout time.Duration) *HostsSettingsCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithContext(ctx context.Context) *HostsSettingsCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithHTTPClient(client *http.Client) *HostsSettingsCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDNSTTLEnabled adds the dNSTTLEnabled to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithDNSTTLEnabled(dNSTTLEnabled *bool) *HostsSettingsCollectionGetParams {
	o.SetDNSTTLEnabled(dNSTTLEnabled)
	return o
}

// SetDNSTTLEnabled adds the dnsTtlEnabled to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetDNSTTLEnabled(dNSTTLEnabled *bool) {
	o.DNSTTLEnabled = dNSTTLEnabled
}

// WithEnabled adds the enabled to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithEnabled(enabled *bool) *HostsSettingsCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithFields(fields []string) *HostsSettingsCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithMaxRecords(maxRecords *int64) *HostsSettingsCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNegativeCacheEnabled adds the negativeCacheEnabled to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithNegativeCacheEnabled(negativeCacheEnabled *bool) *HostsSettingsCollectionGetParams {
	o.SetNegativeCacheEnabled(negativeCacheEnabled)
	return o
}

// SetNegativeCacheEnabled adds the negativeCacheEnabled to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetNegativeCacheEnabled(negativeCacheEnabled *bool) {
	o.NegativeCacheEnabled = negativeCacheEnabled
}

// WithNegativeTTL adds the negativeTTL to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithNegativeTTL(negativeTTL *string) *HostsSettingsCollectionGetParams {
	o.SetNegativeTTL(negativeTTL)
	return o
}

// SetNegativeTTL adds the negativeTtl to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetNegativeTTL(negativeTTL *string) {
	o.NegativeTTL = negativeTTL
}

// WithOrderBy adds the orderBy to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithOrderBy(orderBy []string) *HostsSettingsCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithReturnRecords(returnRecords *bool) *HostsSettingsCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *HostsSettingsCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithSvmName(svmName *string) *HostsSettingsCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithSvmUUID(svmUUID *string) *HostsSettingsCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTTL adds the ttl to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithTTL(ttl *string) *HostsSettingsCollectionGetParams {
	o.SetTTL(ttl)
	return o
}

// SetTTL adds the ttl to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetTTL(ttl *string) {
	o.TTL = ttl
}

// WithUUID adds the uuid to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) WithUUID(uuid *string) *HostsSettingsCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the hosts settings collection get params
func (o *HostsSettingsCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *HostsSettingsCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DNSTTLEnabled != nil {

		// query param dns_ttl_enabled
		var qrDNSTTLEnabled bool

		if o.DNSTTLEnabled != nil {
			qrDNSTTLEnabled = *o.DNSTTLEnabled
		}
		qDNSTTLEnabled := swag.FormatBool(qrDNSTTLEnabled)
		if qDNSTTLEnabled != "" {

			if err := r.SetQueryParam("dns_ttl_enabled", qDNSTTLEnabled); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NegativeCacheEnabled != nil {

		// query param negative_cache_enabled
		var qrNegativeCacheEnabled bool

		if o.NegativeCacheEnabled != nil {
			qrNegativeCacheEnabled = *o.NegativeCacheEnabled
		}
		qNegativeCacheEnabled := swag.FormatBool(qrNegativeCacheEnabled)
		if qNegativeCacheEnabled != "" {

			if err := r.SetQueryParam("negative_cache_enabled", qNegativeCacheEnabled); err != nil {
				return err
			}
		}
	}

	if o.NegativeTTL != nil {

		// query param negative_ttl
		var qrNegativeTTL string

		if o.NegativeTTL != nil {
			qrNegativeTTL = *o.NegativeTTL
		}
		qNegativeTTL := qrNegativeTTL
		if qNegativeTTL != "" {

			if err := r.SetQueryParam("negative_ttl", qNegativeTTL); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TTL != nil {

		// query param ttl
		var qrTTL string

		if o.TTL != nil {
			qrTTL = *o.TTL
		}
		qTTL := qrTTL
		if qTTL != "" {

			if err := r.SetQueryParam("ttl", qTTL); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamHostsSettingsCollectionGet binds the parameter fields
func (o *HostsSettingsCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamHostsSettingsCollectionGet binds the parameter order_by
func (o *HostsSettingsCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
