// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// HostsSettingsCollectionGetReader is a Reader for the HostsSettingsCollectionGet structure.
type HostsSettingsCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *HostsSettingsCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewHostsSettingsCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewHostsSettingsCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewHostsSettingsCollectionGetOK creates a HostsSettingsCollectionGetOK with default headers values
func NewHostsSettingsCollectionGetOK() *HostsSettingsCollectionGetOK {
	return &HostsSettingsCollectionGetOK{}
}

/*
HostsSettingsCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type HostsSettingsCollectionGetOK struct {
	Payload *models.HostsSettingsResponse
}

// IsSuccess returns true when this hosts settings collection get o k response has a 2xx status code
func (o *HostsSettingsCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this hosts settings collection get o k response has a 3xx status code
func (o *HostsSettingsCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this hosts settings collection get o k response has a 4xx status code
func (o *HostsSettingsCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this hosts settings collection get o k response has a 5xx status code
func (o *HostsSettingsCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this hosts settings collection get o k response a status code equal to that given
func (o *HostsSettingsCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the hosts settings collection get o k response
func (o *HostsSettingsCollectionGetOK) Code() int {
	return 200
}

func (o *HostsSettingsCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/host/settings][%d] hostsSettingsCollectionGetOK %s", 200, payload)
}

func (o *HostsSettingsCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/host/settings][%d] hostsSettingsCollectionGetOK %s", 200, payload)
}

func (o *HostsSettingsCollectionGetOK) GetPayload() *models.HostsSettingsResponse {
	return o.Payload
}

func (o *HostsSettingsCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HostsSettingsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewHostsSettingsCollectionGetDefault creates a HostsSettingsCollectionGetDefault with default headers values
func NewHostsSettingsCollectionGetDefault(code int) *HostsSettingsCollectionGetDefault {
	return &HostsSettingsCollectionGetDefault{
		_statusCode: code,
	}
}

/*
HostsSettingsCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type HostsSettingsCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this hosts settings collection get default response has a 2xx status code
func (o *HostsSettingsCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this hosts settings collection get default response has a 3xx status code
func (o *HostsSettingsCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this hosts settings collection get default response has a 4xx status code
func (o *HostsSettingsCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this hosts settings collection get default response has a 5xx status code
func (o *HostsSettingsCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this hosts settings collection get default response a status code equal to that given
func (o *HostsSettingsCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the hosts settings collection get default response
func (o *HostsSettingsCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *HostsSettingsCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/host/settings][%d] hosts_settings_collection_get default %s", o._statusCode, payload)
}

func (o *HostsSettingsCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/host/settings][%d] hosts_settings_collection_get default %s", o._statusCode, payload)
}

func (o *HostsSettingsCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *HostsSettingsCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
