// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// HostsSettingsModifyCollectionReader is a Reader for the HostsSettingsModifyCollection structure.
type HostsSettingsModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *HostsSettingsModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewHostsSettingsModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewHostsSettingsModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewHostsSettingsModifyCollectionOK creates a HostsSettingsModifyCollectionOK with default headers values
func NewHostsSettingsModifyCollectionOK() *HostsSettingsModifyCollectionOK {
	return &HostsSettingsModifyCollectionOK{}
}

/*
HostsSettingsModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type HostsSettingsModifyCollectionOK struct {
}

// IsSuccess returns true when this hosts settings modify collection o k response has a 2xx status code
func (o *HostsSettingsModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this hosts settings modify collection o k response has a 3xx status code
func (o *HostsSettingsModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this hosts settings modify collection o k response has a 4xx status code
func (o *HostsSettingsModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this hosts settings modify collection o k response has a 5xx status code
func (o *HostsSettingsModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this hosts settings modify collection o k response a status code equal to that given
func (o *HostsSettingsModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the hosts settings modify collection o k response
func (o *HostsSettingsModifyCollectionOK) Code() int {
	return 200
}

func (o *HostsSettingsModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /name-services/cache/host/settings][%d] hostsSettingsModifyCollectionOK", 200)
}

func (o *HostsSettingsModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /name-services/cache/host/settings][%d] hostsSettingsModifyCollectionOK", 200)
}

func (o *HostsSettingsModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewHostsSettingsModifyCollectionDefault creates a HostsSettingsModifyCollectionDefault with default headers values
func NewHostsSettingsModifyCollectionDefault(code int) *HostsSettingsModifyCollectionDefault {
	return &HostsSettingsModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	HostsSettingsModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 23724055 | Internal error. Configuration for Vserver failed. Verify that the cluster is healthy, then try the command again. For further assistance, contact technical support. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type HostsSettingsModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this hosts settings modify collection default response has a 2xx status code
func (o *HostsSettingsModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this hosts settings modify collection default response has a 3xx status code
func (o *HostsSettingsModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this hosts settings modify collection default response has a 4xx status code
func (o *HostsSettingsModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this hosts settings modify collection default response has a 5xx status code
func (o *HostsSettingsModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this hosts settings modify collection default response a status code equal to that given
func (o *HostsSettingsModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the hosts settings modify collection default response
func (o *HostsSettingsModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *HostsSettingsModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/cache/host/settings][%d] hosts_settings_modify_collection default %s", o._statusCode, payload)
}

func (o *HostsSettingsModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/cache/host/settings][%d] hosts_settings_modify_collection default %s", o._statusCode, payload)
}

func (o *HostsSettingsModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *HostsSettingsModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
HostsSettingsModifyCollectionBody hosts settings modify collection body
swagger:model HostsSettingsModifyCollectionBody
*/
type HostsSettingsModifyCollectionBody struct {

	// links
	Links *models.HostsSettingsInlineLinks `json:"_links,omitempty"`

	// Specifies whether TTL is based on the DNS or host settings. If enabled, TTL from DNS is used.
	//
	// Example: true
	DNSTTLEnabled *bool `json:"dns_ttl_enabled,omitempty"`

	// Indicates whether or not the cache is enabled.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// hosts settings response inline records
	HostsSettingsResponseInlineRecords []*models.HostsSettings `json:"records,omitempty"`

	// Indicates whether or not the negative cache is enabled.
	//
	NegativeCacheEnabled *bool `json:"negative_cache_enabled,omitempty"`

	// Specifies negative Time to Live, in ISO 8601 format.
	//
	// Example: PT5M
	NegativeTTL *string `json:"negative_ttl,omitempty"`

	// svm
	Svm *models.HostsSettingsInlineSvm `json:"svm,omitempty"`

	// Specifies Time to Live (TTL), in ISO 8601 format.
	//
	// Example: PT24H
	TTL *string `json:"ttl,omitempty"`

	// UUID for the host record.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this hosts settings modify collection body
func (o *HostsSettingsModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHostsSettingsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *HostsSettingsModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *HostsSettingsModifyCollectionBody) validateHostsSettingsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.HostsSettingsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.HostsSettingsResponseInlineRecords); i++ {
		if swag.IsZero(o.HostsSettingsResponseInlineRecords[i]) { // not required
			continue
		}

		if o.HostsSettingsResponseInlineRecords[i] != nil {
			if err := o.HostsSettingsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *HostsSettingsModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hosts settings modify collection body based on the context it is used
func (o *HostsSettingsModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHostsSettingsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *HostsSettingsModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *HostsSettingsModifyCollectionBody) contextValidateHostsSettingsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.HostsSettingsResponseInlineRecords); i++ {

		if o.HostsSettingsResponseInlineRecords[i] != nil {
			if err := o.HostsSettingsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *HostsSettingsModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *HostsSettingsModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *HostsSettingsModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res HostsSettingsModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
HostsSettingsInlineLinks hosts settings inline links
swagger:model hosts_settings_inline__links
*/
type HostsSettingsInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this hosts settings inline links
func (o *HostsSettingsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *HostsSettingsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hosts settings inline links based on the context it is used
func (o *HostsSettingsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *HostsSettingsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *HostsSettingsInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *HostsSettingsInlineLinks) UnmarshalBinary(b []byte) error {
	var res HostsSettingsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
HostsSettingsInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model hosts_settings_inline_svm
*/
type HostsSettingsInlineSvm struct {

	// links
	Links *models.HostsSettingsInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this hosts settings inline svm
func (o *HostsSettingsInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *HostsSettingsInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hosts settings inline svm based on the context it is used
func (o *HostsSettingsInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *HostsSettingsInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *HostsSettingsInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *HostsSettingsInlineSvm) UnmarshalBinary(b []byte) error {
	var res HostsSettingsInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
HostsSettingsInlineSvmInlineLinks hosts settings inline svm inline links
swagger:model hosts_settings_inline_svm_inline__links
*/
type HostsSettingsInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this hosts settings inline svm inline links
func (o *HostsSettingsInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *HostsSettingsInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hosts settings inline svm inline links based on the context it is used
func (o *HostsSettingsInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *HostsSettingsInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *HostsSettingsInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *HostsSettingsInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res HostsSettingsInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
