// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewHostsSettingsModifyParams creates a new HostsSettingsModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewHostsSettingsModifyParams() *HostsSettingsModifyParams {
	return &HostsSettingsModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewHostsSettingsModifyParamsWithTimeout creates a new HostsSettingsModifyParams object
// with the ability to set a timeout on a request.
func NewHostsSettingsModifyParamsWithTimeout(timeout time.Duration) *HostsSettingsModifyParams {
	return &HostsSettingsModifyParams{
		timeout: timeout,
	}
}

// NewHostsSettingsModifyParamsWithContext creates a new HostsSettingsModifyParams object
// with the ability to set a context for a request.
func NewHostsSettingsModifyParamsWithContext(ctx context.Context) *HostsSettingsModifyParams {
	return &HostsSettingsModifyParams{
		Context: ctx,
	}
}

// NewHostsSettingsModifyParamsWithHTTPClient creates a new HostsSettingsModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewHostsSettingsModifyParamsWithHTTPClient(client *http.Client) *HostsSettingsModifyParams {
	return &HostsSettingsModifyParams{
		HTTPClient: client,
	}
}

/*
HostsSettingsModifyParams contains all the parameters to send to the API endpoint

	for the hosts settings modify operation.

	Typically these are written to a http.Request.
*/
type HostsSettingsModifyParams struct {

	/* Info.

	   Info specification.
	*/
	Info *models.HostsSettings

	/* UUID.

	   UUID for the host record.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the hosts settings modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HostsSettingsModifyParams) WithDefaults() *HostsSettingsModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the hosts settings modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *HostsSettingsModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the hosts settings modify params
func (o *HostsSettingsModifyParams) WithTimeout(timeout time.Duration) *HostsSettingsModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the hosts settings modify params
func (o *HostsSettingsModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the hosts settings modify params
func (o *HostsSettingsModifyParams) WithContext(ctx context.Context) *HostsSettingsModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the hosts settings modify params
func (o *HostsSettingsModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the hosts settings modify params
func (o *HostsSettingsModifyParams) WithHTTPClient(client *http.Client) *HostsSettingsModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the hosts settings modify params
func (o *HostsSettingsModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the hosts settings modify params
func (o *HostsSettingsModifyParams) WithInfo(info *models.HostsSettings) *HostsSettingsModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the hosts settings modify params
func (o *HostsSettingsModifyParams) SetInfo(info *models.HostsSettings) {
	o.Info = info
}

// WithUUID adds the uuid to the hosts settings modify params
func (o *HostsSettingsModifyParams) WithUUID(uuid string) *HostsSettingsModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the hosts settings modify params
func (o *HostsSettingsModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *HostsSettingsModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
