// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewLdapCreateParams creates a new LdapCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLdapCreateParams() *LdapCreateParams {
	return &LdapCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLdapCreateParamsWithTimeout creates a new LdapCreateParams object
// with the ability to set a timeout on a request.
func NewLdapCreateParamsWithTimeout(timeout time.Duration) *LdapCreateParams {
	return &LdapCreateParams{
		timeout: timeout,
	}
}

// NewLdapCreateParamsWithContext creates a new LdapCreateParams object
// with the ability to set a context for a request.
func NewLdapCreateParamsWithContext(ctx context.Context) *LdapCreateParams {
	return &LdapCreateParams{
		Context: ctx,
	}
}

// NewLdapCreateParamsWithHTTPClient creates a new LdapCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewLdapCreateParamsWithHTTPClient(client *http.Client) *LdapCreateParams {
	return &LdapCreateParams{
		HTTPClient: client,
	}
}

/*
LdapCreateParams contains all the parameters to send to the API endpoint

	for the ldap create operation.

	Typically these are written to a http.Request.
*/
type LdapCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.LdapService

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ldap create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LdapCreateParams) WithDefaults() *LdapCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ldap create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LdapCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := LdapCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ldap create params
func (o *LdapCreateParams) WithTimeout(timeout time.Duration) *LdapCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ldap create params
func (o *LdapCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ldap create params
func (o *LdapCreateParams) WithContext(ctx context.Context) *LdapCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ldap create params
func (o *LdapCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ldap create params
func (o *LdapCreateParams) WithHTTPClient(client *http.Client) *LdapCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ldap create params
func (o *LdapCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the ldap create params
func (o *LdapCreateParams) WithInfo(info *models.LdapService) *LdapCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ldap create params
func (o *LdapCreateParams) SetInfo(info *models.LdapService) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the ldap create params
func (o *LdapCreateParams) WithReturnRecords(returnRecords *bool) *LdapCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ldap create params
func (o *LdapCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *LdapCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
