// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewLdapDeleteParams creates a new LdapDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLdapDeleteParams() *LdapDeleteParams {
	return &LdapDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLdapDeleteParamsWithTimeout creates a new LdapDeleteParams object
// with the ability to set a timeout on a request.
func NewLdapDeleteParamsWithTimeout(timeout time.Duration) *LdapDeleteParams {
	return &LdapDeleteParams{
		timeout: timeout,
	}
}

// NewLdapDeleteParamsWithContext creates a new LdapDeleteParams object
// with the ability to set a context for a request.
func NewLdapDeleteParamsWithContext(ctx context.Context) *LdapDeleteParams {
	return &LdapDeleteParams{
		Context: ctx,
	}
}

// NewLdapDeleteParamsWithHTTPClient creates a new LdapDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewLdapDeleteParamsWithHTTPClient(client *http.Client) *LdapDeleteParams {
	return &LdapDeleteParams{
		HTTPClient: client,
	}
}

/*
LdapDeleteParams contains all the parameters to send to the API endpoint

	for the ldap delete operation.

	Typically these are written to a http.Request.
*/
type LdapDeleteParams struct {

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ldap delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LdapDeleteParams) WithDefaults() *LdapDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ldap delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LdapDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the ldap delete params
func (o *LdapDeleteParams) WithTimeout(timeout time.Duration) *LdapDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ldap delete params
func (o *LdapDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ldap delete params
func (o *LdapDeleteParams) WithContext(ctx context.Context) *LdapDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ldap delete params
func (o *LdapDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ldap delete params
func (o *LdapDeleteParams) WithHTTPClient(client *http.Client) *LdapDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ldap delete params
func (o *LdapDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithSvmUUID adds the svmUUID to the ldap delete params
func (o *LdapDeleteParams) WithSvmUUID(svmUUID string) *LdapDeleteParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the ldap delete params
func (o *LdapDeleteParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *LdapDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
