// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LdapDeleteReader is a Reader for the LdapDelete structure.
type LdapDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LdapDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLdapDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLdapDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLdapDeleteOK creates a LdapDeleteOK with default headers values
func NewLdapDeleteOK() *LdapDeleteOK {
	return &LdapDeleteOK{}
}

/*
LdapDeleteOK describes a response with status code 200, with default header values.

OK
*/
type LdapDeleteOK struct {
}

// IsSuccess returns true when this ldap delete o k response has a 2xx status code
func (o *LdapDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ldap delete o k response has a 3xx status code
func (o *LdapDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ldap delete o k response has a 4xx status code
func (o *LdapDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ldap delete o k response has a 5xx status code
func (o *LdapDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ldap delete o k response a status code equal to that given
func (o *LdapDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ldap delete o k response
func (o *LdapDeleteOK) Code() int {
	return 200
}

func (o *LdapDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /name-services/ldap/{svm.uuid}][%d] ldapDeleteOK", 200)
}

func (o *LdapDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /name-services/ldap/{svm.uuid}][%d] ldapDeleteOK", 200)
}

func (o *LdapDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLdapDeleteDefault creates a LdapDeleteDefault with default headers values
func NewLdapDeleteDefault(code int) *LdapDeleteDefault {
	return &LdapDeleteDefault{
		_statusCode: code,
	}
}

/*
LdapDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type LdapDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ldap delete default response has a 2xx status code
func (o *LdapDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ldap delete default response has a 3xx status code
func (o *LdapDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ldap delete default response has a 4xx status code
func (o *LdapDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ldap delete default response has a 5xx status code
func (o *LdapDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ldap delete default response a status code equal to that given
func (o *LdapDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ldap delete default response
func (o *LdapDeleteDefault) Code() int {
	return o._statusCode
}

func (o *LdapDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/ldap/{svm.uuid}][%d] ldap_delete default %s", o._statusCode, payload)
}

func (o *LdapDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/ldap/{svm.uuid}][%d] ldap_delete default %s", o._statusCode, payload)
}

func (o *LdapDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LdapDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
