// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LdapGetReader is a Reader for the LdapGet structure.
type LdapGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LdapGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLdapGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLdapGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLdapGetOK creates a LdapGetOK with default headers values
func NewLdapGetOK() *LdapGetOK {
	return &LdapGetOK{}
}

/*
LdapGetOK describes a response with status code 200, with default header values.

OK
*/
type LdapGetOK struct {
	Payload *models.LdapService
}

// IsSuccess returns true when this ldap get o k response has a 2xx status code
func (o *LdapGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ldap get o k response has a 3xx status code
func (o *LdapGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ldap get o k response has a 4xx status code
func (o *LdapGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ldap get o k response has a 5xx status code
func (o *LdapGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ldap get o k response a status code equal to that given
func (o *LdapGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ldap get o k response
func (o *LdapGetOK) Code() int {
	return 200
}

func (o *LdapGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/ldap/{svm.uuid}][%d] ldapGetOK %s", 200, payload)
}

func (o *LdapGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/ldap/{svm.uuid}][%d] ldapGetOK %s", 200, payload)
}

func (o *LdapGetOK) GetPayload() *models.LdapService {
	return o.Payload
}

func (o *LdapGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LdapService)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLdapGetDefault creates a LdapGetDefault with default headers values
func NewLdapGetDefault(code int) *LdapGetDefault {
	return &LdapGetDefault{
		_statusCode: code,
	}
}

/*
LdapGetDefault describes a response with status code -1, with default header values.

Error
*/
type LdapGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ldap get default response has a 2xx status code
func (o *LdapGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ldap get default response has a 3xx status code
func (o *LdapGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ldap get default response has a 4xx status code
func (o *LdapGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ldap get default response has a 5xx status code
func (o *LdapGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ldap get default response a status code equal to that given
func (o *LdapGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ldap get default response
func (o *LdapGetDefault) Code() int {
	return o._statusCode
}

func (o *LdapGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/ldap/{svm.uuid}][%d] ldap_get default %s", o._statusCode, payload)
}

func (o *LdapGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/ldap/{svm.uuid}][%d] ldap_get default %s", o._statusCode, payload)
}

func (o *LdapGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LdapGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
