// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LdapModifyCollectionReader is a Reader for the LdapModifyCollection structure.
type LdapModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LdapModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLdapModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLdapModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLdapModifyCollectionOK creates a LdapModifyCollectionOK with default headers values
func NewLdapModifyCollectionOK() *LdapModifyCollectionOK {
	return &LdapModifyCollectionOK{}
}

/*
LdapModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type LdapModifyCollectionOK struct {
}

// IsSuccess returns true when this ldap modify collection o k response has a 2xx status code
func (o *LdapModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ldap modify collection o k response has a 3xx status code
func (o *LdapModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ldap modify collection o k response has a 4xx status code
func (o *LdapModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ldap modify collection o k response has a 5xx status code
func (o *LdapModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ldap modify collection o k response a status code equal to that given
func (o *LdapModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ldap modify collection o k response
func (o *LdapModifyCollectionOK) Code() int {
	return 200
}

func (o *LdapModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /name-services/ldap][%d] ldapModifyCollectionOK", 200)
}

func (o *LdapModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /name-services/ldap][%d] ldapModifyCollectionOK", 200)
}

func (o *LdapModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLdapModifyCollectionDefault creates a LdapModifyCollectionDefault with default headers values
func NewLdapModifyCollectionDefault(code int) *LdapModifyCollectionDefault {
	return &LdapModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	LdapModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262186     | LDAP Servers cannot be used with Active Directory domain and/or preferred Active Directory servers |
| 2621488    | Invalid SVM context |
| 2621706    | The specified SVM UUID is incorrect for the specified SVM name |
| 4915203    | The specified LDAP schema does not exist |
| 262222     | The specified LDAP servers or preferred Active Directory servers contain duplicate server entries |
| 4915229    | DNS resolution failed due to an internal error. Contact technical support if this issue persists |
| 4915231    | DNS resolution failed for one or more of the specified LDAP servers. Verify that a valid DNS server is configured |
| 23724132   | DNS resolution failed for all the specified LDAP servers. Verify that a valid DNS server is configured |
| 4915234    | The specified LDAP server or preferred Active Directory server is not supported because it is one of the following: multicast, loopback, 0.0.0.0, or broadcast |
| 4915248    | LDAP servers cannot be empty or "-". Specified Active Directory domain is invalid because it is empty or "-" or it contains either the special characters or "-" at the start or end of the domain. |
| 4915251    | STARTTLS and LDAPS cannot be used together |
| 4915257    | The LDAP configuration is invalid. Verify that the distinguished names and bind password are correct |
| 4915258    | The LDAP configuration is invalid. Verify that the Active Directory domain or servers are reachable and that the network configuration is correct |
| 4915259    | LDAP configurations with Active Directory domains are not supported on admin SVM. |
| 23724130   | Cannot use an IPv6 name server address because there are no IPv6 LIFs |
| 4915252    | LDAP Referral is not supported with STARTTLS, with session security levels sign, seal or with LDAPS. |
| 4915266    | LDAP site discovery restriction cannot be applied to a mixed version cluster. |
| 656484     | The default site needs to be specified to enable site restriction. |
| 4915206    | CIFS server is not configured for the vserver. LDAP client configuration requires CIFS server for binding. |
| 4915244    | RPC failure occurred during validation of the LDAP configuration. |
| 4915268    | The bind_as_cifs_server field cannot be set to true when the CIFS server is in workgroup mode. |
| 4915269    | The bind_as_cifs_server field cannot be set to true when the CIFS server is in realm mode. |
*/
type LdapModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ldap modify collection default response has a 2xx status code
func (o *LdapModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ldap modify collection default response has a 3xx status code
func (o *LdapModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ldap modify collection default response has a 4xx status code
func (o *LdapModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ldap modify collection default response has a 5xx status code
func (o *LdapModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ldap modify collection default response a status code equal to that given
func (o *LdapModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ldap modify collection default response
func (o *LdapModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *LdapModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/ldap][%d] ldap_modify_collection default %s", o._statusCode, payload)
}

func (o *LdapModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/ldap][%d] ldap_modify_collection default %s", o._statusCode, payload)
}

func (o *LdapModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LdapModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
LdapModifyCollectionBody ldap modify collection body
swagger:model LdapModifyCollectionBody
*/
type LdapModifyCollectionBody struct {

	// links
	Links *models.LdapServiceInlineLinks `json:"_links,omitempty"`

	// This parameter specifies the name of the Active Directory domain
	// used to discover LDAP servers for use by this client.
	// This is mutually exclusive with `servers` during POST and PATCH.
	//
	// Example: example.com
	AdDomain *string `json:"ad_domain,omitempty"`

	// Specifies the default base DN for all searches.
	// Example: dc=domainB,dc=example,dc=com
	BaseDn *string `json:"base_dn,omitempty"`

	// Specifies the default search scope for LDAP queries:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	BaseScope *string `json:"base_scope,omitempty"`

	// Specifies whether or not CIFS server's credentials are used to bind to the LDAP server.
	//
	BindAsCifsServer *bool `json:"bind_as_cifs_server,omitempty"`

	// Specifies the user that binds to the LDAP servers.
	// Example: cn=Administrators,cn=users,dc=domainB,dc=example,dc=com
	BindDn *string `json:"bind_dn,omitempty"`

	// Specifies the bind password for the LDAP servers.
	// Example: abc
	BindPassword *string `json:"bind_password,omitempty"`

	// Specifies the group Distinguished Name (DN) that is used as the starting point in the LDAP directory tree for group lookups.
	// Example: cn=abc,users,dc=com
	GroupDn *string `json:"group_dn,omitempty"`

	// Specifies the custom filter used for group membership lookups from an LDAP server.
	//
	GroupMembershipFilter *string `json:"group_membership_filter,omitempty"`

	// Specifies the default search scope for LDAP for group lookups:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	GroupScope *string `json:"group_scope,omitempty"`

	// Specifies whether or not netgroup by host querying is enabled.
	//
	IsNetgroupByhostEnabled *bool `json:"is_netgroup_byhost_enabled,omitempty"`

	// Specifies whether or not the SVM owns the LDAP client configuration.
	//
	// Read Only: true
	IsOwner *bool `json:"is_owner,omitempty"`

	// ldap service inline preferred ad servers
	LdapServiceInlinePreferredAdServers []*string `json:"preferred_ad_servers,omitempty"`

	// ldap service inline servers
	LdapServiceInlineServers []*string `json:"servers,omitempty"`

	// ldap service response inline records
	LdapServiceResponseInlineRecords []*models.LdapService `json:"records,omitempty"`

	// Specifies whether or not LDAPS is enabled.
	//
	LdapsEnabled *bool `json:"ldaps_enabled,omitempty"`

	// The minimum bind authentication level. Possible values are:
	// * anonymous - anonymous bind
	// * simple - simple bind
	// * sasl - Simple Authentication and Security Layer (SASL) bind
	//
	// Enum: ["anonymous","simple","sasl"]
	MinBindLevel *string `json:"min_bind_level,omitempty"`

	// Specifies the netgroup Distinguished Name (DN) that is used as the starting point in the LDAP directory tree for netgroup by host lookups.
	// Example: cn=abc,users,dc=com
	NetgroupByhostDn *string `json:"netgroup_byhost_dn,omitempty"`

	// Specifies the default search scope for LDAP for netgroup by host lookups:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	NetgroupByhostScope *string `json:"netgroup_byhost_scope,omitempty"`

	// Specifies the netgroup Distinguished Name (DN) that is used as the starting point in the LDAP directory tree for netgroup lookups.
	// Example: cn=abc,users,dc=com
	NetgroupDn *string `json:"netgroup_dn,omitempty"`

	// Specifies the default search scope for LDAP for netgroup lookups:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	NetgroupScope *string `json:"netgroup_scope,omitempty"`

	// The port used to connect to the LDAP Servers.
	// Example: 389
	// Maximum: 65535
	// Minimum: 1
	Port *int64 `json:"port,omitempty"`

	// Specifies the maximum time to wait for a query response from the LDAP server, in seconds.
	//
	QueryTimeout *int64 `json:"query_timeout,omitempty"`

	// Specifies whether or not LDAP referral is enabled.
	//
	ReferralEnabled *bool `json:"referral_enabled,omitempty"`

	// Specifies whether or not LDAP server discovery is restricted to site-scope.
	//
	RestrictDiscoveryToSite *bool `json:"restrict_discovery_to_site,omitempty"`

	// The name of the schema template used by the SVM.
	// * AD-IDMU - Active Directory Identity Management for UNIX
	// * AD-SFU - Active Directory Services for UNIX
	// * MS-AD-BIS - Active Directory Identity Management for UNIX
	// * RFC-2307 - Schema based on RFC 2307
	// * Custom schema
	//
	// Example: ad_idmu
	Schema *string `json:"schema,omitempty"`

	// Specifies the level of security to be used for LDAP communications:
	// * none - no signing or sealing
	// * sign - sign LDAP traffic
	// * seal - seal and sign LDAP traffic
	//
	// Enum: ["none","sign","seal"]
	SessionSecurity *string `json:"session_security,omitempty"`

	// Indicates whether or not the validation for the specified LDAP configuration is disabled.
	//
	SkipConfigValidation *bool `json:"skip_config_validation,omitempty"`

	// status
	Status *models.LdapServiceInlineStatus `json:"status,omitempty"`

	// svm
	Svm *models.LdapServiceInlineSvm `json:"svm,omitempty"`

	// Specifies whether or not channel binding is attempted in the case of TLS/LDAPS.
	//
	TryChannelBinding *bool `json:"try_channel_binding,omitempty"`

	// Specifies whether or not to use Start TLS over LDAP connections.
	//
	UseStartTLS *bool `json:"use_start_tls,omitempty"`

	// Specifies the user Distinguished Name (DN) that is used as the starting point in the LDAP directory tree for user lookups.
	// Example: cn=abc,users,dc=com
	UserDn *string `json:"user_dn,omitempty"`

	// Specifies the default search scope for LDAP for user lookups:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	UserScope *string `json:"user_scope,omitempty"`
}

// Validate validates this ldap modify collection body
func (o *LdapModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBaseScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGroupScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLdapServiceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinBindLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNetgroupByhostScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNetgroupScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSessionSecurity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUserScope(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LdapModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var ldapModifyCollectionBodyTypeBaseScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapModifyCollectionBodyTypeBaseScopePropEnum = append(ldapModifyCollectionBodyTypeBaseScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// base_scope
	// BaseScope
	// base
	// END DEBUGGING
	// LdapModifyCollectionBodyBaseScopeBase captures enum value "base"
	LdapModifyCollectionBodyBaseScopeBase string = "base"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// base_scope
	// BaseScope
	// onelevel
	// END DEBUGGING
	// LdapModifyCollectionBodyBaseScopeOnelevel captures enum value "onelevel"
	LdapModifyCollectionBodyBaseScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// base_scope
	// BaseScope
	// subtree
	// END DEBUGGING
	// LdapModifyCollectionBodyBaseScopeSubtree captures enum value "subtree"
	LdapModifyCollectionBodyBaseScopeSubtree string = "subtree"
)

// prop value enum
func (o *LdapModifyCollectionBody) validateBaseScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapModifyCollectionBodyTypeBaseScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LdapModifyCollectionBody) validateBaseScope(formats strfmt.Registry) error {
	if swag.IsZero(o.BaseScope) { // not required
		return nil
	}

	// value enum
	if err := o.validateBaseScopeEnum("info"+"."+"base_scope", "body", *o.BaseScope); err != nil {
		return err
	}

	return nil
}

var ldapModifyCollectionBodyTypeGroupScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapModifyCollectionBodyTypeGroupScopePropEnum = append(ldapModifyCollectionBodyTypeGroupScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// group_scope
	// GroupScope
	// base
	// END DEBUGGING
	// LdapModifyCollectionBodyGroupScopeBase captures enum value "base"
	LdapModifyCollectionBodyGroupScopeBase string = "base"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// group_scope
	// GroupScope
	// onelevel
	// END DEBUGGING
	// LdapModifyCollectionBodyGroupScopeOnelevel captures enum value "onelevel"
	LdapModifyCollectionBodyGroupScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// group_scope
	// GroupScope
	// subtree
	// END DEBUGGING
	// LdapModifyCollectionBodyGroupScopeSubtree captures enum value "subtree"
	LdapModifyCollectionBodyGroupScopeSubtree string = "subtree"
)

// prop value enum
func (o *LdapModifyCollectionBody) validateGroupScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapModifyCollectionBodyTypeGroupScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LdapModifyCollectionBody) validateGroupScope(formats strfmt.Registry) error {
	if swag.IsZero(o.GroupScope) { // not required
		return nil
	}

	// value enum
	if err := o.validateGroupScopeEnum("info"+"."+"group_scope", "body", *o.GroupScope); err != nil {
		return err
	}

	return nil
}

func (o *LdapModifyCollectionBody) validateLdapServiceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.LdapServiceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.LdapServiceResponseInlineRecords); i++ {
		if swag.IsZero(o.LdapServiceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.LdapServiceResponseInlineRecords[i] != nil {
			if err := o.LdapServiceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var ldapModifyCollectionBodyTypeMinBindLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["anonymous","simple","sasl"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapModifyCollectionBodyTypeMinBindLevelPropEnum = append(ldapModifyCollectionBodyTypeMinBindLevelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// min_bind_level
	// MinBindLevel
	// anonymous
	// END DEBUGGING
	// LdapModifyCollectionBodyMinBindLevelAnonymous captures enum value "anonymous"
	LdapModifyCollectionBodyMinBindLevelAnonymous string = "anonymous"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// min_bind_level
	// MinBindLevel
	// simple
	// END DEBUGGING
	// LdapModifyCollectionBodyMinBindLevelSimple captures enum value "simple"
	LdapModifyCollectionBodyMinBindLevelSimple string = "simple"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// min_bind_level
	// MinBindLevel
	// sasl
	// END DEBUGGING
	// LdapModifyCollectionBodyMinBindLevelSasl captures enum value "sasl"
	LdapModifyCollectionBodyMinBindLevelSasl string = "sasl"
)

// prop value enum
func (o *LdapModifyCollectionBody) validateMinBindLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapModifyCollectionBodyTypeMinBindLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LdapModifyCollectionBody) validateMinBindLevel(formats strfmt.Registry) error {
	if swag.IsZero(o.MinBindLevel) { // not required
		return nil
	}

	// value enum
	if err := o.validateMinBindLevelEnum("info"+"."+"min_bind_level", "body", *o.MinBindLevel); err != nil {
		return err
	}

	return nil
}

var ldapModifyCollectionBodyTypeNetgroupByhostScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapModifyCollectionBodyTypeNetgroupByhostScopePropEnum = append(ldapModifyCollectionBodyTypeNetgroupByhostScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// netgroup_byhost_scope
	// NetgroupByhostScope
	// base
	// END DEBUGGING
	// LdapModifyCollectionBodyNetgroupByhostScopeBase captures enum value "base"
	LdapModifyCollectionBodyNetgroupByhostScopeBase string = "base"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// netgroup_byhost_scope
	// NetgroupByhostScope
	// onelevel
	// END DEBUGGING
	// LdapModifyCollectionBodyNetgroupByhostScopeOnelevel captures enum value "onelevel"
	LdapModifyCollectionBodyNetgroupByhostScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// netgroup_byhost_scope
	// NetgroupByhostScope
	// subtree
	// END DEBUGGING
	// LdapModifyCollectionBodyNetgroupByhostScopeSubtree captures enum value "subtree"
	LdapModifyCollectionBodyNetgroupByhostScopeSubtree string = "subtree"
)

// prop value enum
func (o *LdapModifyCollectionBody) validateNetgroupByhostScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapModifyCollectionBodyTypeNetgroupByhostScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LdapModifyCollectionBody) validateNetgroupByhostScope(formats strfmt.Registry) error {
	if swag.IsZero(o.NetgroupByhostScope) { // not required
		return nil
	}

	// value enum
	if err := o.validateNetgroupByhostScopeEnum("info"+"."+"netgroup_byhost_scope", "body", *o.NetgroupByhostScope); err != nil {
		return err
	}

	return nil
}

var ldapModifyCollectionBodyTypeNetgroupScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapModifyCollectionBodyTypeNetgroupScopePropEnum = append(ldapModifyCollectionBodyTypeNetgroupScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// netgroup_scope
	// NetgroupScope
	// base
	// END DEBUGGING
	// LdapModifyCollectionBodyNetgroupScopeBase captures enum value "base"
	LdapModifyCollectionBodyNetgroupScopeBase string = "base"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// netgroup_scope
	// NetgroupScope
	// onelevel
	// END DEBUGGING
	// LdapModifyCollectionBodyNetgroupScopeOnelevel captures enum value "onelevel"
	LdapModifyCollectionBodyNetgroupScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// netgroup_scope
	// NetgroupScope
	// subtree
	// END DEBUGGING
	// LdapModifyCollectionBodyNetgroupScopeSubtree captures enum value "subtree"
	LdapModifyCollectionBodyNetgroupScopeSubtree string = "subtree"
)

// prop value enum
func (o *LdapModifyCollectionBody) validateNetgroupScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapModifyCollectionBodyTypeNetgroupScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LdapModifyCollectionBody) validateNetgroupScope(formats strfmt.Registry) error {
	if swag.IsZero(o.NetgroupScope) { // not required
		return nil
	}

	// value enum
	if err := o.validateNetgroupScopeEnum("info"+"."+"netgroup_scope", "body", *o.NetgroupScope); err != nil {
		return err
	}

	return nil
}

func (o *LdapModifyCollectionBody) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(o.Port) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"port", "body", *o.Port, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"port", "body", *o.Port, 65535, false); err != nil {
		return err
	}

	return nil
}

var ldapModifyCollectionBodyTypeSessionSecurityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","sign","seal"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapModifyCollectionBodyTypeSessionSecurityPropEnum = append(ldapModifyCollectionBodyTypeSessionSecurityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// session_security
	// SessionSecurity
	// none
	// END DEBUGGING
	// LdapModifyCollectionBodySessionSecurityNone captures enum value "none"
	LdapModifyCollectionBodySessionSecurityNone string = "none"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// session_security
	// SessionSecurity
	// sign
	// END DEBUGGING
	// LdapModifyCollectionBodySessionSecuritySign captures enum value "sign"
	LdapModifyCollectionBodySessionSecuritySign string = "sign"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// session_security
	// SessionSecurity
	// seal
	// END DEBUGGING
	// LdapModifyCollectionBodySessionSecuritySeal captures enum value "seal"
	LdapModifyCollectionBodySessionSecuritySeal string = "seal"
)

// prop value enum
func (o *LdapModifyCollectionBody) validateSessionSecurityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapModifyCollectionBodyTypeSessionSecurityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LdapModifyCollectionBody) validateSessionSecurity(formats strfmt.Registry) error {
	if swag.IsZero(o.SessionSecurity) { // not required
		return nil
	}

	// value enum
	if err := o.validateSessionSecurityEnum("info"+"."+"session_security", "body", *o.SessionSecurity); err != nil {
		return err
	}

	return nil
}

func (o *LdapModifyCollectionBody) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (o *LdapModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

var ldapModifyCollectionBodyTypeUserScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapModifyCollectionBodyTypeUserScopePropEnum = append(ldapModifyCollectionBodyTypeUserScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// user_scope
	// UserScope
	// base
	// END DEBUGGING
	// LdapModifyCollectionBodyUserScopeBase captures enum value "base"
	LdapModifyCollectionBodyUserScopeBase string = "base"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// user_scope
	// UserScope
	// onelevel
	// END DEBUGGING
	// LdapModifyCollectionBodyUserScopeOnelevel captures enum value "onelevel"
	LdapModifyCollectionBodyUserScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// LdapModifyCollectionBody
	// LdapModifyCollectionBody
	// user_scope
	// UserScope
	// subtree
	// END DEBUGGING
	// LdapModifyCollectionBodyUserScopeSubtree captures enum value "subtree"
	LdapModifyCollectionBodyUserScopeSubtree string = "subtree"
)

// prop value enum
func (o *LdapModifyCollectionBody) validateUserScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapModifyCollectionBodyTypeUserScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LdapModifyCollectionBody) validateUserScope(formats strfmt.Registry) error {
	if swag.IsZero(o.UserScope) { // not required
		return nil
	}

	// value enum
	if err := o.validateUserScopeEnum("info"+"."+"user_scope", "body", *o.UserScope); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ldap modify collection body based on the context it is used
func (o *LdapModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLdapServiceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LdapModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *LdapModifyCollectionBody) contextValidateIsOwner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"is_owner", "body", o.IsOwner); err != nil {
		return err
	}

	return nil
}

func (o *LdapModifyCollectionBody) contextValidateLdapServiceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LdapServiceResponseInlineRecords); i++ {

		if o.LdapServiceResponseInlineRecords[i] != nil {
			if err := o.LdapServiceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *LdapModifyCollectionBody) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (o *LdapModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LdapModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LdapModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res LdapModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LdapServiceInlineLinks ldap service inline links
swagger:model ldap_service_inline__links
*/
type LdapServiceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ldap service inline links
func (o *LdapServiceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LdapServiceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ldap service inline links based on the context it is used
func (o *LdapServiceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LdapServiceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LdapServiceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LdapServiceInlineLinks) UnmarshalBinary(b []byte) error {
	var res LdapServiceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LdapServiceInlineStatus ldap service inline status
swagger:model ldap_service_inline_status
*/
type LdapServiceInlineStatus struct {

	// This field is no longer supported. Use ipv4.code or ipv6.code instead.
	//
	// Example: 65537300
	Code *int64 `json:"code,omitempty"`

	// dn message
	DnMessage []*string `json:"dn_message,omitempty"`

	// ipv4
	IPV4 *models.LdapServiceInlineStatusInlineIPV4 `json:"ipv4,omitempty"`

	// This field is no longer supported. Use ipv4.state instead.
	//
	// Enum: ["up","down"]
	IPV4State *string `json:"ipv4_state,omitempty"`

	// ipv6
	IPV6 *models.LdapServiceInlineStatusInlineIPV6 `json:"ipv6,omitempty"`

	// This field is no longer supported. Use ipv6.state instead.
	//
	// Enum: ["up","down"]
	IPV6State *string `json:"ipv6_state,omitempty"`

	// This field is no longer supported. Use ipv4.message or ipv6.message instead.
	//
	Message *string `json:"message,omitempty"`

	// The status of the LDAP service for the SVM. The LDAP service is up if either `ipv4_state` or `ipv6_state` is up.
	// The LDAP service is down if both `ipv4_state` and `ipv6_state` are down.
	//
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`
}

// Validate validates this ldap service inline status
func (o *LdapServiceInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIPV4(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPV4State(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPV6(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPV6State(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LdapServiceInlineStatus) validateIPV4(formats strfmt.Registry) error {
	if swag.IsZero(o.IPV4) { // not required
		return nil
	}

	if o.IPV4 != nil {
		if err := o.IPV4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status" + "." + "ipv4")
			}
			return err
		}
	}

	return nil
}

var ldapServiceInlineStatusTypeIPV4StatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceInlineStatusTypeIPV4StatePropEnum = append(ldapServiceInlineStatusTypeIPV4StatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service_inline_status
	// LdapServiceInlineStatus
	// ipv4_state
	// IPV4State
	// up
	// END DEBUGGING
	// LdapServiceInlineStatusIPV4StateUp captures enum value "up"
	LdapServiceInlineStatusIPV4StateUp string = "up"

	// BEGIN DEBUGGING
	// ldap_service_inline_status
	// LdapServiceInlineStatus
	// ipv4_state
	// IPV4State
	// down
	// END DEBUGGING
	// LdapServiceInlineStatusIPV4StateDown captures enum value "down"
	LdapServiceInlineStatusIPV4StateDown string = "down"
)

// prop value enum
func (o *LdapServiceInlineStatus) validateIPV4StateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceInlineStatusTypeIPV4StatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LdapServiceInlineStatus) validateIPV4State(formats strfmt.Registry) error {
	if swag.IsZero(o.IPV4State) { // not required
		return nil
	}

	// value enum
	if err := o.validateIPV4StateEnum("info"+"."+"status"+"."+"ipv4_state", "body", *o.IPV4State); err != nil {
		return err
	}

	return nil
}

func (o *LdapServiceInlineStatus) validateIPV6(formats strfmt.Registry) error {
	if swag.IsZero(o.IPV6) { // not required
		return nil
	}

	if o.IPV6 != nil {
		if err := o.IPV6.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status" + "." + "ipv6")
			}
			return err
		}
	}

	return nil
}

var ldapServiceInlineStatusTypeIPV6StatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceInlineStatusTypeIPV6StatePropEnum = append(ldapServiceInlineStatusTypeIPV6StatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service_inline_status
	// LdapServiceInlineStatus
	// ipv6_state
	// IPV6State
	// up
	// END DEBUGGING
	// LdapServiceInlineStatusIPV6StateUp captures enum value "up"
	LdapServiceInlineStatusIPV6StateUp string = "up"

	// BEGIN DEBUGGING
	// ldap_service_inline_status
	// LdapServiceInlineStatus
	// ipv6_state
	// IPV6State
	// down
	// END DEBUGGING
	// LdapServiceInlineStatusIPV6StateDown captures enum value "down"
	LdapServiceInlineStatusIPV6StateDown string = "down"
)

// prop value enum
func (o *LdapServiceInlineStatus) validateIPV6StateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceInlineStatusTypeIPV6StatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LdapServiceInlineStatus) validateIPV6State(formats strfmt.Registry) error {
	if swag.IsZero(o.IPV6State) { // not required
		return nil
	}

	// value enum
	if err := o.validateIPV6StateEnum("info"+"."+"status"+"."+"ipv6_state", "body", *o.IPV6State); err != nil {
		return err
	}

	return nil
}

var ldapServiceInlineStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceInlineStatusTypeStatePropEnum = append(ldapServiceInlineStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service_inline_status
	// LdapServiceInlineStatus
	// state
	// State
	// up
	// END DEBUGGING
	// LdapServiceInlineStatusStateUp captures enum value "up"
	LdapServiceInlineStatusStateUp string = "up"

	// BEGIN DEBUGGING
	// ldap_service_inline_status
	// LdapServiceInlineStatus
	// state
	// State
	// down
	// END DEBUGGING
	// LdapServiceInlineStatusStateDown captures enum value "down"
	LdapServiceInlineStatusStateDown string = "down"
)

// prop value enum
func (o *LdapServiceInlineStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceInlineStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LdapServiceInlineStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"status"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ldap service inline status based on the context it is used
func (o *LdapServiceInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIPV4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIPV6(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LdapServiceInlineStatus) contextValidateIPV4(ctx context.Context, formats strfmt.Registry) error {

	if o.IPV4 != nil {
		if err := o.IPV4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status" + "." + "ipv4")
			}
			return err
		}
	}

	return nil
}

func (o *LdapServiceInlineStatus) contextValidateIPV6(ctx context.Context, formats strfmt.Registry) error {

	if o.IPV6 != nil {
		if err := o.IPV6.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status" + "." + "ipv6")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LdapServiceInlineStatus) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LdapServiceInlineStatus) UnmarshalBinary(b []byte) error {
	var res LdapServiceInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LdapServiceInlineStatusInlineIPV4 ldap service inline status inline ipv4
swagger:model ldap_service_inline_status_inline_ipv4
*/
type LdapServiceInlineStatusInlineIPV4 struct {

	// Code corresponding to the error message. If there is no error, it is 0 to indicate success.
	//
	// Example: 65537300
	Code *int64 `json:"code,omitempty"`

	// dn messages
	DnMessages []*string `json:"dn_messages,omitempty"`

	// Provides additional details on the error.
	//
	Message *string `json:"message,omitempty"`

	// Status of the LDAP service.
	//
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`
}

// Validate validates this ldap service inline status inline ipv4
func (o *LdapServiceInlineStatusInlineIPV4) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ldapServiceInlineStatusInlineIpv4TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceInlineStatusInlineIpv4TypeStatePropEnum = append(ldapServiceInlineStatusInlineIpv4TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service_inline_status_inline_ipv4
	// LdapServiceInlineStatusInlineIPV4
	// state
	// State
	// up
	// END DEBUGGING
	// LdapServiceInlineStatusInlineIPV4StateUp captures enum value "up"
	LdapServiceInlineStatusInlineIPV4StateUp string = "up"

	// BEGIN DEBUGGING
	// ldap_service_inline_status_inline_ipv4
	// LdapServiceInlineStatusInlineIPV4
	// state
	// State
	// down
	// END DEBUGGING
	// LdapServiceInlineStatusInlineIPV4StateDown captures enum value "down"
	LdapServiceInlineStatusInlineIPV4StateDown string = "down"
)

// prop value enum
func (o *LdapServiceInlineStatusInlineIPV4) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceInlineStatusInlineIpv4TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LdapServiceInlineStatusInlineIPV4) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"status"+"."+"ipv4"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ldap service inline status inline ipv4 based on context it is used
func (o *LdapServiceInlineStatusInlineIPV4) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *LdapServiceInlineStatusInlineIPV4) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LdapServiceInlineStatusInlineIPV4) UnmarshalBinary(b []byte) error {
	var res LdapServiceInlineStatusInlineIPV4
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LdapServiceInlineStatusInlineIPV6 ldap service inline status inline ipv6
swagger:model ldap_service_inline_status_inline_ipv6
*/
type LdapServiceInlineStatusInlineIPV6 struct {

	// Code corresponding to the error message. If there is no error, it is 0 to indicate success.
	//
	// Example: 65537300
	Code *int64 `json:"code,omitempty"`

	// dn messages
	DnMessages []*string `json:"dn_messages,omitempty"`

	// Provides additional details on the error.
	//
	Message *string `json:"message,omitempty"`

	// Status of the LDAP service.
	//
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`
}

// Validate validates this ldap service inline status inline ipv6
func (o *LdapServiceInlineStatusInlineIPV6) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ldapServiceInlineStatusInlineIpv6TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ldapServiceInlineStatusInlineIpv6TypeStatePropEnum = append(ldapServiceInlineStatusInlineIpv6TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ldap_service_inline_status_inline_ipv6
	// LdapServiceInlineStatusInlineIPV6
	// state
	// State
	// up
	// END DEBUGGING
	// LdapServiceInlineStatusInlineIPV6StateUp captures enum value "up"
	LdapServiceInlineStatusInlineIPV6StateUp string = "up"

	// BEGIN DEBUGGING
	// ldap_service_inline_status_inline_ipv6
	// LdapServiceInlineStatusInlineIPV6
	// state
	// State
	// down
	// END DEBUGGING
	// LdapServiceInlineStatusInlineIPV6StateDown captures enum value "down"
	LdapServiceInlineStatusInlineIPV6StateDown string = "down"
)

// prop value enum
func (o *LdapServiceInlineStatusInlineIPV6) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ldapServiceInlineStatusInlineIpv6TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LdapServiceInlineStatusInlineIPV6) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"status"+"."+"ipv6"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ldap service inline status inline ipv6 based on context it is used
func (o *LdapServiceInlineStatusInlineIPV6) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *LdapServiceInlineStatusInlineIPV6) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LdapServiceInlineStatusInlineIPV6) UnmarshalBinary(b []byte) error {
	var res LdapServiceInlineStatusInlineIPV6
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LdapServiceInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model ldap_service_inline_svm
*/
type LdapServiceInlineSvm struct {

	// links
	Links *models.LdapServiceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ldap service inline svm
func (o *LdapServiceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LdapServiceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ldap service inline svm based on the context it is used
func (o *LdapServiceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LdapServiceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LdapServiceInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LdapServiceInlineSvm) UnmarshalBinary(b []byte) error {
	var res LdapServiceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LdapServiceInlineSvmInlineLinks ldap service inline svm inline links
swagger:model ldap_service_inline_svm_inline__links
*/
type LdapServiceInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ldap service inline svm inline links
func (o *LdapServiceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LdapServiceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ldap service inline svm inline links based on the context it is used
func (o *LdapServiceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LdapServiceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LdapServiceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LdapServiceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res LdapServiceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
