// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LdapSchemaCollectionGetReader is a Reader for the LdapSchemaCollectionGet structure.
type LdapSchemaCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LdapSchemaCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLdapSchemaCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLdapSchemaCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLdapSchemaCollectionGetOK creates a LdapSchemaCollectionGetOK with default headers values
func NewLdapSchemaCollectionGetOK() *LdapSchemaCollectionGetOK {
	return &LdapSchemaCollectionGetOK{}
}

/*
LdapSchemaCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type LdapSchemaCollectionGetOK struct {
	Payload *models.LdapSchemaResponse
}

// IsSuccess returns true when this ldap schema collection get o k response has a 2xx status code
func (o *LdapSchemaCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ldap schema collection get o k response has a 3xx status code
func (o *LdapSchemaCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ldap schema collection get o k response has a 4xx status code
func (o *LdapSchemaCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ldap schema collection get o k response has a 5xx status code
func (o *LdapSchemaCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ldap schema collection get o k response a status code equal to that given
func (o *LdapSchemaCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ldap schema collection get o k response
func (o *LdapSchemaCollectionGetOK) Code() int {
	return 200
}

func (o *LdapSchemaCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/ldap-schemas][%d] ldapSchemaCollectionGetOK %s", 200, payload)
}

func (o *LdapSchemaCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/ldap-schemas][%d] ldapSchemaCollectionGetOK %s", 200, payload)
}

func (o *LdapSchemaCollectionGetOK) GetPayload() *models.LdapSchemaResponse {
	return o.Payload
}

func (o *LdapSchemaCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LdapSchemaResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLdapSchemaCollectionGetDefault creates a LdapSchemaCollectionGetDefault with default headers values
func NewLdapSchemaCollectionGetDefault(code int) *LdapSchemaCollectionGetDefault {
	return &LdapSchemaCollectionGetDefault{
		_statusCode: code,
	}
}

/*
LdapSchemaCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type LdapSchemaCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ldap schema collection get default response has a 2xx status code
func (o *LdapSchemaCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ldap schema collection get default response has a 3xx status code
func (o *LdapSchemaCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ldap schema collection get default response has a 4xx status code
func (o *LdapSchemaCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ldap schema collection get default response has a 5xx status code
func (o *LdapSchemaCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ldap schema collection get default response a status code equal to that given
func (o *LdapSchemaCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ldap schema collection get default response
func (o *LdapSchemaCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *LdapSchemaCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/ldap-schemas][%d] ldap_schema_collection_get default %s", o._statusCode, payload)
}

func (o *LdapSchemaCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/ldap-schemas][%d] ldap_schema_collection_get default %s", o._statusCode, payload)
}

func (o *LdapSchemaCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LdapSchemaCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
