// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLdapSchemaDeleteCollectionParams creates a new LdapSchemaDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLdapSchemaDeleteCollectionParams() *LdapSchemaDeleteCollectionParams {
	return &LdapSchemaDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLdapSchemaDeleteCollectionParamsWithTimeout creates a new LdapSchemaDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewLdapSchemaDeleteCollectionParamsWithTimeout(timeout time.Duration) *LdapSchemaDeleteCollectionParams {
	return &LdapSchemaDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewLdapSchemaDeleteCollectionParamsWithContext creates a new LdapSchemaDeleteCollectionParams object
// with the ability to set a context for a request.
func NewLdapSchemaDeleteCollectionParamsWithContext(ctx context.Context) *LdapSchemaDeleteCollectionParams {
	return &LdapSchemaDeleteCollectionParams{
		Context: ctx,
	}
}

// NewLdapSchemaDeleteCollectionParamsWithHTTPClient creates a new LdapSchemaDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewLdapSchemaDeleteCollectionParamsWithHTTPClient(client *http.Client) *LdapSchemaDeleteCollectionParams {
	return &LdapSchemaDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
LdapSchemaDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the ldap schema delete collection operation.

	Typically these are written to a http.Request.
*/
type LdapSchemaDeleteCollectionParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* GlobalSchema.

	   Filter by global_schema
	*/
	GlobalSchema *bool

	/* Info.

	   Info specification
	*/
	Info LdapSchemaDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NameMappingAccountUnix.

	   Filter by name_mapping.account.unix
	*/
	NameMappingAccountUnix *string

	/* NameMappingAccountWindows.

	   Filter by name_mapping.account.windows
	*/
	NameMappingAccountWindows *string

	/* NameMappingWindowsToUnixAttribute.

	   Filter by name_mapping.windows_to_unix.attribute
	*/
	NameMappingWindowsToUnixAttribute *string

	/* NameMappingWindowsToUnixNoDomainPrefix.

	   Filter by name_mapping.windows_to_unix.no_domain_prefix
	*/
	NameMappingWindowsToUnixNoDomainPrefix *bool

	/* NameMappingWindowsToUnixObjectClass.

	   Filter by name_mapping.windows_to_unix.object_class
	*/
	NameMappingWindowsToUnixObjectClass *string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Rfc2307AttributeGecos.

	   Filter by rfc2307.attribute.gecos
	*/
	Rfc2307AttributeGecos *string

	/* Rfc2307AttributeGidNumber.

	   Filter by rfc2307.attribute.gid_number
	*/
	Rfc2307AttributeGidNumber *string

	/* Rfc2307AttributeHomeDirectory.

	   Filter by rfc2307.attribute.home_directory
	*/
	Rfc2307AttributeHomeDirectory *string

	/* Rfc2307AttributeLoginShell.

	   Filter by rfc2307.attribute.login_shell
	*/
	Rfc2307AttributeLoginShell *string

	/* Rfc2307AttributeUID.

	   Filter by rfc2307.attribute.uid
	*/
	Rfc2307AttributeUID *string

	/* Rfc2307AttributeUIDNumber.

	   Filter by rfc2307.attribute.uid_number
	*/
	Rfc2307AttributeUIDNumber *string

	/* Rfc2307AttributeUserPassword.

	   Filter by rfc2307.attribute.user_password
	*/
	Rfc2307AttributeUserPassword *string

	/* Rfc2307CnGroup.

	   Filter by rfc2307.cn.group
	*/
	Rfc2307CnGroup *string

	/* Rfc2307CnNetgroup.

	   Filter by rfc2307.cn.netgroup
	*/
	Rfc2307CnNetgroup *string

	/* Rfc2307MemberNisNetgroup.

	   Filter by rfc2307.member.nis_netgroup
	*/
	Rfc2307MemberNisNetgroup *string

	/* Rfc2307MemberUID.

	   Filter by rfc2307.member.uid
	*/
	Rfc2307MemberUID *string

	/* Rfc2307NisMapentry.

	   Filter by rfc2307.nis.mapentry
	*/
	Rfc2307NisMapentry *string

	/* Rfc2307NisMapname.

	   Filter by rfc2307.nis.mapname
	*/
	Rfc2307NisMapname *string

	/* Rfc2307NisNetgroup.

	   Filter by rfc2307.nis.netgroup
	*/
	Rfc2307NisNetgroup *string

	/* Rfc2307NisNetgroupTriple.

	   Filter by rfc2307.nis.netgroup_triple
	*/
	Rfc2307NisNetgroupTriple *string

	/* Rfc2307NisObject.

	   Filter by rfc2307.nis.object
	*/
	Rfc2307NisObject *string

	/* Rfc2307PosixAccount.

	   Filter by rfc2307.posix.account
	*/
	Rfc2307PosixAccount *string

	/* Rfc2307PosixGroup.

	   Filter by rfc2307.posix.group
	*/
	Rfc2307PosixGroup *string

	/* Rfc2307bisEnabled.

	   Filter by rfc2307bis.enabled
	*/
	Rfc2307bisEnabled *bool

	/* Rfc2307bisGroupOfUniqueNames.

	   Filter by rfc2307bis.group_of_unique_names
	*/
	Rfc2307bisGroupOfUniqueNames *string

	/* Rfc2307bisMaximumGroups.

	   Filter by rfc2307bis.maximum_groups
	*/
	Rfc2307bisMaximumGroups *int64

	/* Rfc2307bisUniqueMember.

	   Filter by rfc2307bis.unique_member
	*/
	Rfc2307bisUniqueMember *string

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ldap schema delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LdapSchemaDeleteCollectionParams) WithDefaults() *LdapSchemaDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ldap schema delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LdapSchemaDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := LdapSchemaDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithTimeout(timeout time.Duration) *LdapSchemaDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithContext(ctx context.Context) *LdapSchemaDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithHTTPClient(client *http.Client) *LdapSchemaDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithComment(comment *string) *LdapSchemaDeleteCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *LdapSchemaDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithGlobalSchema adds the globalSchema to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithGlobalSchema(globalSchema *bool) *LdapSchemaDeleteCollectionParams {
	o.SetGlobalSchema(globalSchema)
	return o
}

// SetGlobalSchema adds the globalSchema to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetGlobalSchema(globalSchema *bool) {
	o.GlobalSchema = globalSchema
}

// WithInfo adds the info to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithInfo(info LdapSchemaDeleteCollectionBody) *LdapSchemaDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetInfo(info LdapSchemaDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithName(name *string) *LdapSchemaDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNameMappingAccountUnix adds the nameMappingAccountUnix to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithNameMappingAccountUnix(nameMappingAccountUnix *string) *LdapSchemaDeleteCollectionParams {
	o.SetNameMappingAccountUnix(nameMappingAccountUnix)
	return o
}

// SetNameMappingAccountUnix adds the nameMappingAccountUnix to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetNameMappingAccountUnix(nameMappingAccountUnix *string) {
	o.NameMappingAccountUnix = nameMappingAccountUnix
}

// WithNameMappingAccountWindows adds the nameMappingAccountWindows to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithNameMappingAccountWindows(nameMappingAccountWindows *string) *LdapSchemaDeleteCollectionParams {
	o.SetNameMappingAccountWindows(nameMappingAccountWindows)
	return o
}

// SetNameMappingAccountWindows adds the nameMappingAccountWindows to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetNameMappingAccountWindows(nameMappingAccountWindows *string) {
	o.NameMappingAccountWindows = nameMappingAccountWindows
}

// WithNameMappingWindowsToUnixAttribute adds the nameMappingWindowsToUnixAttribute to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithNameMappingWindowsToUnixAttribute(nameMappingWindowsToUnixAttribute *string) *LdapSchemaDeleteCollectionParams {
	o.SetNameMappingWindowsToUnixAttribute(nameMappingWindowsToUnixAttribute)
	return o
}

// SetNameMappingWindowsToUnixAttribute adds the nameMappingWindowsToUnixAttribute to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetNameMappingWindowsToUnixAttribute(nameMappingWindowsToUnixAttribute *string) {
	o.NameMappingWindowsToUnixAttribute = nameMappingWindowsToUnixAttribute
}

// WithNameMappingWindowsToUnixNoDomainPrefix adds the nameMappingWindowsToUnixNoDomainPrefix to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithNameMappingWindowsToUnixNoDomainPrefix(nameMappingWindowsToUnixNoDomainPrefix *bool) *LdapSchemaDeleteCollectionParams {
	o.SetNameMappingWindowsToUnixNoDomainPrefix(nameMappingWindowsToUnixNoDomainPrefix)
	return o
}

// SetNameMappingWindowsToUnixNoDomainPrefix adds the nameMappingWindowsToUnixNoDomainPrefix to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetNameMappingWindowsToUnixNoDomainPrefix(nameMappingWindowsToUnixNoDomainPrefix *bool) {
	o.NameMappingWindowsToUnixNoDomainPrefix = nameMappingWindowsToUnixNoDomainPrefix
}

// WithNameMappingWindowsToUnixObjectClass adds the nameMappingWindowsToUnixObjectClass to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithNameMappingWindowsToUnixObjectClass(nameMappingWindowsToUnixObjectClass *string) *LdapSchemaDeleteCollectionParams {
	o.SetNameMappingWindowsToUnixObjectClass(nameMappingWindowsToUnixObjectClass)
	return o
}

// SetNameMappingWindowsToUnixObjectClass adds the nameMappingWindowsToUnixObjectClass to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetNameMappingWindowsToUnixObjectClass(nameMappingWindowsToUnixObjectClass *string) {
	o.NameMappingWindowsToUnixObjectClass = nameMappingWindowsToUnixObjectClass
}

// WithOwnerName adds the ownerName to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithOwnerName(ownerName *string) *LdapSchemaDeleteCollectionParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithOwnerUUID(ownerUUID *string) *LdapSchemaDeleteCollectionParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *LdapSchemaDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *LdapSchemaDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRfc2307AttributeGecos adds the rfc2307AttributeGecos to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307AttributeGecos(rfc2307AttributeGecos *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307AttributeGecos(rfc2307AttributeGecos)
	return o
}

// SetRfc2307AttributeGecos adds the rfc2307AttributeGecos to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307AttributeGecos(rfc2307AttributeGecos *string) {
	o.Rfc2307AttributeGecos = rfc2307AttributeGecos
}

// WithRfc2307AttributeGidNumber adds the rfc2307AttributeGidNumber to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307AttributeGidNumber(rfc2307AttributeGidNumber *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307AttributeGidNumber(rfc2307AttributeGidNumber)
	return o
}

// SetRfc2307AttributeGidNumber adds the rfc2307AttributeGidNumber to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307AttributeGidNumber(rfc2307AttributeGidNumber *string) {
	o.Rfc2307AttributeGidNumber = rfc2307AttributeGidNumber
}

// WithRfc2307AttributeHomeDirectory adds the rfc2307AttributeHomeDirectory to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307AttributeHomeDirectory(rfc2307AttributeHomeDirectory *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307AttributeHomeDirectory(rfc2307AttributeHomeDirectory)
	return o
}

// SetRfc2307AttributeHomeDirectory adds the rfc2307AttributeHomeDirectory to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307AttributeHomeDirectory(rfc2307AttributeHomeDirectory *string) {
	o.Rfc2307AttributeHomeDirectory = rfc2307AttributeHomeDirectory
}

// WithRfc2307AttributeLoginShell adds the rfc2307AttributeLoginShell to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307AttributeLoginShell(rfc2307AttributeLoginShell *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307AttributeLoginShell(rfc2307AttributeLoginShell)
	return o
}

// SetRfc2307AttributeLoginShell adds the rfc2307AttributeLoginShell to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307AttributeLoginShell(rfc2307AttributeLoginShell *string) {
	o.Rfc2307AttributeLoginShell = rfc2307AttributeLoginShell
}

// WithRfc2307AttributeUID adds the rfc2307AttributeUID to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307AttributeUID(rfc2307AttributeUID *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307AttributeUID(rfc2307AttributeUID)
	return o
}

// SetRfc2307AttributeUID adds the rfc2307AttributeUid to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307AttributeUID(rfc2307AttributeUID *string) {
	o.Rfc2307AttributeUID = rfc2307AttributeUID
}

// WithRfc2307AttributeUIDNumber adds the rfc2307AttributeUIDNumber to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307AttributeUIDNumber(rfc2307AttributeUIDNumber *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307AttributeUIDNumber(rfc2307AttributeUIDNumber)
	return o
}

// SetRfc2307AttributeUIDNumber adds the rfc2307AttributeUidNumber to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307AttributeUIDNumber(rfc2307AttributeUIDNumber *string) {
	o.Rfc2307AttributeUIDNumber = rfc2307AttributeUIDNumber
}

// WithRfc2307AttributeUserPassword adds the rfc2307AttributeUserPassword to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307AttributeUserPassword(rfc2307AttributeUserPassword *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307AttributeUserPassword(rfc2307AttributeUserPassword)
	return o
}

// SetRfc2307AttributeUserPassword adds the rfc2307AttributeUserPassword to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307AttributeUserPassword(rfc2307AttributeUserPassword *string) {
	o.Rfc2307AttributeUserPassword = rfc2307AttributeUserPassword
}

// WithRfc2307CnGroup adds the rfc2307CnGroup to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307CnGroup(rfc2307CnGroup *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307CnGroup(rfc2307CnGroup)
	return o
}

// SetRfc2307CnGroup adds the rfc2307CnGroup to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307CnGroup(rfc2307CnGroup *string) {
	o.Rfc2307CnGroup = rfc2307CnGroup
}

// WithRfc2307CnNetgroup adds the rfc2307CnNetgroup to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307CnNetgroup(rfc2307CnNetgroup *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307CnNetgroup(rfc2307CnNetgroup)
	return o
}

// SetRfc2307CnNetgroup adds the rfc2307CnNetgroup to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307CnNetgroup(rfc2307CnNetgroup *string) {
	o.Rfc2307CnNetgroup = rfc2307CnNetgroup
}

// WithRfc2307MemberNisNetgroup adds the rfc2307MemberNisNetgroup to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307MemberNisNetgroup(rfc2307MemberNisNetgroup *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307MemberNisNetgroup(rfc2307MemberNisNetgroup)
	return o
}

// SetRfc2307MemberNisNetgroup adds the rfc2307MemberNisNetgroup to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307MemberNisNetgroup(rfc2307MemberNisNetgroup *string) {
	o.Rfc2307MemberNisNetgroup = rfc2307MemberNisNetgroup
}

// WithRfc2307MemberUID adds the rfc2307MemberUID to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307MemberUID(rfc2307MemberUID *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307MemberUID(rfc2307MemberUID)
	return o
}

// SetRfc2307MemberUID adds the rfc2307MemberUid to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307MemberUID(rfc2307MemberUID *string) {
	o.Rfc2307MemberUID = rfc2307MemberUID
}

// WithRfc2307NisMapentry adds the rfc2307NisMapentry to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307NisMapentry(rfc2307NisMapentry *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307NisMapentry(rfc2307NisMapentry)
	return o
}

// SetRfc2307NisMapentry adds the rfc2307NisMapentry to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307NisMapentry(rfc2307NisMapentry *string) {
	o.Rfc2307NisMapentry = rfc2307NisMapentry
}

// WithRfc2307NisMapname adds the rfc2307NisMapname to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307NisMapname(rfc2307NisMapname *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307NisMapname(rfc2307NisMapname)
	return o
}

// SetRfc2307NisMapname adds the rfc2307NisMapname to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307NisMapname(rfc2307NisMapname *string) {
	o.Rfc2307NisMapname = rfc2307NisMapname
}

// WithRfc2307NisNetgroup adds the rfc2307NisNetgroup to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307NisNetgroup(rfc2307NisNetgroup *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307NisNetgroup(rfc2307NisNetgroup)
	return o
}

// SetRfc2307NisNetgroup adds the rfc2307NisNetgroup to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307NisNetgroup(rfc2307NisNetgroup *string) {
	o.Rfc2307NisNetgroup = rfc2307NisNetgroup
}

// WithRfc2307NisNetgroupTriple adds the rfc2307NisNetgroupTriple to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307NisNetgroupTriple(rfc2307NisNetgroupTriple *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307NisNetgroupTriple(rfc2307NisNetgroupTriple)
	return o
}

// SetRfc2307NisNetgroupTriple adds the rfc2307NisNetgroupTriple to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307NisNetgroupTriple(rfc2307NisNetgroupTriple *string) {
	o.Rfc2307NisNetgroupTriple = rfc2307NisNetgroupTriple
}

// WithRfc2307NisObject adds the rfc2307NisObject to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307NisObject(rfc2307NisObject *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307NisObject(rfc2307NisObject)
	return o
}

// SetRfc2307NisObject adds the rfc2307NisObject to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307NisObject(rfc2307NisObject *string) {
	o.Rfc2307NisObject = rfc2307NisObject
}

// WithRfc2307PosixAccount adds the rfc2307PosixAccount to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307PosixAccount(rfc2307PosixAccount *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307PosixAccount(rfc2307PosixAccount)
	return o
}

// SetRfc2307PosixAccount adds the rfc2307PosixAccount to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307PosixAccount(rfc2307PosixAccount *string) {
	o.Rfc2307PosixAccount = rfc2307PosixAccount
}

// WithRfc2307PosixGroup adds the rfc2307PosixGroup to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307PosixGroup(rfc2307PosixGroup *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307PosixGroup(rfc2307PosixGroup)
	return o
}

// SetRfc2307PosixGroup adds the rfc2307PosixGroup to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307PosixGroup(rfc2307PosixGroup *string) {
	o.Rfc2307PosixGroup = rfc2307PosixGroup
}

// WithRfc2307bisEnabled adds the rfc2307bisEnabled to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307bisEnabled(rfc2307bisEnabled *bool) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307bisEnabled(rfc2307bisEnabled)
	return o
}

// SetRfc2307bisEnabled adds the rfc2307bisEnabled to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307bisEnabled(rfc2307bisEnabled *bool) {
	o.Rfc2307bisEnabled = rfc2307bisEnabled
}

// WithRfc2307bisGroupOfUniqueNames adds the rfc2307bisGroupOfUniqueNames to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307bisGroupOfUniqueNames(rfc2307bisGroupOfUniqueNames *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307bisGroupOfUniqueNames(rfc2307bisGroupOfUniqueNames)
	return o
}

// SetRfc2307bisGroupOfUniqueNames adds the rfc2307bisGroupOfUniqueNames to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307bisGroupOfUniqueNames(rfc2307bisGroupOfUniqueNames *string) {
	o.Rfc2307bisGroupOfUniqueNames = rfc2307bisGroupOfUniqueNames
}

// WithRfc2307bisMaximumGroups adds the rfc2307bisMaximumGroups to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307bisMaximumGroups(rfc2307bisMaximumGroups *int64) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307bisMaximumGroups(rfc2307bisMaximumGroups)
	return o
}

// SetRfc2307bisMaximumGroups adds the rfc2307bisMaximumGroups to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307bisMaximumGroups(rfc2307bisMaximumGroups *int64) {
	o.Rfc2307bisMaximumGroups = rfc2307bisMaximumGroups
}

// WithRfc2307bisUniqueMember adds the rfc2307bisUniqueMember to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithRfc2307bisUniqueMember(rfc2307bisUniqueMember *string) *LdapSchemaDeleteCollectionParams {
	o.SetRfc2307bisUniqueMember(rfc2307bisUniqueMember)
	return o
}

// SetRfc2307bisUniqueMember adds the rfc2307bisUniqueMember to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetRfc2307bisUniqueMember(rfc2307bisUniqueMember *string) {
	o.Rfc2307bisUniqueMember = rfc2307bisUniqueMember
}

// WithScope adds the scope to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithScope(scope *string) *LdapSchemaDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *LdapSchemaDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the ldap schema delete collection params
func (o *LdapSchemaDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WriteToRequest writes these params to a swagger request
func (o *LdapSchemaDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.GlobalSchema != nil {

		// query param global_schema
		var qrGlobalSchema bool

		if o.GlobalSchema != nil {
			qrGlobalSchema = *o.GlobalSchema
		}
		qGlobalSchema := swag.FormatBool(qrGlobalSchema)
		if qGlobalSchema != "" {

			if err := r.SetQueryParam("global_schema", qGlobalSchema); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NameMappingAccountUnix != nil {

		// query param name_mapping.account.unix
		var qrNameMappingAccountUnix string

		if o.NameMappingAccountUnix != nil {
			qrNameMappingAccountUnix = *o.NameMappingAccountUnix
		}
		qNameMappingAccountUnix := qrNameMappingAccountUnix
		if qNameMappingAccountUnix != "" {

			if err := r.SetQueryParam("name_mapping.account.unix", qNameMappingAccountUnix); err != nil {
				return err
			}
		}
	}

	if o.NameMappingAccountWindows != nil {

		// query param name_mapping.account.windows
		var qrNameMappingAccountWindows string

		if o.NameMappingAccountWindows != nil {
			qrNameMappingAccountWindows = *o.NameMappingAccountWindows
		}
		qNameMappingAccountWindows := qrNameMappingAccountWindows
		if qNameMappingAccountWindows != "" {

			if err := r.SetQueryParam("name_mapping.account.windows", qNameMappingAccountWindows); err != nil {
				return err
			}
		}
	}

	if o.NameMappingWindowsToUnixAttribute != nil {

		// query param name_mapping.windows_to_unix.attribute
		var qrNameMappingWindowsToUnixAttribute string

		if o.NameMappingWindowsToUnixAttribute != nil {
			qrNameMappingWindowsToUnixAttribute = *o.NameMappingWindowsToUnixAttribute
		}
		qNameMappingWindowsToUnixAttribute := qrNameMappingWindowsToUnixAttribute
		if qNameMappingWindowsToUnixAttribute != "" {

			if err := r.SetQueryParam("name_mapping.windows_to_unix.attribute", qNameMappingWindowsToUnixAttribute); err != nil {
				return err
			}
		}
	}

	if o.NameMappingWindowsToUnixNoDomainPrefix != nil {

		// query param name_mapping.windows_to_unix.no_domain_prefix
		var qrNameMappingWindowsToUnixNoDomainPrefix bool

		if o.NameMappingWindowsToUnixNoDomainPrefix != nil {
			qrNameMappingWindowsToUnixNoDomainPrefix = *o.NameMappingWindowsToUnixNoDomainPrefix
		}
		qNameMappingWindowsToUnixNoDomainPrefix := swag.FormatBool(qrNameMappingWindowsToUnixNoDomainPrefix)
		if qNameMappingWindowsToUnixNoDomainPrefix != "" {

			if err := r.SetQueryParam("name_mapping.windows_to_unix.no_domain_prefix", qNameMappingWindowsToUnixNoDomainPrefix); err != nil {
				return err
			}
		}
	}

	if o.NameMappingWindowsToUnixObjectClass != nil {

		// query param name_mapping.windows_to_unix.object_class
		var qrNameMappingWindowsToUnixObjectClass string

		if o.NameMappingWindowsToUnixObjectClass != nil {
			qrNameMappingWindowsToUnixObjectClass = *o.NameMappingWindowsToUnixObjectClass
		}
		qNameMappingWindowsToUnixObjectClass := qrNameMappingWindowsToUnixObjectClass
		if qNameMappingWindowsToUnixObjectClass != "" {

			if err := r.SetQueryParam("name_mapping.windows_to_unix.object_class", qNameMappingWindowsToUnixObjectClass); err != nil {
				return err
			}
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307AttributeGecos != nil {

		// query param rfc2307.attribute.gecos
		var qrRfc2307AttributeGecos string

		if o.Rfc2307AttributeGecos != nil {
			qrRfc2307AttributeGecos = *o.Rfc2307AttributeGecos
		}
		qRfc2307AttributeGecos := qrRfc2307AttributeGecos
		if qRfc2307AttributeGecos != "" {

			if err := r.SetQueryParam("rfc2307.attribute.gecos", qRfc2307AttributeGecos); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307AttributeGidNumber != nil {

		// query param rfc2307.attribute.gid_number
		var qrRfc2307AttributeGidNumber string

		if o.Rfc2307AttributeGidNumber != nil {
			qrRfc2307AttributeGidNumber = *o.Rfc2307AttributeGidNumber
		}
		qRfc2307AttributeGidNumber := qrRfc2307AttributeGidNumber
		if qRfc2307AttributeGidNumber != "" {

			if err := r.SetQueryParam("rfc2307.attribute.gid_number", qRfc2307AttributeGidNumber); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307AttributeHomeDirectory != nil {

		// query param rfc2307.attribute.home_directory
		var qrRfc2307AttributeHomeDirectory string

		if o.Rfc2307AttributeHomeDirectory != nil {
			qrRfc2307AttributeHomeDirectory = *o.Rfc2307AttributeHomeDirectory
		}
		qRfc2307AttributeHomeDirectory := qrRfc2307AttributeHomeDirectory
		if qRfc2307AttributeHomeDirectory != "" {

			if err := r.SetQueryParam("rfc2307.attribute.home_directory", qRfc2307AttributeHomeDirectory); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307AttributeLoginShell != nil {

		// query param rfc2307.attribute.login_shell
		var qrRfc2307AttributeLoginShell string

		if o.Rfc2307AttributeLoginShell != nil {
			qrRfc2307AttributeLoginShell = *o.Rfc2307AttributeLoginShell
		}
		qRfc2307AttributeLoginShell := qrRfc2307AttributeLoginShell
		if qRfc2307AttributeLoginShell != "" {

			if err := r.SetQueryParam("rfc2307.attribute.login_shell", qRfc2307AttributeLoginShell); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307AttributeUID != nil {

		// query param rfc2307.attribute.uid
		var qrRfc2307AttributeUID string

		if o.Rfc2307AttributeUID != nil {
			qrRfc2307AttributeUID = *o.Rfc2307AttributeUID
		}
		qRfc2307AttributeUID := qrRfc2307AttributeUID
		if qRfc2307AttributeUID != "" {

			if err := r.SetQueryParam("rfc2307.attribute.uid", qRfc2307AttributeUID); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307AttributeUIDNumber != nil {

		// query param rfc2307.attribute.uid_number
		var qrRfc2307AttributeUIDNumber string

		if o.Rfc2307AttributeUIDNumber != nil {
			qrRfc2307AttributeUIDNumber = *o.Rfc2307AttributeUIDNumber
		}
		qRfc2307AttributeUIDNumber := qrRfc2307AttributeUIDNumber
		if qRfc2307AttributeUIDNumber != "" {

			if err := r.SetQueryParam("rfc2307.attribute.uid_number", qRfc2307AttributeUIDNumber); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307AttributeUserPassword != nil {

		// query param rfc2307.attribute.user_password
		var qrRfc2307AttributeUserPassword string

		if o.Rfc2307AttributeUserPassword != nil {
			qrRfc2307AttributeUserPassword = *o.Rfc2307AttributeUserPassword
		}
		qRfc2307AttributeUserPassword := qrRfc2307AttributeUserPassword
		if qRfc2307AttributeUserPassword != "" {

			if err := r.SetQueryParam("rfc2307.attribute.user_password", qRfc2307AttributeUserPassword); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307CnGroup != nil {

		// query param rfc2307.cn.group
		var qrRfc2307CnGroup string

		if o.Rfc2307CnGroup != nil {
			qrRfc2307CnGroup = *o.Rfc2307CnGroup
		}
		qRfc2307CnGroup := qrRfc2307CnGroup
		if qRfc2307CnGroup != "" {

			if err := r.SetQueryParam("rfc2307.cn.group", qRfc2307CnGroup); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307CnNetgroup != nil {

		// query param rfc2307.cn.netgroup
		var qrRfc2307CnNetgroup string

		if o.Rfc2307CnNetgroup != nil {
			qrRfc2307CnNetgroup = *o.Rfc2307CnNetgroup
		}
		qRfc2307CnNetgroup := qrRfc2307CnNetgroup
		if qRfc2307CnNetgroup != "" {

			if err := r.SetQueryParam("rfc2307.cn.netgroup", qRfc2307CnNetgroup); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307MemberNisNetgroup != nil {

		// query param rfc2307.member.nis_netgroup
		var qrRfc2307MemberNisNetgroup string

		if o.Rfc2307MemberNisNetgroup != nil {
			qrRfc2307MemberNisNetgroup = *o.Rfc2307MemberNisNetgroup
		}
		qRfc2307MemberNisNetgroup := qrRfc2307MemberNisNetgroup
		if qRfc2307MemberNisNetgroup != "" {

			if err := r.SetQueryParam("rfc2307.member.nis_netgroup", qRfc2307MemberNisNetgroup); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307MemberUID != nil {

		// query param rfc2307.member.uid
		var qrRfc2307MemberUID string

		if o.Rfc2307MemberUID != nil {
			qrRfc2307MemberUID = *o.Rfc2307MemberUID
		}
		qRfc2307MemberUID := qrRfc2307MemberUID
		if qRfc2307MemberUID != "" {

			if err := r.SetQueryParam("rfc2307.member.uid", qRfc2307MemberUID); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307NisMapentry != nil {

		// query param rfc2307.nis.mapentry
		var qrRfc2307NisMapentry string

		if o.Rfc2307NisMapentry != nil {
			qrRfc2307NisMapentry = *o.Rfc2307NisMapentry
		}
		qRfc2307NisMapentry := qrRfc2307NisMapentry
		if qRfc2307NisMapentry != "" {

			if err := r.SetQueryParam("rfc2307.nis.mapentry", qRfc2307NisMapentry); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307NisMapname != nil {

		// query param rfc2307.nis.mapname
		var qrRfc2307NisMapname string

		if o.Rfc2307NisMapname != nil {
			qrRfc2307NisMapname = *o.Rfc2307NisMapname
		}
		qRfc2307NisMapname := qrRfc2307NisMapname
		if qRfc2307NisMapname != "" {

			if err := r.SetQueryParam("rfc2307.nis.mapname", qRfc2307NisMapname); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307NisNetgroup != nil {

		// query param rfc2307.nis.netgroup
		var qrRfc2307NisNetgroup string

		if o.Rfc2307NisNetgroup != nil {
			qrRfc2307NisNetgroup = *o.Rfc2307NisNetgroup
		}
		qRfc2307NisNetgroup := qrRfc2307NisNetgroup
		if qRfc2307NisNetgroup != "" {

			if err := r.SetQueryParam("rfc2307.nis.netgroup", qRfc2307NisNetgroup); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307NisNetgroupTriple != nil {

		// query param rfc2307.nis.netgroup_triple
		var qrRfc2307NisNetgroupTriple string

		if o.Rfc2307NisNetgroupTriple != nil {
			qrRfc2307NisNetgroupTriple = *o.Rfc2307NisNetgroupTriple
		}
		qRfc2307NisNetgroupTriple := qrRfc2307NisNetgroupTriple
		if qRfc2307NisNetgroupTriple != "" {

			if err := r.SetQueryParam("rfc2307.nis.netgroup_triple", qRfc2307NisNetgroupTriple); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307NisObject != nil {

		// query param rfc2307.nis.object
		var qrRfc2307NisObject string

		if o.Rfc2307NisObject != nil {
			qrRfc2307NisObject = *o.Rfc2307NisObject
		}
		qRfc2307NisObject := qrRfc2307NisObject
		if qRfc2307NisObject != "" {

			if err := r.SetQueryParam("rfc2307.nis.object", qRfc2307NisObject); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307PosixAccount != nil {

		// query param rfc2307.posix.account
		var qrRfc2307PosixAccount string

		if o.Rfc2307PosixAccount != nil {
			qrRfc2307PosixAccount = *o.Rfc2307PosixAccount
		}
		qRfc2307PosixAccount := qrRfc2307PosixAccount
		if qRfc2307PosixAccount != "" {

			if err := r.SetQueryParam("rfc2307.posix.account", qRfc2307PosixAccount); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307PosixGroup != nil {

		// query param rfc2307.posix.group
		var qrRfc2307PosixGroup string

		if o.Rfc2307PosixGroup != nil {
			qrRfc2307PosixGroup = *o.Rfc2307PosixGroup
		}
		qRfc2307PosixGroup := qrRfc2307PosixGroup
		if qRfc2307PosixGroup != "" {

			if err := r.SetQueryParam("rfc2307.posix.group", qRfc2307PosixGroup); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307bisEnabled != nil {

		// query param rfc2307bis.enabled
		var qrRfc2307bisEnabled bool

		if o.Rfc2307bisEnabled != nil {
			qrRfc2307bisEnabled = *o.Rfc2307bisEnabled
		}
		qRfc2307bisEnabled := swag.FormatBool(qrRfc2307bisEnabled)
		if qRfc2307bisEnabled != "" {

			if err := r.SetQueryParam("rfc2307bis.enabled", qRfc2307bisEnabled); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307bisGroupOfUniqueNames != nil {

		// query param rfc2307bis.group_of_unique_names
		var qrRfc2307bisGroupOfUniqueNames string

		if o.Rfc2307bisGroupOfUniqueNames != nil {
			qrRfc2307bisGroupOfUniqueNames = *o.Rfc2307bisGroupOfUniqueNames
		}
		qRfc2307bisGroupOfUniqueNames := qrRfc2307bisGroupOfUniqueNames
		if qRfc2307bisGroupOfUniqueNames != "" {

			if err := r.SetQueryParam("rfc2307bis.group_of_unique_names", qRfc2307bisGroupOfUniqueNames); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307bisMaximumGroups != nil {

		// query param rfc2307bis.maximum_groups
		var qrRfc2307bisMaximumGroups int64

		if o.Rfc2307bisMaximumGroups != nil {
			qrRfc2307bisMaximumGroups = *o.Rfc2307bisMaximumGroups
		}
		qRfc2307bisMaximumGroups := swag.FormatInt64(qrRfc2307bisMaximumGroups)
		if qRfc2307bisMaximumGroups != "" {

			if err := r.SetQueryParam("rfc2307bis.maximum_groups", qRfc2307bisMaximumGroups); err != nil {
				return err
			}
		}
	}

	if o.Rfc2307bisUniqueMember != nil {

		// query param rfc2307bis.unique_member
		var qrRfc2307bisUniqueMember string

		if o.Rfc2307bisUniqueMember != nil {
			qrRfc2307bisUniqueMember = *o.Rfc2307bisUniqueMember
		}
		qRfc2307bisUniqueMember := qrRfc2307bisUniqueMember
		if qRfc2307bisUniqueMember != "" {

			if err := r.SetQueryParam("rfc2307bis.unique_member", qRfc2307bisUniqueMember); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
