// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LdapSchemaDeleteCollectionReader is a Reader for the LdapSchemaDeleteCollection structure.
type LdapSchemaDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LdapSchemaDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLdapSchemaDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLdapSchemaDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLdapSchemaDeleteCollectionOK creates a LdapSchemaDeleteCollectionOK with default headers values
func NewLdapSchemaDeleteCollectionOK() *LdapSchemaDeleteCollectionOK {
	return &LdapSchemaDeleteCollectionOK{}
}

/*
LdapSchemaDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type LdapSchemaDeleteCollectionOK struct {
}

// IsSuccess returns true when this ldap schema delete collection o k response has a 2xx status code
func (o *LdapSchemaDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ldap schema delete collection o k response has a 3xx status code
func (o *LdapSchemaDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ldap schema delete collection o k response has a 4xx status code
func (o *LdapSchemaDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ldap schema delete collection o k response has a 5xx status code
func (o *LdapSchemaDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ldap schema delete collection o k response a status code equal to that given
func (o *LdapSchemaDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ldap schema delete collection o k response
func (o *LdapSchemaDeleteCollectionOK) Code() int {
	return 200
}

func (o *LdapSchemaDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /name-services/ldap-schemas][%d] ldapSchemaDeleteCollectionOK", 200)
}

func (o *LdapSchemaDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /name-services/ldap-schemas][%d] ldapSchemaDeleteCollectionOK", 200)
}

func (o *LdapSchemaDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLdapSchemaDeleteCollectionDefault creates a LdapSchemaDeleteCollectionDefault with default headers values
func NewLdapSchemaDeleteCollectionDefault(code int) *LdapSchemaDeleteCollectionDefault {
	return &LdapSchemaDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	LdapSchemaDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4915204    | Failed to delete. The LDAP schema is being used by at least one LDAP client configuration. |
| 4915205    | The LDAP schema is a default schema and cannot be modified or deleted. |
| 4915217    | LDAP schema is owned by the admin SVM. |
*/
type LdapSchemaDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ldap schema delete collection default response has a 2xx status code
func (o *LdapSchemaDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ldap schema delete collection default response has a 3xx status code
func (o *LdapSchemaDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ldap schema delete collection default response has a 4xx status code
func (o *LdapSchemaDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ldap schema delete collection default response has a 5xx status code
func (o *LdapSchemaDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ldap schema delete collection default response a status code equal to that given
func (o *LdapSchemaDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ldap schema delete collection default response
func (o *LdapSchemaDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *LdapSchemaDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/ldap-schemas][%d] ldap_schema_delete_collection default %s", o._statusCode, payload)
}

func (o *LdapSchemaDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/ldap-schemas][%d] ldap_schema_delete_collection default %s", o._statusCode, payload)
}

func (o *LdapSchemaDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LdapSchemaDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
LdapSchemaDeleteCollectionBody ldap schema delete collection body
swagger:model LdapSchemaDeleteCollectionBody
*/
type LdapSchemaDeleteCollectionBody struct {

	// ldap schema response inline records
	LdapSchemaResponseInlineRecords []*models.LdapSchema `json:"records,omitempty"`
}

// Validate validates this ldap schema delete collection body
func (o *LdapSchemaDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLdapSchemaResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LdapSchemaDeleteCollectionBody) validateLdapSchemaResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.LdapSchemaResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.LdapSchemaResponseInlineRecords); i++ {
		if swag.IsZero(o.LdapSchemaResponseInlineRecords[i]) { // not required
			continue
		}

		if o.LdapSchemaResponseInlineRecords[i] != nil {
			if err := o.LdapSchemaResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ldap schema delete collection body based on the context it is used
func (o *LdapSchemaDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLdapSchemaResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LdapSchemaDeleteCollectionBody) contextValidateLdapSchemaResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LdapSchemaResponseInlineRecords); i++ {

		if o.LdapSchemaResponseInlineRecords[i] != nil {
			if err := o.LdapSchemaResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *LdapSchemaDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LdapSchemaDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res LdapSchemaDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
