// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LdapSchemaDeleteReader is a Reader for the LdapSchemaDelete structure.
type LdapSchemaDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LdapSchemaDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLdapSchemaDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLdapSchemaDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLdapSchemaDeleteOK creates a LdapSchemaDeleteOK with default headers values
func NewLdapSchemaDeleteOK() *LdapSchemaDeleteOK {
	return &LdapSchemaDeleteOK{}
}

/*
LdapSchemaDeleteOK describes a response with status code 200, with default header values.

OK
*/
type LdapSchemaDeleteOK struct {
}

// IsSuccess returns true when this ldap schema delete o k response has a 2xx status code
func (o *LdapSchemaDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ldap schema delete o k response has a 3xx status code
func (o *LdapSchemaDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ldap schema delete o k response has a 4xx status code
func (o *LdapSchemaDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ldap schema delete o k response has a 5xx status code
func (o *LdapSchemaDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ldap schema delete o k response a status code equal to that given
func (o *LdapSchemaDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ldap schema delete o k response
func (o *LdapSchemaDeleteOK) Code() int {
	return 200
}

func (o *LdapSchemaDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /name-services/ldap-schemas/{owner.uuid}/{name}][%d] ldapSchemaDeleteOK", 200)
}

func (o *LdapSchemaDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /name-services/ldap-schemas/{owner.uuid}/{name}][%d] ldapSchemaDeleteOK", 200)
}

func (o *LdapSchemaDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLdapSchemaDeleteDefault creates a LdapSchemaDeleteDefault with default headers values
func NewLdapSchemaDeleteDefault(code int) *LdapSchemaDeleteDefault {
	return &LdapSchemaDeleteDefault{
		_statusCode: code,
	}
}

/*
	LdapSchemaDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4915204    | Failed to delete. The LDAP schema is being used by at least one LDAP client configuration. |
| 4915205    | The LDAP schema is a default schema and cannot be modified or deleted. |
| 4915217    | LDAP schema is owned by the admin SVM. |
*/
type LdapSchemaDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ldap schema delete default response has a 2xx status code
func (o *LdapSchemaDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ldap schema delete default response has a 3xx status code
func (o *LdapSchemaDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ldap schema delete default response has a 4xx status code
func (o *LdapSchemaDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ldap schema delete default response has a 5xx status code
func (o *LdapSchemaDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ldap schema delete default response a status code equal to that given
func (o *LdapSchemaDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ldap schema delete default response
func (o *LdapSchemaDeleteDefault) Code() int {
	return o._statusCode
}

func (o *LdapSchemaDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/ldap-schemas/{owner.uuid}/{name}][%d] ldap_schema_delete default %s", o._statusCode, payload)
}

func (o *LdapSchemaDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/ldap-schemas/{owner.uuid}/{name}][%d] ldap_schema_delete default %s", o._statusCode, payload)
}

func (o *LdapSchemaDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LdapSchemaDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
