// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LdapSchemaModifyReader is a Reader for the LdapSchemaModify structure.
type LdapSchemaModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LdapSchemaModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLdapSchemaModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLdapSchemaModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLdapSchemaModifyOK creates a LdapSchemaModifyOK with default headers values
func NewLdapSchemaModifyOK() *LdapSchemaModifyOK {
	return &LdapSchemaModifyOK{}
}

/*
LdapSchemaModifyOK describes a response with status code 200, with default header values.

OK
*/
type LdapSchemaModifyOK struct {
}

// IsSuccess returns true when this ldap schema modify o k response has a 2xx status code
func (o *LdapSchemaModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ldap schema modify o k response has a 3xx status code
func (o *LdapSchemaModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ldap schema modify o k response has a 4xx status code
func (o *LdapSchemaModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ldap schema modify o k response has a 5xx status code
func (o *LdapSchemaModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ldap schema modify o k response a status code equal to that given
func (o *LdapSchemaModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ldap schema modify o k response
func (o *LdapSchemaModifyOK) Code() int {
	return 200
}

func (o *LdapSchemaModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /name-services/ldap-schemas/{owner.uuid}/{name}][%d] ldapSchemaModifyOK", 200)
}

func (o *LdapSchemaModifyOK) String() string {
	return fmt.Sprintf("[PATCH /name-services/ldap-schemas/{owner.uuid}/{name}][%d] ldapSchemaModifyOK", 200)
}

func (o *LdapSchemaModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLdapSchemaModifyDefault creates a LdapSchemaModifyDefault with default headers values
func NewLdapSchemaModifyDefault(code int) *LdapSchemaModifyDefault {
	return &LdapSchemaModifyDefault{
		_statusCode: code,
	}
}

/*
	LdapSchemaModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4915205    | The LDAP schema is a default schema and cannot be modified or deleted. |
| 4915217    | LDAP schema is owned by the admin SVM. |
| 4915223    | LDAP schema does not belong to the admin SVM. |
*/
type LdapSchemaModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ldap schema modify default response has a 2xx status code
func (o *LdapSchemaModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ldap schema modify default response has a 3xx status code
func (o *LdapSchemaModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ldap schema modify default response has a 4xx status code
func (o *LdapSchemaModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ldap schema modify default response has a 5xx status code
func (o *LdapSchemaModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ldap schema modify default response a status code equal to that given
func (o *LdapSchemaModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ldap schema modify default response
func (o *LdapSchemaModifyDefault) Code() int {
	return o._statusCode
}

func (o *LdapSchemaModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/ldap-schemas/{owner.uuid}/{name}][%d] ldap_schema_modify default %s", o._statusCode, payload)
}

func (o *LdapSchemaModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/ldap-schemas/{owner.uuid}/{name}][%d] ldap_schema_modify default %s", o._statusCode, payload)
}

func (o *LdapSchemaModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LdapSchemaModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
