// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLocalHostCollectionGetParams creates a new LocalHostCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLocalHostCollectionGetParams() *LocalHostCollectionGetParams {
	return &LocalHostCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLocalHostCollectionGetParamsWithTimeout creates a new LocalHostCollectionGetParams object
// with the ability to set a timeout on a request.
func NewLocalHostCollectionGetParamsWithTimeout(timeout time.Duration) *LocalHostCollectionGetParams {
	return &LocalHostCollectionGetParams{
		timeout: timeout,
	}
}

// NewLocalHostCollectionGetParamsWithContext creates a new LocalHostCollectionGetParams object
// with the ability to set a context for a request.
func NewLocalHostCollectionGetParamsWithContext(ctx context.Context) *LocalHostCollectionGetParams {
	return &LocalHostCollectionGetParams{
		Context: ctx,
	}
}

// NewLocalHostCollectionGetParamsWithHTTPClient creates a new LocalHostCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewLocalHostCollectionGetParamsWithHTTPClient(client *http.Client) *LocalHostCollectionGetParams {
	return &LocalHostCollectionGetParams{
		HTTPClient: client,
	}
}

/*
LocalHostCollectionGetParams contains all the parameters to send to the API endpoint

	for the local host collection get operation.

	Typically these are written to a http.Request.
*/
type LocalHostCollectionGetParams struct {

	/* Address.

	   Filter by address
	*/
	Address *string

	/* Aliases.

	   Filter by aliases
	*/
	Aliases *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Hostname.

	   Filter by hostname
	*/
	Hostname *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the local host collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LocalHostCollectionGetParams) WithDefaults() *LocalHostCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the local host collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LocalHostCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := LocalHostCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the local host collection get params
func (o *LocalHostCollectionGetParams) WithTimeout(timeout time.Duration) *LocalHostCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the local host collection get params
func (o *LocalHostCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the local host collection get params
func (o *LocalHostCollectionGetParams) WithContext(ctx context.Context) *LocalHostCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the local host collection get params
func (o *LocalHostCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the local host collection get params
func (o *LocalHostCollectionGetParams) WithHTTPClient(client *http.Client) *LocalHostCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the local host collection get params
func (o *LocalHostCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddress adds the address to the local host collection get params
func (o *LocalHostCollectionGetParams) WithAddress(address *string) *LocalHostCollectionGetParams {
	o.SetAddress(address)
	return o
}

// SetAddress adds the address to the local host collection get params
func (o *LocalHostCollectionGetParams) SetAddress(address *string) {
	o.Address = address
}

// WithAliases adds the aliases to the local host collection get params
func (o *LocalHostCollectionGetParams) WithAliases(aliases *string) *LocalHostCollectionGetParams {
	o.SetAliases(aliases)
	return o
}

// SetAliases adds the aliases to the local host collection get params
func (o *LocalHostCollectionGetParams) SetAliases(aliases *string) {
	o.Aliases = aliases
}

// WithFields adds the fields to the local host collection get params
func (o *LocalHostCollectionGetParams) WithFields(fields []string) *LocalHostCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the local host collection get params
func (o *LocalHostCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithHostname adds the hostname to the local host collection get params
func (o *LocalHostCollectionGetParams) WithHostname(hostname *string) *LocalHostCollectionGetParams {
	o.SetHostname(hostname)
	return o
}

// SetHostname adds the hostname to the local host collection get params
func (o *LocalHostCollectionGetParams) SetHostname(hostname *string) {
	o.Hostname = hostname
}

// WithMaxRecords adds the maxRecords to the local host collection get params
func (o *LocalHostCollectionGetParams) WithMaxRecords(maxRecords *int64) *LocalHostCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the local host collection get params
func (o *LocalHostCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the local host collection get params
func (o *LocalHostCollectionGetParams) WithOrderBy(orderBy []string) *LocalHostCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the local host collection get params
func (o *LocalHostCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwnerName adds the ownerName to the local host collection get params
func (o *LocalHostCollectionGetParams) WithOwnerName(ownerName *string) *LocalHostCollectionGetParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the local host collection get params
func (o *LocalHostCollectionGetParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the local host collection get params
func (o *LocalHostCollectionGetParams) WithOwnerUUID(ownerUUID *string) *LocalHostCollectionGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the local host collection get params
func (o *LocalHostCollectionGetParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the local host collection get params
func (o *LocalHostCollectionGetParams) WithReturnRecords(returnRecords *bool) *LocalHostCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the local host collection get params
func (o *LocalHostCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the local host collection get params
func (o *LocalHostCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *LocalHostCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the local host collection get params
func (o *LocalHostCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the local host collection get params
func (o *LocalHostCollectionGetParams) WithScope(scope *string) *LocalHostCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the local host collection get params
func (o *LocalHostCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WriteToRequest writes these params to a swagger request
func (o *LocalHostCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Address != nil {

		// query param address
		var qrAddress string

		if o.Address != nil {
			qrAddress = *o.Address
		}
		qAddress := qrAddress
		if qAddress != "" {

			if err := r.SetQueryParam("address", qAddress); err != nil {
				return err
			}
		}
	}

	if o.Aliases != nil {

		// query param aliases
		var qrAliases string

		if o.Aliases != nil {
			qrAliases = *o.Aliases
		}
		qAliases := qrAliases
		if qAliases != "" {

			if err := r.SetQueryParam("aliases", qAliases); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Hostname != nil {

		// query param hostname
		var qrHostname string

		if o.Hostname != nil {
			qrHostname = *o.Hostname
		}
		qHostname := qrHostname
		if qHostname != "" {

			if err := r.SetQueryParam("hostname", qHostname); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamLocalHostCollectionGet binds the parameter fields
func (o *LocalHostCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamLocalHostCollectionGet binds the parameter order_by
func (o *LocalHostCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
