// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LocalHostCollectionGetReader is a Reader for the LocalHostCollectionGet structure.
type LocalHostCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LocalHostCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLocalHostCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLocalHostCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLocalHostCollectionGetOK creates a LocalHostCollectionGetOK with default headers values
func NewLocalHostCollectionGetOK() *LocalHostCollectionGetOK {
	return &LocalHostCollectionGetOK{}
}

/*
LocalHostCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type LocalHostCollectionGetOK struct {
	Payload *models.LocalHostResponse
}

// IsSuccess returns true when this local host collection get o k response has a 2xx status code
func (o *LocalHostCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this local host collection get o k response has a 3xx status code
func (o *LocalHostCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this local host collection get o k response has a 4xx status code
func (o *LocalHostCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this local host collection get o k response has a 5xx status code
func (o *LocalHostCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this local host collection get o k response a status code equal to that given
func (o *LocalHostCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the local host collection get o k response
func (o *LocalHostCollectionGetOK) Code() int {
	return 200
}

func (o *LocalHostCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/local-hosts][%d] localHostCollectionGetOK %s", 200, payload)
}

func (o *LocalHostCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/local-hosts][%d] localHostCollectionGetOK %s", 200, payload)
}

func (o *LocalHostCollectionGetOK) GetPayload() *models.LocalHostResponse {
	return o.Payload
}

func (o *LocalHostCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LocalHostResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLocalHostCollectionGetDefault creates a LocalHostCollectionGetDefault with default headers values
func NewLocalHostCollectionGetDefault(code int) *LocalHostCollectionGetDefault {
	return &LocalHostCollectionGetDefault{
		_statusCode: code,
	}
}

/*
LocalHostCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type LocalHostCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this local host collection get default response has a 2xx status code
func (o *LocalHostCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this local host collection get default response has a 3xx status code
func (o *LocalHostCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this local host collection get default response has a 4xx status code
func (o *LocalHostCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this local host collection get default response has a 5xx status code
func (o *LocalHostCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this local host collection get default response a status code equal to that given
func (o *LocalHostCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the local host collection get default response
func (o *LocalHostCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *LocalHostCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/local-hosts][%d] local_host_collection_get default %s", o._statusCode, payload)
}

func (o *LocalHostCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/local-hosts][%d] local_host_collection_get default %s", o._statusCode, payload)
}

func (o *LocalHostCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LocalHostCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
